import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from torch import nn
import os
import math
import random
import torch
import torch.nn.functional as F

# Define the directory path containing the data files
str1 = r'E:\A_experimentNeed\陕西省sgi\space_GWC-sgi04-09'
files = [f for f in os.listdir(str1) if f.endswith('.txt')]
R1 = []  # List to store R-squared (RR) values
RM = []  # List to store RMSE values
M = []   # List to store MAE values
R_sb = []  # List to store RR values for the Shaanbei region
R_gz = []  # List to store RR values for the Guanzhong region
R_sn = []  # List to store RR values for the Shannan region

# Iterate through each file in the directory
for file in files:
    # Load data from the file
    data_sgi = np.loadtxt(f'{str1}/{file}')  # Load the 5th column data
    
    # Define hyperparameters
    input_size = 4
    hidden_size = 4
    num_layer = 2
    output_size = 1
    train_num_ratio = 0.9
    learning_rate = 1e-1
    epoch_num = 300 

    dataset = data_sgi.astype('float32')
    mean = np.mean(dataset)  # Calculate the mean
    std_dev = np.std(dataset)  # Calculate the standard deviation
    dataset = list(map(lambda x: (x - mean) / std_dev, dataset))  # Z-score normalization
    
    # Define a function to generate random data batches
    def data_iter_random(corpus_indices, batch_size, num_steps, device=None):
        num_examples = (len(corpus_indices) - 1) // num_steps  
        example_indices = [i * num_steps for i in range(num_examples)] 
        random.shuffle(example_indices)
  
        def _data(i):        
            return corpus_indices[i: i + num_steps]
        if device is None:
            device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')
        Y=[]
        for i in range(0, num_examples, batch_size):
            batch_indices = example_indices[i: i + batch_size] 
            X = [_data(j) for j in batch_indices]
            Y = [corpus_indices[j + num_steps] for j in batch_indices]
            yield X ,Y

    # Generate input and output data
    d_data1,d_data2 = data_iter_random(dataset,batch_size = len(data_sgi)  // input_size -1 ,num_steps=input_size)
    data_X=d_data1[0]
    data_Y=d_data1[1]
    
    data_X=np.array(data_X)
    data_Y=np.array(data_Y)
    # Split data into training and testing sets
    train_size = int(len(data_X) * train_num_ratio)
    test_size = len(data_X) - train_size
    
    train_X=data_X[:train_size]
    train_Y=data_Y[:train_size]
    # Reshape data for LSTM input
    train_X = train_X.reshape(-1, 1, input_size)
    train_Y = train_Y.reshape(-1, 1, 1)
    
    # Convert data to PyTorch tensors
    train_x = torch.from_numpy(train_X)
    train_y = torch.from_numpy(train_Y)
        
    # Define the LSTM model with one LSTM layer followed by a fully connected layer.
    class lstm(nn.Module):  
        def __init__(self, input_size, hidden_size, output_size, num_layer):
            super(lstm, self).__init__()
            self.layer1 = nn.LSTM(input_size, hidden_size, num_layer, batch_first=True) 
            # self.dropout = nn.Dropout(dropout)
            self.layer2 = nn.Linear(hidden_size, output_size)  
    
        def forward(self, x):      
            # Input: x, (h_0, c_0)  
            # x: (seq_len, batch_size, input_size), (h_0, c_0) are optional and default to zeros
            x, _ = self.layer1(x)  # Output: (seq_len, batch_size, hidden_size)
            
            seq_len, batch_size, hidden_size = x.size()   
            x = x.view(seq_len * batch_size, hidden_size)  # Reshape to (seq_len * batch_size, hidden_size)
            x = self.layer2(x)  # Pass through the fully connected layer
            x = x.view(seq_len, batch_size, -1)  # Reshape back to (seq_len, batch_size, output_size)
            return x
 
    # Instantiate the model 
    model = lstm(input_size, hidden_size, output_size, num_layer)    
    # Define loss function and optimizer
    criterion = nn.MSELoss()
    optimizer = torch.optim.Adam(model.parameters(), lr=learning_rate)
    
    # Train the model
    for e in range(epoch_num):
        optimizer.zero_grad()
        out = model(train_x)  # Forward pass
        loss = criterion(out, train_y)  # Calculate loss
        loss.backward()  # Backward pass
        optimizer.step()  # Update weights

        if (e + 1) % 100 == 0:
            print('Epoch: {}, Loss: {:.5f}'.format(e + 1, loss.item()))
            
    # Evaluate the model
    model.eval()  # Switch to evaluation mode
    
    data_X = data_X.reshape(-1, 1, input_size)
    data_X = torch.from_numpy(data_X)
    pred_test = model(data_X)  # Predict on the test data
    pred_test = pred_test.view(-1).data.numpy()
    
    # Calculate evaluation metrics
    data = data_Y
    mean = np.mean(data)
    SSE = np.sum((data - pred_test) ** 2)  # Sum of Squared Errors
    SST = np.sum((data - mean) ** 2)  # Total Sum of Squares
    RR = 1 - SSE / SST  # R-squared
    R1.append(RR)
    print(f'RR={RR}\n')

    RMSE = math.sqrt(np.sum((data - pred_test) ** 2) / len(data))  # Root Mean Squared Error
    RM.append(RMSE)
    print(f'RMSE={RMSE}')
    
    MAE = np.sum(np.abs(data - pred_test)) / len(data)  # Mean Absolute Error
    M.append(MAE)
    print(f'MAE={MAE}\n')
    
    # Extract latitude and longitude from the filename
    lat = float(file[0:6])
    lon = float(file[7:14])
    if lat >= 36.0 and lat <= 40.0:
        R_sb.append([lat, lon, RR])
    elif lat >= 34 and lat < 36:
        R_gz.append([lat, lon, RR])
    else:
        R_sn.append([lat, lon, RR])

# Post-processing and analysis
j = []    
for i in R1:
    if i < 0:
        j.append([R1.index(i), i]) 
R1_mean = np.mean(R1)
RM_mean = np.mean(RM)
M_mean = np.mean(M)

filename = []  
for x in j:
    filename.append(files[x[0]])
z9 = 0
z8 = 0
z7 = 0
z6 = 0
z = 0
for k in range(len(R1)):
    if R1[k] > 0.9:
        z9 += 1
    elif R1[k] > 0.8: 
        z8 += 1
    elif R1[k] > 0.7:
        z7 += 1
    elif R1[k] > 0.6:
        z6 += 1
    else:
        z += 1
v = 0
for k in range(len(R1)):
    if R1[k] < 0.5:
        v += 1

# Plot R-squared (RR) accuracy chart
y1=[]
y2=[]
y3=[]
for i in range(len(R_sb)):
    y1.append(np.array(R_sb)[i][2])
for i in range(len(R_gz)):
    y2.append(np.array(R_gz)[i][2])
for i in range(len(R_sn)):
    y3.append(np.array(R_sn)[i][2])
y1=np.array(y1)    
y2=np.array(y2)
y3=np.array(y3)  


y=(np.mean(y1)+np.mean(y2)+np.mean(y3))/3

plt.figure(figsize=(10, 6))
plt.axhline(y, color='black', linestyle='--', label=f'RRmean={y:.2f}')
plt.scatter(range(len(y1)),y1 , label='shanbeiRR-value',color='r')
plt.scatter(range(len(y2)), y2, label='guanzhongRR-value',color='g')
plt.scatter(range(len(y3)), y3, label='shannanRR-value',color='b')
plt.title("LSTM-Model")
plt.xlabel('Point num')
plt.ylabel('RR value')
plt.legend(loc='best')
plt.show()

