import pandas as pd
import os
from scipy.stats import pearson3, norm
import numpy as np
import scipy.stats as stats

# Define the directory path containing the data files
str1 = r'E:\A_experimentNeed\Use_data\GWC_spaceGwc\space_GWC04-09'
files = [f for f in os.listdir(str1) if f.endswith('.txt')]

sgi_values = []  # List to store SGI values

# Iterate through each file in the directory
for file in files:
    # Load precipitation data from the file
    precipitation = np.loadtxt(f'{str1}/{file}')
    
    # Fit the precipitation data using the Pearson Type III distribution
    params_pearson3 = stats.pearson3.fit(precipitation)
    
    # Calculate the cumulative distribution function (CDF) values for the fitted distribution
    cdf = stats.pearson3.cdf(precipitation, *params_pearson3)
    
    # Convert CDF values to SGI values using the inverse CDF (percent point function) of the standard normal distribution
    sgi_chunk = norm.ppf(cdf)
    
    # Extend the list of SGI values with the newly calculated chunk
    sgi_values.extend(sgi_chunk)

    # Convert the list of SGI values to a NumPy array
    A = np.array(sgi_values)
    
    # Define the output file name and path
    file_name = f'{file[0:14]}_sgi.txt'
    file_path = os.path.join(os.path.expanduser('~'), 'Desktop\space_GWC-sgi04-09') # createFolder
    
    # Save the SGI values to a text file
    np.savetxt(f'{file_path}/{file_name}', A, fmt='%5.4f', delimiter='  ')
    
    # Clear the list for the next iteration
    sgi_values = []