function plotFigure(startPos, goalPos, X, Y, Z, path1, path2, path3, path4, path5, path6, path7)
    
    % 2.3 Start point, end point and paths
    h1 = scatter3(startPos(1), startPos(2), startPos(3), 120, 'd', ...
                  'MarkerFaceColor', 'r', 'MarkerEdgeColor', 'k', 'LineWidth', 2);
    hold on
    h2 = scatter3(goalPos(1), goalPos(2), goalPos(3), 120, '^', ...
                  'MarkerFaceColor', 'g', 'MarkerEdgeColor', 'k', 'LineWidth', 2);
    
    surf(X, Y, Z, 'LineStyle', 'none');
    shading flat;
    %colormap summer

    pathColors = {'k', 'c', 'b', 'g', 'm', 'y', 'r'};
    h3 = plot3(path1(:,1), path1(:,2), path1(:,3), 'Color', pathColors{1}, 'LineWidth', 2.0);
    h4 = plot3(path2(:,1), path2(:,2), path2(:,3), 'Color', pathColors{2}, 'LineWidth', 2.0);
    h5 = plot3(path3(:,1), path3(:,2), path3(:,3), 'Color', pathColors{3}, 'LineWidth', 2.0);
    h6 = plot3(path4(:,1), path4(:,2), path4(:,3), 'Color', pathColors{4}, 'LineWidth', 2.0);
    h7 = plot3(path5(:,1), path5(:,2), path5(:,3), 'Color', pathColors{5}, 'LineWidth', 2.0);
    h8 = plot3(path6(:,1), path6(:,2), path6(:,3), 'Color', pathColors{6}, 'LineWidth', 2.0);
    h9 = plot3(path7(:,1), path7(:,2), path7(:,3), 'Color', pathColors{7}, 'LineWidth', 2.0);
    
    legend([h1,h2,h3,h4,h5,h6,h7,h8,h9], ...
           {'Starting point','End point','GWO','GO','EO','KOA','DMPSORH','HPSOALS','IDSMPSO'});  
    hold off;
    grid on
    figure
    surf(X, Y, Z, 'LineStyle', 'none');
    shading flat;
    %colormap summer
    % 3. Top-down view
    hold on; 
   % 2.3 Start point, end point and paths
    h1 = scatter3(startPos(1), startPos(2), startPos(3), 120, 'd', ...
                  'MarkerFaceColor', 'r', 'MarkerEdgeColor', 'k', 'LineWidth', 2);
    h2 = scatter3(goalPos(1), goalPos(2), goalPos(3), 120, '^', ...
                  'MarkerFaceColor', 'g', 'MarkerEdgeColor', 'k', 'LineWidth', 2);
    pathColors = {'k', 'c', 'b', 'g', 'm', 'y', 'r'};
    h3 = plot3(path1(:,1), path1(:,2), path1(:,3), 'Color', pathColors{1}, 'LineWidth', 2.0);
    h4 = plot3(path2(:,1), path2(:,2), path2(:,3), 'Color', pathColors{2}, 'LineWidth', 2.0);
    h5 = plot3(path3(:,1), path3(:,2), path3(:,3), 'Color', pathColors{3}, 'LineWidth', 2.0);
    h6 = plot3(path4(:,1), path4(:,2), path4(:,3), 'Color', pathColors{4}, 'LineWidth', 2.0);
    h7 = plot3(path5(:,1), path5(:,2), path5(:,3), 'Color', pathColors{5}, 'LineWidth', 2.0);
    h8 = plot3(path6(:,1), path6(:,2), path6(:,3), 'Color', pathColors{6}, 'LineWidth', 2.0);
    h9 = plot3(path7(:,1), path7(:,2), path7(:,3), 'Color', pathColors{7}, 'LineWidth', 2.0);
    
    view(0,90);
    legend([h1,h2,h3,h4,h5,h6,h7,h8,h9], ...
           {'Starting point','End point','GWO','GO','EO','KOA','DMPSORH','HPSOALS','IDSMPSO'});  
    hold off;
    grid on;
   
end
    