function [Best_val, Worst_val, Mean_val, Median_val, Std_val, Wilcoxon_RankSum_Test, Wilcoxon_SignedRank_Test, Friedamn_val] = Statis_Data(result, Func_name, num, RGBData, dim)

len = length(result.name);
[k, maxIter] = size(result.data{1});
data = zeros(len, k); % Store data

% Extract minimum fitness values from each run
for i = 1:len
    data(i, :) = min(result.data{i}, [], 2)';
end

% Initialize statistical metric arrays
Best_val = zeros(1, len);    % Best values
Worst_val = zeros(1, len);   % Worst values
Mean_val = zeros(1, len);    % Mean values
Median_val = zeros(1, len);  % Median values
Std_val = zeros(1, len);     % Standard deviations

% Calculate statistical metrics
for i = 1:len
    Best_val(i) = min(data(i, :));
    Worst_val(i) = max(data(i, :));
    Mean_val(i) = mean(data(i, :));
    Median_val(i) = median(data(i, :));
    Std_val(i) = std(data(i, :));
end

%-----Wilcoxon Rank-Sum Test
Wilcoxon_RankSum_Test = [];
for i = 1:len
    if i == num
        continue;  % Skip comparison with itself
    end
    % Perform rank-sum test with significance level 0.05
    [p, h] = ranksum(data(num, :), data(i, :), 'alpha', 0.05);
    Wilcoxon_RankSum_Test = [Wilcoxon_RankSum_Test; [p h]];
end

%-----Wilcoxon Signed-Rank Test
Wilcoxon_SignedRank_Test = [];
for i = 1:len
    if i == num
        continue;  % Skip comparison with itself
    end
    % Perform signed-rank test
    [p, h] = signrank(data(num, :), data(i, :));
    Wilcoxon_SignedRank_Test = [Wilcoxon_SignedRank_Test; [p h]];
end

%-----Friedman Test
[p, tbl, stats] = friedman(data');
Friedamn_val = stats.meanranks;

%-----Plot function landscape
figure
[x, y, f] = Plot_CEC2017(Func_name, dim);
surfc(x, y, f, 'LineStyle', 'none');
colormap winter
title(Func_name);

%-----Plot optimal fitness curves
Iter_curve = zeros(len, maxIter);
for i = 1:len
    [~, idx] = min(Best_val);
    Iter_curve(i, :) = result.data{i}(idx, :);
end

figure
for i = 1:len
    semilogy(Iter_curve(i, :), 'Color', RGBData(i, :), 'LineWidth', 1.5, 'LineStyle', '--');
    hold on
end
hold off
xlabel('Iteration number');
ylabel('Fitness value');

% Set legend to display in 2 columns
legend_handle = legend(result.name, 'Location', 'northeast');
legend_handle.NumColumns = 2;  % Split into two columns
legend_handle.FontSize = 8;
% Increase legend width for better two-column layout
legend_handle.Position(3) = 0.35;
% Adjust legend height
legend_handle.Position(4) = 0.25;
box on;  % Display border

%-----Plot boxplot
figure
box_color = RGBData(1:len, :);
h = boxplot(data');
boxobj = findobj(gca, 'Tag', 'Box');

% Color boxplot elements
for j = 1:len
    patch(get(boxobj(j), 'XData'), get(boxobj(j), 'YData'), RGBData(j, :), 'FaceAlpha', 0.5);
end

xticklabels(result.name);
title(Func_name);

end
    