﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading;
using Bloomberglp.Blpapi;
using CDSHeatMap.ViewModel;

namespace CDSHeatMap.BloombergAPIManager
{
    public class BLPSessionManager
    {
        private int errorCode = 3000;

        private const int INITIAL_CONNECTION = 2;

        public int NumberOfConnection { get; set; }

        private bool initialized = false;
        private static BLPSessionManager instance = null;

        private ConcurrentQueue<Session> sessionQueue;

        public BLPSessionManager()
        {

        }

        public static BLPSessionManager getInstance()
        {
            if (instance == null)
            {
                instance = new BLPSessionManager();
                instance.init();
            }

            return instance;
        }

        public bool init()
        {
            if (!initialized)
            {
                NumberOfConnection = 0;

                sessionQueue = new ConcurrentQueue<Session>();

                createConnectionQueue(INITIAL_CONNECTION);

                if (NumberOfConnection <= 0)
                {
                    //warning
                    initialized = false;
                }
                else
                    initialized = true;
            }

            return initialized;
        }

        public bool createConnectionQueue(int numOfConnection)
        {
            bool isAllConCreated = true;
            for (int i = 0; i < numOfConnection; ++i)
            {
                Session session = createSession();

                if (session == null)
                {
                    Trace.WriteLine("Failed to start session with Bloomberg Api Services in session manager." + (errorCode+i), "INFO");

                    isAllConCreated = false;
                    //throw new BlpApiDataException("Failed to start session with Bloomberg Api Services.");
                }
                else if (!openService(session, "//blp/refdata"))
                {
                    Trace.WriteLine("Failed to open Bloomberg Api Reference Data Service in session manager." + (errorCode + i * numOfConnection), "INFO");

                    isAllConCreated = false;
                    //throw new BlpApiDataException("Failed to open Bloomberg Api Reference Data Service");
                }
                else
                {
                    sessionQueue.Enqueue(session);
                    NumberOfConnection++;
                }
            }

            Trace.WriteLine("Bloomberg session manager is created with " + NumberOfConnection + " connection.", "INFO");

            return isAllConCreated;
        }

        public void Dispose()
        {
            initialized = false;

            if (sessionQueue.IsEmpty)
                return;

            foreach (var session in sessionQueue.ToList())
            {
                if (session != null)
                {
                    session.Stop();
                    ((IDisposable)session).Dispose();
                }
            }
        }

        private Session createSession()
        {
            //Trace.WriteLine("createSession is called.", "TRACE");

            var sessionOptions = new SessionOptions
            {
                ServerHost = "localhost",
                ServerPort = 8194,
                ClientMode = SessionOptions.ClientModeType.DAPI,
                AutoRestartOnDisconnection = true,
                ConnectTimeout = 30000
            };

            var retries = 3;

            while (true)
            {
                Session _session = null;
                _session = new Session(sessionOptions);

                if (_session.Start())
                {
                    return _session;
                }

                if (retries == 0)
                {
                    Trace.WriteLine("Failed to start session with Bloomberg Api Services." + errorCode, "INFO");
                    //throw new BlpApiDataException("Failed to start session with Bloomberg Api Services.");
                    //throw new BlpApiDataException(mainThreadDispatcher, "Failed to start session with Bloomberg API Services.");
                }
                retries--;
            }
        }

        private bool openService(Session _session, string service)
        {
            return _session.OpenService(service);
        }

        public Session getSession()
        {
            Session session = null;

            if (NumberOfConnection <= 0)
                return session;

            while (sessionQueue.IsEmpty)
            {
                Thread.Sleep(500);
            }

            sessionQueue.TryDequeue(out session);

            return session;
        }

        public void releaseSession(Session session)
        {
            if (NumberOfConnection <= 0)
                return;

            if (session != null)
            {
                sessionQueue.Enqueue(session);
            }
            else
            {
                NumberOfConnection--;
                Trace.WriteLine("BLP session manager, released session is null !!!" + errorCode, "INFO");
            }
        }

    }
}
