﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Bloomberglp.Blpapi;

namespace CDSHeatMap.BloombergAPIManager
{
    public static class BBCommMessageType
    {
        public const string HISTORICALDATARESPONSE = "HistoricalDataResponse";
        public const string INSTRUMENTLISTRESPONSE = "InstrumentListResponse";
        public const string MARKETDATAEVENTS = "MarketDataEvents";
        public const string REFERENCEDATARESPONSE = "ReferenceDataResponse";
        public const string REQUESTFAILURE = "RequestFailure";
        public const string RESPONSEERROR = "responseError";
        //public const string SERVICEOPENED = "ServiceOpened";
        //public const string SERVICEOPENFAILURE = "ServiceOpenFailure";
        public const string SESSIONSTARTED = "SessionStarted";
        public const string SESSIONSTARTUPFAILURE = "SessionStartupFailure";
        public const string SESSIONTERMINATED = "SessionTerminated";
        //public const string SLOWCONSUMERWARNING = "SlowConsumerWarning";
        //public const string SLOWCONSUMERWARNINGCLEARED = "SlowConsumerWarningCleared";
        //public const string SUBSCRIPTIONSTARTED = "SubscriptionStarted";
        //public const string SUBSCRIPTIONFAILURE = "SubscriptionFailure";
        //public const string SUBSCRIPTIONTERMINATED = "SubscriptionTerminated";

    }

    public static class Names
    {
        public static readonly Name CATEGORY = new Name("category");
        public static readonly Name DESCRIPTION = new Name("description");
        public static readonly Name ERRORINFO = new Name("errorInfo");
        public static readonly Name FIELDDATA = new Name("fieldData");
        public static readonly Name FIELDEXCEPTIONS = new Name("fieldExceptions");
        public static readonly Name FIELDID = new Name("fieldId");
        public static readonly Name FIELDS = new Name("fields");
        public static readonly Name MAXRESULTS = new Name("maxResults");
        public static readonly Name MESSAGE = new Name("message");
        public static readonly Name QUERY = new Name("query");
        public static readonly Name RESULTS = new Name("results");
        public static readonly Name SECURITYDATA = new Name("securityData");
        public static readonly Name SECURITYERROR = new Name("securityError");
        public static readonly Name SECURITIES = new Name("securities");
        public static readonly Name SECURITY = new Name("security");
        public static readonly Name DATE = new Name("date");

    }

    public static class DataFieldNames
    {
        public const string INDX_MEMBERS = "INDX_MEMBERS";
        public const string NAME = "NAME";
        public const string ROLLING_SERIES = "ROLLING_SERIES";

        public const string SECURITY_NAME = "SECURITY_NAME";

        public const string PRIMARY_EQUITY_TICKER = "PRIMARY_EQUITY_TICKER";
        public const string CDS_SPREAD_TICKER_1Y = "CDS_SPREAD_TICKER_1Y";
        public const string CDS_SPREAD_TICKER_2Y = "CDS_SPREAD_TICKER_2Y";
        public const string CDS_SPREAD_TICKER_3Y = "CDS_SPREAD_TICKER_3Y";
        public const string CDS_SPREAD_TICKER_4Y = "CDS_SPREAD_TICKER_4Y";
        public const string CDS_SPREAD_TICKER_5Y = "CDS_SPREAD_TICKER_5Y";
        public const string CDS_SPREAD_TICKER_7Y = "CDS_SPREAD_TICKER_7Y";
        public const string CDS_SPREAD_TICKER_10Y = "CDS_SPREAD_TICKER_10Y";

        public const string PRICING_SOURCE = "PRICING_SOURCE";
        public const string CURRENCY = "CRNCY";

        public const string MID_CDS_SPREAD_1Y = "1Y_MID_CDS_SPREAD";
        public const string MID_CDS_SPREAD_2Y = "2Y_MID_CDS_SPREAD";
        public const string MID_CDS_SPREAD_3Y = "3Y_MID_CDS_SPREAD";
        public const string MID_CDS_SPREAD_4Y = "4Y_MID_CDS_SPREAD";
        public const string MID_CDS_SPREAD_5Y = "5Y_MID_CDS_SPREAD";
        public const string MID_CDS_SPREAD_7Y = "7Y_MID_CDS_SPREAD";
        public const string MID_CDS_SPREAD_10Y = "10Y_MID_CDS_SPREAD";

        public const string BID = "BID";
        public const string MID = "MID";
        public const string ASK = "ASK";
        public const string QUOTE_BID = "QUOTE_BID";
        public const string QUOTE_MID = "QUOTE_MID";
        public const string QUOTE_ASK = "QUOTE_ASK";
        public const string PX_BID = "PX_BID";
        public const string PX_MID = "PX_BID";
        public const string PX_ASK = "PX_ASK";

        public const string PX_HIGH = "PX_HIGH";
        public const string PX_LOW = "PX_LOW";
        public const string PX_LAST = "PX_LAST";
        public const string LAST_PRICE = "LAST_PRICE";
        public const string LAST_TRADE = "LAST_TRADE";

        public const string RTG_MDY_SEN_UNSECURED_DEBT = "RTG_MDY_SEN_UNSECURED_DEBT";
        public const string RTG_MDY_ISSUER_RTG_WATCH = "RTG_MDY_ISSUER_RTG_WATCH";
        public const string RTG_MDY_ISSUER = "RTG_MDY_ISSUER";
        public const string RTG_MOODY_LONG_TERM = "RTG_MOODY_LONG_TERM";
        public const string RTG_MDY_OUTLOOK = "RTG_MDY_OUTLOOK";
        public const string RTG_MDY_SEN_UNSEC_RTG_DT = "RTG_MDY_SEN_UNSEC_RTG_DT";
        public const string RTG_MDY_OUTLOOK_DT = "RTG_MDY_OUTLOOK_DT";
        public const string RTG_SP_LT_LC_ISSUER_CREDIT = "RTG_SP_LT_LC_ISSUER_CREDIT";
        public const string SP_LT_LC_ISSUER_CREDIT_RTG_WATCH = "SP_LT_LC_ISSUER_CREDIT_RTG_WATCH";
        public const string RTG_SP_LT_FC_ISSUER_CREDIT = "RTG_SP_LT_FC_ISSUER_CREDIT";
        public const string SP_LT_FC_ISSUER_CREDIT_RTG_WATCH = "SP_LT_FC_ISSUER_CREDIT_RTG_WATCH";
        public const string RTG_SP_OUTLOOK = "RTG_SP_OUTLOOK";
        public const string RTG_SP_OUTLOOK_DT = "RTG_SP_OUTLOOK_DT";
        public const string RTG_FITCH_SEN_UNSECURED = "RTG_FITCH_SEN_UNSECURED";
        public const string RTG_FITCH_LT_ISSUER_DEFAULT = "RTG_FITCH_LT_ISSUER_DEFAULT";
        public const string RTG_FITCH_LONG_TERM_RTG_WATCH = "RTG_FITCH_LONG_TERM_RTG_WATCH";
        public const string RTG_FITCH_OUTLOOK = "RTG_FITCH_OUTLOOK";
        public const string RTG_FITCH_OUTLOOK_DT = "RTG_FITCH_OUTLOOK_DT";

        public const string INDUSTRY_SECTOR = "INDUSTRY_SECTOR";
        public const string EQY_FUND_IND = "EQY_FUND_IND";
        public const string INDUSTRY_GROUP = "INDUSTRY_GROUP";
        public const string INDUSTRY_SUBGROUP = "INDUSTRY_SUBGROUP";

        public const string CUR_MKT_CAP = "CUR_MKT_CAP";
        public const string MKT_CAP_LAST_TRD = "MKT_CAP_LAST_TRD";
        public const string CURRENT_MARKET_CAP_EOD = "CURRENT_MARKET_CAP_EOD";
        public const string CRNCY_ADJ_MKT_CAP = "CRNCY_ADJ_MKT_CAP";
        public const string CURRENT_MARKET_CAP_SHARE_CLASS = "CURRENT_MARKET_CAP_SHARE_CLASS";
        public const string TOT_DEBT_TO_TOT_CAP = "TOT_DEBT_TO_TOT_CAP";
        public const string TOT_DEBT_TO_COM_EQY = "TOT_DEBT_TO_COM_EQY";
        public const string INTEREST_COVERAGE_RATIO = "INTEREST_COVERAGE_RATIO";
        public const string CF_FREE_CASH_FLOW = "CF_FREE_CASH_FLOW";

        public const string RT_PX_CHG_NET_1D = "RT_PX_CHG_NET_1D";
        public const string RT_PX_CHG_PCT_1D = "RT_PX_CHG_PCT_1D";
        public const string CHG_PCT_1D = "CHG_PCT_1D";
        public const string CHG_PCT_YTD = "CHG_PCT_YTD";
        public const string CHG_NET_1D = "CHG_NET_1D";
        public const string CHG_NET_YTD = "CHG_NET_YTD";

        public const string EBITDA = "EBITDA";
        public const string ENTERPRISE_VALUE = "CURR_ENTP_VAL";
        public const string DDIS_AMT_OUTSTANDING = "DDIS_AMT_OUTSTANDING";
        public const string EQY_DVD_YLD_IND = "EQY_DVD_YLD_IND";
        public const string PE_RATIO = "PE_RATIO";

        public const string EQY_BETA = "EQY_BETA";
        public const string EXPECTED_REPORT_DT = "EXPECTED_REPORT_DT";
        public const string PX_TO_SALES_RATIO = "PX_TO_SALES_RATIO";
        public const string SI_PERCENT_EQUITY_FLOAT = "SI_PERCENT_EQUITY_FLOAT";
        public const string HIST_CALL_IMPL_VOL = "HIST_CALL_IMP_VOL";
        public const string VOL_MEAN = "VOL_MEAN";

        public const string SHORT_AND_LONG_TERM_DEBT = "SHORT_AND_LONG_TERM_DEBT";
        public const string BS_TOT_ASSET = "BS_TOT_ASSET";

        public const string VOLUME_PCT_5_20 = "VOLUME_PCT_5_20";
        public const string SALES_GROWTH = "SALES_GROWTH";

        public const string QUOTE_FACTOR = "QUOTE_FACTOR";

        
        public static readonly List<string> fieldsInit_EqTickerForCache = new List<string> { RTG_MDY_SEN_UNSECURED_DEBT, RTG_SP_LT_LC_ISSUER_CREDIT, RTG_FITCH_SEN_UNSECURED,
                                                                                             INDUSTRY_SECTOR, CUR_MKT_CAP, TOT_DEBT_TO_TOT_CAP, TOT_DEBT_TO_COM_EQY, INTEREST_COVERAGE_RATIO,
                                                                                             EQY_DVD_YLD_IND, ENTERPRISE_VALUE, DDIS_AMT_OUTSTANDING, PE_RATIO, EBITDA,
                                                                                             HIST_CALL_IMPL_VOL, VOL_MEAN, BS_TOT_ASSET, SHORT_AND_LONG_TERM_DEBT, CURRENCY,
                                                                                             PRICING_SOURCE, SECURITY_NAME
                                                                                           };

        public static readonly List<string> fields_EqForSpreadTicker = new List<string> {   CDS_SPREAD_TICKER_1Y, CDS_SPREAD_TICKER_2Y, CDS_SPREAD_TICKER_3Y, CDS_SPREAD_TICKER_4Y, 
                                                                                            CDS_SPREAD_TICKER_5Y, CDS_SPREAD_TICKER_7Y, CDS_SPREAD_TICKER_10Y
                                                                                        };
    }
}
