﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using CDSHeatMap.Interface;

namespace CDSHeatMap.BloombergAPIManager
{
    internal class MarketDataResult : IMarketDataResult
    {
        private List<IDataField> _fields;

        private Dictionary<string, List<IDataField>> _tickerDataFields;
        private Dictionary<string, List<IRateDataField>> _tickerRateDataFields;

        private string _startDate;
        private string _endDate;

        internal MarketDataResult(ITicker ticker, string field)
        {
            Ticker = ticker;

            _fields = new List<IDataField>();

            _fields.Add(new DataField(field));
        }

        internal MarketDataResult(IEnumerable<string> tickerList, IEnumerable<string> fields)
        {
            _tickerDataFields = new Dictionary<string, List<IDataField>>();

            foreach (var ticker in tickerList)
            {
                if (_tickerDataFields.ContainsKey(ticker))
                    continue;

                var _dataFields = new List<IDataField>();
                foreach (var field in fields)
                    _dataFields.Add(new DataField(field));

                _tickerDataFields.Add(ticker, _dataFields);
            }

        }

        internal MarketDataResult(ITicker ticker, IEnumerable<string> fields, string startdate, string enddate)
        {
            Ticker = ticker;

            _startDate = startdate;
            _endDate = enddate;

            _tickerRateDataFields = new Dictionary<string, List<IRateDataField>>();

            var _rateDataFields = new List<IRateDataField>();
            foreach (var field in fields)
                _rateDataFields.Add(new RateDataField(field));

            _tickerRateDataFields.Add(ticker.Ticker, _rateDataFields);
        }

        internal MarketDataResult(IEnumerable<string> tickerList, IEnumerable<string> fields, string startdate, string enddate)
        {
            _startDate = startdate;
            _endDate = enddate;

            _tickerRateDataFields = new Dictionary<string, List<IRateDataField>>();

            foreach (var ticker in tickerList)
            {
                if (_tickerRateDataFields.ContainsKey(ticker))
                    continue;

                var _rateDataFields = new List<IRateDataField>();
                foreach (var field in fields)
                    _rateDataFields.Add(new RateDataField(field));

                _tickerRateDataFields.Add(ticker, _rateDataFields);
            }

        }

        internal MarketDataResult(IEnumerable<ITicker> tickerList, IEnumerable<string> fields, string startdate, string enddate)
        {
            _startDate = startdate;
            _endDate = enddate;

            _tickerRateDataFields = new Dictionary<string, List<IRateDataField>>();

            foreach (var ticker in tickerList)
            {
                if (_tickerRateDataFields.ContainsKey(ticker.Ticker))
                    continue;

                var _rateDataFields = new List<IRateDataField>();
                foreach (var field in fields)
                    _rateDataFields.Add(new RateDataField(field));

                _tickerRateDataFields.Add(ticker.Ticker, _rateDataFields);
            }

        }

        

        public IList<IDataField> DataFields
        {
            get { return _fields; }
        }

        public Dictionary<string, List<IDataField>> TickerDataFields
        {
            get { return _tickerDataFields; }
        }

        public Dictionary<string, List<IRateDataField>> TickerRateDataFields
        {
            get { return _tickerRateDataFields; }
        }

        public string StartDate
        {
            get { return _startDate; }
        }

        public string EndDate
        {
            get { return _endDate; }
        }

        public ITicker Ticker { get; private set; }

        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (_fields != null && _fields.Count > 0)
                    _fields.Clear();

                if (_tickerDataFields != null && _tickerDataFields.Count > 0)
                    _tickerDataFields.Clear();

                if (_tickerRateDataFields != null && _tickerRateDataFields.Count > 0)
                    _tickerRateDataFields.Clear();
            }
            // free native resources
        }

        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        /*
        public bool IsCompleted { get; private set; }

        internal void Completed()
        {
            IsCompleted = true;
        }
        */
    }
}
