﻿using System.Collections.Generic;
using System.Linq;
using Bloomberglp.Blpapi;
using CDSHeatMap.Interface;

namespace CDSHeatMap.BloombergAPIManager
{
    internal class MarketDataSubscription : IMarketDataSubscription
    {
        #region IMarketDataSubscription Members
        
        public ITicker Ticker { get; private set; }

        public string SubscriptionTicker { get; private set; }

        public IList<IDataField> DataFields { get; private set; }

        #endregion

        public Subscription Subscription { get; private set; }

        internal MarketDataSubscription(ITicker ticker, IEnumerable<string> fields)
        {
            Ticker = ticker;
            DataFields = new List<IDataField>();

            string interval = string.Format("interval=" + 3);
            List<string> options = new List<string>();
            options.Add(interval);
            
            foreach (var field in fields)
                DataFields.Add(new DataField(field));

            SubscriptionTicker = ticker.Ticker;

            Subscription = new Subscription(ticker.Ticker, fields.ToList(), options, new CorrelationID(this));
        }
    }
}
