﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CDSHeatMap.BloombergAPIManager;
using CDSHeatMap.Model;
using CDSHeatMap.ViewModel;
using CDSHeatMap.Util;
using CDSHeatMap.DBManager;
using System.Diagnostics;
using System.Threading;

namespace CDSHeatMap.BloombergDataManager
{
    public class CacheManager
    {
        public DataManager dataManager;

        public PersistenceManager<PersistTickerFilterList> PSMTickerFilterList = new PersistenceManager<PersistTickerFilterList>();
        public PersistenceManager<TickerFilterItems> PSMTickerFilterItems = new PersistenceManager<TickerFilterItems>();
        public PersistenceManager<PersistLastParams> PSMLastParameters = new PersistenceManager<PersistLastParams>();

        public static bool appLastParamsRetrieved = false;
        public static PersistLastParams AppLastParams = new PersistLastParams();
        public static PersistTickerFilterList TickerFilterListCache = new PersistTickerFilterList();
        
        /*
        public static Dictionary<string, BloombergData<double>> LastPriceCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> ChgPctYTDCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> ChgPct1DCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> ChgNetYTDCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> ChgNet1DCache = new Dictionary<string, BloombergData<double>>();
        */

        public static Dictionary<string, BloombergData<string>> IndustryCache = new Dictionary<string, BloombergData<string>>();
        public static Dictionary<string, BloombergData<string>> MoodysRatingCache = new Dictionary<string, BloombergData<string>>();
        public static Dictionary<string, BloombergData<string>> FitchRatingCache = new Dictionary<string, BloombergData<string>>();
        public static Dictionary<string, BloombergData<string>> SPRatingCache = new Dictionary<string, BloombergData<string>>();
        public static Dictionary<string, BloombergData<double>> MarketCapCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> TotalDebtToCapCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> DebtToCommonEqCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> InterestCovRatioCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> VolumeChg5d20dCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> SalesGrowthCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> HistCallImplVolCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> VolMeanCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> ShortInterestCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> PriceToSalesRatioCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> TotalDebtCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> TotalAssetCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<DateTime>> ExpectedRptDateCache = new Dictionary<string, BloombergData<DateTime>>();
        public static Dictionary<string, BloombergData<double>> EbitdaCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> EqDividendYieldCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> EnterpriseValueCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> DebtOSCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> PERatioCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> EQBetaCache = new Dictionary<string, BloombergData<double>>();

        public static Dictionary<string, BloombergData<string>> CDSRefNameCache = new Dictionary<string, BloombergData<string>>();
        public static Dictionary<string, BloombergData<string>> PricingSourceCache = new Dictionary<string, BloombergData<string>>();
        public static Dictionary<string, BloombergData<string>> CurrencyCache = new Dictionary<string, BloombergData<string>>();
        public static Dictionary<string, BloombergData<string>> CurrencyCDSCache = new Dictionary<string, BloombergData<string>>();
        public static Dictionary<string, List<BloombergData<string>>> CDSSpreadMatNameCache = new Dictionary<string, List<BloombergData<string>>>();
        public static Dictionary<string, List<BloombergData<string>>> CDSIndexEqTickerCache = new Dictionary<string, List<BloombergData<string>>>();

        public static Dictionary<string, BloombergData<double>> HistoricalPriceCache = new Dictionary<string, BloombergData<double>>();
        public static Dictionary<string, BloombergData<double>> FXRateCache = new Dictionary<string, BloombergData<double>>();

        public List<string> CDSIndexIndustryList;
        public List<string> CDSIndexRatingsList;

        public List<CDSIndexBase> CDSIndexList;

        public CacheManager()
        {
            Trace.WriteLine("CacheManager is created.", "TRACE");
            dataManager = new DataManager();

            CDSIndexIndustryList = new List<string>();
            CDSIndexRatingsList = new List<string>();
            CDSIndexList = new List<CDSIndexBase>();
        }

        public void getInitialCDSIndex(CDSIndex cdsIndex, List<string> AdditionalFields = null)
        {
            Trace.WriteLine("getInitialCDSIndex is called for " + cdsIndex.CDSIndexName, "TRACE");

            CDSIndexIndustryList.Clear();
            CDSIndexRatingsList.Clear();

            List<BloombergData<string>> CDSIndexEqTickerList;
            Dictionary<string, List<string>> FieldByCDSTickerList = new Dictionary<string, List<string>>();

            List<string> EqTickerForSpreadTicker = new List<string>();

            if (CDSIndexEqTickerCache.TryGetValue(cdsIndex.CDSIndexName, out CDSIndexEqTickerList))
            {
                Trace.WriteLine(cdsIndex.CDSIndexName + " found in the cache.", "TRACE");

                foreach (var EqTickerData in CDSIndexEqTickerList)
                {
                    var ticker = EqTickerData.getData();
                    cdsIndex.addCDSIndexMember(ticker);    /*equityTicker*/

                    var member = cdsIndex.CDSIndexMemberList.Last();
                    List<BloombergData<string>> CDSSpreadMatTickerList;

                    if (CDSSpreadMatNameCache.TryGetValue(ticker, out CDSSpreadMatTickerList))
                    {
                        foreach (var spreadMaturity in CDSSpreadMatTickerList)
                        {
                            member.createTickerSpread(spreadMaturity.getData());
                        }
                    }
                    else
                    {
                        EqTickerForSpreadTicker.Add(member.getTickerEquity());
                    }
                }

                if (EqTickerForSpreadTicker.Count > 0)
                {   //get Spread Maturity
                    retrieveCDSSpreadTicker(cdsIndex, EqTickerForSpreadTicker);
                }

                Dictionary<string, List<string>> FieldByTickerList = new Dictionary<string, List<string>>();

                List<string> EqTickerFieldList;

                if (AdditionalFields != null)
                    EqTickerFieldList = DataFieldNames.fieldsInit_EqTickerForCache.Concat(AdditionalFields).ToList();
                else
                    EqTickerFieldList = DataFieldNames.fieldsInit_EqTickerForCache;

                EqTickerFieldList.Add(DataFieldNames.PRICING_SOURCE);

                foreach (var field in EqTickerFieldList)
                {
                    List<string> fieldTickerList = new List<string>();

                    foreach (CDSIndexMember member in cdsIndex.CDSIndexMemberList)
                    {
                        string ticker = member.getTickerEquity();
                        if (ticker == "")
                            continue;

                        if (field == DataFieldNames.SECURITY_NAME)
                        {
                            BloombergData<string> data;
                            if (CDSRefNameCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.CDSRefName = data.getData();
                                else
                                    member.CDSRefName = "";
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.INDUSTRY_SECTOR)
                        {
                            BloombergData<string> data;
                            if (IndustryCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.IndustryName = data.getData();
                                else
                                    member.IndustryName = "";

                                if (!CDSIndexIndustryList.Contains(member.IndustryName))
                                    CDSIndexIndustryList.Add(member.IndustryName);
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.RTG_MDY_SEN_UNSECURED_DEBT)
                        {
                            BloombergData<string> data;
                            if (MoodysRatingCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.MoodysRating = data.getData();
                                else
                                    member.MoodysRating = ConstantItemList.MOODYSNAV;

                                if (!CDSIndexRatingsList.Contains(member.MoodysRating))
                                    CDSIndexRatingsList.Add(member.MoodysRating);
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.RTG_SP_LT_LC_ISSUER_CREDIT)
                        {
                            BloombergData<string> data;
                            if (SPRatingCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.SPRating = data.getData();
                                else
                                    member.SPRating = "";
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.RTG_FITCH_SEN_UNSECURED)
                        {
                            BloombergData<string> data;
                            if (FitchRatingCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.FitchRating = data.getData();
                                else
                                    member.FitchRating = "";
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.CUR_MKT_CAP)
                        {
                            BloombergData<double> data;
                            if (MarketCapCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.MarketCapital = data.getData();
                                else
                                    member.MarketCapital = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.TOT_DEBT_TO_TOT_CAP)
                        {
                            BloombergData<double> data;
                            if (TotalDebtToCapCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.TotalDebtToCapital = data.getData();
                                else
                                    member.TotalDebtToCapital = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.TOT_DEBT_TO_COM_EQY)
                        {
                            BloombergData<double> data;
                            if (DebtToCommonEqCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.DebtToCommonEquity = data.getData();
                                else
                                    member.DebtToCommonEquity = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.INTEREST_COVERAGE_RATIO)
                        {
                            BloombergData<double> data;
                            if (InterestCovRatioCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.InterestCoverageRatio = data.getData();
                                else
                                    member.InterestCoverageRatio = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.EQY_DVD_YLD_IND)
                        {
                            BloombergData<double> data;
                            if (EqDividendYieldCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.EqDividendeYield = data.getData();
                                else
                                    member.EqDividendeYield = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.ENTERPRISE_VALUE)
                        {
                            BloombergData<double> data;
                            if (EnterpriseValueCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.EnterpriseValue = data.getData();
                                else
                                    member.EnterpriseValue = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.DDIS_AMT_OUTSTANDING)
                        {
                            BloombergData<double> data;
                            if (DebtOSCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.DebtOS = data.getData();
                                else
                                    member.DebtOS = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.PE_RATIO)
                        {
                            BloombergData<double> data;
                            if (PERatioCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.PeRatio = data.getData();
                                else
                                    member.PeRatio = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }

                        else if (field == DataFieldNames.EBITDA)
                        {
                            BloombergData<double> data;
                            if (EbitdaCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.EBITDA = data.getData();
                                else
                                    member.EBITDA = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.EXPECTED_REPORT_DT)
                        {
                            BloombergData<DateTime> data;
                            if (ExpectedRptDateCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.ExpectedReportDT = data.getData();
                                else
                                    member.ExpectedReportDT = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.SI_PERCENT_EQUITY_FLOAT)
                        {
                            BloombergData<double> data;
                            if (ShortInterestCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.ShortInterest = data.getData();
                                else
                                    member.ShortInterest = null;
                            }
                            else
                                fieldTickerList.Add(ticker);

                        }
                        else if (field == DataFieldNames.PX_TO_SALES_RATIO)
                        {
                            BloombergData<double> data;
                            if (PriceToSalesRatioCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.PriceToSalesRatio = data.getData();
                                else
                                    member.PriceToSalesRatio = null;
                            }
                            else
                                fieldTickerList.Add(ticker);

                        }
                        else if (field == DataFieldNames.EQY_BETA)
                        {
                            BloombergData<double> data;
                            if (EQBetaCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.EQBeta = data.getData();
                                else
                                    member.EQBeta = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.SHORT_AND_LONG_TERM_DEBT)
                        {
                            BloombergData<double> data;
                            if (TotalDebtCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.TotalDebt = data.getData();
                                else
                                    member.TotalDebt = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.BS_TOT_ASSET)
                        {
                            BloombergData<double> data;
                            if (TotalAssetCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.TotalAssets = data.getData();
                                else
                                    member.TotalAssets = null;
                            }
                            else
                                fieldTickerList.Add(ticker);

                        }
                        else if (field == DataFieldNames.VOLUME_PCT_5_20)
                        {
                            BloombergData<double> data;
                            if (VolumeChg5d20dCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.VolumeChg5d20d = data.getData();
                                else
                                    member.VolumeChg5d20d = null;
                            }
                            else
                                fieldTickerList.Add(ticker);

                        }
                        else if (field == DataFieldNames.SALES_GROWTH)
                        {
                            BloombergData<double> data;
                            if (SalesGrowthCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.SalesGrowth = data.getData();
                                else
                                    member.SalesGrowth = null;
                            }
                            else
                                fieldTickerList.Add(ticker);

                        }
                        else if (field == DataFieldNames.HIST_CALL_IMPL_VOL)
                        {
                            BloombergData<double> data;
                            if (HistCallImplVolCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.HistCallImplVol = data.getData();
                                else
                                    member.HistCallImplVol = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.VOL_MEAN)
                        {
                            BloombergData<double> data;
                            if (VolMeanCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.VolMean = data.getData();
                                else
                                    member.VolMean = null;
                            }
                            else
                                fieldTickerList.Add(ticker);
                        }
                        else if (field == DataFieldNames.PRICING_SOURCE)
                        {
                            BloombergData<string> data;
                            if (PricingSourceCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.PricingSource = data.getData();
                                else
                                    member.PricingSource = "";
                            }
                            else
                            {
                                if (member.getTickerSpread(4) != "")
                                    fieldTickerList.Add(member.getTickerSpread(4));
                            }
                        }
                        else if (field == DataFieldNames.CURRENCY)
                        {
                            BloombergData<string> data;
                            if (CurrencyCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.Currency = data.getData();
                                else
                                    member.Currency = "";
                            }
                            else
                                fieldTickerList.Add(ticker);

                            if (CurrencyCDSCache.TryGetValue(ticker, out data))
                            {
                                if (!data.isDataNull())
                                    member.CurrencyCDS = data.getData();
                                else
                                    member.CurrencyCDS = "";
                            }
                            else
                            {
                                if (member.getTickerSpread(4) != "")
                                    fieldTickerList.Add(member.getTickerSpread(4));
                            }
                        }

                    }

                    if (fieldTickerList.Count > 0)
                        FieldByTickerList.Add(field, fieldTickerList);
                }


                updateFieldByTickerList(FieldByTickerList, cdsIndex.CDSIndexMemberList);

                dataManager.GetInitEquitySpreadTickerPrice(cdsIndex.CDSIndexMemberList, true);
            }
            else
            {
                Trace.WriteLine(cdsIndex.CDSIndexName + " is not in the cache, retrieving data from Bloomberg", "TRACE");

                dataManager.GetInitCDSIndex(cdsIndex, AdditionalFields);

                Trace.WriteLine(cdsIndex.CDSIndexName + " is returned", "TRACE");

                Thread thread = new Thread(() =>
                {
                    try
                    {
                        List<BloombergData<string>> memberTickerList = new List<BloombergData<string>>();

                        foreach (CDSIndexMember member in cdsIndex.CDSIndexMemberList)
                        {
                            string ticker = member.getTickerEquity();

                            if (ticker == "")
                                continue;

                            if (!CDSIndexRatingsList.Contains(member.MoodysRating))
                                CDSIndexRatingsList.Add(member.MoodysRating);

                            if (!CDSIndexIndustryList.Contains(member.IndustryName))
                                CDSIndexIndustryList.Add(member.IndustryName);

                            memberTickerList.Add(new BloombergData<string>(member.TickerEquity));

                            List<BloombergData<string>> spreadMatList = new List<BloombergData<string>>();

                            foreach (var spreadMat in member.TickerSpreadList)
                            {
                                spreadMatList.Add(new BloombergData<string>(spreadMat));
                            }

                            if (CDSSpreadMatNameCache.ContainsKey(member.TickerEquity))
                            {
                                CDSSpreadMatNameCache[member.TickerEquity] = spreadMatList;
                            }
                            else
                                CDSSpreadMatNameCache.Add(member.TickerEquity, spreadMatList);

                            if (CDSRefNameCache.ContainsKey(ticker))
                            {
                                CDSRefNameCache[ticker].updateData(member.CDSRefName);
                            }
                            else
                                CDSRefNameCache.Add(ticker, new BloombergData<string>(member.CDSRefName));

                            if (PricingSourceCache.ContainsKey(ticker))
                            {
                                PricingSourceCache[ticker].updateData(member.PricingSource);
                            }
                            else
                                PricingSourceCache.Add(ticker, new BloombergData<string>(member.PricingSource));

                            if (CurrencyCache.ContainsKey(ticker))
                            {
                                CurrencyCache[ticker].updateData(member.Currency);
                            }
                            else
                                CurrencyCache.Add(ticker, new BloombergData<string>(member.Currency));

                            if (CurrencyCDSCache.ContainsKey(ticker))
                            {
                                CurrencyCDSCache[ticker].updateData(member.CurrencyCDS);
                            }
                            else
                                CurrencyCDSCache.Add(ticker, new BloombergData<string>(member.CurrencyCDS));

                            if (IndustryCache.ContainsKey(ticker))
                            {
                                IndustryCache[ticker].updateData(member.IndustryName);
                            }
                            else
                                IndustryCache.Add(ticker, new BloombergData<string>(member.IndustryName));

                            if (MoodysRatingCache.ContainsKey(ticker))
                            {
                                MoodysRatingCache[ticker].updateData(member.MoodysRating);
                            }
                            else
                                MoodysRatingCache.Add(ticker, new BloombergData<string>(member.MoodysRating));

                            if (FitchRatingCache.ContainsKey(ticker))
                            {
                                FitchRatingCache[ticker].updateData(member.FitchRating);
                            }
                            else
                                FitchRatingCache.Add(ticker, new BloombergData<string>(member.FitchRating));

                            if (SPRatingCache.ContainsKey(ticker))
                            {
                                SPRatingCache[ticker].updateData(member.SPRating);
                            }
                            else
                                SPRatingCache.Add(ticker, new BloombergData<string>(member.SPRating));

                            if (MarketCapCache.ContainsKey(ticker))
                            {
                                if (member.MarketCapital != null)
                                    MarketCapCache[ticker].updateData(member.MarketCapital ?? 0.0);
                                else
                                    MarketCapCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.MarketCapital != null)
                                    MarketCapCache.Add(ticker, new BloombergData<double>(member.MarketCapital ?? 0.0));
                                else
                                    MarketCapCache.Add(ticker, new BloombergData<double>());
                            }

                            if (TotalDebtToCapCache.ContainsKey(ticker))
                            {
                                if (member.TotalDebtToCapital != null)
                                    TotalDebtToCapCache[ticker].updateData(member.TotalDebtToCapital ?? 0.0);
                                else
                                    TotalDebtToCapCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.TotalDebtToCapital != null)
                                    TotalDebtToCapCache.Add(ticker, new BloombergData<double>(member.TotalDebtToCapital ?? 0.0));
                                else
                                    TotalDebtToCapCache.Add(ticker, new BloombergData<double>());
                            }

                            if (DebtToCommonEqCache.ContainsKey(ticker))
                            {
                                if (member.DebtToCommonEquity != null)
                                    DebtToCommonEqCache[ticker].updateData(member.DebtToCommonEquity ?? 0.0);
                                else
                                    DebtToCommonEqCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.DebtToCommonEquity != null)
                                    DebtToCommonEqCache.Add(ticker, new BloombergData<double>(member.DebtToCommonEquity ?? 0.0));
                                else
                                    DebtToCommonEqCache.Add(ticker, new BloombergData<double>());
                            }

                            if (InterestCovRatioCache.ContainsKey(ticker))
                            {
                                if (member.InterestCoverageRatio != null)
                                    InterestCovRatioCache[ticker].updateData(member.InterestCoverageRatio ?? 0.0);
                                else
                                    InterestCovRatioCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.InterestCoverageRatio != null)
                                    InterestCovRatioCache.Add(ticker, new BloombergData<double>(member.InterestCoverageRatio ?? 0.0));
                                else
                                    InterestCovRatioCache.Add(ticker, new BloombergData<double>());
                            }

                            if (EqDividendYieldCache.ContainsKey(ticker))
                            {
                                if (member.EqDividendeYield != null)
                                    EqDividendYieldCache[ticker].updateData(member.EqDividendeYield ?? 0.0);
                                else
                                    EqDividendYieldCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EqDividendeYield != null)
                                    EqDividendYieldCache.Add(ticker, new BloombergData<double>(member.EqDividendeYield ?? 0.0));
                                else
                                    EqDividendYieldCache.Add(ticker, new BloombergData<double>());
                            }

                            if (EnterpriseValueCache.ContainsKey(ticker))
                            {
                                if (member.EnterpriseValue != null)
                                    EnterpriseValueCache[ticker].updateData(member.EnterpriseValue ?? 0.0);
                                else
                                    EqDividendYieldCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EnterpriseValue != null)
                                    EnterpriseValueCache.Add(ticker, new BloombergData<double>(member.EnterpriseValue ?? 0.0));
                                else
                                    EnterpriseValueCache.Add(ticker, new BloombergData<double>());
                            }

                            if (DebtOSCache.ContainsKey(ticker))
                            {
                                if (member.DebtOS != null)
                                    DebtOSCache[ticker].updateData(member.DebtOS ?? 0.0);
                                else
                                    DebtOSCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.DebtOS != null)
                                    DebtOSCache.Add(ticker, new BloombergData<double>(member.DebtOS ?? 0.0));
                                else
                                    DebtOSCache.Add(ticker, new BloombergData<double>());
                            }

                            if (PERatioCache.ContainsKey(ticker))
                            {
                                if (member.PeRatio != null)
                                    PERatioCache[ticker].updateData(member.PeRatio ?? 0.0);
                                else
                                    PERatioCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.PeRatio != null)
                                    PERatioCache.Add(ticker, new BloombergData<double>(member.PeRatio ?? 0.0));
                                else
                                    PERatioCache.Add(ticker, new BloombergData<double>());
                            }

                            if (EbitdaCache.ContainsKey(ticker))
                            {
                                if (member.EBITDA != null)
                                    EbitdaCache[ticker].updateData(member.EBITDA ?? 0.0);
                                else
                                    EbitdaCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EBITDA != null)
                                    EbitdaCache.Add(ticker, new BloombergData<double>(member.EBITDA ?? 0.0));
                                else
                                    EbitdaCache.Add(ticker, new BloombergData<double>());
                            }


                            if (TotalDebtCache.ContainsKey(ticker))
                            {
                                if (member.TotalDebt != null)
                                    TotalDebtCache[ticker].updateData(member.TotalDebt ?? 0.0);
                                else
                                    TotalDebtCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.TotalDebt != null)
                                    TotalDebtCache.Add(ticker, new BloombergData<double>(member.TotalDebt ?? 0.0));
                                else
                                    TotalDebtCache.Add(ticker, new BloombergData<double>());
                            }

                            if (TotalAssetCache.ContainsKey(ticker))
                            {
                                if (member.TotalAssets != null)
                                    TotalAssetCache[ticker].updateData(member.TotalAssets ?? 0.0);
                                else
                                    TotalAssetCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.TotalAssets != null)
                                    TotalAssetCache.Add(ticker, new BloombergData<double>(member.TotalAssets ?? 0.0));
                                else
                                    TotalAssetCache.Add(ticker, new BloombergData<double>());
                            }

                            if (HistCallImplVolCache.ContainsKey(ticker))
                            {
                                if (member.HistCallImplVol != null)
                                    HistCallImplVolCache[ticker].updateData(member.HistCallImplVol ?? 0.0);
                                else
                                    HistCallImplVolCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.HistCallImplVol != null)
                                    HistCallImplVolCache.Add(ticker, new BloombergData<double>(member.HistCallImplVol ?? 0.0));
                                else
                                    HistCallImplVolCache.Add(ticker, new BloombergData<double>());
                            }

                            if (VolMeanCache.ContainsKey(ticker))
                            {
                                if (member.VolMean != null)
                                    VolMeanCache[ticker].updateData(member.VolMean ?? 0.0);
                                else
                                    VolMeanCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.VolMean != null)
                                    VolMeanCache.Add(ticker, new BloombergData<double>(member.VolMean ?? 0.0));
                                else
                                    VolMeanCache.Add(ticker, new BloombergData<double>());
                            }


                            if (AdditionalFields != null)
                            {
                                foreach (string field in AdditionalFields)
                                {
                                    if (field == DataFieldNames.EXPECTED_REPORT_DT)
                                    {
                                        if (ExpectedRptDateCache.ContainsKey(ticker))
                                        {
                                            if (member.ExpectedReportDT != null)
                                                ExpectedRptDateCache[ticker].updateData(member.ExpectedReportDT ?? DateTime.Now);
                                            else
                                                ExpectedRptDateCache[ticker].updateData();
                                        }
                                        else
                                        {
                                            if (member.ExpectedReportDT != null)
                                                ExpectedRptDateCache.Add(ticker, new BloombergData<DateTime>(member.ExpectedReportDT ?? DateTime.Now));
                                            else
                                                ExpectedRptDateCache.Add(ticker, new BloombergData<DateTime>());
                                        }
                                    }
                                    else if (field == DataFieldNames.SI_PERCENT_EQUITY_FLOAT)
                                    {
                                        if (ShortInterestCache.ContainsKey(ticker))
                                        {
                                            if (member.ShortInterest != null)
                                                ShortInterestCache[ticker].updateData(member.ShortInterest ?? 0.0);
                                            else
                                                ShortInterestCache[ticker].updateData();
                                        }
                                        else
                                        {
                                            if (member.ShortInterest != null)
                                                ShortInterestCache.Add(ticker, new BloombergData<double>(member.ShortInterest ?? 0.0));
                                            else
                                                ShortInterestCache.Add(ticker, new BloombergData<double>());
                                        }
                                    }
                                    else if (field == DataFieldNames.PX_TO_SALES_RATIO)
                                    {
                                        if (PriceToSalesRatioCache.ContainsKey(ticker))
                                        {
                                            if (member.PriceToSalesRatio != null)
                                                PriceToSalesRatioCache[ticker].updateData(member.PriceToSalesRatio ?? 0.0);
                                            else
                                                PriceToSalesRatioCache[ticker].updateData();
                                        }
                                        else
                                        {
                                            if (member.PriceToSalesRatio != null)
                                                PriceToSalesRatioCache.Add(ticker, new BloombergData<double>(member.PriceToSalesRatio ?? 0.0));
                                            else
                                                PriceToSalesRatioCache.Add(ticker, new BloombergData<double>());
                                        }
                                    }
                                    else if (field == DataFieldNames.EQY_BETA)
                                    {
                                        if (EQBetaCache.ContainsKey(ticker))
                                        {
                                            if (member.EQBeta != null)
                                                EQBetaCache[ticker].updateData(member.EQBeta ?? 0.0);
                                            else
                                                EQBetaCache[ticker].updateData();
                                        }
                                        else
                                        {
                                            if (member.EQBeta != null)
                                                EQBetaCache.Add(ticker, new BloombergData<double>(member.EQBeta ?? 0.0));
                                            else
                                                EQBetaCache.Add(ticker, new BloombergData<double>());
                                        }
                                    }
                                    else if (field == DataFieldNames.VOLUME_PCT_5_20)
                                    {
                                        if (VolumeChg5d20dCache.ContainsKey(ticker))
                                        {
                                            if (member.VolumeChg5d20d != null)
                                                VolumeChg5d20dCache[ticker].updateData(member.VolumeChg5d20d ?? 0.0);
                                            else
                                                VolumeChg5d20dCache[ticker].updateData();
                                        }
                                        else
                                        {
                                            if (member.VolumeChg5d20d != null)
                                                VolumeChg5d20dCache.Add(ticker, new BloombergData<double>(member.VolumeChg5d20d ?? 0.0));
                                            else
                                                VolumeChg5d20dCache.Add(ticker, new BloombergData<double>());
                                        }
                                    }
                                    else if (field == DataFieldNames.SALES_GROWTH)
                                    {
                                        if (SalesGrowthCache.ContainsKey(ticker))
                                        {
                                            if (member.SalesGrowth != null)
                                                SalesGrowthCache[ticker].updateData(member.SalesGrowth ?? 0.0);
                                            else
                                                SalesGrowthCache[ticker].updateData();
                                        }
                                        else
                                        {
                                            if (member.SalesGrowth != null)
                                                SalesGrowthCache.Add(ticker, new BloombergData<double>(member.SalesGrowth ?? 0.0));
                                            else
                                                SalesGrowthCache.Add(ticker, new BloombergData<double>());
                                        }
                                    }
                                }
                            }
                        }

                        if (CDSIndexEqTickerCache.ContainsKey(cdsIndex.CDSIndexName))
                        {
                            CDSIndexEqTickerCache[cdsIndex.CDSIndexName] = memberTickerList;
                        }
                        else
                            CDSIndexEqTickerCache.Add(cdsIndex.CDSIndexName, memberTickerList);
                    }
                    catch (Exception e1)
                    {
                        Trace.WriteLine("Exception while running Thread in getInitialCDSIndex: " + e1.Message, "ERROR");
                        string stackTrace = "";
                        if (e1.StackTrace != null)
                            stackTrace = e1.StackTrace.ToString();

                        Trace.WriteLine("Exception while running Thread in getInitialCDSIndex: " + stackTrace, "INFO");
                    }
                });
                thread.Start();
            }

            getFXRate(cdsIndex.CDSIndexMemberList);

            Trace.WriteLine("getInitialCDSIndex is completed for " + cdsIndex.CDSIndexName, "TRACE");
        }

        public void getInitialTickerFilterData(TickerFilter tickerFilter, List<string> AdditionalFields = null)
        {
            Trace.WriteLine("getInitialTickerFilterData is called for " + tickerFilter.TickerFilterName, "TRACE");

            CDSIndexIndustryList.Clear();
            CDSIndexRatingsList.Clear();

            List<BloombergData<string>> CDSIndexEqTickerList;
            Dictionary<string, List<string>> FieldByCDSTickerList = new Dictionary<string, List<string>>();

            List<string> EqTickerForSpreadTicker = new List<string>();

            bool foundCDSmembers = true;

            if (!CDSIndexEqTickerCache.TryGetValue(tickerFilter.TFCDSIndex.CDSIndexName, out CDSIndexEqTickerList))
            {
                foundCDSmembers = false;

                CDSIndexEqTickerList = new List<BloombergData<string>>();

                dataManager.GetCDSIndexMembers(tickerFilter.TFCDSIndex);

                foreach (CDSIndexMember member in tickerFilter.TFCDSIndex.CDSIndexMemberList)
                {
                    string ticker = member.getTickerEquity();

                    if (ticker == "")
                        continue;

                    CDSIndexEqTickerList.Add(new BloombergData<string>(member.TickerEquity));

                    if (CDSRefNameCache.ContainsKey(ticker))
                    {
                        CDSRefNameCache[ticker].updateData(member.CDSRefName);
                    }
                    else
                        CDSRefNameCache.Add(ticker, new BloombergData<string>(member.CDSRefName));
                }

                if (CDSIndexEqTickerCache.ContainsKey(tickerFilter.TFCDSIndex.CDSIndexName))
                {
                    CDSIndexEqTickerCache[tickerFilter.TFCDSIndex.CDSIndexName] = CDSIndexEqTickerList;
                }
                else
                    CDSIndexEqTickerCache.Add(tickerFilter.TFCDSIndex.CDSIndexName, CDSIndexEqTickerList);
            }

            //foreach (var EqTickerData in CDSIndexEqTickerList)
            foreach (var member in tickerFilter.TFCDSIndex.CDSIndexMemberList)
            {
                var ticker = member.TickerEquity;
                //var ticker = EqTickerData.getData();

                /* caused duplication in CDS Index after cacheManager.initTickerFilter function
                if (foundCDSmembers)
                {
                    tickerFilter.TFCDSIndex.addCDSIndexMember(ticker);    
                }
                var member = tickerFilter.TFCDSIndex.CDSIndexMemberList[i++];
                */

                string eqticker = member.getTickerEquity();

                if (foundCDSmembers)
                {
                    BloombergData<string> dataRef;
                    if (CDSRefNameCache.TryGetValue(eqticker, out dataRef))
                    {
                        if (!dataRef.isDataNull())
                            member.CDSRefName = dataRef.getData();
                        else
                            member.CDSRefName = "";
                    }
                }

                List<BloombergData<string>> CDSSpreadMatTickerList;

                if (CDSSpreadMatNameCache.TryGetValue(ticker, out CDSSpreadMatTickerList))
                {
                    foreach (var spreadMaturity in CDSSpreadMatTickerList)
                    {
                        member.createTickerSpread(spreadMaturity.getData());
                    }
                }
                else
                {
                    EqTickerForSpreadTicker.Add(member.getTickerEquity());
                }
            }

            foreach (var ticker in tickerFilter.AddedTickerList)
            {
                //insert/update CDSRefName for Added tickers
                var eqTicker = ticker.getTickerEquity();
                if (CDSRefNameCache.ContainsKey(eqTicker))
                {
                    CDSRefNameCache[eqTicker].updateData(ticker.CDSRefName);
                }
                else
                    CDSRefNameCache.Add(eqTicker, new BloombergData<string>(ticker.CDSRefName));

                List<BloombergData<string>> CDSSpreadMatTickerList;

                if (CDSSpreadMatNameCache.TryGetValue(ticker.TickerEquity, out CDSSpreadMatTickerList))
                {
                    foreach (var spreadMaturity in CDSSpreadMatTickerList)
                    {
                        ticker.createTickerSpread(spreadMaturity.getData());
                    }
                }
                else
                {
                    EqTickerForSpreadTicker.Add(ticker.getTickerEquity());
                }
            }

            if (EqTickerForSpreadTicker.Count > 0)
            {   //get Spread Maturity
                retrieveCDSSpreadTicker(tickerFilter, EqTickerForSpreadTicker);
            }

            Dictionary<string, List<string>> FieldByTickerList = new Dictionary<string, List<string>>();

            List<string> EqTickerFieldList;

            if (AdditionalFields != null)
                EqTickerFieldList = DataFieldNames.fieldsInit_EqTickerForCache.Concat(AdditionalFields).ToList();
            else
                EqTickerFieldList = DataFieldNames.fieldsInit_EqTickerForCache;

            var list = tickerFilter.getAllCDSMembers();

            foreach (var field in EqTickerFieldList)
            {
                List<string> fieldTickerList = new List<string>();

                foreach (CDSIndexMember member in list)
                {
                    string ticker = member.getTickerEquity();
                    if (ticker == "")
                        continue;

                    if (field == DataFieldNames.SECURITY_NAME)
                    {
                        BloombergData<string> data;
                        if (CDSRefNameCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.CDSRefName = data.getData();
                            else
                                member.CDSRefName = "";
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.INDUSTRY_SECTOR)
                    {
                        BloombergData<string> data;
                        if (IndustryCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.IndustryName = data.getData();
                            else
                                member.IndustryName = "";

                            if (!CDSIndexIndustryList.Contains(member.IndustryName))
                                CDSIndexIndustryList.Add(member.IndustryName);
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.RTG_MDY_SEN_UNSECURED_DEBT)
                    {
                        BloombergData<string> data;
                        if (MoodysRatingCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.MoodysRating = data.getData();
                            else
                                member.MoodysRating = ConstantItemList.MOODYSNAV;

                            if (!CDSIndexRatingsList.Contains(member.MoodysRating))
                                CDSIndexRatingsList.Add(member.MoodysRating);
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.RTG_SP_LT_LC_ISSUER_CREDIT)
                    {
                        BloombergData<string> data;
                        if (SPRatingCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.SPRating = data.getData();
                            else
                                member.SPRating = "";
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.RTG_FITCH_SEN_UNSECURED)
                    {
                        BloombergData<string> data;
                        if (FitchRatingCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.FitchRating = data.getData();
                            else
                                member.FitchRating = "";
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.CUR_MKT_CAP)
                    {
                        BloombergData<double> data;
                        if (MarketCapCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.MarketCapital = data.getData();
                            else
                                member.MarketCapital = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.TOT_DEBT_TO_TOT_CAP)
                    {
                        BloombergData<double> data;
                        if (TotalDebtToCapCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.TotalDebtToCapital = data.getData();
                            else
                                member.TotalDebtToCapital = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.TOT_DEBT_TO_COM_EQY)
                    {
                        BloombergData<double> data;
                        if (DebtToCommonEqCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.DebtToCommonEquity = data.getData();
                            else
                                member.DebtToCommonEquity = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.INTEREST_COVERAGE_RATIO)
                    {
                        BloombergData<double> data;
                        if (InterestCovRatioCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.InterestCoverageRatio = data.getData();
                            else
                                member.InterestCoverageRatio = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.EQY_DVD_YLD_IND)
                    {
                        BloombergData<double> data;
                        if (EqDividendYieldCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.EqDividendeYield = data.getData();
                            else
                                member.EqDividendeYield = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.ENTERPRISE_VALUE)
                    {
                        BloombergData<double> data;
                        if (EnterpriseValueCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.EnterpriseValue = data.getData();
                            else
                                member.EnterpriseValue = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.DDIS_AMT_OUTSTANDING)
                    {
                        BloombergData<double> data;
                        if (DebtOSCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.DebtOS = data.getData();
                            else
                                member.DebtOS = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.PE_RATIO)
                    {
                        BloombergData<double> data;
                        if (PERatioCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.PeRatio = data.getData();
                            else
                                member.PeRatio = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }

                    else if (field == DataFieldNames.EBITDA)
                    {
                        BloombergData<double> data;
                        if (EbitdaCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.EBITDA = data.getData();
                            else
                                member.EBITDA = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.EXPECTED_REPORT_DT)
                    {
                        BloombergData<DateTime> data;
                        if (ExpectedRptDateCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.ExpectedReportDT = data.getData();
                            else
                                member.ExpectedReportDT = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.SI_PERCENT_EQUITY_FLOAT)
                    {
                        BloombergData<double> data;
                        if (ShortInterestCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.ShortInterest = data.getData();
                            else
                                member.ShortInterest = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.PX_TO_SALES_RATIO)
                    {
                        BloombergData<double> data;
                        if (PriceToSalesRatioCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.PriceToSalesRatio = data.getData();
                            else
                                member.PriceToSalesRatio = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.EQY_BETA)
                    {
                        BloombergData<double> data;
                        if (EQBetaCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.EQBeta = data.getData();
                            else
                                member.EQBeta = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.SHORT_AND_LONG_TERM_DEBT)
                    {
                        BloombergData<double> data;
                        if (TotalDebtCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.TotalDebt = data.getData();
                            else
                                member.TotalDebt = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.BS_TOT_ASSET)
                    {
                        BloombergData<double> data;
                        if (TotalAssetCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.TotalAssets = data.getData();
                            else
                                member.TotalAssets = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.VOLUME_PCT_5_20)
                    {
                        BloombergData<double> data;
                        if (VolumeChg5d20dCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.VolumeChg5d20d = data.getData();
                            else
                                member.VolumeChg5d20d = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.SALES_GROWTH)
                    {
                        BloombergData<double> data;
                        if (SalesGrowthCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.SalesGrowth = data.getData();
                            else
                                member.SalesGrowth = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.HIST_CALL_IMPL_VOL)
                    {
                        BloombergData<double> data;
                        if (HistCallImplVolCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.HistCallImplVol = data.getData();
                            else
                                member.HistCallImplVol = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.VOL_MEAN)
                    {
                        BloombergData<double> data;
                        if (VolMeanCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.VolMean = data.getData();
                            else
                                member.VolMean = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.CURRENCY)
                    {
                        BloombergData<string> data;
                        if (CurrencyCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.Currency = data.getData();
                            else
                                member.Currency = "";
                        }
                        else
                            fieldTickerList.Add(ticker);

                        //CDS currency
                        if (CurrencyCDSCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.CurrencyCDS = data.getData();
                            else
                                member.CurrencyCDS = "";
                        }
                        else
                        {
                            if (member.getTickerSpread(4) != "")
                                fieldTickerList.Add(member.getTickerSpread(4));
                        }
                    }
                    else if (field == DataFieldNames.PRICING_SOURCE)
                    {
                        BloombergData<string> data;
                        if (PricingSourceCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.PricingSource = data.getData();
                            else
                                member.PricingSource = "";
                        }
                        else
                        {
                            if (member.getTickerSpread(4) != "")
                                fieldTickerList.Add(member.getTickerSpread(4));
                        }
                    }

                }

                if (fieldTickerList.Count > 0)
                    FieldByTickerList.Add(field, fieldTickerList);
            }

            updateFieldByTickerList(FieldByTickerList, tickerFilter);

            dataManager.GetInitEquitySpreadTickerPrice(list, true);

            getFXRate(tickerFilter.getAllCDSMembers());

            Trace.WriteLine("getInitialTickerFilterData is completed for " + tickerFilter.TickerFilterName, "TRACE");

        }

        private void retrieveCDSSpreadTicker(CDSIndex cdsIndex, List<string> EqTickerForSpreadTicker)
        {
            Trace.WriteLine("retrieveCDSSpreadTicker is called for " + cdsIndex.CDSIndexName, "TRACE");

            var resultSpreadTicker = dataManager.GetFieldValues(EqTickerForSpreadTicker, DataFieldNames.fields_EqForSpreadTicker);

            foreach (CDSIndexMember member in cdsIndex.CDSIndexMemberList)
            {
                string ticker = member.getTickerEquity();

                if (ticker == "")
                    continue;

                if (!EqTickerForSpreadTicker.Contains(ticker))
                    continue;

                List<BloombergData<string>> spreadTickerList = new List<BloombergData<string>>();

                for (int i = 0; i < DataFieldNames.fields_EqForSpreadTicker.Count(); ++i)
                {
                    string field = resultSpreadTicker[ticker][i].Name;

                    if (field == DataFieldNames.CDS_SPREAD_TICKER_1Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));

                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_2Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_3Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_4Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_5Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_7Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_10Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                }

                if (CDSSpreadMatNameCache.ContainsKey(member.TickerEquity))
                {
                    CDSSpreadMatNameCache[member.TickerEquity] = spreadTickerList;
                }
                else
                {
                    CDSSpreadMatNameCache.Add(member.TickerEquity, spreadTickerList);
                }
            }

            Trace.WriteLine("retrieveCDSSpreadTicker is completed for " + cdsIndex.CDSIndexName, "TRACE");
        }

        private void retrieveCDSSpreadTicker(TickerFilter tickerFilter, List<string> EqTickerForSpreadTicker)
        {
            Trace.WriteLine("retrieveCDSSpreadTicker is called for " + tickerFilter.TickerFilterName, "TRACE");

            var resultSpreadTicker = dataManager.GetFieldValues(EqTickerForSpreadTicker, DataFieldNames.fields_EqForSpreadTicker);

            var list = tickerFilter.getAllCDSMembers();

            foreach (CDSIndexMember member in list)
            {
                string ticker = member.getTickerEquity();

                if (ticker == "")
                    continue;

                if (!EqTickerForSpreadTicker.Contains(ticker))
                    continue;

                List<BloombergData<string>> spreadTickerList = new List<BloombergData<string>>();

                for (int i = 0; i < DataFieldNames.fields_EqForSpreadTicker.Count(); ++i)
                {
                    string field = resultSpreadTicker[ticker][i].Name;

                    if (field == DataFieldNames.CDS_SPREAD_TICKER_1Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));

                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_2Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_3Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_4Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_5Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_7Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_10Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                }

                if (CDSSpreadMatNameCache.ContainsKey(member.TickerEquity))
                {
                    CDSSpreadMatNameCache[member.TickerEquity] = spreadTickerList;
                }
                else
                {
                    CDSSpreadMatNameCache.Add(member.TickerEquity, spreadTickerList);
                }
            }

            Trace.WriteLine("retrieveCDSSpreadTicker is completed for " + tickerFilter.TickerFilterName, "TRACE");
        }

        private void retrieveCDSSpreadTicker(List<CDSIndexMember> AddedTickerList, List<string> EqTickerForSpreadTicker)
        {
            Trace.WriteLine("retrieveCDSSpreadTicker is called for AddedTickerList", "TRACE");

            var resultSpreadTicker = dataManager.GetFieldValues(EqTickerForSpreadTicker, DataFieldNames.fields_EqForSpreadTicker);

            foreach (CDSIndexMember member in AddedTickerList)
            {
                string ticker = member.getTickerEquity();

                if (ticker == "")
                    continue;

                if (!EqTickerForSpreadTicker.Contains(ticker))
                    continue;

                List<BloombergData<string>> spreadTickerList = new List<BloombergData<string>>();

                for (int i = 0; i < DataFieldNames.fields_EqForSpreadTicker.Count(); ++i)
                {
                    string field = resultSpreadTicker[ticker][i].Name;

                    if (field == DataFieldNames.CDS_SPREAD_TICKER_1Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));

                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_2Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_3Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_4Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_5Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_7Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                    else if (field == DataFieldNames.CDS_SPREAD_TICKER_10Y)
                    {
                        member.createTickerSpread((string)(resultSpreadTicker[ticker][i].Value ?? ""));
                        spreadTickerList.Add(new BloombergData<string>(member.TickerSpreadList.Last()));
                    }
                }

                if (CDSSpreadMatNameCache.ContainsKey(member.TickerEquity))
                {
                    CDSSpreadMatNameCache[member.TickerEquity] = spreadTickerList;
                }
                else
                {
                    CDSSpreadMatNameCache.Add(member.TickerEquity, spreadTickerList);
                }
            }

            Trace.WriteLine("retrieveCDSSpreadTicker is completed for AddedTickerList", "TRACE");
        }
        
        public void getTickerFields(List<CDSIndexMember> memberList, IEnumerable<string> tickerList, IEnumerable<string> fieldList)
        {
            Trace.WriteLine("getTickerFields is called", "TRACE");

            if (fieldList == null || fieldList.Count() == 0)
                return;

            if (tickerList == null || tickerList.Count() == 0)
                return;

            Dictionary<string, List<string>> FieldByTickerList = new Dictionary<string, List<string>>();

            foreach (string field in fieldList)
            {
                List<string> fieldTickerList = new List<string>();

                foreach (CDSIndexMember member in memberList)
                {
                    string ticker = member.getTickerEquity();
                    if (ticker == "")
                        continue;

                    if (field == DataFieldNames.EXPECTED_REPORT_DT)
                    {
                        BloombergData<DateTime> data;
                        if (ExpectedRptDateCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.ExpectedReportDT = data.getData();
                            else
                                member.ExpectedReportDT = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.SI_PERCENT_EQUITY_FLOAT)
                    {
                        BloombergData<double> data;
                        if (ShortInterestCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.ShortInterest = data.getData();
                            else
                                member.ShortInterest = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.PX_TO_SALES_RATIO)
                    {
                        BloombergData<double> data;
                        if (PriceToSalesRatioCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.PriceToSalesRatio = data.getData();
                            else
                                member.PriceToSalesRatio = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.EQY_BETA)
                    {
                        BloombergData<double> data;
                        if (EQBetaCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.EQBeta = data.getData();
                            else
                                member.EQBeta = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.SHORT_AND_LONG_TERM_DEBT)
                    {
                        BloombergData<double> data;
                        if (TotalDebtCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.TotalDebt = data.getData();
                            else
                                member.TotalDebt = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.BS_TOT_ASSET)
                    {
                        BloombergData<double> data;
                        if (TotalAssetCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.TotalAssets = data.getData();
                            else
                                member.TotalAssets = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.VOLUME_PCT_5_20)
                    {
                        BloombergData<double> data;
                        if (VolumeChg5d20dCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.VolumeChg5d20d = data.getData();
                            else
                                member.VolumeChg5d20d = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.SALES_GROWTH)
                    {
                        BloombergData<double> data;
                        if (SalesGrowthCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.SalesGrowth = data.getData();
                            else
                                member.SalesGrowth = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.HIST_CALL_IMPL_VOL)
                    {
                        BloombergData<double> data;
                        if (HistCallImplVolCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.HistCallImplVol = data.getData();
                            else
                                member.HistCallImplVol = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                }

                if (fieldTickerList.Count > 0)
                    FieldByTickerList.Add(field, fieldTickerList);

                updateFieldByTickerList(FieldByTickerList, memberList);
            }

            Trace.WriteLine("getTickerFields is completed", "TRACE");
        }

        private void updateFieldByTickerList(Dictionary<string, List<string>> FieldByTickerList, List<CDSIndexMember> memberList)
        {
            Trace.WriteLine("updateFieldByTickerList is called for CDSIndexMember list.", "TRACE");

            foreach (var KeyValue in FieldByTickerList)
            {
                List<string> fields = new List<string>();
                fields.Add(KeyValue.Key);

                var resultSet = dataManager.GetFieldValues(KeyValue.Value, fields);

                foreach (CDSIndexMember member in memberList)
                {
                    string ticker = member.getTickerEquity();
                    string spreadTicker = member.getTickerSpread(4);

                    if (ticker == "")
                        continue;

                    if (!KeyValue.Value.Contains(ticker))
                    {
                        if (spreadTicker == "")
                            continue;

                        if (!KeyValue.Value.Contains(spreadTicker))
                            continue;
                    }

                    for (int i = 0; i < fields.Count; ++i)
                    {
                        string field = "";

                        if (resultSet.ContainsKey(ticker))
                            field = resultSet[ticker][i].Name;
                        else if (resultSet.ContainsKey(spreadTicker))
                            field = resultSet[spreadTicker][i].Name;
                        else
                            continue;

                        if (field == DataFieldNames.SECURITY_NAME)
                        {
                            member.CDSRefName = (string)(resultSet[ticker][i].Value ?? "");

                            if (CDSRefNameCache.ContainsKey(ticker))
                            {
                                CDSRefNameCache[ticker].updateData(member.CDSRefName ?? "");
                            }
                            else
                            {
                                CDSRefNameCache.Add(ticker, new BloombergData<string>(member.CDSRefName ?? ""));
                            }
                        }
                        else if (field == DataFieldNames.INDUSTRY_SECTOR)
                        {
                            member.IndustryName = (string)(resultSet[ticker][i].Value ?? "");

                            if (!CDSIndexIndustryList.Contains(member.IndustryName))
                                CDSIndexIndustryList.Add(member.IndustryName);

                            if (IndustryCache.ContainsKey(ticker))
                            {
                                IndustryCache[ticker].updateData(member.IndustryName ?? "");
                            }
                            else
                            {
                                IndustryCache.Add(ticker, new BloombergData<string>(member.IndustryName ?? ""));
                            }
                        }
                        else if (field == DataFieldNames.RTG_MDY_SEN_UNSECURED_DEBT)
                        {
                            member.MoodysRating = (string)(resultSet[ticker][i].Value ?? ConstantItemList.MOODYSNAV);

                            if (!CDSIndexRatingsList.Contains(member.MoodysRating))
                                CDSIndexRatingsList.Add(member.MoodysRating);

                            if (MoodysRatingCache.ContainsKey(ticker))
                            {
                                MoodysRatingCache[ticker].updateData(member.MoodysRating ?? ConstantItemList.MOODYSNAV);
                            }
                            else
                            {
                                MoodysRatingCache.Add(ticker, new BloombergData<string>(member.MoodysRating ?? ConstantItemList.MOODYSNAV));
                            }
                        }
                        else if (field == DataFieldNames.RTG_SP_LT_LC_ISSUER_CREDIT)
                        {
                            member.SPRating = (string)(resultSet[ticker][i].Value ?? "");

                            if (SPRatingCache.ContainsKey(ticker))
                            {
                                SPRatingCache[ticker].updateData(member.SPRating ?? "");
                            }
                            else
                            {
                                SPRatingCache.Add(ticker, new BloombergData<string>(member.SPRating ?? ""));
                            }
                        }
                        else if (field == DataFieldNames.RTG_FITCH_SEN_UNSECURED)
                        {
                            member.FitchRating = (string)(resultSet[ticker][i].Value ?? "");

                            if (FitchRatingCache.ContainsKey(ticker))
                            {
                                FitchRatingCache[ticker].updateData(member.FitchRating ?? "");
                            }
                            else
                            {
                                FitchRatingCache.Add(ticker, new BloombergData<string>(member.FitchRating ?? ""));
                            }
                        }
                        else if (field == DataFieldNames.CUR_MKT_CAP)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.MarketCapital = null;
                            else
                                member.MarketCapital = (double)(resultSet[ticker][i].Value);

                            if (MarketCapCache.ContainsKey(ticker))
                            {
                                if (member.MarketCapital != null)
                                    MarketCapCache[ticker].updateData(member.MarketCapital ?? 0.0);
                                else
                                    MarketCapCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.MarketCapital != null)
                                    MarketCapCache.Add(ticker, new BloombergData<double>(member.MarketCapital ?? 0.0));
                                else
                                    MarketCapCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.TOT_DEBT_TO_TOT_CAP)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.TotalDebtToCapital = null;
                            else
                                member.TotalDebtToCapital = (double)(resultSet[ticker][i].Value);

                            if (TotalDebtToCapCache.ContainsKey(ticker))
                            {
                                if (member.TotalDebtToCapital != null)
                                    TotalDebtToCapCache[ticker].updateData(member.TotalDebtToCapital ?? 0.0);
                                else
                                    TotalDebtToCapCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.TotalDebtToCapital != null)
                                    TotalDebtToCapCache.Add(ticker, new BloombergData<double>(member.TotalDebtToCapital ?? 0.0));
                                else
                                    TotalDebtToCapCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.TOT_DEBT_TO_COM_EQY)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.DebtToCommonEquity = null;
                            else
                                member.DebtToCommonEquity = (double)(resultSet[ticker][i].Value);

                            if (DebtToCommonEqCache.ContainsKey(ticker))
                            {
                                if (member.DebtToCommonEquity != null)
                                    DebtToCommonEqCache[ticker].updateData(member.DebtToCommonEquity ?? 0.0);
                                else
                                    DebtToCommonEqCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.DebtToCommonEquity != null)
                                    DebtToCommonEqCache.Add(ticker, new BloombergData<double>(member.DebtToCommonEquity ?? 0.0));
                                else
                                    DebtToCommonEqCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.INTEREST_COVERAGE_RATIO)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.InterestCoverageRatio = null;
                            else
                                member.InterestCoverageRatio = (double)(resultSet[ticker][i].Value);

                            if (InterestCovRatioCache.ContainsKey(ticker))
                            {
                                if (member.InterestCoverageRatio != null)
                                    InterestCovRatioCache[ticker].updateData(member.InterestCoverageRatio ?? 0.0);
                                else
                                    InterestCovRatioCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.InterestCoverageRatio != null)
                                    InterestCovRatioCache.Add(ticker, new BloombergData<double>(member.InterestCoverageRatio ?? 0.0));
                                else
                                    InterestCovRatioCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.EQY_DVD_YLD_IND)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.EqDividendeYield = null;
                            else
                                member.EqDividendeYield = (double)(resultSet[ticker][i].Value);

                            if (EqDividendYieldCache.ContainsKey(ticker))
                            {
                                if (member.EqDividendeYield != null)
                                    EqDividendYieldCache[ticker].updateData(member.EqDividendeYield ?? 0.0);
                                else
                                    EqDividendYieldCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EqDividendeYield != null)
                                    EqDividendYieldCache.Add(ticker, new BloombergData<double>(member.EqDividendeYield ?? 0.0));
                                else
                                    EqDividendYieldCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.ENTERPRISE_VALUE)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.EnterpriseValue = null;
                            else
                                member.EnterpriseValue = (double)(resultSet[ticker][i].Value);

                            if (EnterpriseValueCache.ContainsKey(ticker))
                            {
                                if (member.EnterpriseValue != null)
                                    EnterpriseValueCache[ticker].updateData(member.EnterpriseValue ?? 0.0);
                                else
                                    EnterpriseValueCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EnterpriseValue != null)
                                    EnterpriseValueCache.Add(ticker, new BloombergData<double>(member.EnterpriseValue ?? 0.0));
                                else
                                    EnterpriseValueCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.DDIS_AMT_OUTSTANDING)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.DebtOS = null;
                            else
                                member.DebtOS = (double)(resultSet[ticker][i].Value);

                            if (DebtOSCache.ContainsKey(ticker))
                            {
                                if (member.DebtOS != null)
                                    DebtOSCache[ticker].updateData(member.DebtOS ?? 0.0);
                                else
                                    DebtOSCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.DebtOS != null)
                                    DebtOSCache.Add(ticker, new BloombergData<double>(member.DebtOS ?? 0.0));
                                else
                                    DebtOSCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.PE_RATIO)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.PeRatio = null;
                            else
                                member.PeRatio = (double)(resultSet[ticker][i].Value);

                            if (PERatioCache.ContainsKey(ticker))
                            {
                                if (member.PeRatio != null)
                                    PERatioCache[ticker].updateData(member.PeRatio ?? 0.0);
                                else
                                    PERatioCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.PeRatio != null)
                                    PERatioCache.Add(ticker, new BloombergData<double>(member.PeRatio ?? 0.0));
                                else
                                    PERatioCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.EBITDA)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.EBITDA = null;
                            else
                                member.EBITDA = (double)(resultSet[ticker][i].Value);

                            if (EbitdaCache.ContainsKey(ticker))
                            {
                                if (member.EBITDA != null)
                                    EbitdaCache[ticker].updateData(member.EBITDA ?? 0.0);
                                else
                                    EbitdaCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EBITDA != null)
                                    EbitdaCache.Add(ticker, new BloombergData<double>(member.EBITDA ?? 0.0));
                                else
                                    EbitdaCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.EXPECTED_REPORT_DT)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.ExpectedReportDT = null;
                            else
                                member.ExpectedReportDT = ((Bloomberglp.Blpapi.Datetime)(resultSet[ticker][i].Value)).ToSystemDateTime();

                            if (ExpectedRptDateCache.ContainsKey(ticker))
                            {
                                if (member.ExpectedReportDT != null)
                                    ExpectedRptDateCache[ticker].updateData(member.ExpectedReportDT ?? DateTime.Now);
                                else
                                    ExpectedRptDateCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.ExpectedReportDT != null)
                                    ExpectedRptDateCache.Add(ticker, new BloombergData<DateTime>(member.ExpectedReportDT ?? DateTime.Now));
                                else
                                    ExpectedRptDateCache.Add(ticker, new BloombergData<DateTime>());
                            }
                        }
                        else if (field == DataFieldNames.SI_PERCENT_EQUITY_FLOAT)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.ShortInterest = null;
                            else
                                member.ShortInterest = (double)(resultSet[ticker][i].Value);

                            if (ShortInterestCache.ContainsKey(ticker))
                            {
                                if (member.ShortInterest != null)
                                    ShortInterestCache[ticker].updateData(member.ShortInterest ?? 0.0);
                                else
                                    ShortInterestCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.ShortInterest != null)
                                    ShortInterestCache.Add(ticker, new BloombergData<double>(member.ShortInterest ?? 0.0));
                                else
                                    ShortInterestCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.PX_TO_SALES_RATIO)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.PriceToSalesRatio = null;
                            else
                                member.PriceToSalesRatio = (double)(resultSet[ticker][i].Value);

                            if (PriceToSalesRatioCache.ContainsKey(ticker))
                            {
                                if (member.PriceToSalesRatio != null)
                                    PriceToSalesRatioCache[ticker].updateData(member.PriceToSalesRatio ?? 0.0);
                                else
                                    PriceToSalesRatioCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.PriceToSalesRatio != null)
                                    PriceToSalesRatioCache.Add(ticker, new BloombergData<double>(member.PriceToSalesRatio ?? 0.0));
                                else
                                    PriceToSalesRatioCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.EQY_BETA)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.EQBeta = null;
                            else
                                member.EQBeta = (double)(resultSet[ticker][i].Value);

                            if (EQBetaCache.ContainsKey(ticker))
                            {
                                if (member.EQBeta != null)
                                    EQBetaCache[ticker].updateData(member.EQBeta ?? 0.0);
                                else
                                    EQBetaCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EQBeta != null)
                                    EQBetaCache.Add(ticker, new BloombergData<double>(member.EQBeta ?? 0.0));
                                else
                                    EQBetaCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.SHORT_AND_LONG_TERM_DEBT)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.TotalDebt = null;
                            else
                                member.TotalDebt = (double)(resultSet[ticker][i].Value);

                            if (TotalDebtCache.ContainsKey(ticker))
                            {
                                if (member.TotalDebt != null)
                                    TotalDebtCache[ticker].updateData(member.TotalDebt ?? 0.0);
                                else
                                    TotalDebtCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.TotalDebt != null)
                                    TotalDebtCache.Add(ticker, new BloombergData<double>(member.TotalDebt ?? 0.0));
                                else
                                    TotalDebtCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.BS_TOT_ASSET)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.TotalAssets = null;
                            else
                                member.TotalAssets = (double)(resultSet[ticker][i].Value);

                            if (TotalAssetCache.ContainsKey(ticker))
                            {
                                if (member.TotalAssets != null)
                                    TotalAssetCache[ticker].updateData(member.TotalAssets ?? 0.0);
                                else
                                    TotalAssetCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.TotalAssets != null)
                                    TotalAssetCache.Add(ticker, new BloombergData<double>(member.TotalAssets ?? 0.0));
                                else
                                    TotalAssetCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.VOLUME_PCT_5_20)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.VolumeChg5d20d = null;
                            else
                                member.VolumeChg5d20d = (double)(resultSet[ticker][i].Value);

                            if (VolumeChg5d20dCache.ContainsKey(ticker))
                            {
                                if (member.VolumeChg5d20d != null)
                                    VolumeChg5d20dCache[ticker].updateData(member.VolumeChg5d20d ?? 0.0);
                                else
                                    VolumeChg5d20dCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.VolumeChg5d20d != null)
                                    VolumeChg5d20dCache.Add(ticker, new BloombergData<double>(member.VolumeChg5d20d ?? 0.0));
                                else
                                    VolumeChg5d20dCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.SALES_GROWTH)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.SalesGrowth = null;
                            else
                                member.SalesGrowth = (double)(resultSet[ticker][i].Value);

                            if (SalesGrowthCache.ContainsKey(ticker))
                            {
                                if (member.SalesGrowth != null)
                                    SalesGrowthCache[ticker].updateData(member.SalesGrowth ?? 0.0);
                                else
                                    SalesGrowthCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.SalesGrowth != null)
                                    SalesGrowthCache.Add(ticker, new BloombergData<double>(member.SalesGrowth ?? 0.0));
                                else
                                    SalesGrowthCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.HIST_CALL_IMPL_VOL)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.HistCallImplVol = null;
                            else
                                member.HistCallImplVol = (double)(resultSet[ticker][i].Value);

                            if (HistCallImplVolCache.ContainsKey(ticker))
                            {
                                if (member.HistCallImplVol != null)
                                    HistCallImplVolCache[ticker].updateData(member.HistCallImplVol ?? 0.0);
                                else
                                    HistCallImplVolCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.HistCallImplVol != null)
                                    HistCallImplVolCache.Add(ticker, new BloombergData<double>(member.HistCallImplVol ?? 0.0));
                                else
                                    HistCallImplVolCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.CURRENCY)
                        {
                            if (resultSet.Keys.Contains(ticker))
                            {
                                member.Currency = (string)(resultSet[ticker][i].Value ?? "");

                                if (CurrencyCache.ContainsKey(ticker))
                                {
                                    CurrencyCache[ticker].updateData(member.Currency ?? "");
                                }
                                else
                                {
                                    CurrencyCache.Add(ticker, new BloombergData<string>(member.Currency ?? ""));
                                }
                            }
                            else if (resultSet.Keys.Contains(spreadTicker))
                            {
                                member.CurrencyCDS = (string)(resultSet[spreadTicker][i].Value ?? "");

                                if (CurrencyCDSCache.ContainsKey(ticker))
                                {
                                    CurrencyCDSCache[ticker].updateData(member.CurrencyCDS ?? "");
                                }
                                else
                                {
                                    CurrencyCDSCache.Add(ticker, new BloombergData<string>(member.CurrencyCDS ?? ""));
                                }
                            }

                        }
                        else if (field == DataFieldNames.PRICING_SOURCE)
                        {
                            member.PricingSource = (string)(resultSet[spreadTicker][i].Value ?? "");

                            if (PricingSourceCache.ContainsKey(ticker))
                            {
                                PricingSourceCache[ticker].updateData(member.PricingSource ?? "");
                            }
                            else
                            {
                                PricingSourceCache.Add(ticker, new BloombergData<string>(member.PricingSource ?? ""));
                            }
                        }
                    }
                }
            }

            Trace.WriteLine("updateFieldByTickerList is completed for CDSIndexMember list.", "TRACE");
        }

        private void updateFieldByTickerList(Dictionary<string, List<string>> FieldByTickerList, TickerFilter tickerFilter)
        {
            Trace.WriteLine("updateFieldByTickerList is called for tickerFilter " + tickerFilter.TickerFilterName, "TRACE");

            foreach (var KeyValue in FieldByTickerList)
            {
                List<string> fields = new List<string>();
                fields.Add(KeyValue.Key);

                var resultSet = dataManager.GetFieldValues(KeyValue.Value, fields);

                var list = tickerFilter.getAllCDSMembers();

                foreach (CDSIndexMember member in list)
                {
                    string ticker = member.getTickerEquity();
                    string spreadTicker = member.getTickerSpread(4);

                    if (ticker == "")
                        continue;

                    if (!KeyValue.Value.Contains(ticker))
                    {
                        if (spreadTicker == "")
                            continue;

                        if (!KeyValue.Value.Contains(spreadTicker))
                            continue;
                    }

                    for (int i = 0; i < fields.Count; ++i)
                    {
                        string field = "";

                        if (resultSet.ContainsKey(ticker))
                            field = resultSet[ticker][i].Name;
                        else if (resultSet.ContainsKey(spreadTicker))
                            field = resultSet[spreadTicker][i].Name;
                        else
                            continue;

                        if (field == DataFieldNames.SECURITY_NAME)
                        {
                            member.CDSRefName = (string)(resultSet[ticker][i].Value ?? "");

                            if (CDSRefNameCache.ContainsKey(ticker))
                            {
                                CDSRefNameCache[ticker].updateData(member.CDSRefName ?? "");
                            }
                            else
                            {
                                CDSRefNameCache.Add(ticker, new BloombergData<string>(member.CDSRefName ?? ""));
                            }
                        }
                        if (field == DataFieldNames.INDUSTRY_SECTOR)
                        {
                            member.IndustryName = (string)(resultSet[ticker][i].Value ?? "");

                            if (!CDSIndexIndustryList.Contains(member.IndustryName))
                                CDSIndexIndustryList.Add(member.IndustryName);

                            if (IndustryCache.ContainsKey(ticker))
                            {
                                IndustryCache[ticker].updateData(member.IndustryName ?? "");
                            }
                            else
                            {
                                IndustryCache.Add(ticker, new BloombergData<string>(member.IndustryName ?? ""));
                            }
                        }
                        else if (field == DataFieldNames.RTG_MDY_SEN_UNSECURED_DEBT)
                        {
                            member.MoodysRating = (string)(resultSet[ticker][i].Value ?? ConstantItemList.MOODYSNAV);

                            if (!CDSIndexRatingsList.Contains(member.MoodysRating))
                                CDSIndexRatingsList.Add(member.MoodysRating);

                            if (MoodysRatingCache.ContainsKey(ticker))
                            {
                                MoodysRatingCache[ticker].updateData(member.MoodysRating ?? ConstantItemList.MOODYSNAV);
                            }
                            else
                            {
                                MoodysRatingCache.Add(ticker, new BloombergData<string>(member.MoodysRating ?? ConstantItemList.MOODYSNAV));
                            }
                        }
                        else if (field == DataFieldNames.RTG_SP_LT_LC_ISSUER_CREDIT)
                        {
                            member.SPRating = (string)(resultSet[ticker][i].Value ?? "");

                            if (SPRatingCache.ContainsKey(ticker))
                            {
                                SPRatingCache[ticker].updateData(member.SPRating ?? "");
                            }
                            else
                            {
                                SPRatingCache.Add(ticker, new BloombergData<string>(member.SPRating ?? ""));
                            }
                        }
                        else if (field == DataFieldNames.RTG_FITCH_SEN_UNSECURED)
                        {
                            member.FitchRating = (string)(resultSet[ticker][i].Value ?? "");

                            if (FitchRatingCache.ContainsKey(ticker))
                            {
                                FitchRatingCache[ticker].updateData(member.FitchRating ?? "");
                            }
                            else
                            {
                                FitchRatingCache.Add(ticker, new BloombergData<string>(member.FitchRating ?? ""));
                            }
                        }
                        else if (field == DataFieldNames.CUR_MKT_CAP)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.MarketCapital = null;
                            else
                                member.MarketCapital = (double)(resultSet[ticker][i].Value);

                            if (MarketCapCache.ContainsKey(ticker))
                            {
                                if (member.MarketCapital != null)
                                    MarketCapCache[ticker].updateData(member.MarketCapital ?? 0.0);
                                else
                                    MarketCapCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.MarketCapital != null)
                                    MarketCapCache.Add(ticker, new BloombergData<double>(member.MarketCapital ?? 0.0));
                                else
                                    MarketCapCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.TOT_DEBT_TO_TOT_CAP)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.TotalDebtToCapital = null;
                            else
                                member.TotalDebtToCapital = (double)(resultSet[ticker][i].Value);

                            if (TotalDebtToCapCache.ContainsKey(ticker))
                            {
                                if (member.TotalDebtToCapital != null)
                                    TotalDebtToCapCache[ticker].updateData(member.TotalDebtToCapital ?? 0.0);
                                else
                                    TotalDebtToCapCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.TotalDebtToCapital != null)
                                    TotalDebtToCapCache.Add(ticker, new BloombergData<double>(member.TotalDebtToCapital ?? 0.0));
                                else
                                    TotalDebtToCapCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.TOT_DEBT_TO_COM_EQY)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.DebtToCommonEquity = null;
                            else
                                member.DebtToCommonEquity = (double)(resultSet[ticker][i].Value);

                            if (DebtToCommonEqCache.ContainsKey(ticker))
                            {
                                if (member.DebtToCommonEquity != null)
                                    DebtToCommonEqCache[ticker].updateData(member.DebtToCommonEquity ?? 0.0);
                                else
                                    DebtToCommonEqCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.DebtToCommonEquity != null)
                                    DebtToCommonEqCache.Add(ticker, new BloombergData<double>(member.DebtToCommonEquity ?? 0.0));
                                else
                                    DebtToCommonEqCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.INTEREST_COVERAGE_RATIO)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.InterestCoverageRatio = null;
                            else
                                member.InterestCoverageRatio = (double)(resultSet[ticker][i].Value);

                            if (InterestCovRatioCache.ContainsKey(ticker))
                            {
                                if (member.InterestCoverageRatio != null)
                                    InterestCovRatioCache[ticker].updateData(member.InterestCoverageRatio ?? 0.0);
                                else
                                    InterestCovRatioCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.InterestCoverageRatio != null)
                                    InterestCovRatioCache.Add(ticker, new BloombergData<double>(member.InterestCoverageRatio ?? 0.0));
                                else
                                    InterestCovRatioCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.EQY_DVD_YLD_IND)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.EqDividendeYield = null;
                            else
                                member.EqDividendeYield = (double)(resultSet[ticker][i].Value);

                            if (EqDividendYieldCache.ContainsKey(ticker))
                            {
                                if (member.EqDividendeYield != null)
                                    EqDividendYieldCache[ticker].updateData(member.EqDividendeYield ?? 0.0);
                                else
                                    EqDividendYieldCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EqDividendeYield != null)
                                    EqDividendYieldCache.Add(ticker, new BloombergData<double>(member.EqDividendeYield ?? 0.0));
                                else
                                    EqDividendYieldCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.ENTERPRISE_VALUE)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.EnterpriseValue = null;
                            else
                                member.EnterpriseValue = (double)(resultSet[ticker][i].Value);

                            if (EnterpriseValueCache.ContainsKey(ticker))
                            {
                                if (member.EnterpriseValue != null)
                                    EnterpriseValueCache[ticker].updateData(member.EnterpriseValue ?? 0.0);
                                else
                                    EnterpriseValueCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EnterpriseValue != null)
                                    EnterpriseValueCache.Add(ticker, new BloombergData<double>(member.EnterpriseValue ?? 0.0));
                                else
                                    EnterpriseValueCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.DDIS_AMT_OUTSTANDING)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.DebtOS = null;
                            else
                                member.DebtOS = (double)(resultSet[ticker][i].Value);

                            if (DebtOSCache.ContainsKey(ticker))
                            {
                                if (member.DebtOS != null)
                                    DebtOSCache[ticker].updateData(member.DebtOS ?? 0.0);
                                else
                                    DebtOSCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.DebtOS != null)
                                    DebtOSCache.Add(ticker, new BloombergData<double>(member.DebtOS ?? 0.0));
                                else
                                    DebtOSCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.PE_RATIO)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.PeRatio = null;
                            else
                                member.PeRatio = (double)(resultSet[ticker][i].Value);

                            if (PERatioCache.ContainsKey(ticker))
                            {
                                if (member.PeRatio != null)
                                    PERatioCache[ticker].updateData(member.PeRatio ?? 0.0);
                                else
                                    PERatioCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.PeRatio != null)
                                    PERatioCache.Add(ticker, new BloombergData<double>(member.PeRatio ?? 0.0));
                                else
                                    PERatioCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.EBITDA)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.EBITDA = null;
                            else
                                member.EBITDA = (double)(resultSet[ticker][i].Value);

                            if (EbitdaCache.ContainsKey(ticker))
                            {
                                if (member.EBITDA != null)
                                    EbitdaCache[ticker].updateData(member.EBITDA ?? 0.0);
                                else
                                    EbitdaCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EBITDA != null)
                                    EbitdaCache.Add(ticker, new BloombergData<double>(member.EBITDA ?? 0.0));
                                else
                                    EbitdaCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.EXPECTED_REPORT_DT)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.ExpectedReportDT = null;
                            else
                                member.ExpectedReportDT = ((Bloomberglp.Blpapi.Datetime)(resultSet[ticker][i].Value)).ToSystemDateTime();

                            if (ExpectedRptDateCache.ContainsKey(ticker))
                            {
                                if (member.ExpectedReportDT != null)
                                    ExpectedRptDateCache[ticker].updateData(member.ExpectedReportDT ?? DateTime.Now);
                                else
                                    ExpectedRptDateCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.ExpectedReportDT != null)
                                    ExpectedRptDateCache.Add(ticker, new BloombergData<DateTime>(member.ExpectedReportDT ?? DateTime.Now));
                                else
                                    ExpectedRptDateCache.Add(ticker, new BloombergData<DateTime>());
                            }
                        }
                        else if (field == DataFieldNames.SI_PERCENT_EQUITY_FLOAT)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.ShortInterest = null;
                            else
                                member.ShortInterest = (double)(resultSet[ticker][i].Value);

                            if (ShortInterestCache.ContainsKey(ticker))
                            {
                                if (member.ShortInterest != null)
                                    ShortInterestCache[ticker].updateData(member.ShortInterest ?? 0.0);
                                else
                                    ShortInterestCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.ShortInterest != null)
                                    ShortInterestCache.Add(ticker, new BloombergData<double>(member.ShortInterest ?? 0.0));
                                else
                                    ShortInterestCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.PX_TO_SALES_RATIO)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.PriceToSalesRatio = null;
                            else
                                member.PriceToSalesRatio = (double)(resultSet[ticker][i].Value);

                            if (PriceToSalesRatioCache.ContainsKey(ticker))
                            {
                                if (member.PriceToSalesRatio != null)
                                    PriceToSalesRatioCache[ticker].updateData(member.PriceToSalesRatio ?? 0.0);
                                else
                                    PriceToSalesRatioCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.PriceToSalesRatio != null)
                                    PriceToSalesRatioCache.Add(ticker, new BloombergData<double>(member.PriceToSalesRatio ?? 0.0));
                                else
                                    PriceToSalesRatioCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.EQY_BETA)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.EQBeta = null;
                            else
                                member.EQBeta = (double)(resultSet[ticker][i].Value);

                            if (EQBetaCache.ContainsKey(ticker))
                            {
                                if (member.EQBeta != null)
                                    EQBetaCache[ticker].updateData(member.EQBeta ?? 0.0);
                                else
                                    EQBetaCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.EQBeta != null)
                                    EQBetaCache.Add(ticker, new BloombergData<double>(member.EQBeta ?? 0.0));
                                else
                                    EQBetaCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.SHORT_AND_LONG_TERM_DEBT)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.TotalDebt = null;
                            else
                                member.TotalDebt = (double)(resultSet[ticker][i].Value);

                            if (TotalDebtCache.ContainsKey(ticker))
                            {
                                if (member.TotalDebt != null)
                                    TotalDebtCache[ticker].updateData(member.TotalDebt ?? 0.0);
                                else
                                    TotalDebtCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.TotalDebt != null)
                                    TotalDebtCache.Add(ticker, new BloombergData<double>(member.TotalDebt ?? 0.0));
                                else
                                    TotalDebtCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.BS_TOT_ASSET)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.TotalAssets = null;
                            else
                                member.TotalAssets = (double)(resultSet[ticker][i].Value);

                            if (TotalAssetCache.ContainsKey(ticker))
                            {
                                if (member.TotalAssets != null)
                                    TotalAssetCache[ticker].updateData(member.TotalAssets ?? 0.0);
                                else
                                    TotalAssetCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.TotalAssets != null)
                                    TotalAssetCache.Add(ticker, new BloombergData<double>(member.TotalAssets ?? 0.0));
                                else
                                    TotalAssetCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.VOLUME_PCT_5_20)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.VolumeChg5d20d = null;
                            else
                                member.VolumeChg5d20d = (double)(resultSet[ticker][i].Value);

                            if (VolumeChg5d20dCache.ContainsKey(ticker))
                            {
                                if (member.VolumeChg5d20d != null)
                                    VolumeChg5d20dCache[ticker].updateData(member.VolumeChg5d20d ?? 0.0);
                                else
                                    VolumeChg5d20dCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.VolumeChg5d20d != null)
                                    VolumeChg5d20dCache.Add(ticker, new BloombergData<double>(member.VolumeChg5d20d ?? 0.0));
                                else
                                    VolumeChg5d20dCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.SALES_GROWTH)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.SalesGrowth = null;
                            else
                                member.SalesGrowth = (double)(resultSet[ticker][i].Value);

                            if (SalesGrowthCache.ContainsKey(ticker))
                            {
                                if (member.SalesGrowth != null)
                                    SalesGrowthCache[ticker].updateData(member.SalesGrowth ?? 0.0);
                                else
                                    SalesGrowthCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.SalesGrowth != null)
                                    SalesGrowthCache.Add(ticker, new BloombergData<double>(member.SalesGrowth ?? 0.0));
                                else
                                    SalesGrowthCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.HIST_CALL_IMPL_VOL)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.HistCallImplVol = null;
                            else
                                member.HistCallImplVol = (double)(resultSet[ticker][i].Value);

                            if (HistCallImplVolCache.ContainsKey(ticker))
                            {
                                if (member.HistCallImplVol != null)
                                    HistCallImplVolCache[ticker].updateData(member.HistCallImplVol ?? 0.0);
                                else
                                    HistCallImplVolCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.HistCallImplVol != null)
                                    HistCallImplVolCache.Add(ticker, new BloombergData<double>(member.HistCallImplVol ?? 0.0));
                                else
                                    HistCallImplVolCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.VOL_MEAN)
                        {
                            if (resultSet[ticker][i].Value == null)
                                member.VolMean = null;
                            else
                                member.VolMean = (double)(resultSet[ticker][i].Value);

                            if (VolMeanCache.ContainsKey(ticker))
                            {
                                if (member.VolMean != null)
                                    VolMeanCache[ticker].updateData(member.HistCallImplVol ?? 0.0);
                                else
                                    VolMeanCache[ticker].updateData();
                            }
                            else
                            {
                                if (member.VolMean != null)
                                    VolMeanCache.Add(ticker, new BloombergData<double>(member.VolMean ?? 0.0));
                                else
                                    VolMeanCache.Add(ticker, new BloombergData<double>());
                            }
                        }
                        else if (field == DataFieldNames.PRICING_SOURCE)
                        {
                            member.PricingSource = (string)(resultSet[spreadTicker][i].Value ?? "");

                            if (PricingSourceCache.ContainsKey(ticker))
                            {
                                PricingSourceCache[ticker].updateData(member.PricingSource ?? "");
                            }
                            else
                            {
                                PricingSourceCache.Add(ticker, new BloombergData<string>(member.PricingSource ?? ""));
                            }
                        }
                        else if (field == DataFieldNames.CURRENCY)
                        {
                            if (resultSet.Keys.Contains(ticker))
                            {
                                member.Currency = (string)(resultSet[ticker][i].Value ?? "");

                                if (CurrencyCache.ContainsKey(ticker))
                                {
                                    CurrencyCache[ticker].updateData(member.Currency ?? "");
                                }
                                else
                                {
                                    CurrencyCache.Add(ticker, new BloombergData<string>(member.Currency ?? ""));
                                }
                            }
                            else if (resultSet.Keys.Contains(spreadTicker))
                            {
                                member.CurrencyCDS = (string)(resultSet[spreadTicker][i].Value ?? "");

                                if (CurrencyCDSCache.ContainsKey(ticker))
                                {
                                    CurrencyCDSCache[ticker].updateData(member.CurrencyCDS ?? "");
                                }
                                else
                                {
                                    CurrencyCDSCache.Add(ticker, new BloombergData<string>(member.CurrencyCDS ?? ""));
                                }
                            }
                        }
                    }
                }
            }

            Trace.WriteLine("updateFieldByTickerList is completed for tickerFilter " + tickerFilter.TickerFilterName, "TRACE");
        }

        public void getTickerFieldsAndUpdateCache(TickerFilter tickerFilter, IEnumerable<string> tickerList, IEnumerable<string> fieldList)
        {
            Trace.WriteLine("getTickerFieldsAndUpdateCache is called", "TRACE");

            var resultSet = dataManager.GetFieldValues(tickerList, fieldList);

            foreach (CDSIndexMember member in tickerFilter.getAllCDSMembers())
            {
                string ticker = member.getTickerEquity();
                if (ticker == "")
                    continue;

                if (!tickerList.Contains(ticker))
                    continue;

                for (int i = 0; i < fieldList.Count(); ++i)
                {
                    string field = resultSet[ticker][i].Name;

                    if (field == DataFieldNames.VOLUME_PCT_5_20)
                    {
                        if (resultSet[ticker][i].Value == null)
                            member.VolumeChg5d20d = null;
                        else
                            member.VolumeChg5d20d = (double)(resultSet[ticker][i].Value);

                        if (VolumeChg5d20dCache.ContainsKey(ticker))
                        {
                            if (member.VolumeChg5d20d != null)
                                VolumeChg5d20dCache[ticker].updateData(member.VolumeChg5d20d ?? 0.0);
                            else
                                VolumeChg5d20dCache[ticker].updateData();
                        }
                        else
                        {
                            if (member.VolumeChg5d20d != null)
                                VolumeChg5d20dCache.Add(ticker, new BloombergData<double>(member.VolumeChg5d20d ?? 0.0));
                            else
                                VolumeChg5d20dCache.Add(ticker, new BloombergData<double>());
                        }
                    }
                    else if (field == DataFieldNames.SALES_GROWTH)
                    {
                        if (resultSet[ticker][i].Value == null)
                            member.SalesGrowth = null;
                        else
                            member.SalesGrowth = (double)(resultSet[ticker][i].Value);

                        if (SalesGrowthCache.ContainsKey(ticker))
                        {
                            if (member.SalesGrowth != null)
                                SalesGrowthCache[ticker].updateData(member.SalesGrowth ?? 0.0);
                            else
                                SalesGrowthCache[ticker].updateData();
                        }
                        else
                        {
                            if (member.SalesGrowth != null)
                                SalesGrowthCache.Add(ticker, new BloombergData<double>(member.SalesGrowth ?? 0.0));
                            else
                                SalesGrowthCache.Add(ticker, new BloombergData<double>());
                        }
                    }
                    else if (field == DataFieldNames.HIST_CALL_IMPL_VOL)
                    {
                        if (resultSet[ticker][i].Value == null)
                            member.HistCallImplVol = null;
                        else
                            member.HistCallImplVol = (double)(resultSet[ticker][i].Value);

                        if (HistCallImplVolCache.ContainsKey(ticker))
                        {
                            if (member.HistCallImplVol != null)
                                HistCallImplVolCache[ticker].updateData(member.HistCallImplVol ?? 0.0);
                            else
                                HistCallImplVolCache[ticker].updateData();
                        }
                        else
                        {
                            if (member.HistCallImplVol != null)
                                HistCallImplVolCache.Add(ticker, new BloombergData<double>(member.HistCallImplVol ?? 0.0));
                            else
                                HistCallImplVolCache.Add(ticker, new BloombergData<double>());
                        }
                    }
                    else if (field == DataFieldNames.EXPECTED_REPORT_DT)
                    {
                        if (resultSet[ticker][i].Value == null)
                            member.ExpectedReportDT = null;
                        else
                            member.ExpectedReportDT = ((Bloomberglp.Blpapi.Datetime)(resultSet[ticker][i].Value)).ToSystemDateTime();

                        if (ExpectedRptDateCache.ContainsKey(ticker))
                        {
                            if (member.ExpectedReportDT != null)
                                ExpectedRptDateCache[ticker].updateData(member.ExpectedReportDT ?? DateTime.Now);
                            else
                                ExpectedRptDateCache[ticker].updateData();
                        }
                        else
                        {
                            if (member.ExpectedReportDT != null)
                                ExpectedRptDateCache.Add(ticker, new BloombergData<DateTime>(member.ExpectedReportDT ?? DateTime.Now));
                            else
                                ExpectedRptDateCache.Add(ticker, new BloombergData<DateTime>());
                        }
                    }
                    else if (field == DataFieldNames.SI_PERCENT_EQUITY_FLOAT)
                    {
                        if (resultSet[ticker][i].Value == null)
                            member.ShortInterest = null;
                        else
                            member.ShortInterest = (double)(resultSet[ticker][i].Value);

                        if (ShortInterestCache.ContainsKey(ticker))
                        {
                            if (member.ShortInterest != null)
                                ShortInterestCache[ticker].updateData(member.ShortInterest ?? 0.0);
                            else
                                ShortInterestCache[ticker].updateData();
                        }
                        else
                        {
                            if (member.ShortInterest != null)
                                ShortInterestCache.Add(ticker, new BloombergData<double>(member.ShortInterest ?? 0.0));
                            else
                                ShortInterestCache.Add(ticker, new BloombergData<double>());
                        }
                    }
                    else if (field == DataFieldNames.PX_TO_SALES_RATIO)
                    {
                        if (resultSet[ticker][i].Value == null)
                            member.PriceToSalesRatio = null;
                        else
                            member.PriceToSalesRatio = (double)(resultSet[ticker][i].Value);

                        if (PriceToSalesRatioCache.ContainsKey(ticker))
                        {
                            if (member.PriceToSalesRatio != null)
                                PriceToSalesRatioCache[ticker].updateData(member.PriceToSalesRatio ?? 0.0);
                            else
                                PriceToSalesRatioCache[ticker].updateData();
                        }
                        else
                        {
                            if (member.PriceToSalesRatio != null)
                                PriceToSalesRatioCache.Add(ticker, new BloombergData<double>(member.PriceToSalesRatio ?? 0.0));
                            else
                                PriceToSalesRatioCache.Add(ticker, new BloombergData<double>());
                        }
                    }
                    else if (field == DataFieldNames.EQY_BETA)
                    {
                        if (resultSet[ticker][i].Value == null)
                            member.EQBeta = null;
                        else
                            member.EQBeta = (double)(resultSet[ticker][i].Value);

                        if (EQBetaCache.ContainsKey(ticker))
                        {
                            if (member.PriceToSalesRatio != null)
                                EQBetaCache[ticker].updateData(member.EQBeta ?? 0.0);
                            else
                                EQBetaCache[ticker].updateData();
                        }
                        else
                        {
                            if (member.EQBeta != null)
                                EQBetaCache.Add(ticker, new BloombergData<double>(member.EQBeta ?? 0.0));
                            else
                                EQBetaCache.Add(ticker, new BloombergData<double>());
                        }
                    }
                }
            }

            Trace.WriteLine("getTickerFieldsAndUpdateCache is completed", "TRACE");
        }

        public Dictionary<string, Rate> getTickerHistPrice(IEnumerable<string> tickerList, DateTime date)
        {
            Trace.WriteLine("getTickerHistPrice is called for date " + date.ToString(), "TRACE");

            if (tickerList == null || tickerList.Count() == 0)
                return null;

            List<string> histTickerList = new List<string>();
            Dictionary<string, Rate> returnHist = new Dictionary<string, Rate>();

            foreach (string ticker in tickerList)
            {
                var tickerdate = ticker + " " + GetTime(date);

                if (returnHist.ContainsKey(ticker))
                    continue;

                if (histTickerList.Contains(ticker))
                    continue;

                BloombergData<double> data;
                if (HistoricalPriceCache.TryGetValue(tickerdate, out data))
                {
                    if (!data.isDataNull())
                        returnHist.Add(ticker, new Rate(date, data.getData()));
                    else
                        returnHist.Add(ticker, new Rate(date, null));
                }
                else
                    histTickerList.Add(ticker);
            }

            if (histTickerList.Count > 0)
            {
                var result1 = dataManager.RetrieveDatePriceForAll(histTickerList, date);

                foreach (string ticker in histTickerList)
                {
                    var tickerdate = ticker + " " + GetTime(date);

                    if (returnHist.ContainsKey(ticker))
                        continue;

                    returnHist.Add(ticker, result1[ticker]);

                    if (result1[ticker].RateValue != null)
                    {
                        HistoricalPriceCache.Add(tickerdate, new BloombergData<double>(result1[ticker].RateValue ?? 0.0));
                    }
                    else
                    {
                        HistoricalPriceCache.Add(tickerdate, new BloombergData<double>());
                    }
                }

            }

            Trace.WriteLine("getTickerHistPrice is completed for date " + date.ToString(), "TRACE");

            return returnHist;
        }

        public List<string> getTickerFilterList()
        {
            Trace.WriteLine("getTickerFilterList is called", "TRACE");

            if (TickerFilterListCache.countTickerFilter() > 0)
            {
                Trace.WriteLine("getTickerFilterList is completed", "TRACE");
                return TickerFilterListCache.TickerFilterList;
            }
            if (PSMTickerFilterList.checkKeyExist(ConstantItemList.PMTICKERFILTERLIST))
            {
                TickerFilterListCache = (PersistTickerFilterList)PSMTickerFilterList.getKeyData(ConstantItemList.PMTICKERFILTERLIST);
                Trace.WriteLine("getTickerFilterList is completed", "TRACE");
                return TickerFilterListCache.TickerFilterList;
            }
            else
            {
                Trace.WriteLine("getTickerFilterList is completed with null", "TRACE");
                return null;
            }
        }

        public TickerFilterItems getTickerFilterItems(string TickerFilterName)
        {
            Trace.WriteLine("getTickerFilterItems is called for " + TickerFilterName, "TRACE");

            /*
            if (TickerFilterItemsCache.ContainsKey(TickerFilterName))
            {
                return TickerFilterItemsCache[TickerFilterName];
            }
            else */
            if (PSMTickerFilterItems.checkKeyExist(TickerFilterName))
            {
                var item = (TickerFilterItems)PSMTickerFilterItems.getKeyData(TickerFilterName);
                //TickerFilterItemsCache.Add(TickerFilterName, item);
                //return TickerFilterItemsCache[TickerFilterName];

                Trace.WriteLine("getTickerFilterItems is completed for " + TickerFilterName, "TRACE");
                return item;
            }
            else
            {
                Trace.WriteLine("Failed to retrive TickerFilterItems from Bloomberg Persistence Service for filter name " + TickerFilterName + ".", "ERROR");
                return null;
            }

        }

        public PersistLastParams getAppLastParams()
        {
            Trace.WriteLine("getAppLastParams is called", "TRACE");

            if (dataManager.initialized == false)
            {
                Trace.WriteLine("WARNING !!! Bloomberg Session couldn't be created!!!", "ERROR");

                return null;
            }

            if (appLastParamsRetrieved)
            {
                Trace.WriteLine("getAppLastParams is completed", "TRACE");
                return AppLastParams;
            }
            else
            {
                appLastParamsRetrieved = true;

                if (PSMLastParameters.checkKeyExist(ConstantItemList.PMAPPLASTPARAMS))
                {
                    AppLastParams = (PersistLastParams)PSMLastParameters.getKeyData(ConstantItemList.PMAPPLASTPARAMS);
                    Trace.WriteLine("getAppLastParams is completed", "TRACE");
                    return AppLastParams;
                }
                else
                {
                    Trace.WriteLine("Failed to retrive Application last parameters from Bloomberg Persistence Service.", "ERROR");
                    return null;
                }
            }
        }

        public void saveAppLastParams(PersistLastParams lastparams)
        {
            Trace.WriteLine("saveAppLastParams is called", "TRACE");
            if (dataManager.initialized == false)
            {
                Trace.WriteLine("WARNING !!! Bloomberg Session couldn't be created!!!", "ERROR");

                return;
            }

            AppLastParams = lastparams;
            PSMLastParameters.saveKeyData(ConstantItemList.PMAPPLASTPARAMS, lastparams);

            Trace.WriteLine("saveAppLastParams is completed", "TRACE");
        }

        public void saveTickerFilterItems(TickerFilterItems item)
        {
            Trace.WriteLine("saveTickerFilterItems is called", "TRACE");
            if (dataManager.initialized == false)
            {
                Trace.WriteLine("WARNING !!! Bloomberg Session couldn't be created!!!", "ERROR");

                return;
            }

            //Trace.WriteLine("saveTickerFilterItems is called for " + item.TickerFilterName, "TRACE");

            /*if (TickerFilterItemsCache.ContainsKey(item.TickerFilterName))
            {
                TickerFilterItemsCache[item.TickerFilterName] = item;
            }
            else
            {
                TickerFilterItemsCache.Add(item.TickerFilterName, item);*/
                TickerFilterListCache.addTickerFilter(item.TickerFilterName);
                PSMTickerFilterList.saveKeyData(ConstantItemList.PMTICKERFILTERLIST, TickerFilterListCache);
            //}

            PSMTickerFilterItems.saveKeyData(item.TickerFilterName, item);

            Trace.WriteLine("saveTickerFilterItems is completed", "TRACE");
        }

        public void removeTickerFilterItems(string TickerFilterName)
        {
            Trace.WriteLine("removeTickerFilterItems is called", "TRACE");
            if (dataManager.initialized == false)
            {
                Trace.WriteLine("WARNING !!! Bloomberg Session couldn't be created!!!", "ERROR");

                return;
            }

            //Trace.WriteLine("removeTickerFilterItems is called for " + TickerFilterName, "TRACE");

            /*if (TickerFilterItemsCache.ContainsKey(TickerFilterName))
            {
                TickerFilterItemsCache.Remove(TickerFilterName);
            }
            */
            if (TickerFilterListCache.isExistTickerFilter(TickerFilterName))
            {
                TickerFilterListCache.removeTickerFilter(TickerFilterName);

                if (TickerFilterListCache.countTickerFilter() > 0)
                    PSMTickerFilterList.saveKeyData(ConstantItemList.PMTICKERFILTERLIST, TickerFilterListCache);
                else
                    PSMTickerFilterList.removeKeyData(ConstantItemList.PMTICKERFILTERLIST);
            }

            PSMTickerFilterItems.removeKeyData(TickerFilterName);
            Trace.WriteLine("removeTickerFilterItems is completed", "TRACE");
        }

        private static string GetTime(DateTime time)
        {
            return (time.Date - (new DateTime(1970, 1, 1)).Date).TotalMilliseconds.ToString();
        }

        public void initTickerFilter(TickerFilter tickerFilter, CDSIndexBase cdsindexbase, TickerFilterItems tickerFilterItems)
        {
            Trace.WriteLine("initTickerFilter is called for " + tickerFilter.TickerFilterName, "TRACE");

            tickerFilter.setCDSIndex(cdsindexbase);
            tickerFilter.setPricingSource(tickerFilterItems.PriceSource);
            
            //TODO: retrieve CDS Index members
            List<BloombergData<string>> CDSIndexEqTickerList;
            if (!CDSIndexEqTickerCache.TryGetValue(tickerFilter.TFCDSIndex.CDSIndexName, out CDSIndexEqTickerList))
            {
                CDSIndexEqTickerList = new List<BloombergData<string>>();

                dataManager.GetCDSIndexMembers(tickerFilter.TFCDSIndex);

                foreach (CDSIndexMember member in tickerFilter.TFCDSIndex.CDSIndexMemberList)
                {
                    string ticker = member.getTickerEquity();

                    if (ticker == "")
                        continue;

                    CDSIndexEqTickerList.Add(new BloombergData<string>(member.TickerEquity));

                    if (CDSRefNameCache.ContainsKey(ticker))
                    {
                        CDSRefNameCache[ticker].updateData(member.CDSRefName);
                    }
                    else
                        CDSRefNameCache.Add(ticker, new BloombergData<string>(member.CDSRefName));
                }

                if (CDSIndexEqTickerCache.ContainsKey(tickerFilter.TFCDSIndex.CDSIndexName))
                {
                    CDSIndexEqTickerCache[tickerFilter.TFCDSIndex.CDSIndexName] = CDSIndexEqTickerList;
                }
                else
                    CDSIndexEqTickerCache.Add(tickerFilter.TFCDSIndex.CDSIndexName, CDSIndexEqTickerList);
            }
            else
            {
                foreach (var ticker in CDSIndexEqTickerList)
                {
                    string tickerEq = ticker.getData();

                    tickerFilter.TFCDSIndex.addCDSIndexMember(tickerEq);

                    if (CDSRefNameCache.ContainsKey(tickerEq + " Equity"))
                    {
                        tickerFilter.TFCDSIndex.CDSIndexMemberList.Last().CDSRefName = CDSRefNameCache[tickerEq + " Equity"].getData();
                    }
                }
            }

            Trace.WriteLine("initTickerFilter is completed for " + tickerFilter.TickerFilterName, "TRACE");

        }

        public void getInitialAddedTickerList(List<CDSIndexMember> AddedTickerList, List<string> AdditionalFields = null)
        {
            Trace.WriteLine("getInitialAddedTickerList is called", "TRACE");

            if (AddedTickerList == null || AddedTickerList.Count == 0)
            {
                Trace.WriteLine("getInitialAddedTickerList is completed, list is empty.", "TRACE");
                return;
            }
            Dictionary<string, List<string>> FieldByCDSTickerList = new Dictionary<string, List<string>>();

            List<string> EqTickerForSpreadTicker = new List<string>();

            foreach (CDSIndexMember member in AddedTickerList)
            {
                var ticker = member.TickerEquity;

                List<BloombergData<string>> CDSSpreadMatTickerList;

                if (CDSSpreadMatNameCache.TryGetValue(ticker, out CDSSpreadMatTickerList))
                {
                    member.TickerSpreadList.Clear();
                    foreach (var spreadMaturity in CDSSpreadMatTickerList)
                    {
                        member.createTickerSpread(spreadMaturity.getData());
                    }
                }
                else
                {
                    EqTickerForSpreadTicker.Add(member.getTickerEquity());
                }
            }

            if (EqTickerForSpreadTicker.Count > 0)
            {   //get Spread Maturity
                retrieveCDSSpreadTicker(AddedTickerList, EqTickerForSpreadTicker);
            }

            Dictionary<string, List<string>> FieldByTickerList = new Dictionary<string, List<string>>();

            List<string> EqTickerFieldList;

            if (AdditionalFields != null)
                EqTickerFieldList = DataFieldNames.fieldsInit_EqTickerForCache.Concat(AdditionalFields).ToList();
            else
                EqTickerFieldList = DataFieldNames.fieldsInit_EqTickerForCache;

            foreach (var field in EqTickerFieldList)
            {
                List<string> fieldTickerList = new List<string>();

                foreach (CDSIndexMember member in AddedTickerList)
                {
                    string ticker = member.getTickerEquity();
                    if (ticker == "")
                        continue;

                    if (field == DataFieldNames.SECURITY_NAME)
                    {
                        BloombergData<string> data;
                        if (CDSRefNameCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.CDSRefName = data.getData();
                            else
                                member.CDSRefName = "";
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.INDUSTRY_SECTOR)
                    {
                        BloombergData<string> data;
                        if (IndustryCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.IndustryName = data.getData();
                            else
                                member.IndustryName = "";

                            if (!CDSIndexIndustryList.Contains(member.IndustryName))
                                CDSIndexIndustryList.Add(member.IndustryName);
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.RTG_MDY_SEN_UNSECURED_DEBT)
                    {
                        BloombergData<string> data;
                        if (MoodysRatingCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.MoodysRating = data.getData();
                            else
                                member.MoodysRating = ConstantItemList.MOODYSNAV;

                            if (!CDSIndexRatingsList.Contains(member.MoodysRating))
                                CDSIndexRatingsList.Add(member.MoodysRating);
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.RTG_SP_LT_LC_ISSUER_CREDIT)
                    {
                        BloombergData<string> data;
                        if (SPRatingCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.SPRating = data.getData();
                            else
                                member.SPRating = "";
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.RTG_FITCH_SEN_UNSECURED)
                    {
                        BloombergData<string> data;
                        if (FitchRatingCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.FitchRating = data.getData();
                            else
                                member.FitchRating = "";
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.CUR_MKT_CAP)
                    {
                        BloombergData<double> data;
                        if (MarketCapCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.MarketCapital = data.getData();
                            else
                                member.MarketCapital = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.TOT_DEBT_TO_TOT_CAP)
                    {
                        BloombergData<double> data;
                        if (TotalDebtToCapCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.TotalDebtToCapital = data.getData();
                            else
                                member.TotalDebtToCapital = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.TOT_DEBT_TO_COM_EQY)
                    {
                        BloombergData<double> data;
                        if (DebtToCommonEqCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.DebtToCommonEquity = data.getData();
                            else
                                member.DebtToCommonEquity = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.INTEREST_COVERAGE_RATIO)
                    {
                        BloombergData<double> data;
                        if (InterestCovRatioCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.InterestCoverageRatio = data.getData();
                            else
                                member.InterestCoverageRatio = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.EQY_DVD_YLD_IND)
                    {
                        BloombergData<double> data;
                        if (EqDividendYieldCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.EqDividendeYield = data.getData();
                            else
                                member.EqDividendeYield = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.ENTERPRISE_VALUE)
                    {
                        BloombergData<double> data;
                        if (EnterpriseValueCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.EnterpriseValue = data.getData();
                            else
                                member.EnterpriseValue = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.DDIS_AMT_OUTSTANDING)
                    {
                        BloombergData<double> data;
                        if (DebtOSCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.DebtOS = data.getData();
                            else
                                member.DebtOS = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.PE_RATIO)
                    {
                        BloombergData<double> data;
                        if (PERatioCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.PeRatio = data.getData();
                            else
                                member.PeRatio = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }

                    else if (field == DataFieldNames.EBITDA)
                    {
                        BloombergData<double> data;
                        if (EbitdaCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.EBITDA = data.getData();
                            else
                                member.EBITDA = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.EXPECTED_REPORT_DT)
                    {
                        BloombergData<DateTime> data;
                        if (ExpectedRptDateCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.ExpectedReportDT = data.getData();
                            else
                                member.ExpectedReportDT = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.SI_PERCENT_EQUITY_FLOAT)
                    {
                        BloombergData<double> data;
                        if (ShortInterestCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.ShortInterest = data.getData();
                            else
                                member.ShortInterest = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.PX_TO_SALES_RATIO)
                    {
                        BloombergData<double> data;
                        if (PriceToSalesRatioCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.PriceToSalesRatio = data.getData();
                            else
                                member.PriceToSalesRatio = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.EQY_BETA)
                    {
                        BloombergData<double> data;
                        if (EQBetaCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.EQBeta = data.getData();
                            else
                                member.EQBeta = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.SHORT_AND_LONG_TERM_DEBT)
                    {
                        BloombergData<double> data;
                        if (TotalDebtCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.TotalDebt = data.getData();
                            else
                                member.TotalDebt = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.BS_TOT_ASSET)
                    {
                        BloombergData<double> data;
                        if (TotalAssetCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.TotalAssets = data.getData();
                            else
                                member.TotalAssets = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.VOLUME_PCT_5_20)
                    {
                        BloombergData<double> data;
                        if (VolumeChg5d20dCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.VolumeChg5d20d = data.getData();
                            else
                                member.VolumeChg5d20d = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.SALES_GROWTH)
                    {
                        BloombergData<double> data;
                        if (SalesGrowthCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.SalesGrowth = data.getData();
                            else
                                member.SalesGrowth = null;
                        }
                        else
                            fieldTickerList.Add(ticker);

                    }
                    else if (field == DataFieldNames.HIST_CALL_IMPL_VOL)
                    {
                        BloombergData<double> data;
                        if (HistCallImplVolCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.HistCallImplVol = data.getData();
                            else
                                member.HistCallImplVol = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.VOL_MEAN)
                    {
                        BloombergData<double> data;
                        if (VolMeanCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.VolMean = data.getData();
                            else
                                member.VolMean = null;
                        }
                        else
                            fieldTickerList.Add(ticker);
                    }
                    else if (field == DataFieldNames.PRICING_SOURCE)
                    {
                        BloombergData<string> data;
                        if (PricingSourceCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.PricingSource = data.getData();
                            else
                                member.PricingSource = "";
                        }
                        else
                        {
                            if (member.getTickerSpread(4) != "")
                                fieldTickerList.Add(member.getTickerSpread(4));
                        }
                    }
                    else if (field == DataFieldNames.CURRENCY)
                    {
                        BloombergData<string> data;
                        if (CurrencyCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.Currency = data.getData();
                            else
                                member.Currency = "";
                        }
                        else
                            fieldTickerList.Add(ticker);

                        if (CurrencyCDSCache.TryGetValue(ticker, out data))
                        {
                            if (!data.isDataNull())
                                member.CurrencyCDS = data.getData();
                            else
                                member.CurrencyCDS = "";
                        }
                        else
                        {
                            if (member.getTickerSpread(4) != "")
                                fieldTickerList.Add(member.getTickerSpread(4));
                        }
                    }

                }

                if (fieldTickerList.Count > 0)
                    FieldByTickerList.Add(field, fieldTickerList);
            }

            updateFieldByTickerList(FieldByTickerList, AddedTickerList);

            dataManager.GetInitEquitySpreadTickerPrice(AddedTickerList, true);

            getFXRate(AddedTickerList);

            Trace.WriteLine("getInitialAddedTickerList is completed.", "TRACE");
        }

        public List<CDSIndexBase> getCDSIndexList()
        {
            Trace.WriteLine("getCDSIndexList is called", "TRACE");

            if (CDSIndexList.Count > 0)
                return CDSIndexList;

            /*get rolling series*/
            var seriesList = dataManager.RetrieveCDSIndexSeries(ConstantItemList.CDSIndexGENList);

            if (seriesList == null)
            {
                Trace.WriteLine("Failed to retrieve CDS Index series", "ERROR");
                return null;
            }
            List<string> cdsIndexList = new List<string>();

            foreach (var cdsserie in seriesList)
            {
                if (cdsserie.Value != -1)
                {
                    cdsIndexList.Add(cdsserie.Key.Replace("GEN", "S" + cdsserie.Value.ToString()));
                    if (cdsserie.Value > 0)
                        cdsIndexList.Add(cdsserie.Key.Replace("GEN", "S" + (cdsserie.Value - 1).ToString()));
                }
            }

            foreach (var equityIndex in ConstantItemList.EquityIndexList)
            {
                cdsIndexList.Add(equityIndex);
            }

            /*get definition/name*/
            var namesList = dataManager.RetrieveCDSIndexNames(cdsIndexList);

            if (namesList == null)
            {
                Trace.WriteLine("Failed to retrieve CDS Index names!", "ERROR");
                return null;
            }

            /*get equity index list*/
            foreach (var cdsname in namesList)
            {
                if (cdsname.Value != "")
                {
                    if (ConstantItemList.EquityIndexList.Contains(cdsname.Key))
                        CDSIndexList.Add(new CDSIndexBase(cdsname.Key, cdsname.Value, CDSIndexType.EQUITY));
                    else
                        CDSIndexList.Add(new CDSIndexBase(cdsname.Key, cdsname.Value, CDSIndexType.SPREAD));
                }
            }

            //fill the region field
            foreach (var cdsIndex in CDSIndexList)
            {
                foreach (var ind_region in ConstantItemList.IndexRegionDict)
                {
                    if (cdsIndex.CDSIndexName.Contains(ind_region.Key))
                    {
                        cdsIndex.region = ind_region.Value;
                        break;
                    }
                }
            }

            Trace.WriteLine("getCDSIndexList is completed", "TRACE");
            return CDSIndexList;
        }

        public CDSIndexBase getCDSIndexBase(string cdsIndexName)
        {
            Trace.WriteLine("getCDSIndexBase is called", "TRACE");

            var list = getCDSIndexList();

            if (list == null)
            {
                Trace.WriteLine("Failed to retrieve CDS Index List while retrieving details of CDS Index Name " + cdsIndexName + ".", "ERROR");
                return null;
            }

            foreach (var cdsindexbase in list)
                if (cdsIndexName == cdsindexbase.CDSIndexName)
                    return cdsindexbase;

            List<string> listsecurity = new List<string>();
            listsecurity.Add(cdsIndexName);

            var namesList = dataManager.RetrieveCDSIndexNames(listsecurity);

            if (namesList == null)
            {
                Trace.WriteLine("Failed to retrieve CDS Index names!", "ERROR");
                return null;
            }

            foreach (var cdsname in namesList)
            {
                if (cdsname.Value != "")
                {
                    CDSIndexList.Add(new CDSIndexBase(cdsname.Key, cdsname.Value, CDSIndexType.SPREAD));

                    foreach (var ind_region in ConstantItemList.IndexRegionDict)
                    {
                        if (CDSIndexList.Last().CDSIndexName.Contains(ind_region.Key))
                        {
                            CDSIndexList.Last().region = ind_region.Value;
                            break;
                        }
                    }
                    Trace.WriteLine("getCDSIndexBase is completed.", "TRACE");
                    return CDSIndexList.Last();
                }
            }

            Trace.WriteLine("Failed to find the CDS Index details in cache for the CDS Index name " + cdsIndexName + ".", "INFO");

            return null;
        }

        public string compareCcyWithBase(string ccy)
        {
            if (ccy != null || ccy != "")
            {
                if (!ccy.Equals(ConstantItemList.BaseCurrency))
                {
                    return ccy + ConstantItemList.BaseCurrency + ConstantItemList.FXBloombergSuffix;
                }
                else
                    return ccy;
            }

            return ccy;
        }

        public void getFXRate(List<CDSIndexMember> CDSIndexMemberList)
        {
            Trace.WriteLine("getFXRate is called", "TRACE");

            List<string> ccyTickerList = new List<string>();

            foreach (var member in CDSIndexMemberList)
            {
                string ccyTicker = compareCcyWithBase(member.Currency);

                if (ccyTicker != member.Currency)
                {
                    if (!ccyTickerList.Contains(ccyTicker))
                        ccyTickerList.Add(ccyTicker);
                }
                else
                    member.FXRateEquity = 1;

                ccyTicker = compareCcyWithBase(member.CurrencyCDS);

                if (ccyTicker != member.CurrencyCDS)
                {
                    if (!ccyTickerList.Contains(ccyTicker))
                        ccyTickerList.Add(ccyTicker);
                }
                else
                    member.FXRateCDS = 1;
            }

            if (ccyTickerList.Count > 0)
            {
                var ccyFXRateDict = getFXRate(ccyTickerList);

                foreach (var member in CDSIndexMemberList)
                {
                    string ccyTicker = compareCcyWithBase(member.Currency);

                    if (ccyTicker != member.Currency)
                    {
                        if(ccyFXRateDict.Keys.Contains(ccyTicker))
                        {
                            member.FXRateEquity = ccyFXRateDict[ccyTicker];
                        }
                    }

                    ccyTicker = compareCcyWithBase(member.CurrencyCDS);

                    if (ccyTicker != member.CurrencyCDS)
                    {
                        if (ccyFXRateDict.Keys.Contains(ccyTicker))
                        {
                            member.FXRateCDS = ccyFXRateDict[ccyTicker];
                        }
                    }
                }

                ccyTickerList.Clear();
                ccyFXRateDict.Clear();
            }

            Trace.WriteLine("getFXRate is completed", "TRACE");
        }

        public Dictionary<string, double?> getFXRate(List<string> ccyTickerList)
        {
            Dictionary<string, double?> ccyFXRateDict = new Dictionary<string, double?>();

            List<string> reqCcyTickerList = new List<string>();

            foreach (var ccyTicker in ccyTickerList)
            {
                BloombergData<double> data;
                if (FXRateCache.TryGetValue(ccyTicker, out data))
                {
                    if (!data.isDataNull())
                        ccyFXRateDict.Add(ccyTicker, data.getData());
                    else
                        ccyFXRateDict.Add(ccyTicker, null);
                }
                else
                    reqCcyTickerList.Add(ccyTicker);
            }

            if(reqCcyTickerList.Count > 0)
            {
                List<string> fields = new List<string> { DataFieldNames.LAST_PRICE, DataFieldNames.QUOTE_FACTOR };

                var resultSet = dataManager.GetFieldValues(reqCcyTickerList, fields);

                foreach (var ccyTicker in reqCcyTickerList)
                {
                    double? fxRate = null;
                    double? quote_factor = null;

                    for (int i = 0; i < fields.Count; ++i)
                    {
                        if (fields[i] == DataFieldNames.LAST_PRICE)
                        {
                            if (resultSet[ccyTicker][i].Value == null)
                                fxRate = null;
                            else
                                fxRate = (double)(resultSet[ccyTicker][i].Value);
                        }
                        else if (fields[i] == DataFieldNames.QUOTE_FACTOR)
                        {
                            if (resultSet[ccyTicker][i].Value == null)
                                quote_factor = null;
                            else
                                quote_factor = (double)(resultSet[ccyTicker][i].Value);
                        }

                        if (i == fields.Count - 1)
                        {
                            if (fxRate != null)
                                fxRate = fxRate / (quote_factor ?? 1.0);

                            if (FXRateCache.ContainsKey(ccyTicker))
                            {
                                if (fxRate != null)
                                    FXRateCache[ccyTicker].updateData(fxRate ?? 1.0);
                                else
                                    FXRateCache[ccyTicker].updateData();
                            }
                            else
                            {
                                if (fxRate != null)
                                    FXRateCache.Add(ccyTicker, new BloombergData<double>(fxRate ?? 1.0));
                                else
                                    FXRateCache.Add(ccyTicker, new BloombergData<double>());
                            }

                            if (fxRate != null)
                                ccyFXRateDict.Add(ccyTicker, fxRate);
                            else
                                ccyFXRateDict.Add(ccyTicker, null);
                        
                        
                        }
                    } 
                }
            }

            return ccyFXRateDict;
        }

        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                dataManager.Dispose();
                // dispose managed resources
                IndustryCache.Clear();
                MoodysRatingCache.Clear();
                FitchRatingCache.Clear();
                SPRatingCache.Clear();
                MarketCapCache.Clear();
                TotalDebtToCapCache.Clear();
                DebtToCommonEqCache.Clear();
                InterestCovRatioCache.Clear();
                VolumeChg5d20dCache.Clear();
                SalesGrowthCache.Clear();
                HistCallImplVolCache.Clear();
                VolMeanCache.Clear();
                ShortInterestCache.Clear();
                PriceToSalesRatioCache.Clear();
                TotalDebtCache.Clear();
                TotalAssetCache.Clear();
                ExpectedRptDateCache.Clear();
                EbitdaCache.Clear();
                EqDividendYieldCache.Clear();
                EnterpriseValueCache.Clear();
                DebtOSCache.Clear();
                PERatioCache.Clear();
                EQBetaCache.Clear();

                CDSRefNameCache.Clear();
                PricingSourceCache.Clear();
                CurrencyCache.Clear();
                CurrencyCDSCache.Clear();
                CDSSpreadMatNameCache.Clear();
                CDSIndexEqTickerCache.Clear();
                HistoricalPriceCache.Clear();
                FXRateCache.Clear();

                if (CDSIndexIndustryList != null)
                    CDSIndexIndustryList.Clear();

                if (CDSIndexRatingsList != null)
                    CDSIndexRatingsList.Clear();

                if (CDSIndexList != null)
                    CDSIndexList.Clear();
            }
            // free native resources
        }

        public void Dispose()
        {
            Trace.WriteLine("CacheManager Dispose is called", "TRACE");
            Dispose(true);
            GC.SuppressFinalize(this);

            Trace.WriteLine("CacheManager Dispose is completed", "TRACE");
        }

    }
}
