﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.ComponentModel;
using CDSHeatMap.Util;

namespace CDSHeatMap.ColorBar
{
    /// <summary>
    /// Interaction logic for SolidBar.xaml
    /// </summary>
    public partial class SolidBar : UserControl, INotifyPropertyChanged
    {
        public double ColorDataMinimum { get; set; }
        public double ColorDataMaximum { get; set; }
        public bool isNegativeGreen { get; set; }
        public string _header { get; set; }
        public string Header
        {
            get { return _header; }
            set
            {
                 groupBox.Header = value;
                _header = value;
                OnPropertyChanged("Header");
            }
        }


        public string suffix { get; set; }

        public void setProperties()
        {
            lblMinimum.Text = suffix + String.Format("{0:0.0000}",ColorDataMinimum);
            lblMaximum.Text = suffix + String.Format("{0:0.0000}",ColorDataMaximum);
            groupBox.Header = Header;
        }

        public Color Color2
        {
            get { return GreenBackground.Color; }
            set { 
                GreenBackground.Color = value;
                OnPropertyChanged("Color2"); 
                }
        }
        public Color Color1
        {
            get { return RedBackground.Color; }
            set { RedBackground.Color = value;
                OnPropertyChanged("Color1");    
                }
        }
        public double _whiteoffset;
        public double Offset
        {
            get { return WhiteBackground.Offset; }
            set
            {
                WhiteBackground.Offset = value; 
                OnPropertyChanged("Offset");
            }
        }
        public void fillColorBar()
        {
            calculateOffsetAndColor();
            setProperties();
        }

        private void calculateOffsetAndColor() {
            double offset = 0.5;
            double sub = 0;
            sub = (this.ColorDataMaximum - this.ColorDataMinimum);
            offset = ((1 / (sub)) * Math.Abs(ColorDataMinimum));
            WhiteBackground.Offset = offset;
            generateColorForSolidBar();
        }

        private void generateColorForSolidBar()
        {
            Color color = new Color();
            //byte colorCode = 50;  ;
            int section = 24;

            if ((ColorDataMaximum > 0 && ColorDataMinimum >= 0) || ColorDataMaximum <= 0 && ColorDataMinimum < 0)
            {
                if ((ColorDataMaximum > 0 && ColorDataMinimum >= 0))
                    ColorDataMinimum = 0;
                if (ColorDataMaximum < 0 && ColorDataMinimum <= 0)
                    ColorDataMaximum = 0;

                // isNegativeGreen true = green +, red -
                // isNegativeGreen false = red +, green -
                if (isNegativeGreen)
                {
                    if (ColorDataMaximum > 0 && ColorDataMinimum >= 0)
                    {
                        //color = Color.FromRgb(colorCode, 255, colorCode);
                        color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                        Color2 = color;
                        Color1 = Color.FromRgb(255, 255, 255);
                    }
                    else
                    {
                        //color = Color.FromRgb(255, colorCode, colorCode);
                        color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                        Color1 = color;
                        Color2 = Color.FromRgb(255, 255, 255);
                    }
                }
                else
                {
                    if (ColorDataMaximum > 0 && ColorDataMinimum >= 0)
                    {
                        //color = Color.FromRgb(255, colorCode, colorCode);
                        color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                        Color2 = color;
                        Color1 = Color.FromRgb(255, 255, 255);
                    }
                    else
                    {
                        //color = Color.FromRgb(colorCode, 255, colorCode);
                        color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                        Color1 = color;
                        Color2 = Color.FromRgb(255, 255, 255);
                    }
                }
            }
            else
            {
                if (isNegativeGreen)
                {
                    //color = Color.FromRgb(colorCode, 255, colorCode);
                    color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                    Color2 = color;
                    //Color1 = Color.FromRgb(255, colorCode, colorCode);
                    Color1 = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                    
                }
                else
                {
                    //color = Color.FromRgb(255, colorCode, colorCode);
                    color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                    Color2 = color;
                    //Color1 = Color.FromRgb(colorCode, 255, colorCode);
                    Color1 = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                }
            }
        }


        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
       

        public SolidBar()
        {
            InitializeComponent();
        }
    }
}
