﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Bloomberglp.AppPortalApi.DataPersistence;

using CDSHeatMap.ConfigurationManager;

namespace CDSHeatMap.DBManager
{

    public class PersistenceManager<T>
    {
        private string _appNameSpace;

        public PersistenceManager()
        {
            _appNameSpace = "CDSHeatmapApp";
        }

        public void saveKeyData(string nameSpace, string key, T data)
        {
            if (checkKeyExist(nameSpace, key))
            {
                removeKeyData(nameSpace, key);
            }

            PersistenceService.GetNamedContext(nameSpace).SaveData<T>(key, data);
        }

        public void saveKeyData(string key, T data)
        {

            if (checkKeyExist(key))
            {
                removeKeyData(key);
            }

            PersistenceService.GetNamedContext(_appNameSpace).SaveData<T>(key, data);
        }

        public T getKeyData(string nameSpace, string key)
        {
            return PersistenceService.GetNamedContext(nameSpace).GetData<T>(key);
        }

        public T getKeyData(string key)
        {
            return PersistenceService.GetNamedContext(_appNameSpace).GetData<T>(key);
        }

        public void removeKeyData(string nameSpace, string key)
        {
            if (checkKeyExist(nameSpace, key))
                PersistenceService.GetNamedContext(nameSpace).RemoveData(key);
        }

        public void removeKeyData(string key)
        {
            if (checkKeyExist(key))
                PersistenceService.GetNamedContext(_appNameSpace).RemoveData(key);
        }

        public bool checkKeyExist(string nameSpace, string key)
        {
            if (PersistenceService.GetNamedContext(nameSpace).KeyExists(key))
                return true;
            else
                return false;
        }

        public bool checkKeyExist(string key)
        {
            if (PersistenceService.GetNamedContext(_appNameSpace).KeyExists(key))
                return true;
            else
                return false;
        }

    }
}
