﻿using System;
using System.Collections.Generic;
using CDSHeatMap.Model;

namespace CDSHeatMap.Interface
{
    public interface IMarketDataProvider : IDisposable
    {
        IMarketDataResult GetValuesForFields(ITicker ticker, string field);
        IMarketDataResult GetValuesForFields(IEnumerable<string> tickers, IEnumerable<string> fields);
        IMarketDataResult GetQueryResults(ITicker ticker, string field);

        IMarketDataResult GetHistoricalValuesForFields(IEnumerable<string> tickers, IEnumerable<string> fields, string startdate, string enddate);

        IMarketDataSubscription Subscribe(ITicker ticker, IEnumerable<string> list);
        void Unsubscribe(IList<IMarketDataSubscription> subscriptions);
        void Unsubscribe();

        event Action<IMarketDataSubscription> SubsriptionDataUpdate;

        bool isInitialized();
    }
}
