﻿using System.Text;
using System.Threading;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using CDSHeatMap.ViewModel;
using Bloomberglp.AppPortalApi;
using System;
using System.Windows.Threading;
using CDSHeatMap.BloombergAPIManager;
using CDSHeatMap.DBManager;
using CDSHeatMap.Model;
using System.Collections.Generic;

using Bloomberglp.AppPortalApi.DataPersistence;
using Bloomberglp.AppPortalApi.Chrome;
using CDSHeatMap.View;
using System.Diagnostics;
using Bloomberglp.AppPortalApi.Desktop;

namespace CDSHeatMap
{
    [BlpApplication]
    public partial class MainView : UserControl
    {
        internal static MainWindowViewModel mainWindowViewModel;

        Dispatcher mainThreadDispatcher;

        public MainView()
        {
            Trace.WriteLine("CDSHeatMap application is started. CDSHeatMap Version 1.0.1.3", "INFO");

            InitializeComponent();

            try
            {
                bool is64BitOS = false;
                try
                {
                    if (Environment.Is64BitOperatingSystem)
                    {
                        Trace.WriteLine("Environment is 64Bit operating system.", "INFO");

                        is64BitOS = true;
                    }
                    else
                    {
                        Trace.WriteLine("Environment is not 64Bit operating system.", "INFO");
                    }
                }
                catch (Exception exEnv)
                {
                    Trace.WriteLine("Failed to get environment variable." + "\n" + exEnv.Message, "ERROR");
                }

                MainWindowViewModel.Is64BitOS = is64BitOS;
                mainWindowViewModel = new MainWindowViewModel();

                Trace.WriteLine("Main: mainWindowViewModel is created.");

                this.Loaded += delegate
                {
                    Dispatcher.ShutdownStarted += OnDispatcherShutdownStarted;
                    Dispatcher.UnhandledException += OnUnhandledException;

                    BlpApplication.Current.Closing += OnAppClosing;

                    mainThreadDispatcher = Dispatcher.CurrentDispatcher;
                };


                if (!BlpEnvironment.IsEmbedded)
                {
                    setTaskbarIcon();

                    if (PersistenceService.DefaultContext.KeyExists("WINDOW_WIDTH") &&
                    PersistenceService.DefaultContext.KeyExists("WINDOW_HEIGHT"))
                    {
                        var width =
                        PersistenceService.DefaultContext.GetData<int>("WINDOW_WIDTH");
                        var height =
                        PersistenceService.DefaultContext.GetData<int>("WINDOW_HEIGHT");

                        if (width < 600)
                            width = 600;

                        if (height < 600)
                            height = 600;

                        Trace.WriteLine("CDSHeatMap window width is set to " + width + ", window height is set to " + height + ".", "INFO");
                        AppPortalChrome.SetInitialSize(this, new Size(width, height));
                    }
                    else
                    {
                        AppPortalChrome.SetInitialSize(this, new Size(1024, 768));
                    }

                    //set initial location
                    /*
                    if (PersistenceService.DefaultContext.KeyExists("WINDOW_LOCATION_X") &&
                    PersistenceService.DefaultContext.KeyExists("WINDOW_LOCATION_Y"))
                    {
                        var xPos =
                        PersistenceService.DefaultContext.GetData<int>("WINDOW_LOCATION_X");
                        var yPos =
                        PersistenceService.DefaultContext.GetData<int>("WINDOW_LOCATION_Y");
                        if(xPos > 0 && yPos > 0 )
                        {
                            Trace.WriteLine("CDSHeatMap location X-Position is set to " + xPos + ", window Y-Position is set to " + yPos + ".", "INFO");
                            AppPortalChrome.SetInitialLocation(this, new Point(xPos, yPos));
                        }
                    }
                     */
                }
            }
            catch (Exception e)
            {
                Trace.WriteLine(string.Format("A problem is occurred in CDS Heatmap application!!!: {0}", e.Message.ToString()), "ERROR");

                if(e.InnerException != null)
                    Trace.WriteLine(string.Format("A problem is occurred in CDS Heatmap application!!!: {0}", e.InnerException.Message.ToString()), "ERROR");

                if (e.InnerException != null &&
                    e.InnerException.GetType() == typeof(BlpApiDataException))
                {
                    ModalDialog.Instance.Title = "API Error";
                    ModalDialog.Instance.Width = 500;
                    ModalDialog.Instance.Height = 400;

                    string errMainMessage = "CDSHeatmap could not be started...";

                    ModalDialog.Instance.ShowDialog(new ErrorMessageDialog(errMainMessage + "\n\n" + e.InnerException.Message.ToString(), ErrorMsgLevel.BLPContact));

                    Dispatcher.BeginInvokeShutdown(DispatcherPriority.Normal);
                }

                string errMessage = "A problem is occurred in CDS Heatmap application (1010) !!!";
                try
                {
                    Trace.WriteLine(string.Format("A problem is occurred in CDS Heatmap application!!!: {0}", e.Message.ToString()), "ERROR");

                    string stackTrace = "";
                    if (e.StackTrace != null)
                        stackTrace = e.StackTrace.ToString();

                    Trace.WriteLine("Exception Stacktrace (1010): " + stackTrace, "INFO");

                    var popup = new DisplayExceptionView(errMessage + "\n" + e.Message.ToString(), stackTrace);
                    PopupWindow.Instance.Title = "API Error";
                    PopupWindow.Instance.ShowWindow(popup);
                    PopupWindow.Instance.Width = 500;//Aysegul Albayrak,popup size
                    PopupWindow.Instance.Height = 600;
                }
                catch (Exception eDisplay)
                {
                    Trace.WriteLine("Exception while displaying Bloomberg API Error (1011): " + errMessage + "\n" + eDisplay.Message, "ERROR");

                    string stackTraceDisplay = "";
                    if (eDisplay.StackTrace != null)
                        stackTraceDisplay = eDisplay.StackTrace.ToString();

                    Trace.WriteLine("Exception Stacktrace (1011): " + stackTraceDisplay, "INFO");
                }
            }
        }

        private void UserControl_SizeChanged_1(object sender, SizeChangedEventArgs e)
        {
            try
            {
                this.DataContext = mainWindowViewModel;

                if (HeatMapViewModel.isInitialized == true)
                {
                    ((HeatMapViewModel)mainWindowViewModel.BaseWindowSettings[1]).DrawHeatMap();
                }
            }
            catch (Exception ex)
            {
                string errMessage = "A problem is occurred in CDS Heatmap application while resizing window (1020)!!!";
                try
                {
                    Trace.WriteLine(string.Format("A problem is occurred in CDS Heatmap application while resizing window!!!: {0}", ex.Message.ToString()), "ERROR");

                    string stackTrace = "";
                    if (ex.StackTrace != null)
                        stackTrace = ex.StackTrace.ToString();

                    Trace.WriteLine("Exception Stacktrace (1020): " + stackTrace, "INFO");

                    var popup = new DisplayExceptionView(errMessage + "\n" + ex.Message.ToString(), stackTrace);
                    PopupWindow.Instance.Title = "API Error";
                    PopupWindow.Instance.ShowWindow(popup);
                    PopupWindow.Instance.Width = 500;//Aysegul Albayrak,popup size
                    PopupWindow.Instance.Height = 600;
                }
                catch (Exception eDisplay)
                {
                    Trace.WriteLine("Exception while displaying Bloomberg API Error (1021): " + errMessage + "\n" + eDisplay.Message, "ERROR");

                    string stackTraceDisplay = "";
                    if (eDisplay.StackTrace != null)
                        stackTraceDisplay = eDisplay.StackTrace.ToString();

                    Trace.WriteLine("Exception Stacktrace (1021): " + stackTraceDisplay, "INFO");
                }
            }
        }

        static void OnDispatcherShutdownStarted(object sender, EventArgs e)
        {
            try
            {
                Trace.Write("OnDispatcherShutdownStarted!" , "INFO");
                Trace.WriteLine("CDSHeatMap application is closed. CDSHeatMap Version 1.0.1.3", "INFO");

                HeatMapView.Dispose();
                TickerFilterView.Dispose();
            }
            catch (Exception exception)
            {
                Trace.Write("Exception while closing the program (1031) !!!"
                + "\nEXCEPTION: " + exception.Message.ToString()
                + "\nINNER EXCEPTION: " + exception.InnerException.Message.ToString(), "ERROR");

                string stackTrace = "";
                if (exception.StackTrace != null)
                    stackTrace = exception.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace (1031): " + stackTrace, "INFO");
            }

        }

        private void OnUnhandledException(object sender, DispatcherUnhandledExceptionEventArgs e)
        {
            Trace.Write("OnUnhandledException! CDSHeatMap Version 1.0.1.3", "INFO");

            String exceptionMessage = "";
            String innerExceptionMessage = "";

            if (e.Exception != null && e.Exception.Message != null)
                exceptionMessage = e.Exception.Message.ToString();

            if (e.Exception != null && e.Exception.InnerException != null && e.Exception.InnerException.Message != null)
                innerExceptionMessage = e.Exception.InnerException.Message.ToString();


            Trace.Write("CDSHeatMap is closed due to the unhandled expception (1040) !!!"
                + "\nEXCEPTION: " + exceptionMessage
                + "\nINNER EXCEPTION: " + innerExceptionMessage, "INFO");

            if (e.Exception.GetType() == typeof(BlpApiDataException))
            {
                Trace.Write(e.Exception, "ERROR");

                ModalDialog.Instance.Title = "API Error";
                ModalDialog.Instance.Width = 500;
                ModalDialog.Instance.Height = 400;

                string errMessage = "CDSHeatmap could not be started...";

                ModalDialog.Instance.ShowDialog(new ErrorMessageDialog(errMessage + "\n\n" + e.Exception.ToString(), ErrorMsgLevel.BLPContact));
            }

            Trace.Write("CDSHeatMap is closed due to the unhandled expception (1040) !!!"
                + "\nEXCEPTION: " + e.Exception.Message.ToString()
                + "\nINNER EXCEPTION: " + e.Exception.InnerException.Message.ToString(), "INFO");

            
            if (mainThreadDispatcher != null)
            {
                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    string errMessage = "A problem is occurred in CDS Heatmap application  (1040)!!!";
                    try
                    {
                        Trace.WriteLine(string.Format("A problem is occurred in CDS Heatmap application - OnUnhandledException (1040)!!!: {0}", e.Exception.Message.ToString()), "ERROR");

                        string stackTrace = "";
                        if (e.Exception != null && e.Exception.StackTrace != null)
                            stackTrace = e.Exception.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace: " + stackTrace, "INFO");

                        var popup = new DisplayExceptionView(errMessage + "\n" + e.Exception.Message.ToString(), stackTrace);
                        PopupWindow.Instance.Title = "API Error";
                        PopupWindow.Instance.ShowWindow(popup);
                        PopupWindow.Instance.Width = 500;//Aysegul Albayrak,popup size
                        PopupWindow.Instance.Height = 600;
                    }
                    catch (Exception eDisplay)
                    {
                        Trace.WriteLine("Exception while displaying Bloomberg API Error (1041): " + errMessage + "\n" + eDisplay.Message, "ERROR");

                        string stackTraceDisplay = "";
                        if (eDisplay.StackTrace != null)
                            stackTraceDisplay = eDisplay.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace (1041): " + stackTraceDisplay, "INFO");
                    }

                    Dispatcher.BeginInvokeShutdown(DispatcherPriority.Normal);
                });
            }

            e.Handled = true;

            HeatMapView.Dispose();
            TickerFilterView.Dispose();

        }

        private void OnAppClosing(object sender, Bloomberglp.AppPortalApi.ClosingEventArgs e)
        {
            try
            {
                if (!BlpEnvironment.IsEmbedded)
                {
                    var dialog = new ClosingDialog();
                    //ModalDialog.Instance.Style = LoadStyle("ChromeDialogStyle");
                    ModalDialog.Instance.Title = "CDSHeatMap";
                    var result = ModalDialog.Instance.ShowDialog(dialog);
                    if (!result.HasValue || !result.Value)
                        e.Cancel = true;
                    else
                    {
                        Trace.WriteLine("CDSHeatMap application is closed!", "INFO");

                        if (!BlpEnvironment.IsEmbedded)
                        {
                            var size = AppPortalChrome.GetWindowSize(this);
                            var location = AppPortalChrome.GetWindowPosition(this);
                            PersistenceService.DefaultContext.SaveData("WINDOW_WIDTH", (int)size.Width);
                            PersistenceService.DefaultContext.SaveData("WINDOW_HEIGHT", (int)size.Height);
                            PersistenceService.DefaultContext.SaveData("WINDOW_LOCATION_X", (int)location.X);
                            PersistenceService.DefaultContext.SaveData("WINDOW_LOCATION_Y", (int)location.Y);
                        }
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while OnAppClosing: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception while OnAppClosing: " + stackTrace, "INFO");
            }
        }

        void setTaskbarIcon()
        {
            Uri uri = new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/CDS_HeatMap_app_logo.png", UriKind.RelativeOrAbsolute);
            AppPortalChrome.SetIcon(this, BitmapFrame.Create(uri));
        }

    }
}
