﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CDSHeatMap.Model
{
    public class BloombergData<T>
    {
        private bool isNull;
        private T data;
        private DateTime lastUpdateTime;

        public BloombergData()
        {
            isNull = true;
            lastUpdateTime = DateTime.Now;
        }

        public BloombergData(T val)
        {
            data = val;
            isNull = false;
            lastUpdateTime = DateTime.Now;
        }

        public void updateData(T val)
        {
            data = val;
            isNull = false;
            lastUpdateTime = DateTime.Now;
        }

        public void updateData()
        {
            isNull = true;
            lastUpdateTime = DateTime.Now;
        }

        public bool isDataNull()
        {
            return isNull;
        }

        public T getData()
        {
            return data;
        }

        public DateTime getLastUpdateTime()
        {
            return lastUpdateTime;
        }
    }
}
