﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using CDSHeatMap.Interface;

namespace CDSHeatMap.Model
{
    public class CDSIndex : INotifyPropertyChanged, ITicker
    {
        private string _CDSIndexName;
        private List<CDSIndexMember> _CDSIndexMemberList;

        private CDSIndexType _CDSIndexType;

        private int _CDSmaturity;

        //private double _bidPrice;
        //private double _midPrice;
        //private double _askPrice;

        public string CDSIndexName
        {
            get { return _CDSIndexName; }
            set
            {
                _CDSIndexName = value;
                OnPropertyChanged("CDSIndexName");
            }
        }

        public List<CDSIndexMember> CDSIndexMemberList
        {
            get { return _CDSIndexMemberList; }
            set
            {
                _CDSIndexMemberList = value;
                OnPropertyChanged("CDSIndexMemberList");
            }
        }

        public int CDSmaturity
        {
            get { return _CDSmaturity; }
            set
            {
                _CDSmaturity = value;
                OnPropertyChanged("CDSmaturity");
            }
        }

        public CDSIndexType IndexType
        {
            get { return _CDSIndexType; }
            set
            {
                _CDSIndexType = value;
                OnPropertyChanged("IndexType");
            }
        }

        public string Ticker
        {
            get { return CDSIndexName; }
        }

        public void addCDSIndexMember(string _member, string _ticker)
        {
            CDSIndexMemberList.Add(new CDSIndexMember(_member, _ticker));
        }

        public void addCDSIndexMember(string _member)
        {
            CDSIndexMemberList.Add(new CDSIndexMember(_member));
        }

        public void reset()
        {
            CDSIndexMemberList.Clear();
            IndexType = CDSIndexType.UNKNOWN;
        }

        public CDSIndex(string name, CDSIndexType type)
        {
            CDSIndexName = name;
            IndexType = type;
            CDSIndexMemberList = new List<CDSIndexMember>();
        }

        public CDSIndex(string name)
        {
            CDSIndexName = name;
            IndexType = CDSIndexType.UNKNOWN;

            CDSIndexMemberList = new List<CDSIndexMember>();
        }

        public CDSIndex()
        {
            CDSIndexMemberList = new List<CDSIndexMember>();
        }

        public void setCDSIndexName(CDSIndexBase cdsbase)
        {
            CDSIndexName = cdsbase.CDSIndexName;
            IndexType = cdsbase.IndexType;
        }

        public void setCDSIndexName(string name, CDSIndexType type)
        {
            CDSIndexName = name;
            IndexType = type;
        }

        public List<string> getAllEquityTicker()
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in _CDSIndexMemberList)
            {
                if (member.getTickerEquity() != "")
                {
                    tickerList.Add(member.getTickerEquity());
                }
            }

            return tickerList;
        }

        public List<string> getAllSpreadTicker()
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in _CDSIndexMemberList)
            {
                if (member.getTickerSpread() != "")
                {
                    tickerList.Add(member.getTickerSpread());
                }
            }

            return tickerList;
        }

        public Dictionary<string, double?> getAllEquityTickerLastPrice()
        {
            Dictionary<string, double?> tickerLastPriceList = new Dictionary<string, double?>();

            foreach (CDSIndexMember member in _CDSIndexMemberList)
            {
                string ticker = member.getTickerEquity();
                if (ticker != "")
                {
                    if (!tickerLastPriceList.ContainsKey(ticker))
                        tickerLastPriceList.Add(ticker, member.LastPrice);
                }
            }

            return tickerLastPriceList;
        }

        public List<string> get5YSpreadTicker()
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in _CDSIndexMemberList)
            {
                if (member.getTickerSpread() != "")
                {
                    tickerList.Add(member.getTickerSpread());
                }
            }

            return tickerList;
        }

        public List<string> getAllSpreadTickerPricingSource(string source)
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in _CDSIndexMemberList)
            {
                for (int i = 0; i < member.TickerSpreadList.Count; ++i)
                    if (member.getTickerSpread(i, source) != "")
                    {
                        tickerList.Add(member.getTickerSpread(i, source));
                    }
            }

            return tickerList;
        }

        public List<string> getSpreadTickerPricingSource(int i, string source)
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in _CDSIndexMemberList)
            {
                if (i < member.TickerSpreadList.Count)
                {
                    if (member.getTickerSpread(i, source) != "")
                    {
                        tickerList.Add(member.getTickerSpread(i, source));
                    }
                }
            }
            return tickerList;
        }

        public Dictionary<string, double?> getSpreadTickerLastPrice(int i, string source)
        {
            Dictionary<string, double?> tickerLastPriceList = new Dictionary<string, double?>();

            foreach (CDSIndexMember member in _CDSIndexMemberList)
            {
                if (i < member.TickerSpreadList.Count)
                {
                    string ticker = member.getTickerSpread(i, source);
                    if (ticker != "")
                    {
                        if (!tickerLastPriceList.ContainsKey(ticker))
                            tickerLastPriceList.Add(ticker, member.getMidSpread(i));
                    }
                }
            }
            return tickerLastPriceList;
        }

        public List<string> getAllTickerPricingSource(string source)
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in _CDSIndexMemberList)
            {
                if (member.getTickerSpread() != "")
                {
                    tickerList.Add(member.getTickerSpread());
                }

                for (int i = 0; i < member.TickerSpreadList.Count; ++i)
                    if (member.getTickerSpread(i, source) != "")
                    {
                        tickerList.Add(member.getTickerSpread(i, source));
                    }
            }

            return tickerList;
        }

        public List<string> getAllTickerPricingSource(int i, string source)
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in _CDSIndexMemberList)
            {
                if (member.getTickerSpread() != "")
                {
                    tickerList.Add(member.getTickerSpread());
                }

                if (i < member.TickerSpreadList.Count)
                {
                    if (member.getTickerSpread(i, source) != "")
                    {
                        tickerList.Add(member.getTickerSpread(i, source));
                    }
                }
            }

            return tickerList;
        }


        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }

    public enum CDSIndexType
    {
        EQUITY,
        SPREAD,
        TICKERFILTER,
        UNKNOWN
    }

    public class CDSIndexBase : ITicker, INotifyPropertyChanged
    {
        private string _CDSIndexName;
        private string _CDSIndexLongName;
        private CDSIndexType _CDSIndexType;
        private int _rollingSerie;

        public string region;

        public string CDSIndexName
        {
            get { return _CDSIndexName; }
            set
            {
                _CDSIndexName = value;
                OnPropertyChanged("CDSIndexName");
            }
        }

        public string CDSIndexLongName
        {
            get { return _CDSIndexLongName; }
            set
            {
                _CDSIndexLongName = value;
                OnPropertyChanged("CDSIndexLongName");
            }
        }

        public CDSIndexType IndexType
        {
            get { return _CDSIndexType; }
            set
            {
                _CDSIndexType = value;
                OnPropertyChanged("IndexType");
            }
        }

        public int RollingSerie
        {
            get { return _rollingSerie; }
            set
            {
                _rollingSerie = value;
                OnPropertyChanged("RollingSerie");
            }
        }

        public string Ticker
        {
            get { return CDSIndexName; }
        }

        public CDSIndexBase(string name, CDSIndexType type)
        {
            CDSIndexLongName = CDSIndexName = name;
            IndexType = type;
        }

        public CDSIndexBase(string name, string longname, CDSIndexType type)
        {
            CDSIndexName = name;
            CDSIndexLongName = longname;
            IndexType = type;
        }

        public CDSIndexBase(string name)
        {
            CDSIndexLongName = CDSIndexName = name;
            IndexType = CDSIndexType.UNKNOWN;
        }

        public CDSIndexBase()
        {
            // TODO: Complete member initialization
            IndexType = CDSIndexType.UNKNOWN;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }

    public class InsQuery : ITicker
    {
        public InsQuery(string name)
        {
            this.Ticker = name;
        }
        public string Ticker
        {
            get;
            set;
        }
    }
}
