﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using CDSHeatMap.Util;
using CDSHeatMap.Interface;

namespace CDSHeatMap.Model
{
    public class CDSIndexMember : ITicker, INotifyPropertyChanged
    {
        private string _CDSRefName;
        private IndexMember _CDSMember;

        private string _TickerEquity;
        private string _TickerSpread;
        private List<string> _TickerSpreadList;

        private string _TickerRequest;

        private string _IndustryName;
        private string _MoodysRating;
        private string _SPRating;
        private string _FitchRating;

        private string _PricingSource;
        private string _currency;
        private string _currencyCDS;

        private List<double?> _MidSpread;
        private List<double?> _SpreadChgPCT1D;
        private List<double?> _SpreadChgPCTYTD;

        private double? _lastPrice;
        private double? _CDSPrice;

        private double? _marketCapital;
        private double? _totalDebtToCapital;
        private double? _debtToCommonEquity;
        private double? _interestCoverageRatio;

        private double? _ChgPCT1D;
        private double? _ChgPCTYTD;
        private double? _ChgPCT52W;

        private double? _ChgNET1D;
        private double? _ChgNETYTD;
        private double? _ChgNET52W;

        private double? _CDS5YChgNET1D;
        private double? _CDS5YChgNETYTD;

        private double? _volumeChg5d20d;
        private double? _salesGrowth;
        private double? _eqBeta;
        private double? _histCallImplVol;
        private double? _volMean;
        private double? _shortInterest;
        private double? _priceToSalesRatio;

        private double? _totalDebt;
        private double? _totalAssets;
        private DateTime? _expectedReportDT;

        private double? _ebitda;
        private double? _eqDividendYield;
        private double? _enterpriseValue;
        private double? _debtOS;
        private double? _peRatio;

        private double? _fxRateEquity;

        public double? FXRateEquity
        {
            get {
                if (_fxRateEquity == null || _fxRateEquity == 0)
                    return 1;
                else
                    return _fxRateEquity;
            }
            set {
                _fxRateEquity = value;
            }
        }

        private double? _fxRateCDS;

        public double? FXRateCDS
        {
            get
            {
                if (_fxRateCDS == null || _fxRateCDS == 0)
                    return FXRateEquity;
                else
                    return _fxRateCDS;
            }
            set
            {
                _fxRateCDS = value;
            }
        }

        private bool _isChecked;

        public string Ticker
        {
            get { return _TickerRequest; }
            set
            {
                _TickerRequest = value;
                //OnPropertyChanged("Ticker");
            }
        }

        public string CDSRefName
        {
            get { return _CDSRefName; }
            set
            {
                _CDSRefName = value;
                //OnPropertyChanged("CDSRefName");
            }
        }

        public IndexMember CDSMember
        {
            get { return _CDSMember; }
            set
            {
                _CDSMember = value;
                //OnPropertyChanged("CDSMember");
            }
        }

        public string TickerEquity
        {
            get { return _TickerEquity; }
            set
            {
                _TickerEquity = value;
                //OnPropertyChanged("TickerEquity");
            }
        }

        public string TickerSpread
        {
            get 
            {
                if (_TickerSpread == null || _TickerSpread == "")
                {
                    if (TickerSpreadList != null && TickerSpreadList.Count > 4)
                        _TickerSpread = TickerSpreadList[4];
                }

                return _TickerSpread; 
            }
            set
            {
                _TickerSpread = value;
                //OnPropertyChanged("TickerSpread");
            }
        }

        public List<string> TickerSpreadList
        {
            get { return _TickerSpreadList; }
            set
            {
                _TickerSpreadList = value;
                //OnPropertyChanged("TickerSpreadList");
            }
        }

        public string IndustryName
        {
            get { return _IndustryName; }
            set
            {
                _IndustryName = value;
                //OnPropertyChanged("IndustryName");
            }

        }
        public string MoodysRating
        {
            get { return _MoodysRating; }
            set
            {
                _MoodysRating = value;
                //OnPropertyChanged("MoodysRating");
            }

        }
        public string SPRating
        {
            get { return _SPRating; }
            set
            {
                _SPRating = value;
                //OnPropertyChanged("SPRating");
            }

        }
        public string FitchRating
        {
            get { return _FitchRating; }
            set
            {
                _FitchRating = value;
                //OnPropertyChanged("FitchRating");
            }

        }

        public string PricingSource
        {
            get { return _PricingSource; }
            set
            {
                if (value == "USER")
                    _PricingSource = "";
                else
                    _PricingSource = value;
                //OnPropertyChanged("PricingSource");
            }
        }

        public string Currency
        {
            get {
                if (_currency == null)
                    return "";
                else
                    return _currency.ToUpper(); 
            }
            set
            {
                if (value != null || value != "")
                    _currency = value;
                else
                    _currency = value.ToUpper();

                //OnPropertyChanged("Currency");
            }
        }

        public string CurrencyCDS
        {
            get {
                if (_currencyCDS == null)
                    return "";
                else
                    return _currencyCDS.ToUpper();
            }
            set
            {
                if (value != null || value != "")
                    _currencyCDS = value;
                else
                    _currencyCDS = value.ToUpper();
            }
        }

        public List<double?> MidSpread
        {
            get { return _MidSpread; }
            set
            {
                _MidSpread = value;
                //OnPropertyChanged("MidSpread");
            }
        }

        public List<double?> SpreadChgPCT1D
        {
            get { return _SpreadChgPCT1D; }
            set
            {
                _SpreadChgPCT1D = value;
                //OnPropertyChanged("SpreadChgPCT1D");
            }
        }

        public List<double?> SpreadChgPCTYTD
        {
            get { return _SpreadChgPCTYTD; }
            set
            {
                _SpreadChgPCTYTD = value;
                //OnPropertyChanged("SpreadChgPCTYTD");
            }
        }

        public double? LastPrice
        {
            get { return _lastPrice; }
            set
            {
                _lastPrice = value;
                //OnPropertyChanged("LastPrice");
            }
        }

        public double? MarketCapital
        {
            get { return _marketCapital; }
            set
            {
                _marketCapital = value;
                //OnPropertyChanged("MarketCapital");
            }
        }
        public double? TotalDebtToCapital
        {
            get { return _totalDebtToCapital; }
            set
            {
                _totalDebtToCapital = value;
                //OnPropertyChanged("TotalDebtToCapital");
            }
        }
        public double? DebtToCommonEquity
        {
            get { return _debtToCommonEquity; }
            set
            {
                _debtToCommonEquity = value;
                //OnPropertyChanged("DebtToCommonEquity");
            }
        }
        public double? InterestCoverageRatio
        {
            get { return _interestCoverageRatio; }
            set
            {
                _interestCoverageRatio = value;
                //OnPropertyChanged("InterestCoverageRatio");
            }
        }

        public double? ChgPCT1D
        {
            get { return _ChgPCT1D; }
            set
            {
                _ChgPCT1D = value;
                //OnPropertyChanged("ChgPCT1D");
            }
        }
        public double? ChgPCTYTD
        {
            get { return _ChgPCTYTD; }
            set
            {
                _ChgPCTYTD = value;
                //OnPropertyChanged("ChgPCTYTD");
            }
        }
        public double? ChgPCT52W
        {
            get { return _ChgPCT52W; }
            set
            {
                _ChgPCT52W = value;
                //OnPropertyChanged("ChgPCT52W");
            }
        }
        public double? ChgNET52W
        {
            get { return _ChgNET52W; }
            set
            {
                _ChgNET52W = value;
                //OnPropertyChanged("ChgNET52W");
            }
        }
        public double? ChgNET1D
        {
            get { return _ChgNET1D; }
            set
            {
                _ChgNET1D = value;
                //OnPropertyChanged("ChgNET1D");
            }
        }
        public double? ChgNETYTD
        {
            get { return _ChgNETYTD; }
            set
            {
                _ChgNETYTD = value;
                //OnPropertyChanged("ChgNETYTD");
            }
        }

        public double? CDS5YChgNET1D
        {
            get { return _CDS5YChgNET1D; }
            set
            {
                _CDS5YChgNET1D = value;
                //OnPropertyChanged("CDS5YChgNET1D");
            }
        }
        public double? CDS5YChgNETYTD
        {
            get { return _CDS5YChgNETYTD; }
            set
            {
                _CDS5YChgNETYTD = value;
                //OnPropertyChanged("CDS5YChgNETYTD");
            }
        }

        public double? VolumeChg5d20d
        {
            get { return _volumeChg5d20d; }
            set
            {
                _volumeChg5d20d = value;
                //OnPropertyChanged("VolumeChg5d20d");
            }
        }

        public double? SalesGrowth
        {
            get { return _salesGrowth; }
            set
            {
                _salesGrowth = value;
                //OnPropertyChanged("SalesGrowth");
            }
        }

        public DateTime? ExpectedReportDT
        {
            get { return _expectedReportDT; }
            set
            {
                _expectedReportDT = value;
                //OnPropertyChanged("ExpectedReportDT");
            }
        }

        public double? TotalDebt
        {
            get { return _totalDebt; }
            set
            {
                _totalDebt = value;
                //OnPropertyChanged("TotalDebt");
            }
        }

        public double? TotalAssets
        {
            get { return _totalAssets; }
            set
            {
                _totalAssets = value;
                //OnPropertyChanged("TotalAssets");
            }
        }

        public double? EBITDA
        {
            get { return _ebitda; }
            set
            {
                _ebitda = value;
                //OnPropertyChanged("EBITDA");
            }
        }

        public double? EQBeta
        {
            get { return _eqBeta; }
            set
            {
                _eqBeta = value;
                //OnPropertyChanged("EQBeta");
            }
        }

        public double? HistCallImplVol
        {
            get { return _histCallImplVol; }
            set
            {
                _histCallImplVol = value;
                //OnPropertyChanged("HistCallImplVol");
            }
        }

        public double? VolMean
        {
            get { return _volMean; }
            set
            {
                _volMean = value;
                //OnPropertyChanged("VolMean");
            }
        }

        public double? ShortInterest
        {
            get { return _shortInterest; }
            set
            {
                _shortInterest = value;
                //OnPropertyChanged("ShortInterest");
            }
        }

        public double? PriceToSalesRatio
        {
            get { return _priceToSalesRatio; }
            set
            {
                _priceToSalesRatio = value;
                //OnPropertyChanged("PriceToSalesRatio");
            }
        }

        public double? EqDividendeYield
        {
            get { return _eqDividendYield; }
            set
            {
                _eqDividendYield = value;
                //OnPropertyChanged("EqDividendeYield");
            }
        }

        public double? EnterpriseValue
        {
            get { return _enterpriseValue; }
            set
            {
                _enterpriseValue = value;
                //OnPropertyChanged("EnterpriseValue");
            }
        }

        public double? DebtOS
        {
            get { return _debtOS; }
            set
            {
                _debtOS = value;
                //OnPropertyChanged("DebtOS");
            }
        }

        public double? PeRatio
        {
            get { return _peRatio; }
            set
            {
                _peRatio = value;
                //OnPropertyChanged("PeRatio");
            }
        }

        public bool IsCheckedTicker
        {
            get { return _isChecked; }
            set
            {
                _isChecked = value;
                //OnPropertyChanged("IsCheckedTicker");
            }
        }

        public double? CDSPrice
        {
            get { return _CDSPrice; }
            set
            {
                _CDSPrice = value;
                //OnPropertyChanged("CDSPrice");
            }
        }
        
        public void createTickerSpread(string spreadMaturity)
        {
            TickerSpreadList.Add(spreadMaturity);
        }

        public void TickerSpreadRate(double? rate)
        {
            MidSpread.Add(rate);

            // TODO:
            if (MidSpread.Count == 5)
                CDSPrice = getMidSpread(4);
        }

        public double? getMidSpread(int index)
        {
            if (MidSpread != null && MidSpread.Count > index)
                return MidSpread[index];
            else
                return null;
        }

        public void setMidSpread(int index, double? value)
        {
            if (MidSpread != null && MidSpread.Count > index)
            {
                MidSpread[index] = value;

                if(index == 4)
                    CDSPrice = getMidSpread(4);
            }
        }

        public void addChgPCT1D(double? chg1d)
        {
            SpreadChgPCT1D.Add(chg1d);
        }

        public double? getSpreadChgPCT1D(int index)
        {
            if (SpreadChgPCT1D != null && SpreadChgPCT1D.Count > index)
                return SpreadChgPCT1D[index];
            else
                return null;
        }

        public void setSpreadChgPCT1D(int index, double? value)
        {
            if (SpreadChgPCT1D != null && SpreadChgPCT1D.Count > index)
                SpreadChgPCT1D[index] = value;
        }

        public void addChgPCTYTD(double? chgytd)
        {
            SpreadChgPCTYTD.Add(chgytd);
        }

        public double? getSpreadChgPCTYTD(int index)
        {
            if (SpreadChgPCTYTD != null && SpreadChgPCTYTD.Count > index)
                return SpreadChgPCTYTD[index];
            else
                return null;
        }

        public void setSpreadChgPCTYTD(int index, double? value)
        {
            if (SpreadChgPCTYTD != null && SpreadChgPCTYTD.Count > index)
                SpreadChgPCTYTD[index] = value;
        }

        public void resetSpreadRateLists()
        {
            MidSpread.Clear();
            SpreadChgPCT1D.Clear();
            SpreadChgPCTYTD.Clear();

        }

        public CDSIndexMember(string _member, string _ticker)
        {
            //CDSMember = new IndexMember(_member, _ticker);
            CDSRefName = _member;
            TickerSpread = _ticker;
            IsCheckedTicker = true;

            TickerSpreadList = new List<string>(ConstantItemList.CDSSPREAD_NUMBER);
            MidSpread = new List<double?>(ConstantItemList.CDSSPREAD_NUMBER);
            SpreadChgPCT1D = new List<double?>(ConstantItemList.CDSSPREAD_NUMBER);
            SpreadChgPCTYTD = new List<double?>(ConstantItemList.CDSSPREAD_NUMBER);
        }

        public CDSIndexMember(SecurityDescription security)
        {
            //CDSMember = new IndexMember(_member, _ticker);
            CDSRefName = security.Description;
            TickerEquity = security.Security;
            IsCheckedTicker = true;

            TickerSpreadList = new List<string>(ConstantItemList.CDSSPREAD_NUMBER);
            MidSpread = new List<double?>(ConstantItemList.CDSSPREAD_NUMBER);
            SpreadChgPCT1D = new List<double?>(ConstantItemList.CDSSPREAD_NUMBER);
            SpreadChgPCTYTD = new List<double?>(ConstantItemList.CDSSPREAD_NUMBER);
        }

        public CDSIndexMember(string _member)
        {
            TickerEquity = CDSRefName = _member;
            IsCheckedTicker = true;

            TickerSpreadList = new List<string>(ConstantItemList.CDSSPREAD_NUMBER);
            MidSpread = new List<double?>(ConstantItemList.CDSSPREAD_NUMBER);
            SpreadChgPCT1D = new List<double?>(ConstantItemList.CDSSPREAD_NUMBER);
            SpreadChgPCTYTD = new List<double?>(ConstantItemList.CDSSPREAD_NUMBER);
        }

        public string getTicker(CDSIndexType type)
        {
            if (type == CDSIndexType.EQUITY)
                return getTickerEquity();
            else if (type == CDSIndexType.SPREAD)
                return getTickerSpread();
            else
                return Ticker;
        }

        public string getTickerEquity()
        {
            if (TickerEquity == "") return TickerEquity;
            else
                return TickerEquity + " Equity";
        }

        public string getTickerSpread()
        {
            if (TickerSpread == "") return TickerSpread;
            else
                return TickerSpread + " Corp";
        }

        public string getTickerSpread(int i)
        {
            if (TickerSpreadList == null || TickerSpreadList.Count == 0 || TickerSpreadList.Count < i)
                return "";
            if (TickerSpreadList[i] == "") return TickerSpreadList[i];
            return TickerSpreadList[i] + " Corp";
        }

        public string getTickerSpread(int i, string source)
        {
            if (TickerSpreadList == null || TickerSpreadList.Count == 0 || TickerSpreadList.Count < i)
                return "";
            if (TickerSpreadList[i] == "") return TickerSpreadList[i];

            if (getPricingSource(source) == "")
                return TickerSpreadList[i] + " Corp";
            else
                return TickerSpreadList[i] + " " + getPricingSource(source) + " Corp";
        }

        private string getPricingSource(string source)
        {
            string defaultsource = getDefaultPricingSource();

            if (PricingSource == null || PricingSource == "")
            {
                if (source == null || source == "Default" || source == "")
                {
                    return defaultsource;
                }
                else
                    return source;
            }
            else if (source == "Default")
                return "";
            else
                return source;
        }

        private string getDefaultPricingSource()
        {
            if (Currency == "USD")
                return "CBGN";
            else if (Currency == "EUR" || Currency == "GBP" || Currency == "GBp")
                return "CBGL";
            else if (Currency == "JPY" || Currency == "AUD")
                return "CBGT";
            else
                return "CBGN";
        }

        public double? getCDSCurve(string curveName)
        {
            if (curveName == "1Y/5Y")
            {
                return getCDSCurveRate(0, 4);
            }
            else if (curveName == "2Y/5Y")
            {
                return getCDSCurveRate(1, 4);
            }
            else if (curveName == "3Y/5Y")
            {
                return getCDSCurveRate(2, 4);
            }
            else if (curveName == "5Y/7Y")
            {
                return getCDSCurveRate(4, 5);
            }
            else if (curveName == "5Y/10Y")
            {
                return getCDSCurveRate(5, 6);
            }
            else
                return null;
        }

        public double? getCDSCurveRate(int curve1, int curve2)
        {
            if (MidSpread == null)
                return null;

            if (MidSpread.Count != 7)
                return null;

            double? rate1 = getMidSpread(curve1);
            double? rate2 = getMidSpread(curve2);

            if (rate1.HasValue && rate2.HasValue && rate2 != 0.0)
            {
                return (rate1 / rate2);
            }
            else
                return null;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion

    }

    public class IndexMember : INotifyPropertyChanged
    {
        private string _MemberTickerandExchangeCode;
        private double _column1;
        private string _column2;
        private string _column3;
        private string _column4;

        public string MemberTickerandExchangeCode
        {
            get { return _MemberTickerandExchangeCode; }
            set
            {
                _MemberTickerandExchangeCode = value;
                //OnPropertyChanged("MemberTickerandExchangeCode");
            }
        }
        public double Column1
        {
            get { return _column1; }
            set
            {
                _column1 = value;
                //OnPropertyChanged("Column1");
            }
        }
        public string Column2
        {
            get { return _column2; }
            set
            {
                _column2 = value;
                //OnPropertyChanged("Column2");
            }
        }
        public string Column3
        {
            get { return _column3; }
            set
            {
                _column3 = value;
                //OnPropertyChanged("Column3");
            }
        }
        public string Column4
        {
            get { return _column4; }
            set
            {
                _column4 = value;
                //OnPropertyChanged("Column4");
            }
        }

        public IndexMember(string _member, string _ticker)
        {
            _MemberTickerandExchangeCode = _member;
            _column4 = _ticker;
        }

        public IndexMember(string _member)
        {
            _MemberTickerandExchangeCode = _member;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion

    }

    public class SecurityDescription : INotifyPropertyChanged
    {
        private string _security;
        private string _description;

        public string Security
        {
            get { return _security; }
            set
            {
                _security = value;
                //OnPropertyChanged("Security");
            }
        }

        public string Description
        {
            get { return _description; }
            set
            {
                _description = value;
                //OnPropertyChanged("Description");
            }
        }

        public SecurityDescription(string sec, string desc)
        {
            Security = sec;
            Description = desc;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion

    }
}
