﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics;
using System.Windows.Input;
using System.Windows.Media;
using CDSHeatMap.Interface;
using CDSHeatMap.Util;

namespace CDSHeatMap.Model
{
    public class DataChild : INotifyPropertyChanged, ITicker
    {
        private int _ID;
        private string _childName;
        private double _rectangleSize;
        private double? _actualRectangleSize;
        private double? _rectangleColor;
        private double? _circleColor;
        private SolidColorBrush _circleFillingColor;
        private SolidColorBrush _rectangleFillingColor;
        private double? _donutChartColor;

        //ToolTip
        private double? _equityPrice;
        private double? _cds5YSpread;

        private double? _eqChgPCT;
        private double? _eqChgNET;
        private double? _cds5YChgPCT;
        private double? _cds5YChgNET;

        private BooleanNotify _rectColorGuidanceEnabled;

        public BooleanNotify RectColorGuidanceEnabled
        {
            get { return _rectColorGuidanceEnabled; }
            set
            {
                _rectColorGuidanceEnabled = value;
                OnPropertyChanged("RectColorGuidanceEnabled");
            }
        }

        private BooleanNotify _circleColorGuidanceEnabled;

        public BooleanNotify CircleColorGuidanceEnabled
        {
            get { return _circleColorGuidanceEnabled; }
            set
            {
                _circleColorGuidanceEnabled = value;
                OnPropertyChanged("CircleColorGuidanceEnabled");
            }
        }

        private BooleanNotify _rightClickGuidanceEnabled;

        public BooleanNotify RightClickGuidanceEnabled
        {
            get { return _rightClickGuidanceEnabled; }
            set
            {
                _rightClickGuidanceEnabled = value;
                OnPropertyChanged("RightClickGuidanceEnabled");
            }
        }

        private BooleanNotify _tooltipGuidanceEnabled;

        public BooleanNotify TooltipGuidanceEnabled
        {
            get { return _tooltipGuidanceEnabled; }
            set
            {
                _tooltipGuidanceEnabled = value;
                OnPropertyChanged("TooltipGuidanceEnabled");
            }
        }

        private BooleanNotify _volatilityGuidanceEnabled;

        public BooleanNotify VolatilityGuidanceEnabled
        {
            get { return _volatilityGuidanceEnabled; }
            set
            {
                _volatilityGuidanceEnabled = value;
                OnPropertyChanged("VolatilityGuidanceEnabled");
            }
        }

        public double? EqChgPCT
        {
            get { return _eqChgPCT;  }
            set { _eqChgPCT = value; }
        }
        public double? EqChgNET
        {
            get { return _eqChgNET; }
            set { _eqChgNET = value; }
        }

        public double? CDS5YChgPCT
        {
            get { return _cds5YChgPCT; }
            set { _cds5YChgPCT = value; }
        }
        public double? CDS5YChgNET
        {
            get { return _cds5YChgNET; }
            set { _cds5YChgNET = value; }
        }

        private ImageSource _displayImage;

        public ImageSource DisplayImage
        {
            get { return _displayImage; }
            set
            {
                _displayImage = value;
                OnPropertyChanged("DisplayImage");
            }
        }

        private string _tickerName;
        public string TickerName
        {
            get { return _tickerName; }
            set
            {
                _tickerName = value;

                if (_tickerName == "")
                    TickerNameBackground = Brushes.Transparent;
                else
                    TickerNameBackground = Brushes.White;

                OnPropertyChanged("TickerName");
            }
        }

        private SolidColorBrush _tickerNameBackground;
        public SolidColorBrush TickerNameBackground
        {
            get { return _tickerNameBackground; }
            set
            {
                _tickerNameBackground = value;
                if (_tickerNameBackground.CanFreeze)
                    _tickerNameBackground.Freeze();
                OnPropertyChanged("TickerNameBackground");
            }
        }

        public double? EquityPrice
        {
            get { return _equityPrice; }
            set
            {
                _equityPrice = value;
                //OnPropertyChanged("EquityPrice");
            }
        }
        public double? CDS5YSpread
        {
            get { return _cds5YSpread; }
            set
            {
                _cds5YSpread = value;
                //OnPropertyChanged("CDS5YSpread");
            }
        }

        public string PricingSource { get; set; }
        public string Currency { get; set; }

        public void setToolTipData(double? price, double? spread, string source, string ccy)
        {
            EquityPrice = price;
            CDS5YSpread = spread;
            PricingSource = source;
            Currency = ccy;
        }

        private double? _rectLastPrice;
        public double? RectLastPrice
        {
            get { return _rectLastPrice; }
            set
            {
                _rectLastPrice = value;
                //OnPropertyChanged("RectLastPrice");
            }
        }

        private double? _circleLastPrice;
        public double? CircleLastPrice
        {
            get { return _circleLastPrice; }
            set
            {
                _circleLastPrice = value;
                //OnPropertyChanged("CircleLastPrice");
            }
        }

        public Dictionary<string, double?> SelectionDataDisplay { get; set; }

        public ObservableCollection<ContextMenuItem> ContextMenuList { get; set; }

        public string Ticker { get; set; }

        private string _rectColorName;
        public string RectColorName
        {
            get { return _rectColorName; }
            set
            {
                _rectColorName = value;
                //OnPropertyChanged("RectColorName");
            }
        }

        private string _circleColorName;
        public string CircleColorName
        {
            get { return _circleColorName; }
            set
            {
                _circleColorName = value;
                //OnPropertyChanged("CircleColorName");
            }
        }

        private ICommand _leftClickRect;
        public ICommand LeftClickRect
        {
            get { return _leftClickRect; }
            set
            {
                _leftClickRect = value;
                OnPropertyChanged("LeftClickRect");
            }
        }

        public SolidColorBrush _childBorderBrush { get; set; }
        public SolidColorBrush ChildBorderBrush
        {
            get { return _childBorderBrush; }
            set
            {
                _childBorderBrush = value;
                if (_childBorderBrush.CanFreeze)
                    _childBorderBrush.Freeze();
                OnPropertyChanged("ChildBorderBrush");
            }
        }

        public int ID
        {
            get { return _ID; }
            set
            {
                _ID = value;
                OnPropertyChanged("ID");
            }
        }

        private string _childEqTicker;
        private string _childCDSTicker;

        public string ChildEqTicker
        {
            get { return _childEqTicker; }
            set
            {
                _childEqTicker = value;
            }
        }

        public string ChildCDSTicker
        {
            get { return _childCDSTicker; }
            set
            {
                _childCDSTicker = value;
            }
        }

        private List<string> _TickerSpreadList;
        public List<string> TickerSpreadList
        {
            get { return _TickerSpreadList; }
            set
            {
                _TickerSpreadList = value;
            }
        }

        public SolidColorBrush CircleFillingColor
        {
            get { return _circleFillingColor; }
            set
            {
                _circleFillingColor = value;
                if (_circleFillingColor.CanFreeze)
                    _circleFillingColor.Freeze();
                OnPropertyChanged("CircleFillingColor");
            }
        }

        public SolidColorBrush RectangleFillingColor
        {
            get { return _rectangleFillingColor; }
            set
            {
                _rectangleFillingColor = value;
                if (_rectangleFillingColor.CanFreeze)
                    _rectangleFillingColor.Freeze();
                OnPropertyChanged("RectangleFillingColor");
            }
        }



        public string MainGroupName { get; set; }
        public string SubGroupName { get; set; }

        public string ChildName
        {
            get { return _childName; }
            set
            {
                _childName = value;
                OnPropertyChanged("ChildName");
            }
        }

        public double RectangleSize
        {
            get { return _rectangleSize; }
            set
            {
                _rectangleSize = value;
                OnPropertyChanged("RectangleSize");
            }
        }

        public double? ActualRectangleSize
        {
            get { return _actualRectangleSize; }
            set
            {
                _actualRectangleSize = value;
            }
        }

        public double? RectangleColor
        {
            get { return _rectangleColor; }
            set
            {
                _rectangleColor = value;
                //OnPropertyChanged("RectangleColor");
            }
        }

        public double DonutChartColor
        {
            get { return _donutChartColor ?? 0.0; }
            set
            {

                _donutChartColor = value;
                OnPropertyChanged("DonutChartColor");
            }
        }


        public double? CircleColor
        {
            get { return _circleColor; }
            set
            {
                _circleColor = value;
                //OnPropertyChanged("CircleColor");
            }
        }

        public string getTickerEquity()
        {
            if (ChildEqTicker == "")
                return "";
            else
                return ChildEqTicker + " Equity";
        }

        public string getSpreadTicker(int i, string source = null)
        {
            return getTickerSpread(i, source);
        }

        public string getTickerSpread(int i, string source)
        {
            if (TickerSpreadList == null || TickerSpreadList.Count == 0)
                return "";
            if (TickerSpreadList[i] == "") return TickerSpreadList[i];

            if (getPricingSource(source) == "")
                return TickerSpreadList[i] + " Corp";
            else
                return TickerSpreadList[i] + " " + getPricingSource(source) + " Corp";
        }

        private string getPricingSource(string source)
        {
            string defaultsource = getDefaultPricingSource();

            if (PricingSource == null || PricingSource == "")
            {
                if (source == null || source == "Default" || source == "")
                {
                    return defaultsource;
                }
                else
                    return source;
            }
            else if (source == "Default")
                return "";
            else
                return source;
        }

        private string getDefaultPricingSource()
        {
            if (Currency == "USD")
                return "CBGN";
            else if (Currency == "EUR" || Currency == "GBP" || Currency == "GBp")
                return "CBGL";
            else if (Currency == "JPY" || Currency == "AUD")
                return "CBGT";
            else
                return "CBGN";
        }

        public void setEqCDSChgTooltip(double? eqPCT, double? eqNET, double? cdsPCT, double? cdsNET)
        {
            EqChgPCT = eqPCT;
            EqChgNET = eqNET;
            CDS5YChgPCT = cdsPCT;
            CDS5YChgNET = cdsNET;
        }

        public void Dispose()
        {
            SelectionDataDisplay.Clear();
            ContextMenuList.Clear();
        }

        public DataChild(int id, string name, string eqTicker, string cdsTicker, double? size, double? rectangleColor, double? circleColor, double? donutColor, double? rectPrice, double? circlePrice, string mainName, string subName, List<string> tickerSpreadMat, string childLabel, string sizeLabel, string rectLabel, string circLabel)
        {
            RectColorGuidanceEnabled = new BooleanNotify(false);
            CircleColorGuidanceEnabled = new BooleanNotify(false);
            VolatilityGuidanceEnabled = new BooleanNotify(false);
            TooltipGuidanceEnabled = new BooleanNotify(false);
            RightClickGuidanceEnabled = new BooleanNotify(false);

            TickerName = "";
            ID = id;
            ChildName = name;
            ChildEqTicker = eqTicker;
            ChildCDSTicker = cdsTicker;
            ActualRectangleSize = size;
            RectangleColor = rectangleColor;
            CircleColor = circleColor;
            DonutChartColor = donutColor ?? 0.0;
            TickerSpreadList = tickerSpreadMat;

            RectColorName = rectLabel;
            CircleColorName = circLabel;

            RectLastPrice = rectPrice;
            CircleLastPrice = circlePrice;

            SelectionDataDisplay = new Dictionary<string, double?>();

            MainGroupName = mainName;
            SubGroupName = subName;


            /*initialize with default value*/
            Ticker = "";
            RectangleSize = 0;
            RectangleFillingColor = Brushes.Transparent;
            CircleFillingColor = Brushes.Transparent;
            ChildBorderBrush = Brushes.Transparent;
            LeftClickRect = null;

        }

        /*
        public void getDataChildString()
        {
            Trace.WriteLine("MainGroupName:" + MainGroupName ?? "null" + " ", "TRACE");
            Trace.WriteLine("SubGroupName:" + SubGroupName ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("ID:" + ID + " ", "TRACE"); 
            Trace.WriteLine("ChildName:" + ChildName + " ", "TRACE"); 
            Trace.WriteLine("RectangleSize:" + RectangleSize + " ", "TRACE"); 
            Trace.WriteLine("ActualRectSize:" + ActualRectangleSize ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("RectangleColor:" + RectangleColor ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("CircleColor:" + CircleColor ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("CircleFillingColor:" + CircleFillingColor ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("RectangleFillingColor:" + RectangleFillingColor ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("DonutChartColor:" + DonutChartColor ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("EquityPrice:" + EquityPrice ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("CDS5YSpread:" + CDS5YSpread ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("EQChgPCT:" + EqChgPCT ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("EQChgNET:" + EqChgNET ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("CDS5YChgPCT:" + CDS5YChgPCT ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("CDS5YChgNET:" + CDS5YChgNET ?? "null" + " ", "TRACE");
            Trace.WriteLine("RectColorGuidance:" + RectColorGuidanceEnabled == null ? "null" : RectColorGuidanceEnabled.BoolNotify.ToString(), "TRACE");
            Trace.WriteLine("CircleColorGuidance:" + CircleColorGuidanceEnabled == null ? "null" : CircleColorGuidanceEnabled.BoolNotify.ToString(), "TRACE"); 
            Trace.WriteLine("RightClickGuidance:" + RightClickGuidanceEnabled == null ? "null" : RightClickGuidanceEnabled.BoolNotify.ToString(), "TRACE");
            Trace.WriteLine("TooltipGuidance:" + TooltipGuidanceEnabled == null ? "null" : TooltipGuidanceEnabled.BoolNotify.ToString(), "TRACE"); 
            Trace.WriteLine("VolatilityGuidance:" + VolatilityGuidanceEnabled == null ? "null" : VolatilityGuidanceEnabled.BoolNotify.ToString(), "TRACE"); 
            Trace.WriteLine("DisplayImage:" + DisplayImage ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("TickerName:" + TickerName ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("TickerNameBackground:" + TickerNameBackground ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("PricingSource:" + PricingSource ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("Currency:" + Currency ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("RectLastPrice:" + RectLastPrice ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("CircleLastPrice:" + CircleLastPrice ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("SelectionDataDisplay:" + SelectionDataDisplay ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("ContextMenuList:" + ContextMenuList ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("Ticker:" + Ticker ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("RectColorName:" + RectColorName ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("CircleColorName:" + CircleColorName ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("LeftClickRect:" + LeftClickRect ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("ChildBorderBrush:" + ChildBorderBrush ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("ChildEqTicker:" + ChildEqTicker ?? "null" + " ", "TRACE"); 
            Trace.WriteLine("ChildCDSTicker:" + ChildCDSTicker ?? "null" + " ", "TRACE");
            Trace.WriteLine("TickerSpreadList:" + TickerSpreadList ?? "null" + " " + "\n", "TRACE");
        }
        */

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion

    }

    public class LastUpdateDate : INotifyPropertyChanged
    {
        private string _lastUpdate;

        public string LastUpdateTime
        {
            get { return _lastUpdate; }
            set
            {
                _lastUpdate = value;
                OnPropertyChanged("LastUpdateTime");

            }
        }

        public LastUpdateDate(string val)
        {
            LastUpdateTime = val;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }
}
