﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Windows.Input;
using System.Windows.Media;

namespace CDSHeatMap.Model
{
    public class DataChildGroup : INotifyPropertyChanged
    {
        private int _ID;
        private string _childGroupName;
        private double _totalChildRectangleSize;
        private double _totalChildRectangleColor;
        private double _totalChildCircleColor;

        public Dictionary<string, double?> SelDataDisplayMin { get; set; }
        public Dictionary<string, double?> SelDataDisplayAvg { get; set; }
        public Dictionary<string, double?> SelDataDisplayMax { get; set; }
        public Dictionary<string, double>  SelDataChildCount { get; set; }

        public string ParentName { get; set; }

        public ObservableCollection<DataChild> DataChildCollection { get; set; }

        private BooleanNotify _thenByGuidanceEnabled;

        public BooleanNotify ThenByGuidanceEnabled
        {
            get { return _thenByGuidanceEnabled; }
            set
            {
                _thenByGuidanceEnabled = value;
                OnPropertyChanged("ThenByGuidanceEnabled");
            }
        }

        private ICommand _leftClickRect;
        public ICommand LeftClickRect
        {
            get { return _leftClickRect; }
            set
            {
                _leftClickRect = value;
                OnPropertyChanged("LeftClickRect");
            }
        }


        public int ID
        {
            get { return _ID; }
            set
            {
                _ID = value;
                OnPropertyChanged("ID");
            }
        }

        public string ChildGroupName
        {
            get { return _childGroupName; }
            set
            {
                _childGroupName = value;
                OnPropertyChanged("ChildGroupName");
            }
        }

        public double TotalChildRectangleSize
        {
            get { return _totalChildRectangleSize; }
            set
            {
                _totalChildRectangleSize = value;
                OnPropertyChanged("TotalChildRectangleSize");
            }
        }

        public double TotalChildRectangleColor
        {
            get { return _totalChildRectangleColor; }
            set
            {
                _totalChildRectangleColor = value;
                OnPropertyChanged("TotalChildRectangleColor");
            }
        }

        public double TotalChildCircleColor
        {
            get { return _totalChildCircleColor; }
            set
            {
                _totalChildCircleColor = value;
                //OnPropertyChanged("TotalChildCircleColor");
            }
        }

        public SolidColorBrush _childGroupBorderBrush { get; set; }
        public SolidColorBrush ChildGroupBorderBrush
        {
            get { return _childGroupBorderBrush; }
            set
            {
                _childGroupBorderBrush = value;
                OnPropertyChanged("ChildGroupBorderBrush");
                /* 21.05.2015 - bug. crash when app not run in LP
                if (_childGroupBorderBrush.CanFreeze)
                    _childGroupBorderBrush.Freeze();
                 */
            }
        }

        public void Dispose()
        {
            SelDataDisplayMin.Clear();
            SelDataDisplayAvg.Clear();
            SelDataDisplayMax.Clear();
            SelDataChildCount.Clear();
            DataChildCollection.Clear();
        }

        public DataChildGroup(int id,string name, string p)
        {
            ThenByGuidanceEnabled = new BooleanNotify(false);

            ID = id;
            ChildGroupName = name;
            DataChildCollection = new ObservableCollection<DataChild>();
            TotalChildRectangleSize = TotalChildRectangleColor = TotalChildCircleColor = 0;

            SelDataDisplayMin = new Dictionary<string, double?>();
            SelDataDisplayAvg = new Dictionary<string, double?>();
            SelDataDisplayMax = new Dictionary<string, double?>();
            SelDataChildCount = new Dictionary<string, double>();

            ParentName = p;

            ChildGroupBorderBrush = null;
            LeftClickRect = null;
        }

        public void AddChild(DataChild child)
        {
            DataChildCollection.Add(child);
            TotalChildRectangleSize += child.RectangleSize;
            TotalChildRectangleColor += (child.RectangleColor ?? 0.0);
            TotalChildCircleColor += (child.CircleColor ?? 0.0);

            foreach(KeyValuePair<string, double?> key in child.SelectionDataDisplay)
            {
                if (SelDataDisplayMin.ContainsKey((key.Key)))
                {
                    if (SelDataDisplayMin[key.Key].HasValue && key.Value.HasValue)
                    {
                        if (SelDataDisplayMin[key.Key] > key.Value)
                            SelDataDisplayMin[key.Key] = key.Value;
                    }
                    else if (key.Value.HasValue)
                    {
                        SelDataDisplayMin[key.Key] = key.Value;
                    }
                }
                else
                {
                    SelDataDisplayMin.Add(key.Key, key.Value);
                }

                if (SelDataDisplayMax.ContainsKey((key.Key)))
                {
                    if (SelDataDisplayMax[key.Key].HasValue && key.Value.HasValue)
                    {
                        if (SelDataDisplayMax[key.Key] < key.Value)
                            SelDataDisplayMax[key.Key] = key.Value;
                    }
                    else if (key.Value.HasValue)
                    {
                        SelDataDisplayMax[key.Key] = key.Value;
                    }
                }
                else
                {
                    SelDataDisplayMax.Add(key.Key, key.Value);
                }

                if (SelDataDisplayAvg.ContainsKey((key.Key)))
                {
                    if (key.Value.HasValue)
                    {
                        SelDataChildCount[key.Key] = SelDataChildCount[key.Key] + 1;
                        SelDataDisplayAvg[key.Key] = ((SelDataDisplayAvg[key.Key] * (SelDataChildCount[key.Key]-1)) + key.Value) / SelDataChildCount[key.Key];
                    }
                }
                else
                {
                    if (key.Value.HasValue)
                    {
                        SelDataChildCount.Add(key.Key, 1);
                        SelDataDisplayAvg.Add(key.Key, key.Value);
                    }
                }
            }
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion

    }
}
