﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;

namespace CDSHeatMap.Model
{
    public class ObservableName : INotifyPropertyChanged
    {
        private string _name;
        public string DisplayName
        {
            get { return _name; }
            set
            {
                _name = value;
                OnPropertyChanged("DisplayName");
            }
        }

        public ObservableName(string name)
        {
            DisplayName = name;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }

    public class ItemVisibility : INotifyPropertyChanged
    {
        private Visibility _visibility;
        public Visibility _Visibility
        {
            get { return _visibility; }
            set
            {
                _visibility = value;
                OnPropertyChanged("_Visibility");
            }
        }

        public ItemVisibility(Visibility visibility)
        {
            _Visibility = visibility;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }

    public class BooleanNotify : INotifyPropertyChanged
    {
        private bool _boolNotify;
        public bool BoolNotify
        {
            get { return _boolNotify; }
            set
            {
                _boolNotify = value;
                OnPropertyChanged("BoolNotify");
            }
        }

        public BooleanNotify(bool boolNotify)
        {
            BoolNotify = boolNotify;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }
}
