﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace CDSHeatMap.Model
{
    public class Rate : INotifyPropertyChanged
    {
        private DateTime _rateDate;
        private double? _rateValue;

        public DateTime RateDate
        {
            get { return _rateDate; }
            set
            {
                _rateDate = value;
                OnPropertyChanged("RateDate");
            }
        }

        public double? RateValue
        {
            get { return _rateValue; }
            set
            {
                _rateValue = value;
                OnPropertyChanged("RateValue");
            }
        }

        public Rate(DateTime date, double? rate)
        {
            RateDate = date;
            RateValue = rate;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }

    public class JustShowRate : INotifyPropertyChanged
    {
        private string _securityShow;
        private DateTime _rateDateShow;
        private double? _rateShow;

        public DateTime RateDateShow
        {
            get { return _rateDateShow; }
            set
            {
                _rateDateShow = value;
                OnPropertyChanged("RateDateShow");
            }
        }

        public double? RateShow
        {
            get { return _rateShow; }
            set
            {
                _rateShow = value;
                OnPropertyChanged("RateShow");
            }
        }

        public string SecurityShow
        {
            get { return _securityShow; }
            set
            {
                _securityShow = value;
                OnPropertyChanged("SecurityShow");
            }
        }

        public JustShowRate(string sec, DateTime date, double? rate)
        {
            SecurityShow = sec;
            RateDateShow = date;
            RateShow = rate;
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }
}
