﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using CDSHeatMap.Interface;
using CDSHeatMap.Util;
using Bloomberglp.AppPortalApi.DataPersistence;
using System.Runtime.Serialization;

namespace CDSHeatMap.Model
{
    public class TickerFilter : INotifyPropertyChanged, ITickerFilter
    {
        private string _TickerFilterName;

        private CDSIndex _TFCDSIndex;
        private List<CDSIndexMember> _addedTickerList;

        private string _PriceSource;

        public string TickerFilterName
        {
            get { return _TickerFilterName; }
            set
            {
                _TickerFilterName = value;
                OnPropertyChanged("TickerFilterName");
            }
        }

        public CDSIndex TFCDSIndex
        {
            get { return _TFCDSIndex; }
            set
            {
                _TFCDSIndex = value;
                OnPropertyChanged("TFCDSIndex");
            }
        }

        public string PriceSource
        {
            get { return _PriceSource; }
            set
            {
                _PriceSource = value;
                OnPropertyChanged("PriceSource");
            }
        }

        public List<CDSIndexMember> AddedTickerList
        {
            get { return _addedTickerList; }
            set
            {
                _addedTickerList = value;
                OnPropertyChanged("AddedTickerList");
            }
        }

        public void reset()
        {
            TickerFilterName = "";
            AddedTickerList.Clear();
            TFCDSIndex.reset();
        }

        public TickerFilter(string name)
        {
            TickerFilterName = name;

            TFCDSIndex = new CDSIndex();
            AddedTickerList = new List<CDSIndexMember>();
        }

        public TickerFilter()
        {
            TickerFilterName = "";
            TFCDSIndex = new CDSIndex();
            AddedTickerList = new List<CDSIndexMember>();
        }

        public List<CDSIndexMember> getAllCDSMembers()
        {
            if (AddedTickerList.Count > 0)
                return TFCDSIndex.CDSIndexMemberList.Concat(AddedTickerList).ToList();
            else
                return TFCDSIndex.CDSIndexMemberList;
        }

        public void setCDSIndex(CDSIndexBase cdsbase)
        {
            TFCDSIndex.setCDSIndexName(cdsbase);
        }
        public void setPricingSource(string source)
        {
            PriceSource = source;
        }

        public void addTickersToList(List<string> security, List<string> description)
        {
            for (int i = 0; i < security.Count; ++i)
                addTickerToList(new SecurityDescription(security[i], description[i]));
        }
        public void addTickerToList(SecurityDescription security)
        {
            if (!AddedTickerList.Any(member => member.TickerEquity == security.Security))
                AddedTickerList.Add(new CDSIndexMember(security));
        }

        public void uncheckAllCDSIndexMembers()
        {
            foreach (CDSIndexMember member in getAllCDSMembers())
            {
                member.IsCheckedTicker = false;
            }
        }

        public void uncheckCDSIndexMembers(List<string> tickerList)
        {
            foreach (string ticker in tickerList)
            {
                checkCDSIndexMember(ticker, false);
            }
        }

        public void checkCDSIndexMembers(List<string> tickerList)
        {
            foreach (string ticker in tickerList)
            {
                checkCDSIndexMember(ticker, true);
            }
        }

        public void checkCDSIndexMember(string ticker, bool value)
        {
            int index = TFCDSIndex.CDSIndexMemberList.FindIndex(member => member.TickerEquity == ticker);
            if (index >= 0)
            {
                TFCDSIndex.CDSIndexMemberList[index].IsCheckedTicker = value;
            }
            
            index = AddedTickerList.FindIndex(member => member.TickerEquity == ticker);
            if (index >= 0)
            {
                AddedTickerList[index].IsCheckedTicker = value;
            }
        }

        public List<string> getAllEquityTicker()
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.getTickerEquity() != "" && member.IsCheckedTicker == true)
                {
                    if (!tickerList.Contains(member.getTickerEquity()))
                        tickerList.Add(member.getTickerEquity());
                }
            }

            foreach (CDSIndexMember member in AddedTickerList)
            {
                if (member.getTickerEquity() != "" && member.IsCheckedTicker == true)
                {
                    if (!tickerList.Contains(member.getTickerEquity()))
                        tickerList.Add(member.getTickerEquity());
                }
            }

            return tickerList;
        }
        public Dictionary<string, double?> getAllEquityTickerLastPrice()
        {
            Dictionary<string, double?> tickerLastPriceList = new Dictionary<string, double?>();

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                string ticker = member.getTickerEquity();
                if (ticker != "" && member.IsCheckedTicker == true)
                {
                    if (!tickerLastPriceList.ContainsKey(ticker))
                        tickerLastPriceList.Add(ticker, member.LastPrice);
                }
            }

            foreach (CDSIndexMember member in AddedTickerList)
            {
                string ticker = member.getTickerEquity();
                if (ticker != "" && member.IsCheckedTicker == true)
                {
                    if (!tickerLastPriceList.ContainsKey(ticker))
                        tickerLastPriceList.Add(ticker, member.LastPrice);
                }
            }

            return tickerLastPriceList;
        }
        public List<string> getAllSpreadTickerPricingSource(string source)
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.IsCheckedTicker == true)
                {
                    for (int i = 0; i < member.TickerSpreadList.Count; ++i)
                        if (member.getTickerSpread(i, source) != "")
                        {
                            if (!tickerList.Contains(member.getTickerSpread(i, source)))
                                tickerList.Add(member.getTickerSpread(i, source));
                        }
                }
            }

            foreach (CDSIndexMember member in AddedTickerList)
            {
                if (member.IsCheckedTicker == true)
                {
                    for (int i = 0; i < member.TickerSpreadList.Count; ++i)
                        if (member.getTickerSpread(i, source) != "")
                        {
                            if (!tickerList.Contains(member.getTickerSpread(i, source)))
                                tickerList.Add(member.getTickerSpread(i, source));
                        }
                }
            }

            return tickerList;
        }
        public List<string> getSpreadTickerPricingSource(int i, string source)
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.IsCheckedTicker == true)
                {
                    if (i < member.TickerSpreadList.Count)
                    {
                        if (member.getTickerSpread(i, source) != "")
                        {
                            if (!tickerList.Contains(member.getTickerSpread(i, source)))
                                tickerList.Add(member.getTickerSpread(i, source));
                        }
                    }
                }
            }

            foreach (CDSIndexMember member in AddedTickerList)
            {
                if (member.IsCheckedTicker == true)
                {
                    if (i < member.TickerSpreadList.Count)
                    {
                        if (member.getTickerSpread(i, source) != "")
                        {
                            if (!tickerList.Contains(member.getTickerSpread(i, source)))
                                tickerList.Add(member.getTickerSpread(i, source));
                        }
                    }
                }
            }
            return tickerList;
        }
        public Dictionary<string, double?> getSpreadTickerLastPrice(int i, string source)
        {
            Dictionary<string, double?> tickerLastPriceList = new Dictionary<string, double?>();

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.IsCheckedTicker == true)
                {
                    if (i < member.TickerSpreadList.Count)
                    {
                        string ticker = member.getTickerSpread(i, source);
                        if (ticker != "")
                        {
                            if (!tickerLastPriceList.ContainsKey(ticker))
                                tickerLastPriceList.Add(ticker, member.getMidSpread(i));
                        }
                    }
                }
            }

            foreach (CDSIndexMember member in AddedTickerList)
            {
                if (member.IsCheckedTicker == true)
                {
                    if (i < member.TickerSpreadList.Count)
                    {
                        string ticker = member.getTickerSpread(i, source);
                        if (ticker != "")
                        {
                            if (!tickerLastPriceList.ContainsKey(ticker))
                                tickerLastPriceList.Add(ticker, member.getMidSpread(i));
                        }
                    }
                }
            }
            return tickerLastPriceList;
        }
        public List<string> getAllTickerPricingSource(string source)
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.IsCheckedTicker == true)
                {
                    if (member.getTickerSpread() != "")
                    {
                        if (!tickerList.Contains(member.getTickerSpread()))
                            tickerList.Add(member.getTickerSpread());
                    }

                    for (int i = 0; i < member.TickerSpreadList.Count; ++i)
                        if (member.getTickerSpread(i, source) != "")
                        {
                            if (!tickerList.Contains(member.getTickerSpread(i, source)))
                                tickerList.Add(member.getTickerSpread(i, source));
                        }
                }
            }

            foreach (CDSIndexMember member in AddedTickerList)
            {
                if (member.IsCheckedTicker == true)
                {
                    if (member.getTickerSpread() != "")
                    {
                        if (!tickerList.Contains(member.getTickerSpread()))
                            tickerList.Add(member.getTickerSpread());
                    }

                    for (int i = 0; i < member.TickerSpreadList.Count; ++i)
                        if (member.getTickerSpread(i, source) != "")
                        {
                            if (!tickerList.Contains(member.getTickerSpread(i, source)))
                                tickerList.Add(member.getTickerSpread(i, source));
                        }
                }
            }

            return tickerList;
        }
        public List<string> getAllTickerPricingSource(int i, string source)
        {
            List<string> tickerList = new List<string>();

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.IsCheckedTicker == true)
                {
                    if (member.getTickerSpread() != "")
                    {
                        if (!tickerList.Contains(member.getTickerSpread()))
                            tickerList.Add(member.getTickerSpread());
                    }

                    if (i < member.TickerSpreadList.Count)
                    {
                        if (member.getTickerSpread(i, source) != "")
                        {
                            if (!tickerList.Contains(member.getTickerSpread(i, source)))
                                tickerList.Add(member.getTickerSpread(i, source));
                        }
                    }
                }
            }

            foreach (CDSIndexMember member in AddedTickerList)
            {
                if (member.IsCheckedTicker == true)
                {
                    if (member.getTickerSpread() != "")
                    {
                        if (!tickerList.Contains(member.getTickerSpread()))
                            tickerList.Add(member.getTickerSpread());
                    }

                    if (i < member.TickerSpreadList.Count)
                    {
                        if (member.getTickerSpread(i, source) != "")
                        {
                            if (!tickerList.Contains(member.getTickerSpread(i, source)))
                                tickerList.Add(member.getTickerSpread(i, source));
                        }
                    }
                }
            }

            return tickerList;
        }

        public bool checkMemberCoherency()
        {
            bool isCoherent = true;

            foreach (var customTicker in AddedTickerList)
            {
                int index = TFCDSIndex.CDSIndexMemberList.FindIndex(member => member.TickerEquity == customTicker.TickerEquity);
                if (index >= 0)
                {
                    AddedTickerList.Remove(customTicker);
                    isCoherent = false;
                }
            }
            return isCoherent;
        }

        public bool addcoherentCustomTickers(TickerFilterItems tickerFilterItems)
        {
            bool isUnCoherent = false;

            List<int> unCoherentIndexList = new List<int>();

            for (int i = 0; i < tickerFilterItems.addedTickerList.Count; ++i)
            {
                int index = TFCDSIndex.CDSIndexMemberList.FindIndex(member => member.TickerEquity == tickerFilterItems.addedTickerList[i]);
                if (index >= 0)
                {
                    unCoherentIndexList.Add(i);
                    isUnCoherent = true;
                }
                else
                {
                    addTickerToList(new SecurityDescription(tickerFilterItems.addedTickerList[i], tickerFilterItems.addedTickerDescriptionList[i]));
                }
            }

            if (unCoherentIndexList.Count > 0)
            {
                for (int i = unCoherentIndexList.Count - 1; i >= 0; ++i)
                {
                    tickerFilterItems.addedTickerList.RemoveAt(i);
                    tickerFilterItems.addedTickerDescriptionList.RemoveAt(i);
                }
            }

            return isUnCoherent;
        }

        public void checkAllTickers(TickerFilterItems tickerFilterItems)
        {
            //uncheckCDSIndexMembers(tickerFilterItems.unselectedTickerList);
            //uncheckCDSIndexMembers(tickerFilterItems.filteredoutTickerList);
            uncheckAllCDSIndexMembers();
            checkCDSIndexMembers(tickerFilterItems.filteredinTickerList);
            uncheckCDSIndexMembers(tickerFilterItems.unselectedTickerList);
            checkCDSIndexMembers(tickerFilterItems.selectedTickerList);
        }

        public List<double?> getCDS5YSpread_MinMax()
        {
            List<double?> minmaxValue = new List<double?>() { null, null };

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.CDSPrice.HasValue)
                {
                    if (minmaxValue[0].HasValue)
                    {
                        if ((member.CDSPrice*member.FXRateCDS) < minmaxValue[0])
                            minmaxValue[0] = (member.CDSPrice * member.FXRateCDS);
                    }
                    else
                        minmaxValue[0] = (member.CDSPrice * member.FXRateCDS);

                    if (minmaxValue[1].HasValue)
                    {
                        if ((member.CDSPrice * member.FXRateCDS) > minmaxValue[1])
                            minmaxValue[1] = (member.CDSPrice * member.FXRateCDS);
                    }
                    else
                        minmaxValue[1] = (member.CDSPrice * member.FXRateCDS);
                }
            }

            return minmaxValue;
        }
        public List<double?> getMarketCap_MinMax()
        {
            List<double?> minmaxValue = new List<double?>() { null, null };

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.MarketCapital.HasValue)
                {
                    if (minmaxValue[0].HasValue)
                    {
                        if ((member.MarketCapital * member.FXRateEquity) < minmaxValue[0])
                            minmaxValue[0] = (member.MarketCapital * member.FXRateEquity);
                    }
                    else
                        minmaxValue[0] = (member.MarketCapital * member.FXRateEquity);

                    if (minmaxValue[1].HasValue)
                    {
                        if ((member.MarketCapital * member.FXRateEquity) > minmaxValue[1])
                            minmaxValue[1] = (member.MarketCapital * member.FXRateEquity);
                    }
                    else
                        minmaxValue[1] = (member.MarketCapital * member.FXRateEquity);
                }
            }

            return minmaxValue;
        }
        public List<double?> getTotalDebtTotalCap_MinMax()
        {
            List<double?> minmaxValue = new List<double?>() { null, null };

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.TotalDebtToCapital.HasValue)
                {
                    if (minmaxValue[0].HasValue)
                    {
                        if (member.TotalDebtToCapital < minmaxValue[0])
                            minmaxValue[0] = member.TotalDebtToCapital;
                    }
                    else
                        minmaxValue[0] = member.TotalDebtToCapital;

                    if (minmaxValue[1].HasValue)
                    {
                        if (member.TotalDebtToCapital > minmaxValue[1])
                            minmaxValue[1] = member.TotalDebtToCapital;
                    }
                    else
                        minmaxValue[1] = member.TotalDebtToCapital;
                }
            }

            return minmaxValue;
        }
        public List<double?> getDebtCommonEquity_MinMax()
        {
            List<double?> minmaxValue = new List<double?>() { null, null };

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.DebtToCommonEquity.HasValue)
                {
                    if (minmaxValue[0].HasValue)
                    {
                        if (member.DebtToCommonEquity < minmaxValue[0])
                            minmaxValue[0] = member.DebtToCommonEquity;
                    }
                    else
                        minmaxValue[0] = member.DebtToCommonEquity;

                    if (minmaxValue[1].HasValue)
                    {
                        if (member.DebtToCommonEquity > minmaxValue[1])
                            minmaxValue[1] = member.DebtToCommonEquity;
                    }
                    else
                        minmaxValue[1] = member.DebtToCommonEquity;
                }
            }

            return minmaxValue;
        }
        public List<double?> getInterestCoverageRatio_MinMax()
        {
            List<double?> minmaxValue = new List<double?>() { null, null };

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.InterestCoverageRatio.HasValue)
                {
                    if (minmaxValue[0].HasValue)
                    {
                        if (member.InterestCoverageRatio < minmaxValue[0])
                            minmaxValue[0] = member.InterestCoverageRatio;
                    }
                    else
                        minmaxValue[0] = member.InterestCoverageRatio;

                    if (minmaxValue[1].HasValue)
                    {
                        if (member.InterestCoverageRatio > minmaxValue[1])
                            minmaxValue[1] = member.InterestCoverageRatio;
                    }
                    else
                        minmaxValue[1] = member.InterestCoverageRatio;
                }
            }

            return minmaxValue;
        }

        public List<double?> getCDSCurveFilter_MinMax(string curveName)
        {

            if (curveName == "1Y/5Y")
            {
                return getCDSCurveFilterItem_MinMax(0, 4);
            }
            else if (curveName == "2Y/5Y")
            {
                return getCDSCurveFilterItem_MinMax(1, 4);
            }
            else if (curveName == "3Y/5Y")
            {
                return getCDSCurveFilterItem_MinMax(2, 4);
            }
            else if (curveName == "5Y/7Y")
            {
                return getCDSCurveFilterItem_MinMax(4, 5);
            }
            else if (curveName == "5Y/10Y")
            {
                return getCDSCurveFilterItem_MinMax(5, 6);
            }
            else
                return new List<double?>() { 0.0, 0.0 };
        }
        private List<double?> getCDSCurveFilterItem_MinMax(int curve1, int curve2)
        {
            List<double?> minmaxValue = new List<double?>() { null, null };

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.MidSpread == null)
                    continue;

                if (member.MidSpread.Count != 7)
                    continue;

                double? rate1 = member.getMidSpread(curve1);
                double? rate2 = member.getMidSpread(curve2);
                double rate;

                if (rate1.HasValue && rate2.HasValue && rate2 != 0.0)
                {
                    rate = (rate1 / rate2 ?? 0.0);
                }
                else
                    continue;


                if (minmaxValue[0].HasValue)
                {
                    if (rate < minmaxValue[0])
                        minmaxValue[0] = rate;
                }
                else
                    minmaxValue[0] = rate;

                if (minmaxValue[1].HasValue)
                {
                    if (rate > minmaxValue[1])
                        minmaxValue[1] = rate;
                }
                else
                    minmaxValue[1] = rate;

            }

            return minmaxValue;
        }

        public CDSIndexMember getMemberByEqTicker(string eqTicker)
        {
            int index = TFCDSIndex.CDSIndexMemberList.FindIndex(member => member.TickerEquity == eqTicker);
            if (index >= 0)
            {
                return TFCDSIndex.CDSIndexMemberList[index];
            }

            index = AddedTickerList.FindIndex(member => member.TickerEquity == eqTicker);
            if (index >= 0)
            {
                return AddedTickerList[index];
            }

            return null;
        }


        public int numberOfTicker()
        {
            int count = 0;

            foreach (CDSIndexMember member in TFCDSIndex.CDSIndexMemberList)
            {
                if (member.getTickerEquity() != "" && member.IsCheckedTicker == true)
                {
                    count++;
                }
            }

            foreach (CDSIndexMember member in AddedTickerList)
            {
                if (member.getTickerEquity() != "" && member.IsCheckedTicker == true)
                {
                    count++;
                }
            }

            return count;
        }



        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }

    public class TickerFilterItems : ExtensibleDataObject, ITickerFilter
    {
        public string TickerFilterName { get; set; }
        public string CDSIndexName { get; set; }

        public List<string> Ratings { get; set; }
        public List<bool> RatingsChecked { get; set; }
        public List<string> Industries { get; set; }
        public List<bool> IndustriesChecked { get; set; }

        public List<string> addedTickerList { get; set; }
        public List<string> addedTickerDescriptionList { get; set; }
        public List<string> unselectedTickerList { get; set; }
        public List<string> selectedTickerList { get; set; }
        public List<string> filteredoutTickerList { get; set; }
        public List<string> filteredinTickerList { get; set; }

        public List<string> quickFilterItems { get; set; }

        public string PriceSource { get; set; }

        public double? CDS5YSpreadMin { get; set; }
        public double? CDS5YSpreadMax { get; set; }
        public double? CDS5YSpreadSelMin { get; set; }
        public double? CDS5YSpreadSelMax { get; set; }

        public string selCDSCurveFilter { get; set; }
        public double? CDSCurveFilterMin { get; set; }
        public double? CDSCurveFilterMax { get; set; }
        public double? CDSCurveFilterSelMin { get; set; }
        public double? CDSCurveFilterSelMax { get; set; }

        public double? marketCapMin { get; set; }
        public double? marketCapMax { get; set; }
        public double? marketCapSelMin { get; set; }
        public double? marketCapSelMax { get; set; }

        public double? totalDebtToTotalCapMin { get; set; }
        public double? totalDebtToTotalCapMax { get; set; }
        public double? totalDebtToTotalCapSelMin { get; set; }
        public double? totalDebtToTotalCapSelMax { get; set; }

        public double? debtToCommonEquityMin { get; set; }
        public double? debtToCommonEquityMax { get; set; }
        public double? debtToCommonEquitySelMin { get; set; }
        public double? debtToCommonEquitySelMax { get; set; }

        public double? interestCoverageRatioMin { get; set; }
        public double? interestCoverageRatioMax { get; set; }
        public double? interestCoverageRatioSelMin { get; set; }
        public double? interestCoverageRatioSelMax { get; set; }

        public bool applyFilterDync { get; set; }

        public TickerFilterItems(string name)
        {
            TickerFilterName = name;

            this.Ratings = new List<string>();
            this.RatingsChecked = new List<bool>();
            this.Industries = new List<string>();
            this.IndustriesChecked = new List<bool>();
            this.addedTickerList = new List<string>();
            this.addedTickerDescriptionList = new List<string>();
            this.unselectedTickerList = new List<string>();
            this.selectedTickerList = new List<string>();
            this.filteredoutTickerList = new List<string>();
            this.filteredinTickerList = new List<string>();
            this.quickFilterItems = new List<string>();

            applyFilterDync = false;
        }

        public TickerFilterItems()
        {
            this.Ratings = new List<string>();
            this.RatingsChecked = new List<bool>();
            this.Industries = new List<string>();
            this.IndustriesChecked = new List<bool>();
            this.addedTickerList = new List<string>();
            this.addedTickerDescriptionList = new List<string>();
            this.unselectedTickerList = new List<string>();
            this.selectedTickerList = new List<string>();
            this.filteredoutTickerList = new List<string>();
            this.filteredinTickerList = new List<string>();
            this.quickFilterItems = new List<string>();

            applyFilterDync = false;
        }
    }

    public class PersistTickerFilterList : ExtensibleDataObject
    {
        public List<string> TickerFilterList { get; set; }

        public PersistTickerFilterList()
        {
            TickerFilterList = new List<string>();
        }

        public void addTickerFilter(string tf)
        {
            if (!isExistTickerFilter(tf))
                TickerFilterList.Add(tf);
        }

        public void removeTickerFilter(string tf)
        {
            if (isExistTickerFilter(tf))
                TickerFilterList.Remove(tf);
        }

        public bool isExistTickerFilter(string tf)
        {
            return TickerFilterList.Contains(tf);
        }

        public void clearTickerFilter()
        {
            TickerFilterList.Clear();
        }

        public int countTickerFilter()
        {
            return TickerFilterList.Count;
        }

    }
}
