﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace CDSHeatMap.NormalDist
{
    /*Aysegul Albayrak*/
    public class NormalDistribution
    {
        public double calculateNormDist(List<double> list, double x){

            double y = 0d;
            double variance = Variance(list);
            double mean = Mean(list);
            double firstStep = (1 / (variance*(Math.Sqrt(2 * Math.PI))));
            double secondStep = (-(Math.Pow(x - mean,2.0))/(2*Math.Pow(variance,2.0)));
            double thirdStep = Math.Exp(secondStep);
            y = firstStep * thirdStep;

            return y;

        }

        private double Variance(List<double> list)
        {
            List<double> numbers = list.ToList();

            double mean = Mean(list);
            double result = numbers.Sum(number => Math.Pow(number - mean, 2.0));
            return result / numbers.Count;
        }

        private double Variance2(List<double> list)
        {
            double variance = 0;
            double result = 0d;
            double mean = Mean(list);
            for (int i = 0; i < list.Count ; i++)
            {
                variance += Math.Pow((list[i] - mean), 2);
            }
            if (list.Count > 0)
                result = variance / (list.Count);

            return result ;
        
        }

        private double StandardDeviation(List<double> list)
        {

            double standardDeviation = 0d;
            if (list.Count != 0)
            {
                double variance = Variance(list);
                standardDeviation = Math.Sqrt(variance);
            }
            return standardDeviation;
        }

        private double Mean(List<double> list)
        {
            double average = 0d;
            if(list.Count != 0)
                average = list.Average();
            return average;
            
        }

        private double Median(List<double> list)
        {
            List<double> orderedList = list
                .OrderBy(numbers => numbers)
                .ToList();

            int listSize = orderedList.Count;
            double result;

            if (listSize % 2 == 0) // even
            {
                int midIndex = listSize / 2;
                result = ((orderedList.ElementAt(midIndex - 1) +
                           orderedList.ElementAt(midIndex)) / 2);
            }
            else // odd
            {
                double element = (double)listSize / 2;
                element = Math.Round(element, MidpointRounding.AwayFromZero);
                result = orderedList.ElementAt((int)(element - 1));
            }
            return result;
        }



        public double getMinNormDistValue(List<double> list)
        {
            double min = 0d;
            double mean = 0d;
            double standardDeviation = 0d ;
            mean = Mean(list);
            standardDeviation = StandardDeviation(list);
            min = mean - standardDeviation;
            return min;
        }

        public double getMaxNormDistValue(List<double> list)
        {
            double max = 0d;
            double mean = 0d;
            double standardDeviation = 0d;
            mean = Mean(list);
            standardDeviation = StandardDeviation(list);
            max = mean + standardDeviation;
            return max;

        }


    }
}