﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
/*AYSEGUL ALBAYRAK,15.08.2014*/

namespace CDSHeatMap.PieChart
{
    /// <summary>
    /// Interaction logic for DonutChart.xaml
    /// </summary>
    public partial class DonutChart : UserControl
    {

        public double HoleSize { get; set; }
       
        
        public DonutChart()
        {
            InitializeComponent();
            HoleSize = 0.9;
        }



        public void ConstructPiePieces(double currentItem, double max, double size, bool isNone)
        {
            //List<PiePiece> piePieces = new List<PiePiece>();
            this.Width = size;
            this.Height = size;
            double halfWidth = this.Width / 2;
            double innerRadius = halfWidth * HoleSize;
            double accumulativeAngle = 0;
            double wedgeAngleCurrent = 0;
            double wedgeAngleOther = 0;
            PiePiece piece1 = new PiePiece();
            PiePiece piece2 = new PiePiece();
            canvas.Children.Clear();
            //piePieces.Clear();

            if (isNone == true)
            {
                canvas.Background = Brushes.Transparent;
                return;
            }

            if (currentItem == 0 || max == 0)
            {
                max = 100;
                currentItem = max / 2;
                
                wedgeAngleCurrent = currentItem * 360 / max;
                piece1.Radius = halfWidth;
                piece1.Radius = halfWidth;
                piece1.InnerRadius = innerRadius;
                piece1.CentreX = halfWidth;
                piece1.CentreY = halfWidth;
                piece1.WedgeAngle = wedgeAngleCurrent;
                piece1.Fill = Brushes.Transparent;
                piece1.Tag = 1;

                double otherItems = (max - currentItem);
                wedgeAngleOther = otherItems * 360 / max;
                piece2.Radius = halfWidth;
                piece2.Radius = halfWidth;
                piece2.InnerRadius = innerRadius;
                piece2.CentreX = halfWidth;
                piece2.CentreY = halfWidth;
                piece2.WedgeAngle = wedgeAngleOther;
                piece2.Fill = Brushes.Transparent;
                piece2.Tag = 2;

            }
            else if (currentItem == max)
            {
                if (max > 0)
                {
                    max = 100;
                }
                else
                    max = -100;

                currentItem = max / 2;

                wedgeAngleCurrent = currentItem * 360 / max;
                piece1.Radius = halfWidth;
                piece1.Radius = halfWidth;
                piece1.InnerRadius = innerRadius;
                piece1.CentreX = halfWidth;
                piece1.CentreY = halfWidth;
                piece1.WedgeAngle = wedgeAngleCurrent;
                if (currentItem > 0)
                    piece1.Fill = Brushes.Blue;
                else
                    piece1.Fill = Brushes.DodgerBlue;
                piece1.Tag = 1;

                double otherItems = (max - currentItem);
                wedgeAngleOther = otherItems * 360 / max;
                piece2.Radius = halfWidth;
                piece2.Radius = halfWidth;
                piece2.InnerRadius = innerRadius;
                piece2.CentreX = halfWidth;
                piece2.CentreY = halfWidth;
                piece2.WedgeAngle = wedgeAngleOther;
                if (currentItem > 0)
                    piece2.Fill = Brushes.Blue;
                else
                    piece2.Fill = Brushes.DodgerBlue;
                piece2.Tag = 2;
            }
            else
            {

                wedgeAngleCurrent = currentItem * 360 / max;
                piece1.Radius = halfWidth;
                piece1.Radius = halfWidth;
                piece1.InnerRadius = innerRadius;
                piece1.CentreX = halfWidth;
                piece1.CentreY = halfWidth;
                piece1.WedgeAngle = wedgeAngleCurrent;
                if (currentItem > 0)
                    piece1.Fill = Brushes.Blue;
                else
                    piece1.Fill = Brushes.DodgerBlue;
                piece1.Tag = 1;

                double otherItems = (max - currentItem);
                wedgeAngleOther = otherItems * 360 / max;
                piece2.Radius = halfWidth;
                piece2.Radius = halfWidth;
                piece2.InnerRadius = innerRadius;
                piece2.CentreX = halfWidth;
                piece2.CentreY = halfWidth;
                piece2.WedgeAngle = wedgeAngleOther;
                piece2.Fill = Brushes.Transparent;
                piece2.Tag = 2;
            }


            if (currentItem > 0)
            {
                piece1.RotationAngle = accumulativeAngle;
                //piePieces.Add(piece1);
                accumulativeAngle += wedgeAngleCurrent;

                piece2.RotationAngle = accumulativeAngle;
                //piePieces.Add(piece2);
                accumulativeAngle += wedgeAngleOther;
            }


            else
            {
                piece2.RotationAngle = accumulativeAngle;
                //piePieces.Add(piece2);
                accumulativeAngle += wedgeAngleOther;


                piece1.RotationAngle = accumulativeAngle;
                //piePieces.Add(piece1);
                accumulativeAngle += wedgeAngleCurrent;

            }
        
            canvas.Children.Insert(0, piece1);
            canvas.Children.Insert(0, piece2);
        }
    }
}
