﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CDSHeatMap.QuickFilter
{
    /*AYSEGUL ALBAYRAK,16.06.2014*/
    /// <summary>
    /// Interaction logic for QuickFilter.xaml
    /// </summary>
    public partial class QuickFilter : UserControl
    {

        private List<string> allKeys = null;
        Dictionary<string, List<string>> dictionaryList = null;
        Dictionary<string, string> fieldList = null;
        private int filterCount = 0;

        ObservableCollection<QuickFilterObject> _QuickFilterCollection = new ObservableCollection<QuickFilterObject>();

        public ObservableCollection<QuickFilterObject> QuickFilterCollection { get { return _QuickFilterCollection; } }


        public QuickFilter()
        {
            InitializeComponent();


        }

        public void setItemList(Dictionary<string, List<string>> list, Dictionary<string, string> fields, int filterCount)
        {
            Dictionary<string, List<string>> newList = new Dictionary<string, List<string>>();
            newList = addFirstItem("ALL", list);
            list = newList;
            this.dictionaryList = list;//key,value array
            this.fieldList = fields;
            this.allKeys = ListUtil.getAllKey(list);
            this.filterCount = filterCount;


        }


        public Dictionary<string, List<string>> addFirstItem(string key, Dictionary<string, List<string>> dictionary)
        {
            Dictionary<string, List<string>> newDictionary = new Dictionary<string, List<string>>();
            List<string> keyList = ListUtil.addIndexToList(dictionary, key, 0);
            List<string> newValueList = new List<string>();
            for (int i = 0; i < keyList.Count; i++)
            {

                if (key == keyList[i].ToString())
                    newValueList = ListUtil.getAllValues(dictionary);
                else
                    newValueList = ListUtil.getValueFromKey(keyList[i].ToString(), dictionary);

                newDictionary.Add(keyList[i].ToString(), newValueList);
            }
            return newDictionary;


        }

        public void createGridItems(string p1, string p2, string p3)
        {
            _QuickFilterCollection.Add(new QuickFilterObject(p1, p2, p3, allKeys, dictionaryList, fieldList));
        }


        private void removeRow(object sender, RoutedEventArgs e)
        {
            try
            {
                if (_QuickFilterCollection.Count > 1)
                {
                    if (_QuickFilterCollection.Count == 2 && MyGrid.SelectedIndex != 0)
                    {
                        _QuickFilterCollection[MyGrid.SelectedIndex - 1].negativeVisibilty = "Hidden";
                        _QuickFilterCollection[MyGrid.SelectedIndex - 1].andOrVisibilty = "Hidden";
                        _QuickFilterCollection[MyGrid.SelectedIndex - 1].andOrValue = null;
                        _QuickFilterCollection[MyGrid.SelectedIndex - 1].plusVisibilty = "Visible";
                    }
                    else if (MyGrid.SelectedIndex == 0)
                    {
                        _QuickFilterCollection[MyGrid.SelectedIndex + 1].andOrVisibilty = "Hidden";
                        _QuickFilterCollection[MyGrid.SelectedIndex + 1].andOrValue = null;
                        if (_QuickFilterCollection.Count == 2)
                        {
                            _QuickFilterCollection[MyGrid.SelectedIndex + 1].plusVisibilty = "Visible";
                            _QuickFilterCollection[MyGrid.SelectedIndex + 1].negativeVisibilty = "Hidden";
                        }

                    }

                    else if (MyGrid.SelectedIndex == _QuickFilterCollection.Count - 1)
                    {

                        _QuickFilterCollection[MyGrid.SelectedIndex - 1].plusVisibilty = "Visible";
                    }

                }


                _QuickFilterCollection.RemoveAt(MyGrid.SelectedIndex);

                MyGrid.Items.Refresh();
                MyGrid.ItemsSource = QuickFilterCollection;
            }
            catch (Exception)
            {

                return;
            }

        }

        public void addRow(object sender, RoutedEventArgs e)
        {

            try
            {
                _QuickFilterCollection[MyGrid.SelectedIndex].plusVisibilty = "Hidden";
                _QuickFilterCollection[MyGrid.SelectedIndex].negativeVisibilty = "Visible";
                createGridItems("Visible", "Visible", "Visible");

                if (MyGrid.Items.Count == filterCount)
                    _QuickFilterCollection[filterCount - 1].plusVisibilty = "Hidden";

                MyGrid.Items.Refresh();
                MyGrid.ItemsSource = QuickFilterCollection;
            }
            catch (Exception)
            {

                return;
            }

        }

        private void mainList_OnGotFocus(object sender, SelectionChangedEventArgs e)
        {

            ComboBox SelectBox = (ComboBox)sender;

            if (SelectBox.SelectedValue == null)
                return;

            _QuickFilterCollection[MyGrid.SelectedIndex].subList = ListUtil.getValueFromKey((SelectBox.SelectedValue.ToString()), dictionaryList);



        }

        private void filterOperatorChange(object sender, SelectionChangedEventArgs e)
        {
            ComboBox SelectBox = (ComboBox)sender;

            if (SelectBox.SelectedValue == null)
                return;
            _QuickFilterCollection[MyGrid.SelectedIndex].TextBoxVisibility = (SelectBox.SelectedValue.ToString() == "Between") ? "Visible" : "Hidden";
        }


        public ObservableCollection<QuickFilterObject> getGridList()
        {
            QuickFilterCollection[0].andOrValue = "";
            return QuickFilterCollection;
        }

        public void setGroupBoxName(string groupBoxName)
        {
            groupBox.Header = groupBoxName;
        }

        public void setGridRow(string andOr, string mainVal, string subVal, string operatorVal, string minVal, string maxVal)
        {
            try
            {
                int currentRow = QuickFilterCollection.Count - 1;

                if (currentRow < 0)
                    return;

                QuickFilterCollection[currentRow].andOrValue = andOr;
                QuickFilterCollection[currentRow].mainFilterValue = mainVal;
                QuickFilterCollection[currentRow].subFilterValue = subVal;
                QuickFilterCollection[currentRow].filterOperatorValue = operatorVal;
                QuickFilterCollection[currentRow].minValue = minVal;

                QuickFilterCollection[currentRow].TextBoxVisibility = (operatorVal == "Between") ? "Visible" : "Hidden";

                if (operatorVal == "Between")
                {
                    QuickFilterCollection[currentRow].maxValue = maxVal;
                }

                MyGrid.Items.Refresh();
                MyGrid.ItemsSource = QuickFilterCollection;
            }
            catch (Exception)
            {

                return;
            }

        }



        public event PropertyChangedEventHandler PropertyChanged;

        public void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

    }
}

