﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace CDSHeatMap.QuickFilter
{
    public class QuickFilterObject : INotifyPropertyChanged
    {



        public string minValue { get; set; }

        public string maxValue { get; set; }

        public string mainFilterValue { get; set; }

        public string subFilterValue { get; set; }

        public string andOrValue { get; set; }

        public List<string> filterList { get; set; }

        public List<string> filterSubList { get; set; }

        public string filterOperatorValue { get; set; }

        public string andOrVisibilty { get; set; }

        public string plusVisibilty { get; set; }

        public string negativeVisibilty { get; set; }

        public string textBoxVisibility { get; set; }

        public Dictionary<string, string> fieldList { get; set; }

        public QuickFilterObject(string p1, string p2, string p3, List<string> itemList, Dictionary<string, List<string>> dictionaryList, Dictionary<string, string> _fieldList)
        {

            this.andOrVisibilty = p1;
            this.plusVisibilty = p2;
            this.negativeVisibilty = p3;
            this.filterList = itemList;
            this.filterOperatorValue = filterOperatorList.First<string>();
            this.andOrValue = andOrList.First<string>();
            this.MainFilterValue = filterList.First<string>();
            this.subList = dictionaryList[this.MainFilterValue];
            this.TextBoxVisibility = (filterOperatorValue == "Between") ? "Visible" : "Hidden";
            this.fieldList = _fieldList;
        }


        public string TextBoxVisibility
        {
            get { return textBoxVisibility; }
            set
            {
                textBoxVisibility = value;
                OnPropertyChanged("TextBoxVisibility");
            }
        }


        public List<string> subList
        {
            get { return filterSubList; }
            set
            {
                filterSubList = value;
                OnPropertyChanged("subList");
            }
        }

        public string MainFilterValue
        {
            get { return mainFilterValue; }
            set
            {
                mainFilterValue = value;
                OnPropertyChanged("MainFilterValue");
            }
        }


        public event PropertyChangedEventHandler PropertyChanged;

        public void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }




        public string andOrText
        {
            get { return "AND/OR"; }
            set { }
        }

        public string filterText
        {
            get { return " Choose Data to Filter"; }
            set { }
        }


        public string and
        {
            get { return "AND"; }
            set { }
        }

        public string between
        {
            get { return "Values Between"; }
            set { }
        }



        public string[] andOrList
        {
            get { return new string[] { "AND", "OR" }; }
            set { }
        }


        public string[] filterOperatorList
        {
            get { return new string[] { "Between", "Equals", "Does Not Equal", "Greather Than", "Greather Than Or Equal To", "Less Than", "Less Than Or Equal To", "Begins With", "Ends With", "Contains", "Does Not Contain" }; }
            set { }
        }


    }
}
