﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

/*AYSEGUL ALBAYRAK,16.06.2014*/
namespace CDSHeatMap.RangeSliderControl
{
    /// <summary>
    /// Interaction logic for RangeSliderControl.xaml
    /// </summary>
    public partial class RangeSliderControl : UserControl
    {
        public RangeSliderControl()
        {
            this.InitializeComponent();
            this.LayoutUpdated += new EventHandler(RangeSlider_LayoutUpdated);
           
        }
        void RangeSlider_LayoutUpdated(object sender, EventArgs e)
        {
            setFinalParams();
        }

        public void setFinalParams() {
            SetLowerValueVisibility();
        }

        public void SetLowerValueVisibility()
        {
            if (DisableLowerValue)
            {
                LowerSlider.Visibility = System.Windows.Visibility.Collapsed;
            }
            else
            {
                LowerSlider.Visibility = System.Windows.Visibility.Visible;
            }
        }

        public double minimum
        {
            get { return (double)GetValue(MinimumProperty); }
            set { SetValue(MinimumProperty, value); }
        }

        public double maximum
        {
            get { return (double)GetValue(MaximumProperty); }
            set { SetValue(MaximumProperty, value); }
        }

        public double lowerValue
        {
            get { return (double)GetValue(LowerValueProperty); }
            set { SetValue(LowerValueProperty, value); }
        }

        public double upperValue
        {
            get { return (double)GetValue(UpperValueProperty); }
            set { SetValue(UpperValueProperty, value); }
        }

        public bool DisableLowerValue
        {
            get { return (bool)GetValue(DisableLowerValueProperty); }
            set { SetValue(DisableLowerValueProperty, value); }
        }


        public string prefix
        {
            get { return (string)GetValue(PrefixProperty); }
            set { SetValue(PrefixProperty, value); }
        }

        public string suffix
        {
            get { return (string)GetValue(SuffixProperty); }
            set { SetValue(SuffixProperty, value); }
        }


        public double tickFrequency
        {
            get { return (double)GetValue(TickFrequencyProperty); }
            set { SetValue(TickFrequencyProperty, value); }
        }


        public event DragCompletedEventHandler DragCompleted;

        private void DragCompleted_1(object sender, DragCompletedEventArgs e)
        {
            if (DragCompleted != null)
                DragCompleted(sender,e);
        }


        public static readonly DependencyProperty MinimumProperty =
            DependencyProperty.Register("minimum", typeof(double), typeof(RangeSliderControl), new UIPropertyMetadata(1d, new PropertyChangedCallback(PropertyChanged)));

        public static readonly DependencyProperty LowerValueProperty =
            DependencyProperty.Register("lowerValue", typeof(double), typeof(RangeSliderControl), new UIPropertyMetadata(10d, new PropertyChangedCallback(PropertyChanged)));

        public static readonly DependencyProperty UpperValueProperty =
            DependencyProperty.Register("upperValue", typeof(double), typeof(RangeSliderControl), new UIPropertyMetadata(40d, new PropertyChangedCallback(PropertyChanged)));

        public static readonly DependencyProperty MaximumProperty =
            DependencyProperty.Register("maximum", typeof(double), typeof(RangeSliderControl), new UIPropertyMetadata(200d, new PropertyChangedCallback(PropertyChanged)));

        public static readonly DependencyProperty DisableLowerValueProperty =
            DependencyProperty.Register("DisableLowerValue", typeof(bool), typeof(RangeSliderControl), new UIPropertyMetadata(false, new PropertyChangedCallback(DisabledLowerValueChanged)));

        public static readonly DependencyProperty PrefixProperty =
        DependencyProperty.Register("prefix", typeof(string), typeof(RangeSliderControl), new UIPropertyMetadata("", new PropertyChangedCallback(PropertyChanged)));

        public static readonly DependencyProperty SuffixProperty =
        DependencyProperty.Register("suffix", typeof(string), typeof(RangeSliderControl), new UIPropertyMetadata("", new PropertyChangedCallback(PropertyChanged)));

        public static readonly DependencyProperty TickFrequencyProperty =
        DependencyProperty.Register("tickFrequency", typeof(double), typeof(RangeSliderControl), new UIPropertyMetadata(1d, new PropertyChangedCallback(PropertyChanged)));



        private static void DisabledLowerValueChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            RangeSliderControl slider = (RangeSliderControl)d;
            slider.SetLowerValueVisibility();
        }

        private static void PropertyChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            RangeSliderControl slider = (RangeSliderControl)d;
           if (e.Property == RangeSliderControl.LowerValueProperty)
            {
                slider.UpperSlider.Value = Math.Max(slider.upperValue, slider.lowerValue);
            }
            else if (e.Property == RangeSliderControl.UpperValueProperty)
            {
                slider.LowerSlider.Value = Math.Min(slider.upperValue, slider.lowerValue);
            }
        }

    
       

    }
}
 