﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading;
using System.Windows;
using System.Windows.Threading;
using Bloomberglp.TerminalApiEx;
using MessageBox = Bloomberglp.AppPortalApi.Desktop.MessageBox;

namespace CDSHeatMap
{
    internal static class TerminalApi
    {
        public static bool IsRegistered;

        public static void RunFunction(string mnemonic, string security, Dispatcher dispatcher)
        {
            ExecuteApiCall(delegate
            {
                BlpTerminal.BeginRunFunction(mnemonic, "1", new string[] { security }, null, (ar) =>
                    dispatcher.BeginInvoke((Action)delegate
                    {
                        try
                        {
                            BlpTerminal.EndRunFunction(ar);
                        }
                        catch (Exception ex)
                        {
                            if (ex.Message.IndexOf("APPLICATION_VALIDATION", StringComparison.OrdinalIgnoreCase) >= 0)
                                MessageBox.Show("Application assembly must have a strong name and assembly public key token has to be registered with Bloomberg in order for application to use the Bloomberg Terminal API. For more information please refer to the Terminal API documentation.", "API Not Enabled", MessageBoxButton.OK, MessageBoxImage.Exclamation);
                            else
                                MessageBox.Show(ex.ToString());

                            Trace.WriteLine(string.Format("Terminal API error: ", ex.Message.ToString()), "ERROR");

                            string stackTrace = "";
                            if (ex.StackTrace != null)
                                stackTrace = ex.StackTrace.ToString();

                            Trace.WriteLine("Terminal API error - Exception Stacktrace: " + stackTrace, "INFO");
                        }
                    }), null);
            }, dispatcher);
        }

        public static void ExecuteApiCall(Action operation, Dispatcher dispatcher)
        {
            lock (typeof(TerminalApi))
            {
                if (IsRegistered)
                {
                    try
                    {
                        operation();
                    }
                    catch (Exception e)
                    {
                        if (e.Message.IndexOf("APPLICATION_VALIDATION", StringComparison.OrdinalIgnoreCase) >= 0)
                            MessageBox.Show("Application assembly must have a strong name and assembly public key token has to be registered with Bloomberg in order for application to use the Bloomberg Terminal API. For more information please refer to the Terminal API documentation.", "API Not Enabled", MessageBoxButton.OK, MessageBoxImage.Exclamation);
                        else
                            System.Windows.MessageBox.Show(e.ToString());

                        Trace.WriteLine(string.Format("Execution Terminal API call error: ", e.Message.ToString()), "ERROR");

                        string stackTrace = "";
                        if (e.StackTrace != null)
                            stackTrace = e.StackTrace.ToString();

                        Trace.WriteLine("Execution Terminal API call error - Exception Stacktrace: " + stackTrace, "INFO");
                    }
                    return;
                }
            }
            BlpApi.BeginRegister((ar) => dispatcher.BeginInvoke((Action)delegate
            {
                try
                {
                    BlpApi.EndRegister(ar);
                    IsRegistered = true;
                    operation();
                }
                catch (Exception e)
                {
                    if (e.Message.IndexOf("public key", StringComparison.OrdinalIgnoreCase) >= 0 || e.Message.IndexOf("strong name", StringComparison.OrdinalIgnoreCase) >= 0 || e.Message.IndexOf("APPLICATION_VALIDATION", StringComparison.OrdinalIgnoreCase) >= 0)
                        MessageBox.Show("Application assembly must have a strong name and assembly public key token has to be registered with Bloomberg in order for application to use the Bloomberg Terminal API. For more information please refer to the Terminal API documentation.", "API Not Enabled", MessageBoxButton.OK, MessageBoxImage.Exclamation);
                    else
                        System.Windows.MessageBox.Show(e.ToString());

                    Trace.WriteLine(string.Format("Execution Terminal API call error while registering: ", e.Message.ToString()), "ERROR");

                    string stackTrace = "";
                    if (e.StackTrace != null)
                        stackTrace = e.StackTrace.ToString();

                    Trace.WriteLine("Execution Terminal API call error while registering - Exception Stacktrace: " + stackTrace, "INFO");
                }
            }, null), null);
        }
    }
}
