﻿using CDSHeatMap.Model;
using CDSHeatMap.Util;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CDSHeatMap.Ticker
{
    /// <summary>
    /// Interaction logic for tickerUserControl.xaml
    /// </summary>
    public partial class TickerUserControl : UserControl
    {
        public TickerUserControl()
        {
            InitializeComponent();
        }

        public event Action<ItemChecked> CheckBox_ItemChecked;

        public ObservableCollection<ContextMenuItem> ContextMenuList { get; set; }

        public double LabelFontSize
        {
            get { return lbl.FontSize; }
            set { lbl.FontSize= value; }

        }

        public Brush LabelFontColor
        {
            get { return lbl.Foreground; }
            set { lbl.Foreground = value; }

        }

        public double LabelWidth 
        {
            get { return lbl.Width; }
            set { lbl.Width = value; }

        }

        public double TickerWidth {

            get { return this.Width; }
            set 
            { 
                this.Width = value;
                lbl.Width = this.Width - 30;
                stkpnl1.Width = this.Width - (chcbx.Width + 60);
            }
        
        }

        /*Aysegul Albayrak,29.12.2014,ticker background*/
        public Brush BorderBackground
        {
            get { return brdr.Background; }
            set { brdr.Background = value; }

        }

        public bool IsChecked
        {
            get { return chcbx.IsChecked.Value; }
            set { chcbx.IsChecked = value; }

        }



        public object Value
        {
            get { return lbl.Content; }
            set { lbl.Content = value; }

        }



        public void addContextMenuItem()
        {
            cntxMenu.ItemsSource = ContextMenuList;
        }

        private void chcbx_Click_1(object sender, RoutedEventArgs e)
        {
            if (CheckBox_ItemChecked != null)
                CheckBox_ItemChecked(new ItemChecked((Value ?? "").ToString(), IsChecked));
        }

        private void lbl_Click_1(object sender, RoutedEventArgs e)
        {
            IsChecked = !IsChecked;

            if (CheckBox_ItemChecked != null)
                CheckBox_ItemChecked(new ItemChecked((Value ?? "").ToString(), IsChecked));
        }

    }

   

}
