﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CDSHeatMap.Util
{
    public class CheckPoint
    {
        private static readonly DateTime Jan1st1970 = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc);

        public static long CurrentTimeMillis()
        {
            return (long)(DateTime.UtcNow - Jan1st1970).TotalMilliseconds;
        }

        long enterTime = 0;
        long exitTime = 0;

        public CheckPoint()
        {
            enter();
        }

        public void enter()
        {
            this.enterTime = CurrentTimeMillis();
            this.exitTime = this.enterTime;
        }

        public void reset()
        {
            this.enterTime = 0;
            this.exitTime = 0;
        }

        public long exit()
        {
            this.exitTime = CurrentTimeMillis();
            return getElapsedTimeInMilis();
        }

        public long getElapsedTimeInMilis()
        {
            return exitTime - enterTime;
        }

        public int getElapsedTimeInSeconds()
        {
            return (int)(getElapsedTimeInMilis() / 1000L);
        }

        public int getElapsedTimeInMinutes()
        {
            return (int)(getElapsedTimeInSeconds() / 60L);
        }

        public String getElapsedTime()
        {
            int seconds = getElapsedTimeInSeconds();

            int mininutesPart = seconds / 60;
            int secondsPart = seconds % 60;

            String minutesPartString = mininutesPart < 10 ? String.Format("0{0}", mininutesPart) : ""
                    + mininutesPart;
            String secondsPartString = secondsPart < 10 ? "0" + secondsPart : String.Format("{0}", secondsPart);

            return String.Format("{0}:{1}", minutesPartString, secondsPartString);
        }

    }
}
