﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CDSHeatMap.Model;

namespace CDSHeatMap.Util
{
    public static class ConstantItemList
    {
        public static string BaseCurrency = "USD";
        public static string FXBloombergSuffix = " Curncy";

        public static List<string> CDSIndexGENList = new List<string> { "CDX IG CDSI GEN 5Y Corp", "CDX HY CDSI GEN 5Y Corp", "CDX IG HVOL CDSI GEN 5Y Corp",
                                                                        "CDX HY B CDSI GEN 5Y PRC Corp", "CDX HY BB CDSI GEN 5Y Corp",
                                                                        "ITRX EUR CDSI GEN 5Y Corp", "ITRX XOVER CDSI GEN 5Y Corp",
                                                                        "ITRX EXJP IG CDSI GEN 5Y Corp", "ITRX JAPAN CDSI GEN 5Y Corp", "ITRX AUS CDSI GEN 5Y Corp"};

        public static List<string> EquityIndexList = new List<string> { "SPX Index", "NDX Index", "INDU Index", 
                                                                        "SXXP Index", "UKX Index", "DAX Index", "CAC Index", "IBEX Index", "XU100 Index", 
                                                                        "NKY Index", "HSI Index", "AS51 Index" };

        public static string REGION_US = "U.S.";
        public static string REGION_EU = "Europe";
        public static string REGION_AA = "Asia & Australia";

        public static Dictionary<string, string> IndexRegionDict = new Dictionary<string, string> {{"CDX", REGION_US}, {"SPX Index", REGION_US}, {"NDX Index", REGION_US}, {"INDU Index", REGION_US},
            {"ITRX EUR", REGION_EU}, {"ITRX XOVER", REGION_EU}, {"SXXP Index", REGION_EU}, {"UKX Index", REGION_EU}, {"DAX Index", REGION_EU}, 
            {"CAC Index", REGION_EU}, {"IBEX Index", REGION_EU}, {"XU100 Index", REGION_EU},
            {"ITRX EXJP", REGION_AA}, {"ITRX JAPAN", REGION_AA}, {"ITRX AUS", REGION_AA}, {"NKY Index", REGION_AA}, {"HSI Index", REGION_AA}, {"AS51 Index", REGION_AA}
        };



        public static List<string> CDSPricingSourceList = new List<string> { "Default", "CMAN", "CBGN", "CBGL", "CBGT" };

        public const int CDSSPREAD_NUMBER = 7;
        public static readonly List<int> CDSMaturityList = new List<int> { 1, 2, 3, 4, 5, 7, 10 };

        public const string PMTICKERFILTERLIST = "TickerFilter";
        public const string PMAPPLASTPARAMS = "AppLastParams";

        public static readonly Dictionary<string, string> MoodysRatingScale = new Dictionary<string, string>
        {
            {"Aaa", "Aaa"},
            {"Aa1", "Aa1-Aa3"}, {"Aa2", "Aa1-Aa3"}, {"Aa3", "Aa1-Aa3"},
            {"A1", "A1-A3"}, {"A2", "A1-A3"}, {"A3", "A1-A3"},
            {"Baa1", "Baa1-Baa3"}, {"Baa2", "Baa1-Baa3"}, {"Baa3", "Baa1-Baa3"},
            {"Ba1", "Ba1-Ba3"}, {"Ba2", "Ba1-Ba3"}, {"Ba3", "Ba1-Ba3"},
            {"B1", "B1-B3"}, {"B2", "B1-B3"}, {"B3", "B1-B3"},
            {"Caa1", "Caa1-Caa3"}, {"Caa2", "Caa1-Caa3"}, {"Caa3", "Caa1-Caa3"},
            {"Ca", "Ca-C"}, {"C", "Ca-C"}, 
            {"WR", "WR"}, 
            {MOODYSNAV, MOODYSNAV} 
        };

        public static List<string> SelDataDisplayList = new List<string> { "Price Chg YTD", "5Y CDS Spread", "10Y CDS Spread", "3Y/5Y Curve", "5Y/10Y Curve", 
                                                                            "P/E", "Dividend Yield", "Debt O/S", "Debt/Equity", "EV/EBITDA" };


        public static List<string> FirstByList = new List<string> { INDUSTRY, MOODYSRATING, EXPECTED_EARNINGS_RD, SHORT_INTEREST_EF, CDS_SPREAD_5Y, YTD_5Y_CDS_SPREAD_CHG, PE_RATIO, PRICE_SALES_RATIO, 
                                                                    MARKET_CAPITAL, YTD_EQUITY_CHG, EQUITY_BETA, EBITDA, TOTAL_DEBT_COMMON_EQ, INTEREST_COVERAGE_RATIO, HIST_CALL_IMPL_VOL, NONE };

        public static List<string> ThenByList = new List<string> { MOODYSRATING, EXPECTED_EARNINGS_RD, SHORT_INTEREST_EF, CDS_SPREAD_5Y, YTD_5Y_CDS_SPREAD_CHG, PE_RATIO, MARKET_CAPITAL, 
                                                                   YTD_EQUITY_CHG, PRICE_SALES_RATIO, EQUITY_BETA, EBITDA, TOTAL_DEBT_COMMON_EQ, INTEREST_COVERAGE_RATIO, HIST_CALL_IMPL_VOL, NONE };

        public static List<string> RectSizeList = new List<string> { MARKET_CAPITAL, CDS_SPREAD_5Y, HIST_CALL_IMPL_VOL, TOTAL_DEBT, TOTAL_ASSETS, ENTERPRISE_VALUE, EQUAL_SIZE };

        public const string INDUSTRY = "Industry";
        public const string MOODYSRATING = "Moody's Rating";
        public const string EXPECTED_EARNINGS_RD = "Expected Earnings Report Date";
        public const string SHORT_INTEREST_EF = "Short Interest (% of Equity Float)";
        public const string CDS_SPREAD_5Y = "5Y CDS Spread";
        public const string YTD_5Y_CDS_SPREAD_CHG = "% YTD 5Y CDS Spread Change";
        public const string PE_RATIO = "P/E Ratio";
        public const string PRICE_SALES_RATIO = "Price to Sales Ratio";
        public const string MARKET_CAPITAL = "Market Capital";
        public const string YTD_EQUITY_CHG = "% YTD Equity Change";
        public const string EQUITY_BETA = "Equity Beta";
        public const string EBITDA = "EBITDA";
        public const string TOTAL_DEBT_COMMON_EQ = "Total Debt to Common Equity";
        public const string INTEREST_COVERAGE_RATIO = "Interest Coverage Ratio";
        public const string HIST_CALL_IMPL_VOL = "Historical Call Implied Volatility";
        public const string VOL_MEAN = "Volatility Mean";
        public const string NONE = "NONE";
        public const string TOTAL_DEBT = "Total Debt";
        public const string TOTAL_ASSETS = "Total Assets";
        public const string ENTERPRISE_VALUE = "Enterprise Value";
        public const string EQUAL_SIZE = "Equal Size";

        public static List<string> RectColorList = new List<string> { SHARE_PRICE_CHG, CDS_PRICE_5Y_CHG, CDS_PRICE_1Y_CHG, CDS_PRICE_2Y_CHG, CDS_PRICE_10Y_CHG, VOLUME_CHG_5D_20D, SALES_1Y_GROWTH, HIST_CALL_IMPL_VOL };
        public static List<string> CircleColorList = new List<string> { CDS_PRICE_5Y_CHG, CDS_PRICE_1Y_CHG, CDS_PRICE_2Y_CHG, CDS_PRICE_10Y_CHG, SHARE_PRICE_CHG, VOLUME_CHG_5D_20D, SALES_1Y_GROWTH, HIST_CALL_IMPL_VOL, NONE };
        public static List<string> DonutChartList = new List<string> { HIST_CALL_IMPL_VOL, VOL_MEAN, NONE };
        public const string SHARE_PRICE_CHG = "% Share Price Change";
        public const string CDS_PRICE_5Y_CHG = "%5Y CDS Spread Change";
        public const string CDS_PRICE_1Y_CHG = "%1Y CDS Spread Change";
        public const string CDS_PRICE_2Y_CHG = "%2Y CDS Spread Change";
        public const string CDS_PRICE_10Y_CHG = "%10Y CDS Spread Change";
        public const string VOLUME_CHG_5D_20D = "% Volume Change 5day VS 20day";
        public const string SALES_1Y_GROWTH = "% Sales 1y Growth";

        public static List<string> HighlighterList = new List<string> { };

        public const string NOTAVAILABLE = "NotAV";
        public const string MOODYSNAV = "NoData";
        public const string FirstNOTAVAILABLE = "FirstNotAV";

        public const string NONEHeader = "";

        public const string TODAY = "Today";
        public const string TOMORROW = "Tomorrow";
        public const string THISWEEK = "This Week";
        public const string NEXTWEEK = "Next Week";
        public const string THISMONTH = "This Month";
        public const string NEXTMONTH = "Next Month";
        public const string WITHIN60D = "Within 60 Days";
        public const string WITHIN90D = "Within 90 Days";
        public const string LATER90D = "LATER 90 Days";

        public const int MAXHEATMAPGROUP = 10;
        public const int MAXHEATMAPSUBGROUP = 5;

        public static Dictionary<string, bool> GreenColorList = new Dictionary<string, bool> { {SHARE_PRICE_CHG, true}, {CDS_PRICE_5Y_CHG, false}, {CDS_PRICE_1Y_CHG, false}, 
                                                                                               {CDS_PRICE_2Y_CHG, false}, {CDS_PRICE_10Y_CHG, false}, {VOLUME_CHG_5D_20D, true},
                                                                                               {SALES_1Y_GROWTH, true}, {NONE, true} };

        //Quick Filter Item 

        public static string MAIN_PRICE = "Price";
        public static string MAIN_MARKETCAP = "Market Cap";
        public static string MAIN_EARNINGS = "Earnings";
        public static string MAIN_EMPLOYEES = "Employees";
        public static string MAIN_INSTITUTIONALHOLDINGS = "Institutional Holdings";
        public static string MAIN_ISSUERATIOS = "Issue Ratios";
        public static string MAIN_PERSHARERATIOS = "Per Share Ratios";
        public static string MAIN_CASHFLOWANALYSIS = "Cashflow Analysis";
        public static string MAIN_GROWTHPOTENTIAL = "Growth Potential";
        public static string MAIN_PROFITABILITY = "Profitability";
        public static string MAIN_STRUCTURE = "Structure";
        public static string MAIN_CREDITFUNDAMENTALS = "Credit Fundamentals";
        public static string MAIN_FINANCIALFIRMSPECIFIC = "Financial Firms Specific";

        public static List<string> SUB_PRICE = new List<string> { "Price", "Change 1 Day Percent", "Change Year To Date Percent", "52 Week High Change Percent", "52 Week Low Change Percent", 
                                                                   "Change Percent Between User Set Dates", "Total Return 1 Year Pct", "Beta" };
        public static List<string> SUB_MARKETCAP = new List<string> { "Current Market Cap", "Current Shares Outstanding", "Equity Float", "Free Float Percent", "Short Interest",
                                                                       "Short Interest Percent of Equity Float", "Days to Cover (Short Interest Ratio)"};
        public static List<string> SUB_EARNINGS = new List<string> { "Price Earnings Ratio (P/E)", "Expected Earnings Report Date", "Est P/E Current Year", "Est P/E", "Est P/E Date",
                                                                      "Est PEG", "EPS - 1 Yr Growth", "Dividend Indicated Yld - Gross", "Dividend Net 5yr Growth Rate"};
        public static List<string> SUB_EMPLOYEES = new List<string> { "Current Number of Employees", "Employees - 1 Year Growth", "Employees 5 Year Growth" };
        public static List<string> SUB_INSTITUTIONALHOLDINGS = new List<string> { "Instit Owner # of Holders", "Instit Owner % Shares Out", "% Held by Insiders", "Percent Change in Insider Holdings 6M" };
        public static List<string> SUB_ISSUERATIOS = new List<string> { "Dividend Indicated Yld - Net", "Price to Book Ratio", "Price to Sales Ratio", "Current EV to Trailing 12M EBITDA",
                                                                        "Periodic EV to Trailing 12M EBITDA", "Current Enterprise Value"};
        public static List<string> SUB_PERSHARERATIOS = new List<string> { "Earnings Per Share (Trailing 12M)", "Earnings Per Share (Trailing 12M) / Share Price", "Dividends per Share",
                                                                            "Dividends per Share/Share Price", "Book Value per Share", "Book Value per Share/Share Price", "Book Value per Share - 1 Yr Growth",
                                                                            "Revenue per Share", "Cash Flow per Share", "Free Cash Flow/Basic Shr", "Free Cash Flow Per Share - 1 Yr Growth"};
        public static List<string> SUB_CASHFLOWANALYSIS = new List<string> { "Price/Cash Flow", "Current Price to Free Cash Flow", "Cash Flow to Net Income", "Dividend Payout Ratio",
                                                                             "Cash Generated to Cash Required", "Cash Dividend Coverage", "Cash from Operations to Sales", "Effective Interest Rate"};
        public static List<string> SUB_GROWTHPOTENTIAL = new List<string> { "Diluted EPS from Continuing Ops - 1 Yr Growth", "Capital - 1 Year Growth", "Book Value per Share - 1 Yr Growth",
                                                                            "R & D Expenditure to Net Sales", "Retention Ratio", "Sales - 1 Year Growth", "Employees - 1 Year Growth", "Assets - 1 Year Growth"};
        public static List<string> SUB_PROFITABILITY = new List<string> { "EBITDA", "Operating Margin", "Pre-Tax Margin", "EBITDA to Revenue", "Trailing 12M EBITDA Margin", "EBITDA Margin 3 Yr Average", 
                                                                          "EBITDA - 1 Yr Growth", "Return on Assets", "Return on Common Equity", "Return on Capital", "Asset Turnover" };
        public static List<string> SUB_STRUCTURE = new List<string> { "Current Ratio", "Quick Ratio", "Total Debt to Total Assets", "Total Debt to Common Equity", "Accounts Receivable Turnover", 
                                                                      "Inventory Turnover", "Gross Margin", "EBIT/Total Interest Expenses", "EV/This Year Est EBITDA" };
        public static List<string> SUB_CREDITFUNDAMENTALS = new List<string> { "Total Debt", "Net Debt", "Enterprise Value", "EV to Trailing 12M EBITDA", "Long Term Borrowings", "Short Term Borrowings",
                                                                                "Cashflow To Interest Expense", "EBITDA", "Interest Expense", "Net Income", "Cash From Operations", "Capital Expenditures",
                                                                                "Net Sales (Trailing 12M)", "Total Debt to EBITDA", "Total Assets", "Total Capital", "Total Debt to Total Assets", "Total Debt to Total Capital",
                                                                                "Debt Distribution Amount Outstanding", "Long Term Debt to Total Capital", "Long Term Debt to Total Assets", "Total Debt per Share",
                                                                                "Long Term Debt to Total Equity", "Total Debt to Earnings before Interest Taxes", "Tot Amount Outstanding on Bonds to Tot Debt Ratio",
                                                                                "Total Debt and Preferred Equity to Total Capital", "Total Debt to Total Equity", "Net Debt To Shareholders Equity",
                                                                                "Long Term Debt to Common Equity", "Long Term Debt to Total Equity", "LT Debt and Preferred Equity to Total Capital",
                                                                                "Preferred Equity", "Total Debt and Preferred Equity", "Net Debt To Shareholders Equity", "Total Shareholders Equity",
                                                                                "Free Cash Flow", "Free Cash Flow to Interest Expense", "EBIT", "Total Interest Expense", "EBITDA to Tot Int Exp", "Int Expenses to Tot Debts" };
        public static List<string> SUB_FINANCIALFIRMSPECIFIC = new List<string> { "Book Value of Equity", "Total Deposits", "Total Loans","Net Revenue", "Net Revenue Growth %, YoY", "Profit", 
                                                                                  "Profit Margin %", "Operating Income", "Operating Income Margin %", "Net Income Before XO", "Net Income Margin %",
                                                                                  "Adjusted EPS", "Adjusted EPS Growth %, YoY", "Tier 1 Common Eqty %", "Tier 1 Capital Ratio %", "Total Capital Ratio %" };

        public static Dictionary<string, List<string>> QuickFilterItemList = new Dictionary<string, List<string>> { 
        {MAIN_PRICE, SUB_PRICE}, {MAIN_MARKETCAP, SUB_MARKETCAP}, {MAIN_EARNINGS, SUB_EARNINGS}, {MAIN_EMPLOYEES, SUB_EMPLOYEES}, {MAIN_INSTITUTIONALHOLDINGS, SUB_INSTITUTIONALHOLDINGS},
        {MAIN_ISSUERATIOS, SUB_ISSUERATIOS}, {MAIN_PERSHARERATIOS, SUB_PERSHARERATIOS}, {MAIN_CASHFLOWANALYSIS, SUB_CASHFLOWANALYSIS}, {MAIN_GROWTHPOTENTIAL, SUB_GROWTHPOTENTIAL}, 
        {MAIN_PROFITABILITY, SUB_PROFITABILITY}, {MAIN_STRUCTURE, SUB_STRUCTURE}, {MAIN_CREDITFUNDAMENTALS, SUB_CREDITFUNDAMENTALS}, {MAIN_FINANCIALFIRMSPECIFIC, SUB_FINANCIALFIRMSPECIFIC}
        };


        public static Dictionary<string, string> QuickFilterFieldList = new Dictionary<string, string> {
            {"Price", "LAST_PRICE"}, {"Change 1 Day Percent", "CHG_PCT_1D"}, {"Change Year To Date Percent", "CHG_PCT_YTD"}, {"52 Week High Change Percent", "CHG_PCT_HIGH_52WEEK"},  
            {"52 Week Low Change Percent", "CHG_PCT_LOW_52WEEK"}, {"Change Percent Between User Set Dates", "CALCULATED"}, {"Total Return 1 Year Pct", "EQY_TRR_PCT_1YR"}, {"Beta", "EQY_BETA"}, 
            {"Current Market Cap", "CUR_MKT_CAP"}, {"Current Shares Outstanding", "EQY_SH_OUT"}, {"Equity Float", "EQY_FLOAT"}, {"Free Float Percent", "EQY_FREE_FLOAT_PCT"},
            {"Short Interest", "SHORT_INT"}, {"Short Interest Percent of Equity Float", "SI_PERCENT_EQUITY_FLOAT"}, {"Days to Cover (Short Interest Ratio)", "SHORT_INT_RATIO"},
            {"Price Earnings Ratio (P/E)", "PE_RATIO"},{"Expected Earnings Report Date", "EXPECTED_REPORT_DT"}, {"Est P/E Current Year", "BEST_PE_RATIO"}, {"Est P/E", "BEST_PE_CUR_YR"},
            {"Est P/E Date", "BEST_CUR_FISCAL_YEAR_PERIOD"}, {"Est PEG", "BEST_EPEG_RATIO"}, {"EPS - 1 Yr Growth", "EPS_GROWTH"}, {"Dividend Indicated Yld - Gross", "EQY_DVD_YLD_IND"},
            {"Dividend Net 5yr Growth Rate", "EQY_DPS_NET_5YR_GROWTH"}, {"Current Number of Employees", "CUR_EMPLOYEES"}, {"Employees - 1 Year Growth", "EMPL_GROWTH"},
            {"Employees 5 Year Growth", "EMPLOYEES_5_YEAR_GROWTH"}, {"Instit Owner # of Holders", "EQY_INST_HOLD"}, {"Instit Owner % Shares Out", "EQY_INST_PCT_SH_OUT"},
            {"% Held by Insiders", "PCT_INSIDER_SHARES_OUT"}, {"Percent Change in Insider Holdings 6M", "PCT_CHG_INSIDER_HOLDINGS"}, {"Dividend Indicated Yld - Net", "EQY_DVD_YLD_IND_NET"},
            {"Price to Book Ratio", "PX_TO_BOOK_RATIO"}, {"Price to Sales Ratio", "PX_TO_SALES_RATIO"}, {"Current EV to Trailing 12M EBITDA", "CURRENT_EV_TO_T12M_EBITDA"},
            {"Periodic EV to Trailing 12M EBITDA", "EV_TO_T12M_EBITDA"}, {"Current Enterprise Value", "CURR_ENTP_VAL"}, {"Earnings Per Share (Trailing 12M)", "TRAIL_12M_EPS"},
            {"Earnings Per Share (Trailing 12M) / Share Price", "CALCULATED=TRAIL_12M_EPS/LAST_PRICE"}, {"Dividends per Share", "EQY_DPS"}, {"Dividends per Share/Share Price", "CALCULATED=EQY_DPS/LAST_PRICE"},
            {"Book Value per Share", "BOOK_VAL_PER_SH"}, {"Book Value per Share/Share Price", "CALCULATED=BOOK_VAL_PER_SH/LAST_PRICE"}, {"Book Value per Share - 1 Yr Growth", "BVPS_GROWTH"},
            {"Revenue per Share", "REVENUE_PER_SH"}, {"Cash Flow per Share", "CASH_FLOW_PER_SH"}, {"Free Cash Flow/Basic Shr", "FREE_CASH_FLOW_PER_SH"}, {"Free Cash Flow Per Share - 1 Yr Growth", "FREE_CASH_FLOW_PER_SH_GROWTH"},
            {"Price/Cash Flow", "PX_TO_CASH_FLOW"}, {"Current Price to Free Cash Flow", "CURRENT_PX_TO_FREE_CASH_FLOW"},  {"Cash Flow to Net Income", "CASH_FLOW_TO_NET_INC"}, 
            {"Dividend Payout Ratio", "DVD_PAYOUT_RATIO"}, {"Cash Generated to Cash Required", "CASH_GEN_TO_CASH_REQ"}, {"Cash Dividend Coverage", "CASH_DVD_COVERAGE"}, {"Cash from Operations to Sales", "CFO_TO_SALES"}, 
            {"Effective Interest Rate", "EFF_INT_RATE"}, {"Diluted EPS from Continuing Ops - 1 Yr Growth", "RR_DIL_EPS_CONT_OPS_GROWTH"}, {"Capital - 1 Year Growth", "GROWTH_IN_CAP"},
            {"R & D Expenditure to Net Sales", "RD_EXPEND_TO_NET_SALES"}, {"Retention Ratio", "RETENTION_RATIO"}, {"Sales - 1 Year Growth", "SALES_GROWTH"},
            {"Assets - 1 Year Growth", "ASSET_GROWTH"}, {"EBITDA", "EBITDA"}, {"Operating Margin", "OPER_MARGIN"}, {"Pre-Tax Margin", "PRETAX_MARGIN"},
            {"EBITDA to Revenue", "EBITDA_TO_REVENUE"}, {"Trailing 12M EBITDA Margin", "EBITDA_MARGIN"}, {"EBITDA Margin 3 Yr Average", "EBITDA_MARGIN_3YR_AVG"}, {"EBITDA - 1 Yr Growth", "EBITDA_GROWTH"},
            {"Return on Assets", "RETURN_ON_ASSET"}, {"Return on Common Equity", "RETURN_COM_EQY"}, {"Return on Capital", "RETURN_ON_CAP"}, {"Asset Turnover", "ASSET_TURNOVER"}, {"Current Ratio", "CUR_RATIO"}, 
            {"Quick Ratio", "QUICK_RATIO"}, {"Total Debt to Total Assets", "TOT_DEBT_TO_TOT_ASSET"}, {"Total Debt to Common Equity", "TOT_DEBT_TO_COM_EQY"}, {"Accounts Receivable Turnover", "ACCT_RCV_TURN"}, 
            {"Inventory Turnover", "INVENT_TURN"}, {"Gross Margin", "GROSS_MARGIN"}, {"EBIT/Total Interest Expenses", "INTEREST_COVERAGE_RATIO"}, {"EV/This Year Est EBITDA", "EST_EV_THIS_YR_EBITDA"},
            {"Total Debt", "SHORT_AND_LONG_TERM_DEBT"}, {"Net Debt", "NET_DEBT"}, {"Enterprise Value", "ENTERPRISE_VALUE"}, {"EV to Trailing 12M EBITDA", "EV_TO_T12M_EBITDA"}, {"Long Term Borrowings", "BS_LT_BORROW"},
            {"Short Term Borrowings", "BS_ST_BORROW"}, {"Cashflow To Interest Expense", "CASH_FLOW_TO_INT_EXPENSE"}, {"Interest Expense", "IS_INT_EXPENSE"}, {"Net Income", "NET_INCOME"},
            {"Cash From Operations", "CF_CASH_FROM_OPER"}, {"Capital Expenditures", "CAPITAL_EXPEND"}, {"Net Sales (Trailing 12M)", "TRAIL_12M_NET_SALES"}, {"Total Debt to EBITDA", "TOT_DEBT_TO_EBITDA"},
            {"Total Assets", "BS_TOT_ASSET"}, {"Total Capital", "BS_TOT_CAP"},   {"Total Debt to Total Capital", "TOT_DEBT_TO_TOT_CAP"},
            {"Debt Distribution Amount Outstanding", "DDIS_AMT_OUTSTANDING"}, {"Long Term Debt to Total Capital", "LT_DEBT_TO_TOT_CAP"}, {"Long Term Debt to Total Assets", "LT_DEBT_TO_TOT_ASSET"},
            {"Total Debt per Share", "TOTAL_DEBT_PER_SHARE"}, {"Long Term Debt to Total Equity", "LT_DEBT_TO_TOT_EQY"}, {"Total Debt to Earnings before Interest Taxes", "TOTAL_DEBT_TO_EBIT"},
            {"Tot Amount Outstanding on Bonds to Tot Debt Ratio", "BOND_TO_TOTAL_DEBT"}, {"Total Debt and Preferred Equity to Total Capital ", "TOT_DEBT_&_PFD_EQTY_TO_TOT_CPTL"},
            {"Total Debt to Total Equity", "TOT_DEBT_TO_TOT_EQY"}, {"Net Debt To Shareholders Equity", "NET_DEBT_TO_SHRHLDR_EQTY"}, {"Long Term Debt to Common Equity", "LT_DEBT_TO_COM_EQY"},
            {"LT Debt and Preferred Equity to Total Capital", "LT_DEBT_&_PFD_EQTY_TO_TOT_CPTL"}, {"Preferred Equity", "BS_PFD_EQY"},
            {"Total Debt and Preferred Equity", "TOTAL_DEBT_AND_PREFERRED_EQUITY"}, {"Total Shareholders Equity", "TOTAL_EQUITY"},
            {"Free Cash Flow", "CF_FREE_CASH_FLOW"}, {"Free Cash Flow to Interest Expense", "FCF_TO_INTEREST_EXPENSE"}, {"EBIT", "EBIT"}, {"Total Interest Expense", "TOT_INT_EXP"},
            {"EBITDA to Tot Int Exp", "EBITDA_TO_TOT_INT_EXP"}, {"Int Expenses to Tot Debts", "INT_EXP_TO_TOT_DEBT"}, {"Book Value of Equity", "TOT_COMMON_EQY"}, {"Total Deposits", "BS_CUSTOMER_DEPOSITS"},
            {"Total Loans", "BS_TOT_LOAN"}, {"Net Revenue", "NET_REV"}, {"Net Revenue Growth %, YoY", "NET_REV_GROWTH"}, {"Profit", "PRETAX_PRE-PROVISION_PROFIT"}, {"Profit Margin %", "PRETX_PREPROV_PROF_TO_NET_REV"},
            {"Operating Income", "IS_OPER_INC"}, {"Operating Income Margin %", "OPER_MARGIN"}, {"Net Income Before XO", "IS_INC_BEF_XO_ITEM"}, {"Net Income Margin %", "INC_BEF_XO_ITEMS_TO_NET_SALES"},
            {"Adjusted EPS", "IS_COMP_EPS_ADJUSTED"}, {"Adjusted EPS Growth %, YoY", "ESTIMATE_COMP_EPS_ADJ_GRWTH"}, {"Tier 1 Common Eqty %", "BS_TIER1_COM_EQUITY_RATIO"},
            {"Tier 1 Capital Ratio %", "BS_TIER1_CAP_RATIO"}, {"Total Capital Ratio %", "BS_TOT_CAP_TO_RISK_BASE_CAP"}
        };


        public static int[,] GreenColorValues = { { 255, 255, 255 }, { 237, 246, 235 }, { 223, 239, 218 }, { 208, 232, 202 }, { 194, 225, 186 }, { 180, 219, 171 }, { 165, 212, 156 }, { 150, 206, 142 }, 
                                                  { 135, 201, 128 }, { 121, 195, 112 }, { 104, 190, 97 }, { 86, 186, 84 }, { 61, 181, 74 }, { 56, 174, 74 }, { 50, 168, 74 }, { 43, 162, 74 }, 
                                                  { 35, 157, 74 },  { 27, 151, 74 }, { 13, 146, 73 }, { 0, 141, 73 }, { 0, 136, 73 },  { 0, 131, 72 },  { 0, 126, 72 }, { 0, 121, 71 }, { 0, 116, 71 }};


        public static int[,] RedColorValues = { { 255, 255, 255 }, { 251, 234, 227 }, { 247, 217, 205 }, { 244, 201, 185 }, { 241, 184, 166 }, { 238, 168, 147 }, { 235, 153, 130 }, { 232, 138, 115 }, 
                                                { 229, 123, 101 }, { 227, 108, 87 }, { 224, 92, 74 }, { 222, 74, 61 }, { 219, 52, 50 }, { 214, 49, 47}, { 210, 46, 45 }, { 205, 43, 42 }, { 201, 40, 40 },
                                                { 197, 37, 37 }, { 192, 34, 34 }, { 188, 31, 32 }, { 183, 28, 29 }, { 178, 25, 27 }, { 174, 21, 24 }, { 169, 18, 21 }, { 165, 13, 18 }};
    }

    public enum ShowChangeRateClass
    {
        YTD,
        WEEK52,
        CLOSE,
        DAY1,
        CUSTOM
    }

    public enum CDSSpreadMaturity
    {
        CDSSPREAD1Y,
        CDSSPREAD2Y,
        CDSSPREAD3Y,
        CDSSPREAD4Y,
        CDSSPREAD5Y,
        CDSSPREAD7Y,
        CDSSPREAD10Y
    }

    public enum CDSCurveFilter
    {
        CURVE_1Y5Y,
        CURVE_2Y5Y,
        CURVE_3Y5Y,
        CURVE_5Y7Y,
        CURVE_5Y10Y
    }

}
