﻿using System;
using System.Globalization;
using System.Windows.Data;

namespace CDSHeatMap.Util
{
    public class DataFormatter : IValueConverter
    {
        // IFormatProvider.GetFormat implementation. 
        public object GetFormat(Type formatType)
        {
            // Determine whether custom formatting object is requested. 
            if (formatType == typeof(ICustomFormatter))
                return this;
            else
                return null;
        }

        public string ConvertToolTip(object value)
        {
            /*usage
            <TextBlock Text="{Binding Path=Id, Converter={StaticResource formatter}, ConverterParameter='Sale No:\{0\} '}" />
            <TextBlock Text="{Binding Path=Amount, Converter={StaticResource formatter}, ConverterParameter=' \{0:C\}'}" FontWeight="Bold" />
            <TextBlock Text="{Binding Path=SalesTaxPercentage, Converter={StaticResource formatter}, ConverterParameter=' (\{0:P\} Sales Tax)'}" />
            <TextBlock Text="{Binding Path=TimeOfSale, Converter={StaticResource formatter}, ConverterParameter=' \{0:dd-MMM-yyyy hh:mm\}'}" /> 
             */

            try
            {
                if(value == null)
                    return "";

                if (value is double)
                {
                    double num = (double)value;

                    if (num >= 10000000000.0)
                        return (num / 1000000000.0).ToString("#.##") + "B";

                    else if (num >= 1000000000.0)
                        return (num / 1000000000.0).ToString("#.##") + "B";

                    else if (num >= 1000000.0)
                        return (num / 1000000.0).ToString("#.##") + "M";

                    else if (num >= 10000.0)
                        return (num / 1000.0).ToString("#.##") + "K";

                    else if (num >= 1000.0)
                        return (num / 1000.0).ToString("#.##") + "K";

                    else if (num >= 10.0)
                        return (num).ToString("#.##");

                    else if (num >= 1.0)
                        return (num).ToString("#.##");

                    else if (num < 1.0)
                        return (num).ToString("0.##");

                    else
                        return num.ToString("#.##");
                }
                else if(value is string)
                {
                    string stringVal = (string)value;
                    double doubleVal;

                    double.TryParse(stringVal, out doubleVal);

                    if (doubleVal != 0)
                    {
                        return ConvertToolTip(doubleVal);
                    }
                    else
                        return value.ToString();

               }
                else
                {
                    return value.ToString();
                    /*
                    try
                    {
                        return HandleOtherFormats(format, arg);
                    }
                    catch (FormatException e)
                    {
                        throw new FormatException(String.Format("The format of '{0}' is invalid.", format), e);
                    }
                     */
                }
            }
            catch
            {
                return value.ToString();
            }
        }


        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            /*usage
            <TextBlock Text="{Binding Path=Id, Converter={StaticResource formatter}, ConverterParameter='Sale No:\{0\} '}" />
            <TextBlock Text="{Binding Path=Amount, Converter={StaticResource formatter}, ConverterParameter=' \{0:C\}'}" FontWeight="Bold" />
            <TextBlock Text="{Binding Path=SalesTaxPercentage, Converter={StaticResource formatter}, ConverterParameter=' (\{0:P\} Sales Tax)'}" />
            <TextBlock Text="{Binding Path=TimeOfSale, Converter={StaticResource formatter}, ConverterParameter=' \{0:dd-MMM-yyyy hh:mm\}'}" /> 
             */

            try
            {

                string formatString = parameter as string;

                if (value is double)
                {
                    double num = (double)value;

                    if (num >= 10000000000.0)
                        return (num / 1000000000.0).ToString("#") + "B";

                    else if (num >= 1000000000.0)
                        return (num / 1000000000.0).ToString("#.#") + "B";

                    else if (num >= 1000000.0)
                        return (num / 1000000.0).ToString("#") + "M";

                    else if (num >= 10000.0)
                        return (num / 1000.0).ToString("#") + "K";

                    else if (num >= 1000.0)
                        return (num / 1000.0).ToString("#.#") + "K";

                    else if (num >= 10.0)
                        return (num).ToString("#");

                    else if (num >= 1.0)
                        return (num).ToString("#.##");

                    else if (num < 1.0)
                        return (num).ToString("0.##");

                    else
                        return num.ToString("#.##");
                }
                else if (formatString != null)
                {
                    return string.Format(culture, formatString, value);
                }
                else
                {
                    return value.ToString();
                    /*
                    try
                    {
                        return HandleOtherFormats(format, arg);
                    }
                    catch (FormatException e)
                    {
                        throw new FormatException(String.Format("The format of '{0}' is invalid.", format), e);
                    }
                     */
                }
            }
            catch {
                return value.ToString();
            }
        }

        private string HandleOtherFormats(string format, object arg)
        {
            if (arg is IFormattable)
                return ((IFormattable)arg).ToString(format, CultureInfo.CurrentCulture);
            else if (arg != null)
                return arg.ToString();
            else
                return String.Empty;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            return null;
        }
    }

    public class MultiBindingFormatter : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            string val="";

            switch ((string)parameter)
            {
                case "ThreeParameter":
                    if (values[0] != null)
                    {

                        if (values[0] is double)
                        {
                            double num1 = (double)values[0];

                            if (num1 >= 10000000000.0)
                                val += (num1 / 1000000000.0).ToString("#") + "B";

                            else if (num1 >= 1000000000.0)
                                val += (num1 / 1000000000.0).ToString("#.#") + "B";

                            else if (num1 >= 1000000.0)
                                val += (num1 / 1000000.0).ToString("#") + "M";

                            else if (num1 >= 10000.0)
                                val += (num1 / 1000.0).ToString("#") + "K";
                            
                            else if (num1 >= 1000.0)
                                val += (num1 / 1000.0).ToString("#.#") + "K";
 
                            else if (num1 >= 10.0)
                                val += (num1).ToString("#");

                            else if (num1 >= 1.0)
                                val += (num1).ToString("#.##");
  
                            else if (num1  < 1.0)
                                val += (num1).ToString("0.##");

                            else
                                val += num1.ToString("#.##");

                        }

                        val += values[2].ToString() + " ---- ";
                    }
                    else
                        val += " ---- ";

                    if (values[1] != null)
                    {
                        if (values[1] is double)
                        {
                            double num2 = (double)values[1];

                            if (num2 >= 10000000000.0)
                                val += (num2 / 1000000000.0).ToString("#") + "B";

                            else if (num2 >= 1000000000.0)
                                val += (num2 / 1000000000.0).ToString("#.#") + "B";

                            else if (num2 >= 1000000.0)
                                val += (num2 / 1000000.0).ToString("#") + "M";

                            else if (num2 >= 10000.0)
                                val += (num2 / 1000.0).ToString("#") + "K";

                            else if (num2 >= 1000.0)
                                val += (num2 / 1000.0).ToString("#.#") + "K";

                            else if (num2 >= 10.0)
                                val += (num2).ToString("#");

                            else if (num2 >= 1.0)
                                val += (num2).ToString("#.##");

                            else if (num2 < 1.0)
                                val += (num2).ToString("0.##");

                            else
                                val += num2.ToString("#.##");
                        }
                        val += values[2].ToString();
                    }
                    else if (values[0] == null)
                    {
                        val = "";
                    }

                    break;

                case "TwoParameter":
                     if (values[0] is double)
                    {
                        double num1 = (double)values[0];

                        if (num1 >= 10000000000.0)
                            val += (num1 / 1000000000.0).ToString("#") + "B";

                        else if (num1 >= 1000000000.0)
                            val += (num1 / 1000000000.0).ToString("#.#") + "B";

                        else if (num1 >= 1000000.0)
                            val += (num1 / 1000000.0).ToString("#") + "M";

                        else if (num1 >= 10000.0)
                            val += (num1 / 1000.0).ToString("#") + "K";

                        else if (num1 >= 1000.0)
                            val += (num1 / 1000.0).ToString("#.#") + "K";

                        else if (num1 >= 10.0)
                            val += (num1).ToString("#");

                        else if (num1 >= 1.0)
                            val += (num1).ToString("#.##");

                        else if (num1 < 1.0)
                            val += (num1).ToString("0.##");

                        else
                            val += num1.ToString("#.##");
                    }

                    val += values[1].ToString();
                    break;
                default:
                    break;
            }

            return val;
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            string[] splitValues = ((string)value).Split(' ');
            return splitValues;
        }
    }

    public class ToolTipDataFormatter : IValueConverter
    {
        // IFormatProvider.GetFormat implementation. 
        public object GetFormat(Type formatType)
        {
            // Determine whether custom formatting object is requested. 
            if (formatType == typeof(ICustomFormatter))
                return this;
            else
                return null;
        }

        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            /*usage
            <TextBlock Text="{Binding Path=Id, Converter={StaticResource formatter}, ConverterParameter='Sale No:\{0\} '}" />
            <TextBlock Text="{Binding Path=Amount, Converter={StaticResource formatter}, ConverterParameter=' \{0:C\}'}" FontWeight="Bold" />
            <TextBlock Text="{Binding Path=SalesTaxPercentage, Converter={StaticResource formatter}, ConverterParameter=' (\{0:P\} Sales Tax)'}" />
            <TextBlock Text="{Binding Path=TimeOfSale, Converter={StaticResource formatter}, ConverterParameter=' \{0:dd-MMM-yyyy hh:mm\}'}" /> 
             */

            string formatString = parameter as string;

            if (value is double)
            {
                double num = (double)value;

                if (num >= 1000000000.0)
                    return (num / 1000000000.0).ToString("#.#") + "B";

                else if (num >= 1000000.0)
                    return (num / 1000000.0).ToString("#.#") + "M";

                else if (num >= 10000.0)
                    return (num / 1000.0).ToString("#.##") + "K";

                else if (num >= 1.0)
                    return (num).ToString("#.##");

                else if (num < 1.0)
                    return (num).ToString("0.##");

                else
                    return num.ToString("#.##");
            }
            else if (formatString != null)
            {
                return string.Format(culture, formatString, value);
            }
            else
            {
                return value.ToString();
                /*
                try
                {
                    return HandleOtherFormats(format, arg);
                }
                catch (FormatException e)
                {
                    throw new FormatException(String.Format("The format of '{0}' is invalid.", format), e);
                }
                 */
            }
        }

        private string HandleOtherFormats(string format, object arg)
        {
            if (arg is IFormattable)
                return ((IFormattable)arg).ToString(format, CultureInfo.CurrentCulture);
            else if (arg != null)
                return arg.ToString();
            else
                return String.Empty;
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            return null;
        }
    }

}
