﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;

namespace CDSHeatMap.Util
{
    public class ItemChecked : INotifyPropertyChanged
    {
        private string _text;
        private bool _isChecked;

        public string Text 
        {
            get { return _text; }
            set
            { 
                _text = value;
                OnPropertyChanged("Text");
            } 
        }

        public bool IsChecked 
        {
            get { return _isChecked; }
            set
            {
                _isChecked = value;
                OnPropertyChanged("IsChecked");
            } 
        }

        public ItemChecked(string text, bool check)
        {
            Text = text;
            IsChecked = check;
            
        }

        public ItemChecked()
        {
            // TODO: Complete member initialization
        }

        #region INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(property));
            }
        }
        #endregion
    }
}
