﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CDSHeatMap.Util
{
    class MainFilterItems
    {
        public Dictionary<string, List<string>> mainList = new Dictionary<string, List<string>>();
        public Dictionary<string, string> fieldList = new Dictionary<string, string>();

        SubFilterItems subList = new SubFilterItems();


        public MainFilterItems(bool isTickerFilter=false)
        {

            fillList(isTickerFilter);
        }

        private void fillList(bool isTickerFilter = false)
        {
            List<string> SUB_PRICE = new List<string> { "Price", "Change 1 Day Percent", "Change Year To Date Percent", "52 Week High Change Percent", "52 Week Low Change Percent", 
                                                                        "Total Return 1 Year Pct", "Beta" };

            foreach (KeyValuePair<string, List<string>> quickFilterItem in ConstantItemList.QuickFilterItemList)
            {
                if (isTickerFilter && quickFilterItem.Key.Equals(ConstantItemList.MAIN_PRICE))
                    mainList.Add(quickFilterItem.Key, SUB_PRICE);
                else
                    mainList.Add(quickFilterItem.Key, quickFilterItem.Value);
            }

            foreach (KeyValuePair<string, string> quickFilterField in ConstantItemList.QuickFilterFieldList)
            {
                if (!(isTickerFilter && quickFilterField.Key.Equals("Change Percent Between User Set Dates")))
                    fieldList.Add(quickFilterField.Key, quickFilterField.Value);
            }
        }


    }



}
