﻿using CDSHeatMap.Model;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using Bloomberglp.AppPortalApi.Desktop;
using CDSHeatMap.View;
using System.Diagnostics;

namespace CDSHeatMap.Util
{
    public class ValidateQuickFilterItem
    {
        public static bool validateFilter(QuickFilterViewObject quickFilter)
        {
            string message = "";

            try
            {
                if (String.IsNullOrWhiteSpace(quickFilter.subValue))
                    message = "Please select a filter!";
                else if (ConstantItemList.SUB_PRICE.Contains(quickFilter.subValue))
                {
                    if (quickFilter.subValue == "Change Percent Between User Set Dates")
                        message = "";
                    else
                        message = validateOperator(typeof(double), quickFilter.operatorValue, quickFilter.minTextValue, quickFilter.maxTextValue);
                }
                else if (ConstantItemList.SUB_EARNINGS.Contains(quickFilter.subValue))
                {
                    if (quickFilter.subValue == "Expected Earnings Report Date" ||
                        quickFilter.subValue == "Est P/E Date")
                        message = validateOperator(typeof(DateTime), quickFilter.operatorValue, quickFilter.minTextValue, quickFilter.maxTextValue);
                    else
                        message = validateOperator(typeof(double), quickFilter.operatorValue, quickFilter.minTextValue, quickFilter.maxTextValue);
                }
                else if (ConstantItemList.SUB_EMPLOYEES.Contains(quickFilter.subValue))
                {
                    if (quickFilter.subValue == "Current Number of Employees")
                        message = validateOperator(typeof(int), quickFilter.operatorValue, quickFilter.minTextValue, quickFilter.maxTextValue);
                    else
                        message = validateOperator(typeof(double), quickFilter.operatorValue, quickFilter.minTextValue, quickFilter.maxTextValue);
                }
                else if (ConstantItemList.SUB_MARKETCAP.Contains(quickFilter.subValue) ||
                            ConstantItemList.SUB_INSTITUTIONALHOLDINGS.Contains(quickFilter.subValue) ||
                            ConstantItemList.SUB_ISSUERATIOS.Contains(quickFilter.subValue) ||
                            ConstantItemList.SUB_PERSHARERATIOS.Contains(quickFilter.subValue) ||
                            ConstantItemList.SUB_CASHFLOWANALYSIS.Contains(quickFilter.subValue) ||
                            ConstantItemList.SUB_GROWTHPOTENTIAL.Contains(quickFilter.subValue) ||
                            ConstantItemList.SUB_PROFITABILITY.Contains(quickFilter.subValue) ||
                            ConstantItemList.SUB_STRUCTURE.Contains(quickFilter.subValue) ||
                            ConstantItemList.SUB_CREDITFUNDAMENTALS.Contains(quickFilter.subValue) ||
                            ConstantItemList.SUB_FINANCIALFIRMSPECIFIC.Contains(quickFilter.subValue)
                    )
                {
                    message = validateOperator(typeof(double), quickFilter.operatorValue, quickFilter.minTextValue, quickFilter.maxTextValue);
                }
            }
            catch (Exception e)
            {
                Trace.WriteLine(string.Format("Quick Filter validation error: ", e.Message.ToString()), "ERROR");

                string stackTrace = "";
                if (e.StackTrace != null)
                    stackTrace = e.StackTrace.ToString();

                Trace.WriteLine("Quick Filter validation error - Exception Stacktrace: " + stackTrace, "INFO");

                var popup = new NotificationView(e.Message, ErrorMsgLevel.None);
                PopupWindow.Instance.Title = "Quick Filter Warning";
                PopupWindow.Instance.ShowWindow(popup);
                PopupWindow.Instance.Width = 250;//Aysegul Albayrak,popup size
                PopupWindow.Instance.Height = 230;
            }

            if (message == "")
                return true;
            else
            {
                var popup = new NotificationView(message, ErrorMsgLevel.None);
                PopupWindow.Instance.Title = "Quick Filter Warning";
                PopupWindow.Instance.ShowWindow(popup);
                PopupWindow.Instance.Width = 250;//Aysegul Albayrak,popup size
                PopupWindow.Instance.Height = 230;
                return false;
            }
        }

        public static string validateOperator(System.Type type, string compare, string filterValue, string maxFilterValue)
        {
            try
            {
                string message = "";

                double signVal = 1.0;
                double signMax = 1.0;

                if (type == typeof(double))
                {
                    if (!string.IsNullOrEmpty(filterValue))
                    {
                        if (filterValue[0] == '-')
                        {
                            signVal = -1.0;
                            filterValue = filterValue.Remove(0, 1);
                        }
                    }

                    if (!string.IsNullOrEmpty(maxFilterValue))
                    {
                        if (maxFilterValue[0] == '-')
                        {
                            signMax = -1.0;
                            maxFilterValue = maxFilterValue.Remove(0, 1);
                        }
                    }
                }


                if (type == typeof(double))
                {
                    double valDouble1;
                    double valDouble2;

                    switch (compare)
                    {
                        case "Between":
                            if (string.IsNullOrEmpty(maxFilterValue) && string.IsNullOrEmpty(filterValue))
                            {
                                message = "Min and Max Values cannot be empty!";
                                return message;
                            }
                            if (string.IsNullOrEmpty(maxFilterValue))
                            {
                                message = "Max Value cannot be empty!";
                                return message;
                            }
                            else if (string.IsNullOrEmpty(filterValue))
                            {
                                message = "Min Value cannot be empty!";
                                return message;
                            }

                            if (double.TryParse(filterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble1))
                            {
                                if (double.TryParse(maxFilterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble2))
                                {
                                    if ((valDouble2 * signMax) >= (valDouble1 * signVal))
                                        message = "";
                                    else
                                        message = "Max value cannot be less than Min Value!";
                                }
                                else
                                    message = "Max value should be a floating number!";
                            }
                            else
                                message = "Min value should be a floating number!";

                            break;

                        case "Equals":
                        case "Does Not Equal":
                        case "Greather Than":
                        case "Greather Than Or Equal To":
                        case "Less Than":
                        case "Less Than Or Equal To":
                            if (double.TryParse(filterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble1))
                            {
                                message = "";
                            }
                            else
                                message = "Value should be a floating number!";

                            break;

                        case "Begins With":
                        case "Ends With":
                        case "Contains":
                        case "Does Not Contain":
                            message = "This operator cannot be used for this filter";
                            break;
                    }
                }
                else if (type == typeof(int))
                {
                    int valueInt1;
                    int valueInt2;

                    switch (compare)
                    {
                        case "Between":
                            if (string.IsNullOrEmpty(maxFilterValue))
                            {
                                message = "Max Value cannot be empty!";
                                return message;
                            }
                            else if (string.IsNullOrEmpty(filterValue))
                            {
                                message = "Min Value cannot be empty!";
                                return message;
                            }

                            if (int.TryParse(filterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt1))
                            {
                                if (int.TryParse(maxFilterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt2))
                                {
                                    if (valueInt2 >= valueInt1)
                                        message = "";
                                    else
                                        message = "Max value cannot be less than Min Value!";
                                }
                                else
                                    message = "Max value should be integer!";
                            }
                            else
                                message = "Min value should be integer!";

                            break;

                        case "Equals":
                        case "Does Not Equal":
                        case "Greather Than":
                        case "Greather Than Or Equal To":
                        case "Less Than":
                        case "Less Than Or Equal To":
                            if (int.TryParse(filterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt1))
                            {
                                message = "";
                            }
                            else
                                message = "Value should be integer!";

                            break;

                        case "Begins With":
                        case "Ends With":
                        case "Contains":
                        case "Does Not Contain":
                            message = "This operator cannot be used for this filter";
                            break;
                    }

                }
                else if (type == typeof(string))
                {
                    switch (compare)
                    {
                        case "Between":
                        case "Greather Than":
                        case "Greather Than Or Equal To":
                        case "Less Than":
                        case "Less Than Or Equal To":
                            message = "This operator cannot be used for this filter";
                            break;

                        case "Equals":
                        case "Does Not Equal":
                        case "Begins With":
                        case "Ends With":
                        case "Contains":
                        case "Does Not Contain":
                            message = "";
                            break;
                    }
                }
                else if (type == typeof(DateTime))
                {
                    DateTime valueDate1;
                    DateTime valueDate2;

                    switch (compare)
                    {
                        case "Between":
                            if (string.IsNullOrEmpty(maxFilterValue))
                            {
                                message = "Max Value cannot be empty!";
                                return message;
                            }
                            else if (string.IsNullOrEmpty(filterValue))
                            {
                                message = "Min Value cannot be empty!";
                                return message;
                            }

                            if (DateTime.TryParse(filterValue, out valueDate1))
                            {
                                if (DateTime.TryParse(maxFilterValue, out valueDate2))
                                {
                                    if (valueDate2 >= valueDate1)
                                        message = "";
                                    else
                                        message = "Max value cannot be less than Min Value!";
                                }
                                else
                                    message = "Max value should be DateTime!";
                            }
                            else
                                message = "Min value should be DateTime!";

                            break;

                        case "Equals":
                        case "Does Not Equal":
                        case "Greather Than":
                        case "Greather Than Or Equal To":
                        case "Less Than":
                        case "Less Than Or Equal To":
                            if (DateTime.TryParse(filterValue, out valueDate1))
                            {
                                message = "";
                            }
                            else
                                message = "Value should be DateTime!";
                            break;

                        case "Begins With":
                        case "Ends With":
                        case "Contains":
                        case "Does Not Contain":
                            message = "This operator cannot be used for this filter";
                            break;
                    }

                }

                return message;
            }
            catch (Exception e)
            {
                Trace.WriteLine(string.Format("Quick Filter validation error while parsing: ", e.Message.ToString()), "ERROR");

                string stackTrace = "";
                if (e.StackTrace != null)
                    stackTrace = e.StackTrace.ToString();

                Trace.WriteLine("Quick Filter validation error while parsing - Exception Stacktrace: " + stackTrace, "INFO");

                return e.Message;
            }
        }
    }
}
