﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;
using Bloomberglp.AppPortalApi.Chrome;
using Bloomberglp.AppPortalApi.Desktop;

namespace CDSHeatMap.View
{
    /// <summary>
    /// Interaction logic for DisplayExceptionView.xaml
    /// </summary>
    public partial class DisplayExceptionView : UserControl, INotifyPropertyChanged
    {
        private string _message;
        public string Message
        {
            get { return _message; }
            set
            {
                _message = value;
                Notify("Message");
            }
        }

        private string _stacktrace;
        public string StackTrace
        {
            get { return _stacktrace; }
            set
            {
                _stacktrace = value;
                Notify("StackTrace");
            }
        }

        public DisplayExceptionView()
        {
            InitializeComponent();
            DataContext = this;
            Dispatcher.BeginInvoke((Action)(() =>
            {
                LayoutUpdated += DisplayExceptionView_LayoutUpdated;
                LayoutUpdated -= DisplayExceptionView_LayoutUpdated;

                Loaded += DisplayExceptionView_LayoutUpdated;

                AppPortalChrome.SetInitialSize(this, new Size(400, 400));

                PopupWindow.Instance.ShowWindow(this);
            }), DispatcherPriority.ContextIdle);

        }

        public DisplayExceptionView(string warning, string trace)
        {
            Message = warning;
            StackTrace = trace;

            InitializeComponent();
            DataContext = this;
        }

        private void btnClose_Click(object sender, RoutedEventArgs e)
        {
            PopupWindow.Instance.Close();
        }

        #region INotifyPropertyChanged

        public event PropertyChangedEventHandler PropertyChanged;

        private void Notify(string propName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propName));
        }

        #endregion

        private void DisplayExceptionView_LayoutUpdated(object sender, EventArgs e)
        {
            AppPortalChrome.SetInitialSize(this, new Size(400, 400));

        }

        private void Msg_Clicked(object sender, RoutedEventArgs e)
        {
            txtStackTrace.Background = Brushes.White;
            txtStackTrace.Foreground = Brushes.Black;

            Bloomberglp.AppPortalApi.Desktop.Clipboard.SetData(Bloomberglp.AppPortalApi.Desktop.DataFormats.Text, (Message + "\n" + StackTrace));

            runFunction("cdsheatmap@globit.com.tr", "MSG");
        }

        public void runFunction(string action, string ticker)
        {
            TerminalApi.RunFunction(action, ticker, Dispatcher);
        }

        private void copyToClipboardText(object sender, MouseEventArgs e)
        {
            txtStackTrace.Background = Brushes.White;
            txtStackTrace.Foreground = Brushes.Black;

            Bloomberglp.AppPortalApi.Desktop.Clipboard.SetData(Bloomberglp.AppPortalApi.Desktop.DataFormats.Text, (Message + "\n" + StackTrace));
        }

    }
}
