﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Bloomberglp.AppPortalApi.Desktop;

namespace CDSHeatMap.View
{
    /// <summary>
    /// Interaction logic for ErrorMessageDialog.xaml
    /// </summary>
    public partial class ErrorMessageDialog : UserControl
    {
        private ErrorMsgLevel errorMsgLevel;

        
        public ErrorMessageDialog(string warning, ErrorMsgLevel errorLevel = ErrorMsgLevel.None)
        {
            InitializeComponent();
            DataContext = this;

            txtMessage.Text = warning;

            errorMsgLevel = errorLevel;

            if (errorMsgLevel == ErrorMsgLevel.BLPContact)
            {
                panelHelp.Visibility = System.Windows.Visibility.Visible;
                txtHelp.Text = "Please kindly contact Bloomberg Help for further assistance:";
                btnHelpBlp.Content = "Bloomberg Live Help";
            }
            else if (errorMsgLevel == ErrorMsgLevel.GlobitContact)
            {
                panelHelp.Visibility = System.Windows.Visibility.Visible;
                txtHelp.Text = "Please send the error code and below error message to :";
                btnHelpBlp.Content = "cdsheatmap@globit.com.tr";
            }
            else if (errorMsgLevel == ErrorMsgLevel.None)
            {
                panelHelp.Visibility = System.Windows.Visibility.Hidden;
            }
        }

        private void Help_Clicked(object sender, RoutedEventArgs e)
        {
            if(errorMsgLevel == ErrorMsgLevel.BLPContact)
                runFunction("HELP", "HELP");
            else if(errorMsgLevel == ErrorMsgLevel.GlobitContact)
                runFunction("cdsheatmap@globit.com.tr", "MSG");
        }

        public void runFunction(string action, string ticker)
        {
            TerminalApi.RunFunction(action, ticker, Dispatcher);
        }

        private void btnClose_Click(object sender, RoutedEventArgs e)
        {
            ModalDialog.Instance.Close(true);
        }
         
    }
}
