﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using CDSHeatMap.Model;
using CDSHeatMap.Util;
using CDSHeatMap.QuickFilter;
using CDSHeatMap.ViewModel;
using CDSHeatMap.PieChart;

using Image = System.Drawing.Image;
using System.Windows.Threading;
using System.Diagnostics;

using Bloomberglp.AppPortalApi.Tutorial;
using System.Threading;
using Bloomberglp.AppPortalApi;
using Bloomberglp.AppPortalApi.Chrome;
using Bloomberglp.AppPortalApi.Desktop;

namespace CDSHeatMap.View
{
    /// <summary>
    /// Interaction logic for HeatMapView.xaml
    /// </summary>
    public partial class HeatMapView : UserControl
    {
        private HeatMapViewModel vm = MainWindowViewModel.heatmapViewModel;

        private static WebDocument _documentShell;
        private static int showGuidanceOrder = 0;
        public static bool isPlayingGuidance = false;

        public static bool initialized = false;
        public static List<QuickFilterViewObject> filterList = new List<QuickFilterViewObject>();
        
        public static bool isNormalDistChecked = true;
        public static bool isHideTickerChecked = false;
        public static bool isRectSizeAlg1Checked = true;

        public static int rdbtncalender = 0;

        Dispatcher mainThreadDispatcher;

        public HeatMapView()
        {
            Trace.WriteLine("HeatMapView is called.", "TRACE");

            InitializeComponent();

            mainThreadDispatcher = Dispatcher.CurrentDispatcher;

            BaseWindowViewModel.onHeatMapView = true;

            if (TickerFilterView.isPlayingGuidance)
            {
                TickerFilterView.isPlayingGuidance = false;
            }

            MainFilterItems items = new MainFilterItems();
            quickFilter.setItemList(items.mainList, items.fieldList, 2);
            quickFilter.createGridItems("Hidden", "Visible", "Hidden");
            rdbtnYtd.IsChecked = true;
            rectColorBar.Header = HeatMapViewModel.RectColor;
            circleColorBar.Header = HeatMapViewModel.CircleColor;

            resetGuidance();

            if (vm.isDataManagerInitialized())
            {
                if (!initialized)
                {
                    var appLastParams = HeatMapViewModel.cacheManager.getAppLastParams();

                    if (appLastParams != null)
                    {
                        isNormalDistChecked = appLastParams.isNormalDistChecked;
                        isHideTickerChecked = appLastParams.isHideTickerChecked;
                        isRectSizeAlg1Checked = appLastParams.isRectSizeAlg1Checked;

                        if (appLastParams.DisplayChange == "YTD")
                        {
                            HeatMapViewModel.fillDateFields(ShowChangeRateClass.YTD);
                            rdbtncalender = 1;
                        }
                        else if (appLastParams.DisplayChange == "52W")
                        {
                            HeatMapViewModel.fillDateFields(ShowChangeRateClass.WEEK52);
                            rdbtncalender = 2;
                        }
                        else if (appLastParams.DisplayChange == "1D")
                        {
                            HeatMapViewModel.fillDateFields(ShowChangeRateClass.DAY1);
                            rdbtncalender = 3;
                        }
                        else if (appLastParams.DisplayChange == "CLOSE")
                        {
                            HeatMapViewModel.fillDateFields(ShowChangeRateClass.CLOSE);
                            rdbtncalender = 4;
                        }
                        else if (appLastParams.DisplayChange == "CUSTOM")
                        {
                            try
                            {
                                beginDate.SelectedDate = HeatMapViewModel.BeginDate = appLastParams.BeginDate;
                                endDate.SelectedDate = HeatMapViewModel.EndDate = appLastParams.EndDate;
                                HeatMapViewModel.fillDateFields(ShowChangeRateClass.CUSTOM);
                            }
                            catch (Exception e)
                            {
                                HeatMapViewModel.fillDateFields(ShowChangeRateClass.CLOSE);
                                HeatMapViewModel.fillDateFields(ShowChangeRateClass.CUSTOM);
                            }

                            rdbtncalender = 5;
                        }
                        else
                        {
                            rdbtncalender = 1;
                            rdbtnYtd.IsChecked = true;
                        }
                    }
                    else
                    {
                        //This is the first time that user runs CDSHeatMap, to understand this --> showGuidanceOrder = -1
                        showGuidanceOrder = -1;

                        rdbtncalender = 1;
                        rdbtnYtd.IsChecked = true;
                    }

                    initialized = true;
                }

                if (isNormalDistChecked)
                {
                    rdbtnNormal.IsChecked = false;
                    rdbtnDist.IsChecked = true;
                }
                else
                {
                    rdbtnNormal.IsChecked = true;
                    rdbtnDist.IsChecked = false;
                }

                if (isHideTickerChecked)
                {
                    rdbtnHideTicker.IsChecked = true;
                    rdbtnShowTicker.IsChecked = false;
                }
                else
                {
                    rdbtnHideTicker.IsChecked = false;
                    rdbtnShowTicker.IsChecked = true;
                }

                if (isRectSizeAlg1Checked)
                {
                    rdbtnRectSizeAlg1.IsChecked = true;
                    rdbtnRectSizeAlg2.IsChecked = false;
                }
                else
                {
                    rdbtnRectSizeAlg1.IsChecked = false;
                    rdbtnRectSizeAlg2.IsChecked = true;
                }

                if (rdbtncalender == 1)
                {
                    HeatMapViewModel.fillDateFields(ShowChangeRateClass.YTD);
                    rdbtnYtd.IsChecked = true;
                    rdbtnWeek.IsChecked = false;
                    rdbtnDay1.IsChecked = false;
                    rdbtnClose.IsChecked = false;
                    rdbtnCustom.IsChecked = false;
                }
                else if (rdbtncalender == 2)
                {
                    HeatMapViewModel.fillDateFields(ShowChangeRateClass.WEEK52);
                    rdbtnWeek.IsChecked = true;
                    rdbtnYtd.IsChecked = false;
                    rdbtnDay1.IsChecked = false;
                    rdbtnClose.IsChecked = false;
                    rdbtnCustom.IsChecked = false;
                }
                else if (rdbtncalender == 3)
                {
                    HeatMapViewModel.fillDateFields(ShowChangeRateClass.DAY1);
                    rdbtnDay1.IsChecked = true;
                    rdbtnYtd.IsChecked = false;
                    rdbtnWeek.IsChecked = false;
                    rdbtnClose.IsChecked = false;
                    rdbtnCustom.IsChecked = false;
                }
                else if (rdbtncalender == 4)
                {
                    HeatMapViewModel.fillDateFields(ShowChangeRateClass.CLOSE);
                    rdbtnClose.IsChecked = true;
                    rdbtnYtd.IsChecked = false;
                    rdbtnWeek.IsChecked = false;
                    rdbtnDay1.IsChecked = false;
                    rdbtnCustom.IsChecked = false;
                }
                else if (rdbtncalender == 5)
                {
                    try
                    {
                        HeatMapViewModel.fillDateFields(ShowChangeRateClass.CUSTOM);
                    }
                    catch (Exception e)
                    {
                        HeatMapViewModel.fillDateFields(ShowChangeRateClass.CLOSE);
                        HeatMapViewModel.fillDateFields(ShowChangeRateClass.CUSTOM);
                    }

                    rdbtnCustom.IsChecked = true;
                    rdbtnYtd.IsChecked = false;
                    rdbtnWeek.IsChecked = false;
                    rdbtnDay1.IsChecked = false;
                    rdbtnClose.IsChecked = false;

                    beginDate.Background = Brushes.White;
                    endDate.Background = Brushes.White;
                }
            }

            try
            {
                vm.initializeViewModel();
                vm.IsBusy = true;
                ShowBusyIndicator("Loading Securities...");
                Mouse.OverrideCursor = Cursors.Wait;
                myToolTip.Visibility = System.Windows.Visibility.Hidden;

                // Introduce an artificial delay to demonstrate the busy indicator in the UI
                Thread worker = new Thread(() =>
                {
                    doInitializeHeatMapWork();
                });
                worker.Start();

                Trace.WriteLine("HeatMapView is completed.", "TRACE");
            }
            catch (Exception ex)
            {
                Trace.Write("Exception during heatmap initialize. guidance !!!" + ex.Message.ToString(), "INFO");
            }

        }

        private void doInitializeHeatMapWork()
        {
            try
            {
                Trace.WriteLine("doInitializeHeatMapWork is called.", "TRACE");

                // Introduce an artificial delay to demonstrate the busy indicator in the UI
                Thread thread = new Thread(() =>
                {
                    try
                    {
                        vm.initialize();
                    }
                    finally
                    {
                        vm.IsBusy = false;
                    }
                });
                thread.Start();


                while (vm.IsBusy == true)
                {
                    System.Threading.Thread.Sleep(100); // artificial delay
                }

                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        vm.initializeAfter(null);
                        fillColorBar();

                        //changeBackgroundToWhite(null, null);

                        if (vm.HeatMapGroup != null)
                            groupList.SelectedValue = vm.HeatMapGroup;
                        else
                            Trace.Write("UNEXPECTED error!!! vm.HeatMapGroup is NULL!!!", "INFO");

                        if (showGuidanceOrder == -1 && vm.isDataManagerInitialized())
                        {
                            //This is the first time that user runs CDSHeatMap
                            showGuidanceOrder = 0;
                            MenuTutorial_Click(null, null);
                            PlayPauseGuidance_Click(null, null);
                        }

                    }
                    catch (Exception e)
                    {
                        Trace.WriteLine("Exception initializing HeatMap (6004): " + e.Message.ToString(), "ERROR");
                        string stackTrace = "";
                        if (e.StackTrace != null)
                            stackTrace = e.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace (6004): " + stackTrace, "INFO");
                    }
                    finally
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                    }
                });

                Trace.WriteLine("doInitializeHeatMapWork is completed.", "TRACE");
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Failed to initialize CDS Heat Map View. Exception (6001): " + ex.Message.ToString(), "ERROR");
                string stackTrace = "";
                if (ex.StackTrace != null)
                    stackTrace = ex.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace (6001): " + stackTrace, "INFO");

                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                    }
                    catch (Exception eDispatcher)
                    {
                        Trace.WriteLine("Exception while mainThreadDispatcher process : " + eDispatcher.Message.ToString(), "INFO");
                        string stackTraceDispatcher = "";
                        if (eDispatcher.StackTrace != null)
                            stackTraceDispatcher = eDispatcher.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace: " + stackTraceDispatcher, "INFO");
                    }
                 });
            }
        }

        private void ellipse_SizeChanged_1(object sender, SizeChangedEventArgs e)
        {
            myToolTip.Visibility = System.Windows.Visibility.Hidden;
            Ellipse el = sender as Ellipse;
            FrameworkElement o1 = (FrameworkElement)el.TemplatedParent;
            FrameworkElement button = (FrameworkElement)o1.Parent;
            FrameworkElement grid = (FrameworkElement)button.Parent;
            double height = grid.ActualHeight;
            double width = grid.ActualWidth;
            double ellipseSize = ((height < width) ? height : width) * (0.8);
            el.Width = ellipseSize;
            el.Height = ellipseSize;

            FrameworkElement currentGrid = (FrameworkElement)el.Parent;
            DonutChart currentChart = (DonutChart)LogicalTreeHelper.FindLogicalNode(currentGrid, "pieChart");

            //TODO:donut DataCollectiondan getir, updateHeatMap donutColor değiştiğinde, burayı çağır.
            //double donutChartColor = 15;
            //double max = 45;
            double donutChartColor = (double)(el.Tag ?? 0.0);
            double max = 0;
            if (donutChartColor < 0)
                max = vm.minDonutChartListNegative;
            else
                max = vm.maxDonutChartListPositive;

            bool isNone = false;

            if (vm.DonutColor == ConstantItemList.NONE) isNone = true;

            currentChart.ConstructPiePieces(donutChartColor, max, ellipseSize * 1.1, isNone);
        }


        private void Ellipse_SizeChanged_2(object sender, SizeChangedEventArgs e)
        {
            myToolTip.Visibility = System.Windows.Visibility.Hidden;
            Ellipse el = sender as Ellipse;
            FrameworkElement grid = (FrameworkElement)el.Parent;
            double height = grid.ActualHeight;
            double width = grid.ActualWidth;
            double ellipseSize = (((height < width) ? height : width) * (0.8)) * (0.5);
            el.Width = ellipseSize;
            el.Height = ellipseSize;


        }

        private void clickApplyFilter(object sender, RoutedEventArgs e)
        {
            Trace.WriteLine("clickApplyFilter is called.", "TRACE");

            resetGuidance();

            myToolTip.Visibility = System.Windows.Visibility.Hidden;
            filterList.Clear();
            ObservableCollection<QuickFilterObject> gridItem = quickFilter.getGridList();
            foreach (var item in gridItem)
            {
                QuickFilterViewObject quickObject = new QuickFilterViewObject();
                quickObject.andOrValue = item.andOrValue;
                quickObject.mainValue = item.mainFilterValue;
                quickObject.subValue = item.subFilterValue;
                quickObject.operatorValue = item.filterOperatorValue;
                quickObject.maxTextValue = item.maxValue;
                quickObject.minTextValue = item.minValue;

                if (item.subFilterValue != null)
                {
                    if (item.fieldList.ContainsKey(item.subFilterValue))
                        quickObject.fieldName = item.fieldList[item.subFilterValue];
                    else
                        quickObject.fieldName = "";
                }

                if (ValidateQuickFilterItem.validateFilter(quickObject))
                    filterList.Add(quickObject);
            }

            if (filterList.Count > 0)
                vm.updateHighLightCircle();

            Trace.WriteLine("clickApplyFilter is completed.", "TRACE");
        }


        public void changeBackground(object sender, RoutedEventArgs e)
        {
            ComboBox cb = (ComboBox)sender;
            if (cb.IsDropDownOpen)
            {
                cb.Background = Brushes.Yellow;

                var updBtnTemplate = btnUpdateMap.Template;
                var btnImageControl = (System.Windows.Controls.Image)updBtnTemplate.FindName("btn_UpdateMap", btnUpdateMap);

                if (btnImageControl != null)
                {
                    btnImageControl.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_redbtn.png"));
                    if (btnImageControl.Source.CanFreeze)
                        btnImageControl.Source.Freeze();
                }
            }
        }

        private void doUpdateHeatMapWork()
        {
            try
            {
                Trace.WriteLine("doUpdateHeatMapWork is called.", "TRACE");
                // Introduce an artificial delay to demonstrate the busy indicator in the UI
                Thread thread = new Thread(() =>
                {
                    try
                    {
                        vm.UpdateHeatMap();
                    }
                    finally
                    {
                        vm.IsBusy = false;
                    }
                });
                thread.Start();

                while (vm.IsBusy == true)
                {
                    System.Threading.Thread.Sleep(100); // artificial delay
                }

                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        vm.UpdateHeatMapAfter();
                    }
                    catch (Exception e)
                    {
                        Trace.WriteLine("Exception updating HeatMap after data is initialized (6006): " + e.Message.ToString(), "ERROR");
                        string stackTrace = "";
                        if (e.StackTrace != null)
                            stackTrace = e.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace (6006): " + stackTrace, "INFO");
                    }
                    finally
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                    }
                    //UpdateMapImg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_btn.png"));
                    fillColorBar();

                    var updBtnTemplate = btnUpdateMap.Template;
                    var btnImageControl = (System.Windows.Controls.Image)updBtnTemplate.FindName("btn_UpdateMap", btnUpdateMap);

                    if (btnImageControl != null)
                    {
                        btnImageControl.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_btn.png"));
                        if (btnImageControl.Source.CanFreeze)
                            btnImageControl.Source.Freeze();
                    }

                    groupList.Background = Brushes.White;
                    firstBy.Background = Brushes.White;
                    thenBy.Background = Brushes.White;
                    rectSize.Background = Brushes.White;
                    rectColor.Background = Brushes.White;
                    circleColor.Background = Brushes.White;
                    donutColor.Background = Brushes.White;

                    beginDate.Background = Brushes.White;
                    endDate.Background = Brushes.White;
                });

                Trace.WriteLine("doUpdateHeatMapWork is completed.", "TRACE");
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Failed to update CDS Heat Map View (6003): " + ex.Message.ToString(), "ERROR");
                string stackTrace = "";
                if (ex.StackTrace != null)
                    stackTrace = ex.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace (6003): " + stackTrace, "INFO");
                //UpdateMapImg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_btn.png"));
                //Trace.WriteLine(string.Format("Unable to load PDF file {0}: {1}", uri, ex), "ERROR");

                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                    }
                    catch (Exception eDispatcher)
                    {
                        Trace.WriteLine("Exception while mainThreadDispatcher process : " + eDispatcher.Message.ToString(), "INFO");
                        string stackTraceDispatcher = "";
                        if (eDispatcher.StackTrace != null)
                            stackTraceDispatcher = eDispatcher.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace: " + stackTraceDispatcher, "INFO");
                    }
                });
            }
        
        
        }

        private void changeBackgroundToWhite(object sender, RoutedEventArgs e)
        {
            Trace.WriteLine("changeBackgroundToWhite is called.", "TRACE");

            if (sender != null)
                resetGuidance();

            //btn_UpdateMap.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_redbtn.png"));
            myToolTip.Visibility = System.Windows.Visibility.Hidden;
            vm.IsBusy = true;
            ShowBusyIndicator("Updating CDSHeatMap...");
            Mouse.OverrideCursor = Cursors.Wait;

            // Introduce an artificial delay to demonstrate the busy indicator in the UI
            Thread worker = new Thread(() =>
            {
                doUpdateHeatMapWork();
            });
            worker.Start();

            //TODO: neden updateHeatMap çağrılıyor.
            //vm.UpdateHeatMap();

            Trace.WriteLine("changeBackgroundToWhite is completed.", "TRACE");

        }

        public void fillColorBar()
        {
            Trace.WriteLine("fillColorBar is called.", "TRACE");

            string rectValue = HeatMapViewModel.RectColor;//rectColor.SelectedValue.ToString();
            bool isRectNegGreen = vm.getNegativeGreenColor(rectValue);
            rectColorBar.ColorDataMinimum = HeatMapViewModel.RectangleDataMinimum;
            rectColorBar.ColorDataMaximum = HeatMapViewModel.RectangleDataMaximum;
            rectColorBar.Header = HeatMapViewModel.RectColor;
            rectColorBar.isNegativeGreen = isRectNegGreen;
            rectColorBar.suffix = "%";
            rectColorBar.fillColorBar();


            string circleValue = HeatMapViewModel.CircleColor;//circleColor.SelectedValue.ToString();
            bool isCircleNegGreen = vm.getNegativeGreenColor(circleValue);
            circleColorBar.ColorDataMinimum = HeatMapViewModel.CircleDataMinimum;
            circleColorBar.ColorDataMaximum = HeatMapViewModel.CircleDataMaximum;
            circleColorBar.Header = HeatMapViewModel.CircleColor;
            circleColorBar.isNegativeGreen = isCircleNegGreen;
            circleColorBar.suffix = "%";
            circleColorBar.fillColorBar();

            Trace.WriteLine("fillColorBar is completed.", "TRACE");
        }

        public void fillColorBarGuidance()
        {
            string rectValue = HeatMapViewModel.RectColor;//rectColor.SelectedValue.ToString();
            bool isRectNegGreen = vm.getNegativeGreenColor(rectValue);
            rectColorBarGuidance.ColorDataMinimum = HeatMapViewModel.RectangleDataMinimum;
            rectColorBarGuidance.ColorDataMaximum = HeatMapViewModel.RectangleDataMaximum;
            rectColorBarGuidance.Header = HeatMapViewModel.RectColor;
            rectColorBarGuidance.isNegativeGreen = isRectNegGreen;
            rectColorBarGuidance.suffix = "%";
            rectColorBarGuidance.fillColorBar();


            string circleValue = HeatMapViewModel.CircleColor;//circleColor.SelectedValue.ToString();
            bool isCircleNegGreen = vm.getNegativeGreenColor(circleValue);
            circleColorBarGuidance.ColorDataMinimum = HeatMapViewModel.CircleDataMinimum;
            circleColorBarGuidance.ColorDataMaximum = HeatMapViewModel.CircleDataMaximum;
            circleColorBarGuidance.Header = HeatMapViewModel.CircleColor;
            circleColorBarGuidance.isNegativeGreen = isCircleNegGreen;
            circleColorBarGuidance.suffix = "%";
            circleColorBarGuidance.fillColorBar();
        }

        private void datePicker_SelectedDateChanged(object sender, SelectionChangedEventArgs e)
        {
            if (HeatMapViewModel.BeginDate.Date != vm.PrevDate1.Date || HeatMapViewModel.EndDate.Date != vm.PrevDate2.Date)
            {
                beginDate.Background = Brushes.Yellow;
                endDate.Background = Brushes.Yellow;

                var updBtnTemplate = btnUpdateMap.Template;
                var btnImageControl = (System.Windows.Controls.Image)updBtnTemplate.FindName("btn_UpdateMap", btnUpdateMap);

                if (btnImageControl != null)
                {
                    btnImageControl.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_redbtn.png"));
                    if (btnImageControl.Source.CanFreeze)
                        btnImageControl.Source.Freeze();
                }
            }
        }

        private void clickRadioButton(object sender, RoutedEventArgs e)
        {
            RadioButton rdbtn = (RadioButton)sender;
            string value = rdbtn.Content.ToString();

            beginDate.Background = Brushes.Yellow;
            endDate.Background = Brushes.Yellow;

            switch (value)
            {
                case "YTD":
                    HeatMapViewModel.fillDateFields(ShowChangeRateClass.YTD);
                    rdbtncalender = 1;
                    break;

                case "52W":
                    HeatMapViewModel.fillDateFields(ShowChangeRateClass.WEEK52);
                    rdbtncalender = 2;
                    break;

                case "1D":
                    HeatMapViewModel.fillDateFields(ShowChangeRateClass.DAY1);
                    rdbtncalender = 3;
                    break;

                case "Close":
                    HeatMapViewModel.fillDateFields(ShowChangeRateClass.CLOSE);
                    rdbtncalender = 4;
                    break;

                case "Custom":
                case "Cstm":
                    HeatMapViewModel.fillDateFields(ShowChangeRateClass.CUSTOM);
                    rdbtncalender = 5;
                    break;

                default:
                    break;
            }
            beginDate.SelectedDate = HeatMapViewModel.BeginDate;
            endDate.SelectedDate = HeatMapViewModel.EndDate;

            var updBtnTemplate = btnUpdateMap.Template;
            var btnImageControl = (System.Windows.Controls.Image)updBtnTemplate.FindName("btn_UpdateMap", btnUpdateMap);

            if (btnImageControl != null)
            {
                btnImageControl.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_redbtn.png"));
                if (btnImageControl.Source.CanFreeze)
                    btnImageControl.Source.Freeze();
            }
        }

        private void clickNormal(object sender, RoutedEventArgs e)
        {
            isNormalDistChecked = true;
            vm.updateHeatMapFromNormDist();
        }


        private void clickLinear(object sender, RoutedEventArgs e)
        {
            isNormalDistChecked = false;
            vm.updateHeatMapFromNormLinear();
        }


        private void clickHideTicker(object sender, RoutedEventArgs e)
        {
            isHideTickerChecked = true;
            vm.updateHeatMapShowTickerName(false);
        }


        private void clickShowTicker(object sender, RoutedEventArgs e)
        {
            isHideTickerChecked = false;
            vm.updateHeatMapShowTickerName(true);
        }


        private void clickRectSizeAlg1(object sender, RoutedEventArgs e)
        {
            isRectSizeAlg1Checked = true;
            vm.DrawHeatMap();
        }


        private void clickRectSizeAlg2(object sender, RoutedEventArgs e)
        {
            isRectSizeAlg1Checked = false;
            vm.DrawHeatMap();
        }

        public void rectCmbxChangeBackgroundAndHeader(object sender, RoutedEventArgs e)
        {
            try
            {
                ComboBox cb = (ComboBox)sender;
                if (cb.IsDropDownOpen)
                {
                    cb.Background = Brushes.Yellow;
                    rectColorBar.Header = cb.SelectedValue.ToString();

                    var updBtnTemplate = btnUpdateMap.Template;
                    var btnImageControl = (System.Windows.Controls.Image)updBtnTemplate.FindName("btn_UpdateMap", btnUpdateMap);

                    if (btnImageControl != null)
                    {
                        btnImageControl.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_redbtn.png"));
                        if (btnImageControl.Source.CanFreeze)
                            btnImageControl.Source.Freeze();
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while rectCmbxChangeBackgroundAndHeader: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace rectCmbxChangeBackgroundAndHeader: " + stackTrace, "INFO");
            }

        }


        public void circleCmbxChangeBackgroundAndHeader(object sender, RoutedEventArgs e)
        {
            try
            {
                ComboBox cb = (ComboBox)sender;
                if (cb.IsDropDownOpen)
                {
                    cb.Background = Brushes.Yellow;
                    circleColorBar.Header = cb.SelectedValue.ToString();

                    var updBtnTemplate = btnUpdateMap.Template;
                    var btnImageControl = (System.Windows.Controls.Image)updBtnTemplate.FindName("btn_UpdateMap", btnUpdateMap);

                    if (btnImageControl != null)
                    {
                        btnImageControl.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_redbtn.png"));
                        if (btnImageControl.Source.CanFreeze)
                            btnImageControl.Source.Freeze();
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while circleCmbxChangeBackgroundAndHeader: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace circleCmbxChangeBackgroundAndHeader: " + stackTrace, "INFO");
            }

        }

        private void disableDatePicker(object sender, RoutedEventArgs e)
        {
            beginDate.IsEnabled = false;
            endDate.IsEnabled = false;
        }

        private void enableDatePicker(object sender, RoutedEventArgs e)
        {
            beginDate.IsEnabled = true;
            endDate.IsEnabled = true;
        }


        public static void runFunction(string action, string ticker)
        {
            TerminalApi.RunFunction(action, ticker, Dispatcher.CurrentDispatcher);
        }

        private void openingContextMenu(object sender, RoutedEventArgs e)
        {
            try
            {
                ContextMenu cm = (ContextMenu)sender;
                var s = cm.Items[0];
                int id = ((ContextMenuItem)(s)).Id;
                vm.highlightBorderChildTicker(id);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while openingContextMenu: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace openingContextMenu: " + stackTrace, "INFO");
            }
        }

        /*
        private void MouseLeave_1(object sender, MouseEventArgs e)
        {
            
           Button btn = sender as Button;
           System.Windows.Controls.ToolTip toolTip = ((System.Windows.Controls.ToolTip)btn.ToolTip);
           StackPanel mainPanel = (StackPanel)LogicalTreeHelper.FindLogicalNode(toolTip, "mainStackPanel");
           StackPanel panel = (StackPanel)LogicalTreeHelper.FindLogicalNode(mainPanel, "stckPanel");
           panel.Visibility = Visibility.Collapsed;
           //toolTip.IsOpen = false;
           
        }
        */

        private void ComboBox_KeyDown_1(object sender, KeyEventArgs e)
        {
            if (e.Key == System.Windows.Input.Key.Enter)
            {
                if (null != searchBtn.Command)
                {
                    searchBtn.Command.Execute(null);
                }

            }
        }

        /*
        private void toolTip_Opened_1(object sender, RoutedEventArgs e)
        {
            System.Windows.Controls.ToolTip toolTip = sender as System.Windows.Controls.ToolTip;
            StackPanel mainPanel = (StackPanel)LogicalTreeHelper.FindLogicalNode(toolTip, "mainStackPanel");
            StackPanel panel = (StackPanel)LogicalTreeHelper.FindLogicalNode(mainPanel, "stckPanel");
            StackPanel subStckPanel = (StackPanel)LogicalTreeHelper.FindLogicalNode(mainPanel, "subStckPanel");
            TextBlock lblFirstBy = (TextBlock)LogicalTreeHelper.FindLogicalNode(subStckPanel, "lblFirstBy");
            TextBlock lblThenBy = (TextBlock)LogicalTreeHelper.FindLogicalNode(subStckPanel, "lblThenBy");
            TextBlock lblRectSize = (TextBlock)LogicalTreeHelper.FindLogicalNode(subStckPanel, "lblRectSize");
            TextBlock lblRectColor = (TextBlock)LogicalTreeHelper.FindLogicalNode(subStckPanel, "lblRectColor");
            TextBlock lblCircleColor = (TextBlock)LogicalTreeHelper.FindLogicalNode(subStckPanel, "lblCircleColor");
            Image imageEquityPrice = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imageEquityPrice");
            Image imageMarketCap = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imageMarketCap");
            Image imageTotalAssets = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imageTotalAssets");
            Image imagePE = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imagePE");
            Image imageCDS = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imageCDS");
            Image imageTotalDebt = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imageTotalDebt");
            Image imageDebtEquity = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imageDebtEquity");
            Image imageImpliedVol = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imageImpliedVol");
            Image imageGreenMean = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imageGreenMean");
            Image imageYellowMean = (Image)LogicalTreeHelper.FindLogicalNode(toolTip, "imageYellowMean");
            lblFirstBy.Text = firstBy.SelectedValue.ToString() + ": ";
            lblThenBy.Text = thenBy.SelectedValue.ToString() + ": ";
            lblRectSize.Text = rectSize.SelectedValue.ToString() + ": ";
            lblRectColor.Text = rectColor.SelectedValue.ToString() + ": ";
            lblCircleColor.Text = circleColor.SelectedValue.ToString() + ": ";
           /* imageEquityPrice.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Green.png");
            imageMarketCap.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Yellow.png");
            imageTotalAssets.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Yellow.png");
            imagePE.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Yellow.png");
            imageCDS.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Green.png");
            imageTotalDebt.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Yellow.png");
            imageDebtEquity.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Yellow.png");
            imageImpliedVol.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Yellow.png");
            imageGreenMean.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Green.png");
            imageYellowMean.Source = (ImageSource)new ImageSourceConverter().ConvertFromString("../../Image/circle_Yellow.png");*/
        /** }
     */
        /*
        private void Grid_MouseMove(object sender, MouseEventArgs e)
        {
            

                //Visibility.Visible;

                //fill tooltip

                DataFormatter formatter = new DataFormatter();

                Grid el = sender as Grid;

                FrameworkElement currentGrid = (FrameworkElement)el;

                BringToFront(myToolTip);

                int id = (int)(el.Tag ?? -1);

                if (id == -1)
                    return;

                DataChild child = vm.getTickerFromHash(id);
                CDSIndexMember member = vm.getCDSMemberDetails(child.ChildEqTicker);

                if (child == null)
                    return;

                if (member == null)
                    return;

                TXTEqTicker.Text = child.ChildEqTicker;
                TXTEqTickerLong.Text = child.ChildName;

                TXTEqPriceccy.Text = getCurrency(member.Currency);
                TXTEqPrice.Text = formatter.ConvertToolTip(child.EquityPrice);


                double? tmpChg;
                ShowChangeRateClass tmpRateClass;

                if (HeatMapViewModel.RateClass == ShowChangeRateClass.CLOSE)
                    tmpRateClass = ShowChangeRateClass.YTD;
                else
                    tmpRateClass = HeatMapViewModel.RateClass;

                tmpChg = child.EqChgNET;
                TXTEqTdyChgAbs.Text = formatter.ConvertToolTip(tmpChg);

                if (tmpChg != null)
                {
                    if (tmpChg > 0f)
                    {
                        ImageEqChgTdy.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/green_up.png"));
                        TXTEqTdyChgAbs.Foreground = Brushes.YellowGreen;
                        TXTEqTdyChgPct.Foreground = Brushes.YellowGreen;
                        TXTEqTdyChg.Foreground = Brushes.YellowGreen;
                    }
                    else if (tmpChg < 0f)
                    {
                        ImageEqChgTdy.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/red_down.png"));
                        TXTEqTdyChgAbs.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTEqTdyChgPct.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTEqTdyChg.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                    }
                }
                else
                {
                    ImageEqChgTdy.Source = null;
                }


                tmpChg = child.EqChgNET;
                if (tmpChg != null)
                    TXTEqTdyChgPct.Text = "(" + formatter.ConvertToolTip(tmpChg) + "%)";
                else
                    TXTEqTdyChgPct.Text = "";

                tmpChg = vm.getEquityChgNet(member, tmpRateClass);
                TXTEqChgAbs.Text = formatter.ConvertToolTip(tmpChg);

                if (tmpChg != null)
                {
                    if (tmpChg > 0f)
                    {
                        ImageEqChg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/green_up.png"));
                        TXTEqChgAbs.Foreground = Brushes.YellowGreen;
                        TXTEqChgPct.Foreground = Brushes.YellowGreen;
                        TXTEqChg.Foreground = Brushes.YellowGreen;
                    }
                    else if (tmpChg < 0f)
                    {
                        ImageEqChg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/red_down.png"));
                        TXTEqChgAbs.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTEqChgPct.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTEqChg.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                    }
                }
                else
                {
                    ImageEqChg.Source = null;
                }

                tmpChg = vm.getEquityChg(member, tmpRateClass);
                if (tmpChg != null)
                    TXTEqChgPct.Text = "(" + formatter.ConvertToolTip(tmpChg) + "%)";
                else
                    TXTEqChgPct.Text = "";

                tmpChg = child.CDS5YChgNET;
                TXTCDSTdyChgAbs.Text = formatter.ConvertToolTip(tmpChg);
                if (tmpChg != null)
                {
                    if (tmpChg < 0f)
                    {
                        ImageCDSChgTdy.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/green_down.png"));
                        TXTCDSTdyChgAbs.Foreground = Brushes.YellowGreen;
                        TXTCDSTdyChgPct.Foreground = Brushes.YellowGreen;
                        TXTCDSTdyChg.Foreground = Brushes.YellowGreen;
                    }
                    else if (tmpChg > 0f)
                    {
                        ImageCDSChgTdy.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/red_up.png"));
                        TXTCDSTdyChgAbs.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTCDSTdyChgPct.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTCDSTdyChg.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                    }
                }
                else
                {
                    ImageCDSChgTdy.Source = null;
                }

                tmpChg = child.CDS5YChgPCT;
                if (tmpChg != null)
                    TXTCDSTdyChgPct.Text = " (" + formatter.ConvertToolTip(tmpChg) + "%)";
                else
                    TXTCDSTdyChgPct.Text = "";

                tmpChg = vm.get5YCDSChgNet(member, tmpRateClass);
                TXTCDSChgAbs.Text = formatter.ConvertToolTip(tmpChg);
                if (tmpChg != null)
                {
                    if (tmpChg < 0f)
                    {
                        ImageCDSChg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/green_down.png"));
                        TXTCDSChgAbs.Foreground = Brushes.YellowGreen;
                        TXTCDSChgPct.Foreground = Brushes.YellowGreen;
                        TXTCDSChg.Foreground = Brushes.YellowGreen;
                    }
                    else if (tmpChg > 0f)
                    {
                        ImageCDSChg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/red_up.png"));
                        TXTCDSChgAbs.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTCDSChgPct.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTCDSChg.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                    }
                }
                else
                {
                    ImageCDSChg.Source = null;
                }

                tmpChg = vm.get5YCDSChg(member, tmpRateClass);
                if (tmpChg != null)
                    TXTCDSChgPct.Text = " (" + formatter.ConvertToolTip(tmpChg) + "%)";
                else
                    TXTCDSChgPct.Text = "";

                if (HeatMapViewModel.RateClass == ShowChangeRateClass.YTD ||
                    HeatMapViewModel.RateClass == ShowChangeRateClass.CLOSE)
                {
                    TXTCDSChg.Text = TXTEqChg.Text = "YTD : ";

                    TXTEqTdyChgPct.Text = " (" + formatter.ConvertToolTip(member.ChgPCT1D) + "%)";
                    TXTEqChgPct.Text = " (" + formatter.ConvertToolTip(member.ChgPCTYTD) + "%)";

                    if (member.getSpreadChgPCT1D(4) != null)
                        TXTCDSTdyChgPct.Text = " (" + formatter.ConvertToolTip(member.getSpreadChgPCT1D(4)) + "%)";
                    else
                        TXTCDSTdyChgPct.Text = "";

                    if (member.getSpreadChgPCTYTD(4) != null)
                        TXTCDSChgPct.Text = " (" + formatter.ConvertToolTip(member.getSpreadChgPCTYTD(4)) + "%)";
                    else
                        TXTCDSChgPct.Text = "";
                }
                else if (HeatMapViewModel.RateClass == ShowChangeRateClass.WEEK52)
                {
                    TXTCDSChg.Text = TXTEqChg.Text = "52W : ";
                }
                else if (HeatMapViewModel.RateClass == ShowChangeRateClass.DAY1)
                {
                    TXTCDSChg.Text = TXTEqChg.Text = "1D : ";
                }
                else //OTHER
                {
                    TXTCDSChg.Text = TXTEqChg.Text = "Custom : ";

                }

                TXTPEratio.Text = formatter.ConvertToolTip(child.PERatio);

                TXTMarketCapccy.Text = getCurrency(member.Currency);
                TXTMarketCap.Text = formatter.ConvertToolTip(child.MarketCap);
                TXTTotalAssetsccy.Text = getCurrency(member.Currency);
                TXTTotalAssets.Text = formatter.ConvertToolTip(child.TotalAssets);

                TXTCDSPrice.Text = formatter.ConvertToolTip(child.CDS5YSpread);

                TXTDebtEq.Text = formatter.ConvertToolTip(child.DebtToEquity);

                TXTTotalDebtccy.Text = getCurrency(member.Currency);
                TXTTotalDebt.Text = formatter.ConvertToolTip(child.TotalDebt);

                TXTMoodys.Text = member.MoodysRating;
                TXTSP.Text = child.SPRating;

                TXTHistImpVol.Text = formatter.ConvertToolTip(child.ImpliedVol) + "%";
                TXTImpVolMean.Text = formatter.ConvertToolTip(child.VolMean) + "%";

                FirstByTitle.Text = vm.FirstBy;
                TXTFirstBy.Text = formatter.ConvertToolTip(vm.getFirstBy(member));

                if (vm.ThenBy != ConstantItemList.NONE)
                {
                    ThenByTitle.Text = vm.ThenBy;
                    TXTThenBy.Text = formatter.ConvertToolTip(vm.getThenBy(member));
                    ThenBySep.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    ThenByTitle.Text = "";
                    TXTThenBy.Text = "";
                    ThenBySep.Visibility = System.Windows.Visibility.Hidden;
                }

                RectSizeTitle.Text = vm.RectSize;
                TXTRectSize.Text = formatter.ConvertToolTip(child.ActualRectangleSize);

                if (HeatMapViewModel.RectColor != ConstantItemList.NONE)
                {
                    RectColorTitle.Text = HeatMapViewModel.RectColor;
                    TXTRectColor.Text = formatter.ConvertToolTip(child.RectangleColor);
                    RectColorSep.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    RectColorTitle.Text = "";
                    TXTRectColor.Text = "";
                    RectColorSep.Visibility = System.Windows.Visibility.Hidden;
                }

                if (HeatMapViewModel.CircleColor != ConstantItemList.NONE)
                {
                    CircleColorTitle.Text = HeatMapViewModel.CircleColor;
                    TXTCircColor.Text = formatter.ConvertToolTip(child.CircleColor);
                    CircleColorSep.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    CircleColorTitle.Text = "";
                    TXTCircColor.Text = "";
                    CircleColorSep.Visibility = System.Windows.Visibility.Hidden;
                }

                if (vm.DonutColor != ConstantItemList.NONE)
                {
                    CircleChartTitle.Text = vm.DonutColor;
                    TXTCircChart.Text = formatter.ConvertToolTip(child.DonutChartColor);
                    CircleChartSep.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    CircleChartTitle.Text = "";
                    TXTCircChart.Text = "";
                    CircleChartSep.Visibility = System.Windows.Visibility.Hidden;
                }

                myToolTip.Visibility = Visibility.Visible;

                double x = Mouse.GetPosition(this).X;
                double y = Mouse.GetPosition(this).Y;

                //Aysegul Albayrak,set tooltip position,31.12.2014
                //begin
                double xOffset = 7;
                double yOffset = 7;
                double screenWidth = System.Windows.SystemParameters.PrimaryScreenWidth;
                double screenhight = System.Windows.SystemParameters.PrimaryScreenHeight;

                if (x >= (screenWidth - 400))
                {
                    x = x - 400;
                    xOffset = xOffset - 14;
                }
                if (y >= (screenhight - 450))
                {
                    y = y - 450;
                    yOffset = yOffset - 14;
                }
                //end

                myToolTip.SetHorizontalOffset(y);
                myToolTip.SetVerticalOffset(x);
                myToolTip.Margin = new Thickness(x + xOffset, y + yOffset, 0, 0);

            
        }
        */
        /*
        private void Grid_MouseLeave(object sender, MouseEventArgs e)
        {
          
            //myToolTip.Visibility = Visibility.Hidden;
            //Visibility.Hidden;
        }
         */

        private string getCurrency(string ccy)
        {
            if (ccy == "USD")
                return "$ ";
            else if (ccy == "EUR")
                return "€ ";
            else if (ccy == "GBP" || ccy == "GBp")
                return "£ ";
            else if (ccy == "JPY")
                return "¥ ";
            else if (ccy == "AUD")
                return "A$ ";
            else if (ccy == "TRY")
                return "TRY ";
            else
                return ccy + " ";

        }

        private void ShowBusyIndicator(string message)
        {
            BringToFront(BusyIndicatiorPanel);
            BusyIndicatiorPanel.Visibility = Visibility.Visible;
            PleaseWaitMsg.Text = message;
            //BusyIndicator.BusyContent = new TextBlock() { Text = message };
            //BusyIndicator.IsBusy = true;

            this.IsHitTestVisible = false;
        }

        private void HideBusyIndicator()
        {
            //BusyIndicator.IsBusy = false;
            BusyIndicatiorPanel.Visibility = Visibility.Hidden;
            this.IsHitTestVisible = true;
        }

        public void BringToFront(FrameworkElement element)
        {
            if (element == null) return;

            Panel parent = element.Parent as Panel;
            if (parent == null) return;

            var maxZ = parent.Children.OfType<UIElement>()
              .Where(x => x != element)
              .Select(x => Panel.GetZIndex(x))
              .Max();
            Panel.SetZIndex(element, maxZ + 1);
        }

        private int prevToolTipID = -1;

        private void Grid_ToolTipClick(object sender, RoutedEventArgs e)
        {
            try
            {
                //Visibility.Visible;

                //fill tooltip

                DataFormatter formatter = new DataFormatter();

                Button el = sender as Button;
                FrameworkElement currentGrid = (FrameworkElement)el;


                BringToFront(myToolTip);

                int id = (int)(el.CommandParameter ?? -1);

                if (id == -1)
                    return;

                if (id == prevToolTipID)
                {
                    myToolTip.Visibility = System.Windows.Visibility.Hidden;
                    prevToolTipID = -1;
                    return;
                }
                else
                    prevToolTipID = id;

                DataChild child = vm.getTickerFromHash(id);
                CDSIndexMember member = vm.getCDSMemberDetails(child.ChildEqTicker);

                if (child == null)
                    return;

                if (member == null)
                    return;

                TXTEqTicker.Text = child.ChildEqTicker;
                TXTEqTickerLong.Text = child.ChildName;

                TXTEqPriceccy.Text = getCurrency(member.Currency);
                TXTEqPrice.Text = formatter.ConvertToolTip(child.EquityPrice);


                double? tmpChg;
                ShowChangeRateClass tmpRateClass;

                if (HeatMapViewModel.RateClass == ShowChangeRateClass.CLOSE)
                    tmpRateClass = ShowChangeRateClass.YTD;
                else
                    tmpRateClass = HeatMapViewModel.RateClass;

                tmpChg = child.EqChgNET;
                TXTEqTdyChgAbs.Text = formatter.ConvertToolTip(tmpChg);

                if (tmpChg != null)
                {
                    if (tmpChg >= 0f)
                    {
                        ImageEqChgTdy.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/green_up.png"));
                        if (ImageEqChgTdy.Source.CanFreeze)
                            ImageEqChgTdy.Source.Freeze();

                        TXTEqTdyChgAbs.Foreground = Brushes.YellowGreen;
                        TXTEqTdyChgPct.Foreground = Brushes.YellowGreen;
                        TXTEqTdyChg.Foreground = Brushes.YellowGreen;
                    }
                    else if (tmpChg < 0f)
                    {
                        ImageEqChgTdy.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/red_down.png"));
                        if (ImageEqChgTdy.Source.CanFreeze)
                            ImageEqChgTdy.Source.Freeze();
                        TXTEqTdyChgAbs.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTEqTdyChgPct.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTEqTdyChg.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                    }
                }
                else
                {
                    ImageEqChgTdy.Source = null;
                }


                tmpChg = child.EqChgPCT;
                if (tmpChg != null)
                    TXTEqTdyChgPct.Text = "(" + formatter.ConvertToolTip(tmpChg) + "%)";
                else
                    TXTEqTdyChgPct.Text = "";

                tmpChg = vm.getEquityChgNet(member, tmpRateClass);
                TXTEqChgAbs.Text = formatter.ConvertToolTip(tmpChg);

                if (tmpChg != null)
                {
                    if (tmpChg >= 0f)
                    {
                        ImageEqChg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/green_up.png"));
                        if (ImageEqChg.Source.CanFreeze)
                            ImageEqChg.Source.Freeze();

                        TXTEqChgAbs.Foreground = Brushes.YellowGreen;
                        TXTEqChgPct.Foreground = Brushes.YellowGreen;
                        TXTEqChg.Foreground = Brushes.YellowGreen;
                    }
                    else if (tmpChg < 0f)
                    {
                        ImageEqChg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/red_down.png"));
                        if (ImageEqChg.Source.CanFreeze)
                            ImageEqChg.Source.Freeze();

                        TXTEqChgAbs.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTEqChgPct.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTEqChg.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                    }
                }
                else
                {
                    ImageEqChg.Source = null;
                }

                tmpChg = vm.getEquityChg(member, tmpRateClass);
                if (tmpChg != null)
                    TXTEqChgPct.Text = "(" + formatter.ConvertToolTip(tmpChg) + "%)";
                else
                    TXTEqChgPct.Text = "";

                tmpChg = child.CDS5YChgNET;
                TXTCDSTdyChgAbs.Text = formatter.ConvertToolTip(tmpChg);
                if (tmpChg != null)
                {
                    if (tmpChg <= 0f)
                    {
                        ImageCDSChgTdy.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/green_down.png"));
                        if (ImageCDSChgTdy.Source.CanFreeze)
                            ImageCDSChgTdy.Source.Freeze();

                        TXTCDSTdyChgAbs.Foreground = Brushes.YellowGreen;
                        TXTCDSTdyChgPct.Foreground = Brushes.YellowGreen;
                        TXTCDSTdyChg.Foreground = Brushes.YellowGreen;
                    }
                    else if (tmpChg > 0f)
                    {
                        ImageCDSChgTdy.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/red_up.png"));
                        if (ImageCDSChgTdy.Source.CanFreeze)
                            ImageCDSChgTdy.Source.Freeze();

                        TXTCDSTdyChgAbs.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTCDSTdyChgPct.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTCDSTdyChg.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                    }
                }
                else
                {
                    ImageCDSChgTdy.Source = null;
                }

                tmpChg = child.CDS5YChgPCT;
                if (tmpChg != null)
                    TXTCDSTdyChgPct.Text = " (" + formatter.ConvertToolTip(tmpChg) + "%)";
                else
                    TXTCDSTdyChgPct.Text = "";

                tmpChg = vm.get5YCDSChgNet(member, tmpRateClass);
                TXTCDSChgAbs.Text = formatter.ConvertToolTip(tmpChg);
                if (tmpChg != null)
                {
                    if (tmpChg < 0f)
                    {
                        ImageCDSChg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/green_down.png"));
                        if (ImageCDSChg.Source.CanFreeze)
                            ImageCDSChg.Source.Freeze();

                        TXTCDSChgAbs.Foreground = Brushes.YellowGreen;
                        TXTCDSChgPct.Foreground = Brushes.YellowGreen;
                        TXTCDSChg.Foreground = Brushes.YellowGreen;
                    }
                    else if (tmpChg > 0f)
                    {
                        ImageCDSChg.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/red_up.png"));
                        if (ImageCDSChg.Source.CanFreeze)
                            ImageCDSChg.Source.Freeze();

                        TXTCDSChgAbs.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTCDSChgPct.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                        TXTCDSChg.Foreground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ff4b4b"));
                    }
                }
                else
                {
                    ImageCDSChg.Source = null;
                }

                tmpChg = vm.get5YCDSChg(member, tmpRateClass);
                if (tmpChg != null)
                    TXTCDSChgPct.Text = " (" + formatter.ConvertToolTip(tmpChg) + "%)";
                else
                    TXTCDSChgPct.Text = "";

                if (HeatMapViewModel.RateClass == ShowChangeRateClass.YTD ||
                    HeatMapViewModel.RateClass == ShowChangeRateClass.CLOSE)
                {
                    TXTCDSChg.Text = TXTEqChg.Text = "YTD : ";
                }
                else if (HeatMapViewModel.RateClass == ShowChangeRateClass.WEEK52)
                {
                    TXTCDSChg.Text = TXTEqChg.Text = "52W : ";
                }
                else if (HeatMapViewModel.RateClass == ShowChangeRateClass.DAY1)
                {
                    TXTCDSChg.Text = TXTEqChg.Text = "1D : ";
                }
                else //OTHER
                {
                    TXTCDSChg.Text = TXTEqChg.Text = "Custom : ";

                }

                TXTPEratio.Text = formatter.ConvertToolTip(member.PeRatio);

                TXTMarketCapccy.Text = getCurrency(member.Currency);
                TXTMarketCap.Text = formatter.ConvertToolTip(member.MarketCapital);
                TXTTotalAssetsccy.Text = getCurrency(member.Currency);
                TXTTotalAssets.Text = formatter.ConvertToolTip(member.TotalAssets);

                TXTCDSPrice.Text = formatter.ConvertToolTip(child.CDS5YSpread);

                TXTDebtEq.Text = formatter.ConvertToolTip(member.DebtToCommonEquity);

                TXTTotalDebtccy.Text = getCurrency(member.Currency);
                TXTTotalDebt.Text = formatter.ConvertToolTip(member.TotalDebt);

                TXTMoodys.Text = member.MoodysRating;
                TXTSP.Text = member.SPRating;

                TXTHistImpVol.Text = formatter.ConvertToolTip(member.HistCallImplVol) + "%";
                TXTImpVolMean.Text = formatter.ConvertToolTip(member.VolMean) + "%";

                string fxCcy = "";
                if (vm.ThenBy != ConstantItemList.NONE)
                {
                    FirstByTitle.Text = vm.FirstBy;
                    fxCcy = "";
                    if (vm.FirstBy == ConstantItemList.CDS_SPREAD_5Y || vm.FirstBy == ConstantItemList.MARKET_CAPITAL || vm.FirstBy == ConstantItemList.EBITDA)
                        fxCcy = "$ ";

                    TXTFirstBy.Text = fxCcy + formatter.ConvertToolTip(vm.getFirstBy(member));
                    FirstBySep.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    FirstByTitle.Text = "";
                    TXTFirstBy.Text = "";
                    FirstBySep.Visibility = System.Windows.Visibility.Hidden;
                }

                if (vm.ThenBy != ConstantItemList.NONE)
                {
                    ThenByTitle.Text = vm.ThenBy;

                    fxCcy = "";
                    if (vm.ThenBy == ConstantItemList.CDS_SPREAD_5Y || vm.ThenBy == ConstantItemList.MARKET_CAPITAL || vm.ThenBy == ConstantItemList.EBITDA)
                        fxCcy = "$ ";

                    TXTThenBy.Text = fxCcy + formatter.ConvertToolTip(vm.getThenBy(member));
                    ThenBySep.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    ThenByTitle.Text = "";
                    TXTThenBy.Text = "";
                    ThenBySep.Visibility = System.Windows.Visibility.Hidden;
                }

                RectSizeTitle.Text = vm.RectSize;
                if (vm.RectSize == ConstantItemList.HIST_CALL_IMPL_VOL || vm.RectSize == ConstantItemList.EQUAL_SIZE)
                    TXTRectSize.Text = formatter.ConvertToolTip(child.ActualRectangleSize);
                else if (child.ActualRectangleSize != null)
                    TXTRectSize.Text = "$ " + formatter.ConvertToolTip(child.ActualRectangleSize);
                else
                    TXTRectSize.Text = formatter.ConvertToolTip(child.ActualRectangleSize);

                if (HeatMapViewModel.RectColor != ConstantItemList.NONE)
                {
                    RectColorTitle.Text = HeatMapViewModel.RectColor;
                    TXTRectColor.Text = formatter.ConvertToolTip(child.RectangleColor);
                    RectColorSep.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    RectColorTitle.Text = "";
                    TXTRectColor.Text = "";
                    RectColorSep.Visibility = System.Windows.Visibility.Hidden;
                }

                if (HeatMapViewModel.CircleColor != ConstantItemList.NONE)
                {
                    CircleColorTitle.Text = HeatMapViewModel.CircleColor;
                    TXTCircColor.Text = formatter.ConvertToolTip(child.CircleColor);
                    CircleColorSep.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    CircleColorTitle.Text = "";
                    TXTCircColor.Text = "";
                    CircleColorSep.Visibility = System.Windows.Visibility.Hidden;
                }

                if (vm.DonutColor != ConstantItemList.NONE)
                {
                    CircleChartTitle.Text = vm.DonutColor;
                    TXTCircChart.Text = formatter.ConvertToolTip(child.DonutChartColor);
                    CircleChartSep.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    CircleChartTitle.Text = "";
                    TXTCircChart.Text = "";
                    CircleChartSep.Visibility = System.Windows.Visibility.Hidden;
                }

                myToolTip.Visibility = Visibility.Visible;

                double x = Mouse.GetPosition(this).X;
                double y = Mouse.GetPosition(this).Y;

                /*Aysegul Albayrak,set tooltip position,31.12.2014*/
                //begin
                double xOffset = 7;
                double yOffset = 7;
                double screenWidth = 0.0;
                double screenHeight = 0.0;

                try
                {
                    if (!BlpEnvironment.IsEmbedded)
                    {
                        var size = AppPortalChrome.GetWindowSize(this);

                        screenWidth = size.Width;
                        screenHeight = size.Height;
                    }
                    else
                    {
                        screenWidth = 900;
                        screenHeight = 680;
                    }
                }
                catch (Exception ex)
                {
                    //no need to handle
                }

                if (screenWidth <= 0 || screenHeight <= 0)
                {
                    screenWidth = System.Windows.SystemParameters.PrimaryScreenWidth;
                    screenHeight = System.Windows.SystemParameters.PrimaryScreenHeight;
                }

                if (x >= (screenWidth - 400))
                {
                    x = x - 400;
                    xOffset = xOffset - 14;
                }
                if (y >= (screenHeight - 470))
                {
                    y = y - 450;

                    //Tooltip may not fit in the screen when window is resized to a minimum size than PrimaryScreen size 
                    if (y < 0) y = 0;

                    yOffset = yOffset - 14;
                }
                //end

                myToolTip.SetHorizontalOffset(y);
                myToolTip.SetVerticalOffset(x);
                myToolTip.Margin = new Thickness(x + xOffset, y + yOffset, 0, 0);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while opening Tooltip: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace Tooltip: " + stackTrace, "INFO");
            }

        }

        private void closeTooltip(object sender, RoutedEventArgs e)
        {
            myToolTip.Visibility = System.Windows.Visibility.Hidden;
            prevToolTipID = -1;
        }

        private void OnHeatMap_Updated(object sender, DataTransferEventArgs e)
        {
            fillColorBar();
        }

        public void showGuidanceAtOrder(int order, bool isShow)
        {
            try
            {
                if (BaseWindowViewModel.onHeatMapView == false)
                {
                    return;
                }

                switch (order)
                {
                    case 1:
                        GuidanceService.SetShowGuidance(HeatmapPanel, isShow);

                        GuidanceService.SetShowGuidance(groupList, false);
                        break;

                    case 2:
                        GuidanceService.SetShowGuidance(HeatmapPanel, false);

                        GuidanceService.SetShowGuidance(groupList, isShow);

                        GuidanceService.SetShowGuidance(firstBy, false);
                        break;

                    case 3:
                        GuidanceService.SetShowGuidance(groupList, false);

                        GuidanceService.SetShowGuidance(firstBy, isShow);

                        vm.setFirstByGuidance(false);
                        break;

                    case 4:
                        GuidanceService.SetShowGuidance(firstBy, isShow);

                        //FirstByGuidanceEnabled
                        vm.setFirstByGuidance(isShow);

                        GuidanceService.SetShowGuidance(thenBy, false);
                        break;

                    case 5:
                        GuidanceService.SetShowGuidance(firstBy, false);
                        vm.setFirstByGuidance(false);

                        GuidanceService.SetShowGuidance(thenBy, isShow);

                        vm.setThenByGuidance(false);
                        break;

                    case 6:
                        GuidanceService.SetShowGuidance(thenBy, isShow);

                        //ThenByGuidanceEnabled
                        vm.setThenByGuidance(isShow);

                        GuidanceService.SetShowGuidance(rectSize, false);

                        break;

                    case 7:
                        GuidanceService.SetShowGuidance(thenBy, false);
                        vm.setThenByGuidance(false);

                        GuidanceService.SetShowGuidance(rectSize, isShow);

                        GuidanceService.SetShowGuidance(rectColor, false);
                        break;

                    case 8:
                        GuidanceService.SetShowGuidance(rectSize, false);

                        GuidanceService.SetShowGuidance(rectColor, isShow);

                        GuidanceService.SetShowGuidance(rectColorBarGuidance, false);
                        vm.setRectColorGuidance(false);

                        break;

                    case 9:
                        GuidanceService.SetShowGuidance(rectColor, isShow);
                        GuidanceService.SetShowGuidance(rectColorBarGuidance, isShow);

                        //RectColorGuidanceEnabled
                        vm.setRectColorGuidance(isShow);

                        GuidanceService.SetShowGuidance(circleColor, false);

                        break;

                    case 10:
                        GuidanceService.SetShowGuidance(rectColor, false);
                        GuidanceService.SetShowGuidance(rectColorBarGuidance, false);
                        vm.setRectColorGuidance(false);

                        GuidanceService.SetShowGuidance(circleColor, isShow);

                        GuidanceService.SetShowGuidance(circleColorBarGuidance, false);
                        vm.setCircleColorGuidance(false);
                        break;

                    case 11:
                        GuidanceService.SetShowGuidance(circleColor, isShow);
                        GuidanceService.SetShowGuidance(circleColorBarGuidance, isShow);

                        //CircleColorGuidanceEnabled
                        vm.setCircleColorGuidance(isShow);

                        GuidanceService.SetShowGuidance(donutColor, false);
                        GuidanceService.SetShowGuidance(donutColor, false);
                        break;

                    case 12:
                        GuidanceService.SetShowGuidance(circleColor, false);
                        GuidanceService.SetShowGuidance(circleColorBarGuidance, false);
                        vm.setCircleColorGuidance(false);

                        GuidanceService.SetShowGuidance(donutColor, isShow);

                        //VolatilityGuidanceEnabled
                        vm.setVolatilityGuidance(isShow);

                        GuidanceService.SetShowGuidance(datePickerPanel, false);
                        break;

                    case 13:
                        GuidanceService.SetShowGuidance(donutColor, false);
                        vm.setVolatilityGuidance(false);

                        GuidanceService.SetShowGuidance(datePickerPanel, isShow);

                        GuidanceService.SetShowGuidance(btnUpdateMapGuidance, false);
                        var updBtnTemplatePrev = btnUpdateMapGuidance.Template;
                        if (updBtnTemplatePrev != null)
                        {
                            var btnImageControlPrev = (System.Windows.Controls.Image)updBtnTemplatePrev.FindName("btn_UpdateMapGuidance", btnUpdateMapGuidance);

                            if (btnImageControlPrev != null)
                            {
                                btnImageControlPrev.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_btn.png"));
                                if (btnImageControlPrev.Source.CanFreeze)
                                    btnImageControlPrev.Source.Freeze();
                            }
                        }
                        break;

                    case 14:
                        GuidanceService.SetShowGuidance(datePickerPanel, false);

                        GuidanceService.SetShowGuidance(btnUpdateMapGuidance, isShow);

                        var updBtnTemplateRed = btnUpdateMapGuidance.Template;
                        if (updBtnTemplateRed != null)
                        {
                            var btnImageControlRed = (System.Windows.Controls.Image)updBtnTemplateRed.FindName("btn_UpdateMapGuidance", btnUpdateMapGuidance);

                            if (btnImageControlRed != null)
                            {
                                if (isShow)
                                {
                                    btnImageControlRed.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_redbtn.png"));
                                    if (btnImageControlRed.Source.CanFreeze)
                                        btnImageControlRed.Source.Freeze();
                                }
                                else
                                {
                                    btnImageControlRed.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_btn.png"));
                                    if (btnImageControlRed.Source.CanFreeze)
                                        btnImageControlRed.Source.Freeze();
                                }
                            }
                        }

                        vm.setTooltipGuidance(false);
                        break;

                    case 15:
                        GuidanceService.SetShowGuidance(btnUpdateMapGuidance, false);
                        var updBtnTemplate = btnUpdateMapGuidance.Template;
                        if (updBtnTemplate != null)
                        {
                            var btnImageControl = (System.Windows.Controls.Image)updBtnTemplate.FindName("btn_UpdateMapGuidance", btnUpdateMapGuidance);

                            if (btnImageControl != null)
                            {
                                btnImageControl.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/UpdateMap_btn.png"));
                                if (btnImageControl.Source.CanFreeze)
                                    btnImageControl.Source.Freeze();
                            }
                        }

                        vm.setTooltipGuidance(isShow);
                        //TooltipGuidanceEnabled

                        GuidanceService.SetShowGuidance(selectionDetailsNameGuidance, false);

                        break;

                    case 16:
                        vm.setTooltipGuidance(false);

                        GuidanceService.SetShowGuidance(selectionDetailsNameGuidance, isShow);

                        vm.setRightClickGuidance(false);
                        break;

                    case 17:

                        GuidanceService.SetShowGuidance(selectionDetailsNameGuidance, false);
                        //RightClickGuidanceEnabled
                        vm.setRightClickGuidance(isShow);
                        break;

                    case 18:
                        vm.setRightClickGuidance(false);

                        GuidanceDisplay(false);
                        showGuidanceOrder = 0;

                        if (isPlayingGuidance)
                        {
                            isPlayingGuidance = false;

                            var playGuidanceTemplate = PlayGuidance.Template;
                            var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                            if (playPauseImage != null)
                            {
                                playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                                if (playPauseImage.Source.CanFreeze)
                                    playPauseImage.Source.Freeze();
                            }
                        }

                        break;
                }
            }
            catch (Exception e)
            {
                if(isShow)
                    Trace.WriteLine("Exception while displaying showGuidanceAtOrder order:" + order + " : " + e.Message.ToString(), "INFO");
                else
                    Trace.WriteLine("Exception while closing showGuidanceAtOrder order:" + order + " : " + e.Message.ToString(), "INFO");
            }
            
        }

        private void CloseGuidance_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                showGuidanceAtOrder(showGuidanceOrder, false);

                GuidanceDisplay(false);
                showGuidanceOrder = 0;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while CloseGuidance_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace CloseGuidance_Click: " + stackTrace, "INFO");
            }
        }

        private void NextGuidance_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                showGuidanceOrder++;
                showGuidanceAtOrder(showGuidanceOrder, true);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while NextGuidance_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace NextGuidance_Click: " + stackTrace, "INFO");
            }
        }

        private void PlayPauseGuidance_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (isPlayingGuidance == false)
                {
                    PlayGuidance.Content = "Pause";

                    if (showGuidanceOrder <= 0 || showGuidanceOrder >= 18)
                        showGuidanceOrder = 0;

                    isPlayingGuidance = true;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/pause.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }

                    Thread worker = new Thread(() =>
                    {
                        try
                        {
                            if (showGuidanceOrder != 0)
                                Thread.Sleep(5000);

                            while (showGuidanceOrder <= 18)
                            {
                                if (isPlayingGuidance == false)
                                    break;

                                try
                                {
                                    if (BaseWindowViewModel.onHeatMapView == false)
                                    {
                                        isPlayingGuidance = false;
                                        showGuidanceOrder = 0;
                                        //GuidanceDisplay(false);
                                        break;
                                    }

                                    mainThreadDispatcher.BeginInvoke((Action)delegate
                                    {
                                        try
                                        {
                                            showGuidanceOrder++;
                                            showGuidanceAtOrder(showGuidanceOrder, true);
                                        }
                                        catch (Exception eDispatcher)
                                        {
                                            Trace.WriteLine("Exception while mainThreadDispatcher process : " + eDispatcher.Message.ToString(), "INFO");
                                            string stackTraceDispatcher = "";
                                            if (eDispatcher.StackTrace != null)
                                                stackTraceDispatcher = eDispatcher.StackTrace.ToString();

                                            Trace.WriteLine("Exception Stacktrace: " + stackTraceDispatcher, "INFO");
                                        }
                                    });
                                }
                                catch (Exception e1)
                                {
                                    if (BaseWindowViewModel.onHeatMapView == false)
                                    {
                                        isPlayingGuidance = false;
                                        showGuidanceOrder = 0;
                                        //GuidanceDisplay(false);
                                        break;
                                    }
                                }

                                Thread.Sleep(5000);

                                if (BaseWindowViewModel.onHeatMapView == false)
                                {
                                    isPlayingGuidance = false;
                                    showGuidanceOrder = 0;
                                    //GuidanceDisplay(false);
                                    break;
                                }
                            }
                        }
                        catch (Exception e1)
                        {
                            Trace.WriteLine("Exception while running Thread in HeatmapView PlayPauseGuidance_Click: " + e1.Message, "ERROR");
                            string stackTrace = "";
                            if (e1.StackTrace != null)
                                stackTrace = e1.StackTrace.ToString();

                            Trace.WriteLine("Exception while running Thread in HeatmapView getInitialCDSIndex: " + stackTrace, "INFO");
                        }
                    });
                    worker.Start();
                }
                else
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }
            }
            catch (Exception ex)
            {
                Trace.Write("Exception during heatmap play guidance!!!" + ex.Message);
            }
        }

        private void PrevGuidance_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                if (showGuidanceOrder == 1)
                    return;

                showGuidanceOrder--;
                showGuidanceAtOrder(showGuidanceOrder, true);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while PrevGuidance_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace PrevGuidance_Click: " + stackTrace, "INFO");
            }
        }

        public void resetGuidance()
        {
            try
            {
                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                CloseGuidance_Click(null, null);
                showGuidanceOrder = 0;
            }
            catch (Exception ex)
            {
                Trace.Write("Exception during heatmap reset guidance!!!" + ex.Message);
            }
        }

        public void GuidanceDisplay(bool isDisplay)
        {
            try
            {
                if (isDisplay)
                {   //Display Guidance
                    if (vm.buttonState == HeatMapViewModel.ButtonState.Hidden)
                    {
                        vm.OnShowHideCommand(null);
                    }

                    HeatMapRightPanel.Visibility = System.Windows.Visibility.Collapsed;
                    HeatMapRightPanelGuidance.Visibility = System.Windows.Visibility.Visible;

                    fillColorBarGuidance();

                    CloseGuidance.Visibility = System.Windows.Visibility.Visible;
                    NextGuidance.Visibility = System.Windows.Visibility.Visible;
                    PrevGuidance.Visibility = System.Windows.Visibility.Visible;
                    PlayGuidance.Visibility = System.Windows.Visibility.Visible;

                }
                else
                {   //Hide Guidance
                    HeatMapRightPanelGuidance.Visibility = System.Windows.Visibility.Collapsed;
                    HeatMapRightPanel.Visibility = System.Windows.Visibility.Visible;

                    CloseGuidance.Visibility = System.Windows.Visibility.Hidden;
                    NextGuidance.Visibility = System.Windows.Visibility.Hidden;
                    PrevGuidance.Visibility = System.Windows.Visibility.Hidden;
                    PlayGuidance.Visibility = System.Windows.Visibility.Hidden;
                }
            }
            catch (Exception ex)
            {
                Trace.Write("Exception during heatmap guidance display!!!" + ex.Message);
            }
        }

        /*
        private void OnOpenDocumentCompleted(object sender, EventArgs e)
        {
            Dispatcher.BeginInvoke((Action)delegate
            {
                HideBusyIndicator();
                Mouse.OverrideCursor = null;
            });
        }
        */
        private void MenuGuide_Click(object sender, RoutedEventArgs e)
        {
            string uri = "http://www.globit.com.tr/static/CDS_HeatMapUserGuide.pdf";

            try
            {
                if (_documentShell == null)
                {
                    _documentShell = new WebDocument();
                    //_documentShell.OpenDocumentCompleted += OnOpenDocumentCompleted;
                }

                /*
                Mouse.OverrideCursor = Cursors.Wait;
                ShowBusyIndicator("Loading User Guide...");
                */
                // Introduce an artificial delay to demonstrate the busy indicator in the UI
                Thread thread = new Thread(() =>
                {
                    try
                    {
                        _documentShell.OpenDocumentAsync(new Uri(uri));
                        System.Threading.Thread.Sleep(500); // artificial delay
                    }
                    catch (Exception e1)
                    {
                        Trace.WriteLine("Exception while running Thread in HeatmapView MenuGuide_Click: " + e1.Message, "ERROR");
                        string stackTrace = "";
                        if (e1.StackTrace != null)
                            stackTrace = e1.StackTrace.ToString();

                        Trace.WriteLine("Exception while running Thread in HeatmapView MenuGuide_Click: " + stackTrace, "INFO");
                    }
                 });
                thread.Start();

                String guideMessage = "User Guide is being downloaded in the background, and will open automatically in your pdf reader. \n\nYou can continue using CDS HeatMap, or have a quick look at our Tutorial in the meantime. \n\nThank you!";

                var popup = new NotificationView(guideMessage, ErrorMsgLevel.None);
                PopupWindow.Instance.Title = "Downloading...";
                PopupWindow.Instance.ShowWindow(popup);
                PopupWindow.Instance.Width = 400;
                PopupWindow.Instance.Height = 250;

            }
            catch (Exception ex)
            {
                Trace.WriteLine(string.Format("Unable to load PDF file {0}: {1}", uri, ex), "ERROR");

                string stackTrace = "";
                if (ex.StackTrace != null)
                    stackTrace = ex.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace: " + stackTrace, "INFO");

                /*
                Dispatcher.BeginInvoke((Action)delegate
                {
                    HideBusyIndicator();
                    Mouse.OverrideCursor = null;
                });
                 */
            }
        }

        private void MenuTutorial_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (vm.ThenBy == ConstantItemList.NONE || vm.DonutColor == ConstantItemList.NONE)
                {
                    vm.ThenBy = ConstantItemList.MOODYSRATING;
                    vm.DonutColor = ConstantItemList.VOL_MEAN;

                    thenBy.SelectedValue = ConstantItemList.MOODYSRATING;
                    donutColor.SelectedValue = ConstantItemList.VOL_MEAN;

                    myToolTip.Visibility = System.Windows.Visibility.Hidden;
                    ShowBusyIndicator("Loading Tutorial...");
                    Mouse.OverrideCursor = Cursors.Wait;

                    try
                    {
                        vm.UpdateHeatMapAfter();
                    }
                    catch (Exception ex)
                    {
                        Trace.WriteLine("Exception updating HeatMap (6005): " + ex.Message.ToString(), "ERROR");
                        string stackTrace = "";
                        if (ex.StackTrace != null)
                            stackTrace = ex.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace (6005): " + stackTrace, "INFO");
                    }
                    finally
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                    }

                    fillColorBar();
                }

                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                //CloseGuidance_Click(null, null);

                if (showGuidanceOrder > 1)
                    showGuidanceAtOrder(showGuidanceOrder, false);

                GuidanceDisplay(true);

                showGuidanceOrder = 1;
                showGuidanceAtOrder(showGuidanceOrder, true);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while MenuTutorial_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace MenuTutorial_Click: " + stackTrace, "INFO");
            }
        }

        private void MenuAbout_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                var popup = new AboutView();
                PopupWindow.Instance.Title = "About";
                PopupWindow.Instance.ShowWindow(popup);
                PopupWindow.Instance.Width = 800;
                PopupWindow.Instance.Height = 600;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while MenuAbout_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace MenuAbout_Click: " + stackTrace, "INFO");
            }
        }

        public static void Dispose()
        {
            Trace.WriteLine("HeatmapView Dispose is called", "TRACE");

            if (_documentShell != null)
                _documentShell.Dispose();

            Trace.WriteLine("HeatmapView Dispose is completed", "TRACE");
        }
        
    }

}
    