﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Bloomberglp.AppPortalApi.Desktop;
using System.Windows.Threading;
using Bloomberglp.AppPortalApi.Chrome;
using Bloomberglp.AppPortalApi.DataPersistence;

namespace CDSHeatMap.View
{
    public enum ErrorMsgLevel
    {
        None,
        BLPContact,
        GlobitContact
    };

    /// <summary>
    /// Interaction logic for NotificationView.xaml
    /// </summary>
    public partial class NotificationView : UserControl, INotifyPropertyChanged
    {
        private ErrorMsgLevel errorMsgLevel;
        private string _message;
        public string Message
        {
            get { return _message; }
            set
            {
                _message = value;
                Notify("Message");
            }
        }

        public NotificationView()
        {
            InitializeComponent();
            DataContext = this;
            errorMsgLevel = ErrorMsgLevel.None;

            Dispatcher.BeginInvoke((Action)(() =>
            {
                LayoutUpdated += NotificationView_LayoutUpdated;
                LayoutUpdated -= NotificationView_LayoutUpdated;

                Loaded += NotificationView_LayoutUpdated;

                AppPortalChrome.SetInitialSize(this, new Size(300, 300));

                PopupWindow.Instance.ShowWindow(this);
            }), DispatcherPriority.ContextIdle);

        }

        public NotificationView(string warning, ErrorMsgLevel errorLevel = ErrorMsgLevel.None)
        {
            Message = warning;
            InitializeComponent();
            DataContext = this;

            errorMsgLevel = errorLevel;

            if (errorMsgLevel == ErrorMsgLevel.BLPContact)
            {
                panelHelp.Visibility = System.Windows.Visibility.Visible;
                txtHelp.Text = "Please kindly contact Bloomberg Help for further assistance:";
                btnHelpBlp.Content = "Bloomberg Live Help";
            }
            else if (errorMsgLevel == ErrorMsgLevel.GlobitContact)
            {
                panelHelp.Visibility = System.Windows.Visibility.Visible;
                txtHelp.Text = "Please send the error code and below error message to :";
                btnHelpBlp.Content = "cdsheatmap@globit.com.tr";
            }
            else if (errorMsgLevel == ErrorMsgLevel.None)
            {
                panelHelp.Visibility = System.Windows.Visibility.Hidden;
            }
        }

        private void Help_Clicked(object sender, RoutedEventArgs e)
        {
            if(errorMsgLevel == ErrorMsgLevel.BLPContact)
                runFunction("HELP", "HELP");
            else if(errorMsgLevel == ErrorMsgLevel.GlobitContact)
                runFunction("cdsheatmap@globit.com.tr", "MSG");
        }

        public void runFunction(string action, string ticker)
        {
            TerminalApi.RunFunction(action, ticker, Dispatcher);
        }

        private void btnClose_Click(object sender, RoutedEventArgs e)
        {
            PopupWindow.Instance.Close();
        }

        #region INotifyPropertyChanged

        public event PropertyChangedEventHandler PropertyChanged;

        private void Notify(string propName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propName));
        }

        #endregion

        private void NotificationView_LayoutUpdated(object sender, EventArgs e)
        {
            AppPortalChrome.SetInitialSize(this, new Size(300, 300));

        }


    }
}
