﻿using CDSHeatMap.Model;
using CDSHeatMap.Ticker;
using CDSHeatMap.Util;
using CDSHeatMap.ViewModel;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using CDSHeatMap.QuickFilter;
using Bloomberglp.AppPortalApi.Desktop;
using System.Windows.Threading;
using System.Diagnostics;
using System.Threading;
using Bloomberglp.AppPortalApi.Tutorial;

namespace CDSHeatMap.View
{
    /// <summary>
    /// Interaction logic for TickerFilterView.xaml
    /// </summary>
    public partial class TickerFilterView : UserControl
    {
        private TickerFilterViewModel vm = MainWindowViewModel.tickerfilterViewModel;

        private static WebDocument _documentShell;
        private static int showGuidanceOrder = 0;
        public static bool isPlayingGuidance = false;

        int wrpPnl0RowCount = 0;
        int wrpPnl1RowCount = 0;
        int wrpPnl2RowCount = 0;
        int wrpPnl3RowCount = 0;
        int flagForCustomPanel = -1;
        WrapPanel wpBottomCustom = new WrapPanel();
        DockPanel dpCustom = null;
        Border customBorder = new Border();
        Dictionary<string, List<TickerUserControl>> tickerList = new Dictionary<string, List<TickerUserControl>>();
        List<TickerUserControl> customTickerList = new List<TickerUserControl>();
        TextBlock customHeader = new TextBlock(); 
        public static List<QuickFilterViewObject> filterList = new List<QuickFilterViewObject>();

        public List<string> QuickFilterFalseTickerList;

        bool borderBrushed = false;
        bool uncheckedRemoved = false;

        List<TickerUserControl> BorderBrushedTickerList = new List<TickerUserControl>();

        Dispatcher mainThreadDispatcher;

        public TickerFilterView()
        {
            Trace.WriteLine("TickerFilterView is called.", "TRACE");

            InitializeComponent();
            mainThreadDispatcher = Dispatcher.CurrentDispatcher;

            BaseWindowViewModel.onHeatMapView = false;

            if (HeatMapView.isPlayingGuidance)
            {
                HeatMapView.isPlayingGuidance = false; 
            }

            Trace.WriteLine("TickerFilterView is completed.", "TRACE");
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            Trace.WriteLine("TickerFilterView Window_Loaded is called.", "TRACE");

            MainFilterItems items = new MainFilterItems(true);
            quickFilter.setItemList(items.mainList, items.fieldList, 0);
            quickFilter.setGroupBoxName("Quick Filter");
            quickFilter.createGridItems("Hidden", "Visible", "Hidden");

            //setDefaultParameters();
            vm.initializeViewModel();
            TickerFilterView_Open();
            //createPanelObject(tickerList);
            Trace.WriteLine("TickerFilterView Window_Loaded is completed.", "TRACE");
        }

        public void TickerFilterView_Open()
        {
            try
            {
                Trace.WriteLine("TickerFilterView_Open is called.", "TRACE");

                if (!vm.isDataManagerInitialized())
                {
                    Trace.WriteLine("TickerFilterViewModel, data manager is not initialized!!!", "INFO");
                    return;
                }

                CDSIndexBase HeatMapGroup = vm.getSelectedGroupType();

                var tickerFilterItems = vm.getTickerFilterItems();
                var tickerFilter = vm.getTickerFilter();

                if (HeatMapGroup.IndexType == CDSIndexType.SPREAD ||
                    HeatMapGroup.IndexType == CDSIndexType.EQUITY)
                {
                    tickerFilterItems.CDSIndexName = tickerFilter.TFCDSIndex.CDSIndexName;
                    tickerFilterItems.PriceSource = vm.getPriceSource();

                    //regionList.SelectedValue = "ALL";
                    cdsIndexList.SelectedItem = vm.getCDSIndexLongName(HeatMapGroup.CDSIndexName);
                    cdsPriceSourceList.SelectedValue = tickerFilterItems.PriceSource;
                    savedList.SelectedValue = "";

                    vm.setFilterItemValues();

                    getInitialTickerFilterItems(false);
                    updateTickerFilterItems(tickerFilterItems, false);

                    resetCustomTickerParams();

                }
                else if (HeatMapGroup.IndexType == CDSIndexType.TICKERFILTER)
                {
                    //regionList.SelectedValue = "ALL";
                    cdsIndexList.SelectedItem = vm.getCDSIndexLongName(tickerFilterItems.CDSIndexName);
                    cdsPriceSourceList.SelectedValue = tickerFilterItems.PriceSource;
                    savedList.SelectedValue = tickerFilterItems.TickerFilterName;

                    vm.setFilterItemValues();

                    loadTickerFilterItems(tickerFilterItems, false);
                    //load tickerFilter
                    createTickerFilterListOnLoad(tickerFilterItems.applyFilterDync);
                }
                else
                {   //IndexType == CDSIndexType.UNKNOWN

                    Trace.WriteLine("Unexpected case in which CDS Index type is unknown for " + HeatMapGroup.CDSIndexLongName, "ERROR");

                    return;
                }

                Trace.WriteLine("TickerFilterView_Open is completed.", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while TickerFilterView_Open: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace TickerFilterView_Open: " + stackTrace, "INFO");
            }
        }

        void createPanelObject(Dictionary<string, List<TickerUserControl>> list)
        {

            int headerCount = list.Keys.Count;

            foreach (KeyValuePair<string, List<TickerUserControl>> item in list)
            {
                if (item.Key != "CUSTOM TICKER")
                {
                    DockPanel dp0 = new DockPanel();
                    Border brdr = new Border();
                    brdr.HorizontalAlignment = HorizontalAlignment.Stretch;
                    brdr.BorderBrush = Brushes.White;
                    brdr.BorderThickness = new Thickness(1);
                    brdr.Background = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/TickerFilter_title.png")));
                    brdr.Padding = new Thickness(1);
                    brdr.CornerRadius = new CornerRadius(4);
                    WrapPanel wpBottom = new WrapPanel();
                    TextBlock tb = new TextBlock();
                    tb.Text = item.Key.ToString();
                    tb.Foreground = Brushes.White;
                    tb.HorizontalAlignment = HorizontalAlignment.Center;
                    brdr.Child = tb;
                    brdr.Width = wrpPnl0.ActualWidth - ((SystemParameters.VerticalScrollBarWidth) / 4);


                    foreach (TickerUserControl ticker in list[item.Key])
                    {
                        wpBottom.Children.Add(ticker);
                    }


                    DockPanel.SetDock(brdr, Dock.Top);
                    DockPanel.SetDock(wpBottom, Dock.Bottom);
                    dp0.Children.Add(brdr);
                    dp0.Children.Add(wpBottom);

                    int minRow = findMinCount(wrpPnl0RowCount, wrpPnl1RowCount, wrpPnl2RowCount, wrpPnl3RowCount);

                    if (minRow == wrpPnl0RowCount)
                    {
                        wrpPnl0RowCount = wrpPnl0RowCount + item.Value.Count();
                        wrpPnl0.Children.Add(dp0);
                    }
                    else if (minRow == wrpPnl1RowCount)
                    {
                        wrpPnl1RowCount = wrpPnl1RowCount + item.Value.Count();
                        wrpPnl1.Children.Add(dp0);
                    }
                    else if (minRow == wrpPnl2RowCount)
                    {
                        wrpPnl2RowCount = wrpPnl2RowCount + item.Value.Count();
                        wrpPnl2.Children.Add(dp0);
                    }
                    else if (minRow == wrpPnl3RowCount)
                    {
                        wrpPnl3RowCount = wrpPnl3RowCount + item.Value.Count();
                        wrpPnl3.Children.Add(dp0);
                    }
                }
            }

        }

        private int findMinCount(int a, int b, int c, int d)
        {
            List<int> intList = new List<int>();
            intList.Add(a);
            intList.Add(b);
            intList.Add(c);
            intList.Add(d);
            intList = intList.OrderBy(numbers => numbers).ToList();
            return (intList.First());
        }

        public void addContextMenuToTicker(TickerUserControl ticker)
        {
            try
            {
                ticker.ContextMenuList = new ObservableCollection<ContextMenuItem>();

                ContextMenuItem contextItem1 = new ContextMenuItem();
                contextItem1.Displayname = "Equity DES";
                contextItem1.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem1.ChildName = ticker.Value.ToString();
                ticker.ContextMenuList.Add(contextItem1);

                ContextMenuItem contextItem2 = new ContextMenuItem();
                contextItem2.Displayname = "ECCG";
                contextItem2.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem2.ChildName = ticker.Value.ToString();
                ticker.ContextMenuList.Add(contextItem2);

                ContextMenuItem contextItem3 = new ContextMenuItem();
                contextItem3.Displayname = "Equity Corp";
                contextItem3.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem3.ChildName = ticker.Value.ToString();
                ticker.ContextMenuList.Add(contextItem3);

                ContextMenuItem contextItem4 = new ContextMenuItem();
                contextItem4.Displayname = "Equity GP";
                contextItem4.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem4.ChildName = ticker.Value.ToString();
                ticker.ContextMenuList.Add(contextItem4);

                ContextMenuItem contextItem5 = new ContextMenuItem();
                contextItem5.Displayname = "CN";
                contextItem5.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem5.ChildName = ticker.Value.ToString();
                ticker.ContextMenuList.Add(contextItem5);

                ContextMenuItem contextItem6 = new ContextMenuItem();
                contextItem6.Displayname = "RV";
                contextItem6.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem6.ChildName = ticker.Value.ToString();
                ticker.ContextMenuList.Add(contextItem6);

                ContextMenuItem contextItem7 = new ContextMenuItem();
                contextItem7.Displayname = "CRPR";
                contextItem7.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem7.ChildName = ticker.Value.ToString();
                ticker.ContextMenuList.Add(contextItem7);

                ticker.addContextMenuItem();
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while TickerFilterView addContextMenuToTicker: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace TickerFilterView addContextMenuToTicker: " + stackTrace, "INFO");
            }
        }

        #region RetrieveCommandForContextMenuItem
        public bool CanCreateContextMenu(object obj)
        {
            return true;
        }
        public void ClickContextMenu(object obj)
        {
            MenuItemDataObject items = (MenuItemDataObject)obj;
            if (items.action == "Equity DES" && items.childName != "")
                runFunction("DES", items.childName + " Equity");
            else if (items.action == "ECCG" && items.childName != "")
                runFunction("ECCG", items.childName + " Equity");
            else if (items.action == "Equity Corp" && items.childName != "")
                runFunction("Corp", items.childName);
            else if (items.action == "Equity GP" && items.childName != "")
                runFunction("GP", items.childName + " Equity");
            else if (items.action == "CN" && items.childName != "")
                runFunction("CN", items.childName + " Equity");
            else if (items.action == "RV" && items.childName != "")
                runFunction("RV", items.childName + " Equity");
            else if (items.action == "CRPR" && items.childName != "")
                runFunction("CRPR", items.childName + " Equity");

        }

        public void runFunction(string action, string ticker)
        {
            TerminalApi.RunFunction(action, ticker, Dispatcher);
        }
        #endregion

        private void mainList_OnGotFocus(object sender, SelectionChangedEventArgs e)
        {

            ComboBox SelectBox = (ComboBox)sender;

            if (TickerFilterViewModel.regionValue == null)
                return;

            Dictionary<string, List<string>> regionDict = vm.createRegionDict();

            if (regionDict == null)
            {
                Trace.WriteLine("Failed to retrieve CDS Index region list!", "ERROR");
                return;
            }

            RegionItems items = new RegionItems(regionDict);
            cdsIndexList.ItemsSource = CDSHeatMap.Util.ListUtil.getValueFromKey((TickerFilterViewModel.regionValue.ToString()), TickerFilterViewModel.newList);
        }

        public void doLoadTickerWork(string loadtickerFilterName)
        {
            Trace.WriteLine("doLoadTickerWork is called.", "TRACE");

            bool isTFloaded = false;

            try
            {
                // Introduce an artificial delay to demonstrate the busy indicator in the UI
                Thread thread = new Thread(() =>
                {
                    try
                    {
                        isTFloaded = vm.loadTickerFilterItemsAndData(loadtickerFilterName);
                    }
                    finally
                    {
                        vm.IsBusy = false;
                    }
                });
                thread.Start();

                while (vm.IsBusy == true)
                {
                    System.Threading.Thread.Sleep(100); // artificial delay
                }

                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        if (isTFloaded)
                        {
                            resetBorderBrush();

                            if (uncheckedRemoved)
                                uncheckedRemoved = false;

                            var tfName = savedList.Text;

                            clearTickerListParamaters();

                            var tickerFilterItems = vm.getTickerFilterItems();

                            cdsIndexList.SelectedItem = vm.getCDSIndexLongName(tickerFilterItems.CDSIndexName);
                            cdsPriceSourceList.SelectedValue = tickerFilterItems.PriceSource;
                            savedList.SelectedValue = tickerFilterItems.TickerFilterName;

                            quickFilter.QuickFilterCollection.Clear();
                            quickFilter.createGridItems("Hidden", "Visible", "Hidden");

                            loadTickerFilterItems(tickerFilterItems, false);
                            //load tickerFilter
                            createTickerFilterListOnLoad(vm.getTickerFilterItems().applyFilterDync);

                            //loadTickerFilterItems(vm.getTickerFilterItems(), true);
                            vm.setisTickerFilterChanged(true);

                            savedList.Text = tfName;
                        }
                        /*
                        else
                            warnFilterName.Text = "*Filter name couldn't found!";
                        */
                        

                        /*
                        string message = "";
                        if (isTFloaded)
                        {
                            message = "Ticker Filter is Loaded!";
                        }
                        else
                        {
                            message = "Unable to load saved Ticker Filter!";
                        }
                         */
                    }
                    catch (Exception ex1)
                    {
                        Trace.WriteLine("Exception in doLoadTickerWork: Exception (5003): " + ex1.Message, "ERROR");

                        string stackTrace = "";
                        if (ex1.StackTrace != null)
                            stackTrace = ex1.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace (5003): " + stackTrace, "INFO");
                    }
                    finally
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                    }
                    /*
                    var popup = new NotificationView(message);
                    PopupWindow.Instance.Title = "Ticker Filter Notification";
                    PopupWindow.Instance.ShowWindow(popup);
                     */
                });

                Trace.WriteLine("doLoadTickerWork is completed.", "TRACE");
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Error: (5004) - Exception while loading Ticker Filter " + loadtickerFilterName + "\nException: " + ex.Message.ToString(), "ERROR");

                string stackTrace = "";
                if (ex.StackTrace != null)
                    stackTrace = ex.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace (5004): " + stackTrace, "INFO");

                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        HideBusyIndicator(); 
                        Mouse.OverrideCursor = null;
                    }
                    catch (Exception eDispatcher)
                    {
                        Trace.WriteLine("Exception while mainThreadDispatcher process : " + eDispatcher.Message.ToString(), "INFO");
                        string stackTraceDispatcher = "";
                        if (eDispatcher.StackTrace != null)
                            stackTraceDispatcher = eDispatcher.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace: " + stackTraceDispatcher, "INFO");
                    }
                });
                /*
                var popup = new NotificationView(ex.Message);
                PopupWindow.Instance.Title = "Ticker Filter Error";
                PopupWindow.Instance.ShowWindow(popup);
                 */
            }
        }

        private void loadTickerFilterFromTickerFilterName(object sender, RoutedEventArgs e)
        {
            try
            {
                Trace.WriteLine("loadTickerFilterFromTickerFilterName is called.", "TRACE");

                clearFields();

                if (!String.IsNullOrWhiteSpace(savedList.Text))
                {
                    Mouse.OverrideCursor = Cursors.Wait;
                    ShowBusyIndicator("Loading Ticker Filter...");

                    string sendTickerFilter = savedList.Text;
                    vm.IsBusy = true;

                    Thread worker = new Thread(() =>
                    {
                        doLoadTickerWork(sendTickerFilter);
                    });
                    worker.Start();

                }

                Trace.WriteLine("loadTickerFilterFromTickerFilterName is completed.", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while loadTickerFilterFromTickerFilterName: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace loadTickerFilterFromTickerFilterName: " + stackTrace, "INFO");
            }
        }

        private void saveTickerFilter(object sender, RoutedEventArgs e)
        {
            try
            {
                Trace.WriteLine("saveTickerFilter is called.", "TRACE");

                clearFields();

                string message = "";
                //vm.save ticker filter
                if (!String.IsNullOrWhiteSpace(savedList.Text))
                {
                    resetBorderBrush();

                    var tfName = savedList.Text;
                    vm.getTickerFilterItems().CDSIndexName = vm.getTickerFilter().TFCDSIndex.CDSIndexName;
                    vm.getTickerFilter().TickerFilterName = vm.getTickerFilterItems().TickerFilterName = tfName;
                    vm.addTickerFilterItems(tfName);

                    vm.setisTickerFilterChanged(true);
                    savedList.Text = tfName;

                    message = "Ticker Filter is saved as " + tfName;
                }
                else
                {
                    message = "Ticker Filter couldn't saved!";
                    //warnFilterName.Text = "*Filter name can not be empty";
                }

                Trace.WriteLine("saveTickerFilter is completed.", "TRACE");

                var popup = new NotificationView(message, ErrorMsgLevel.None);
                PopupWindow.Instance.Title = "Ticker Filter Notification";
                PopupWindow.Instance.ShowWindow(popup);
                PopupWindow.Instance.Width = 250;//Aysegul Albayrak,popup size
                PopupWindow.Instance.Height = 230;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while saveTickerFilter: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace saveTickerFilter: " + stackTrace, "INFO");
            }

        }

        private void deleteTickerFilter(object sender, RoutedEventArgs e)
        {
            try
            {
                Trace.WriteLine("deleteTickerFilter is called.", "TRACE");

                clearFields();

                string message = "";
                //TODO: CDS index name kayboluyor
                //vm.save ticker filter
                if (!String.IsNullOrWhiteSpace(savedList.Text))
                {
                    resetBorderBrush();

                    vm.removeTickerFilterItems(savedList.Text);
                    savedList.Text = "";
                    vm.getTickerFilterItems().TickerFilterName = savedList.Text;
                    vm.getTickerFilter().TickerFilterName = savedList.Text;

                    clearTickerFilter(null, null);
                    vm.setisTickerFilterChanged(true);

                    message = savedList.Text + " Ticker Filter is deleted.";
                }
                else
                {
                    message = savedList.Text + " Ticker Filter couldn't be deleted.";
                    //warnFilterName.Text = "*Filter name can not be empty";
                }

                Trace.WriteLine("deleteTickerFilter is completed.", "TRACE");

                var popup = new NotificationView(message, ErrorMsgLevel.None);
                PopupWindow.Instance.Title = "Ticker Filter Notification";
                PopupWindow.Instance.ShowWindow(popup);
                PopupWindow.Instance.Width = 280;//Aysegul Albayrak,popup size
                PopupWindow.Instance.Height = 230;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while deleteTickerFilter: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace deleteTickerFilter: " + stackTrace, "INFO");
            }
        }

        private void clearTickerFilter(object sender, RoutedEventArgs e)
        {
            try
            {
                Trace.WriteLine("clearTickerFilter is called.", "TRACE");

                resetBorderBrush();

                clearFields();
                listView.Visibility = Visibility.Collapsed;
                clearTickerListParamaters();

                if (uncheckedRemoved)
                    uncheckedRemoved = false;

                /*
                chckBox.IsChecked = false;
                unChckBox.IsChecked = false;
                removeChckBox.IsChecked = false;
                */

                vm.resetTickerFilterWithInitialData();

                getInitialTickerFilterItems(false);
                updateTickerFilterItems(vm.getTickerFilterItems(), false);

                //regionList.SelectedValue = "ALL";
                vm.fillRegionList();

                if (cdsIndexList.SelectedItem == null)
                    vm.getTickerFilter().TickerFilterName = "";
                else
                    vm.getTickerFilter().TickerFilterName = vm.getCDSIndexShortName(cdsIndexList.SelectedItem.ToString());

                vm.getTickerFilterItems().TickerFilterName = vm.getTickerFilter().TickerFilterName;

                quickFilter.QuickFilterCollection.Clear();
                quickFilter.createGridItems("Hidden", "Visible", "Hidden");

                cdsPriceSourceList.SelectedValue = vm.getPriceSource();
                savedList.SelectedValue = "";
                savedList.Text = "";

                vm.setisTickerFilterChanged(true);

                Trace.WriteLine("clearTickerFilter is completed.", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while clearTickerFilter: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace clearTickerFilter: " + stackTrace, "INFO");
            }
        }

        private void chckBox_Checked(object sender, RoutedEventArgs e)
        {
            resetBorderBrush();

            if (uncheckedRemoved)
            {
                retrieveTickerList();
                uncheckedRemoved = false;
            }
            
            changeTickerCkecked(true);
        }

        private void unChckBox_Checked(object sender, RoutedEventArgs e)
        {
            resetBorderBrush();

            if (uncheckedRemoved)
            {
                retrieveTickerList();
                uncheckedRemoved = false;
            }

            changeTickerCkecked(false);
        }

        private void changeTickerCkecked(bool value)
        {
            try
            {
                vm.getTickerFilterItems().TickerFilterName = vm.getTickerFilter().TickerFilterName = "";
                savedList.SelectedValue = "";

                var tickerFilterItems = vm.getTickerFilterItems();

                tickerFilterItems.unselectedTickerList.Clear();
                tickerFilterItems.selectedTickerList.Clear();

                foreach (KeyValuePair<string, List<TickerUserControl>> item in tickerList)
                {
                    foreach (TickerUserControl ticker in tickerList[item.Key])
                    {
                        ticker.IsChecked = value;
                        string tickerName = ticker.Value.ToString();

                        if (value)
                        {
                            tickerFilterItems.selectedTickerList.Add(tickerName);

                            if (tickerFilterItems.filteredoutTickerList.Contains(tickerName))
                            {
                                //ticker.Background = Brushes.Orange;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_orange.png")));
                                ticker.LabelFontColor = Brushes.Black;   //TODO
                            }
                            else
                            {
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                ticker.LabelFontColor = Brushes.White;   //TODO
                            }

                        }
                        else
                        {
                            tickerFilterItems.unselectedTickerList.Add(tickerName);

                            if (tickerFilterItems.filteredinTickerList.Contains(tickerName))
                            {
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                                ticker.LabelFontColor = Brushes.Black;   //TODO
                            }
                            else
                            {
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                ticker.LabelFontColor = Brushes.White;   //TODO
                            }
                        }
                    }
                }

                vm.updateTickerFilterAfterFlag(value);

                vm.setisTickerFilterChanged(true);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while changeTickerCkecked: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace changeTickerCkecked: " + stackTrace, "INFO");
            }
        }

        private void removeUnChckBox_Checked(object sender, RoutedEventArgs e)
        {
            resetBorderBrush();

            if (!uncheckedRemoved)
                removeTicker(true);
        }

        private void removeTicker(bool checkedValue)
        {
            try
            {
                var tfItems = vm.getTickerFilterItems();
                var tf = vm.getTickerFilter();

                Dictionary<string, List<ItemChecked>> tempTickerList = new Dictionary<string, List<ItemChecked>>();

                foreach (KeyValuePair<string, List<TickerUserControl>> items in tickerList)
                {
                    List<ItemChecked> listTicker = new List<ItemChecked>();
                    foreach (TickerUserControl ticker in tickerList[items.Key].ToList())
                    {
                        if (items.Key != "CUSTOM TICKER")
                        {
                            if (checkedValue)
                            {
                                if (ticker.IsChecked)
                                {
                                    ItemChecked tempTicker = new ItemChecked();
                                    tempTicker.Text = ticker.Value.ToString();
                                    tempTicker.IsChecked = ticker.IsChecked;
                                    listTicker.Add(tempTicker);
                                }
                                else
                                    uncheckedRemoved = true;
                            }
                            else
                            {
                                ItemChecked tempTicker = new ItemChecked();
                                tempTicker.Text = ticker.Value.ToString();
                                tempTicker.IsChecked = ticker.IsChecked;
                                listTicker.Add(tempTicker);
                            }
                        }
                        else
                        {
                            if (checkedValue)
                            {
                                if (ticker.IsChecked)
                                {
                                    ItemChecked tempTicker = new ItemChecked();
                                    tempTicker.Text = ticker.Value.ToString();
                                    tempTicker.IsChecked = ticker.IsChecked;
                                    listTicker.Add(tempTicker);
                                }
                                else
                                {
                                    int i = tfItems.addedTickerList.IndexOf(ticker.Value.ToString());

                                    if (i >= 0)
                                    {
                                        tfItems.addedTickerList.RemoveAt(i);
                                        tfItems.addedTickerDescriptionList.RemoveAt(i);
                                        tfItems.unselectedTickerList.Remove(ticker.Value.ToString());

                                        for (int z = 0; i < tf.AddedTickerList.Count; ++z)
                                        {
                                            if (tf.AddedTickerList[z].TickerEquity == ticker.Value.ToString())
                                            {
                                                tf.AddedTickerList.RemoveAt(z);
                                                break;
                                            }
                                        }
                                    }

                                }
                            }
                            else
                            {
                                ItemChecked tempTicker = new ItemChecked();
                                tempTicker.Text = ticker.Value.ToString();
                                tempTicker.IsChecked = ticker.IsChecked;
                                listTicker.Add(tempTicker);
                            }

                        }

                    }

                    if ((tickerList[items.Key]).Count > 0)
                        tempTickerList.Add(items.Key, listTicker);
                }

                clearTickerListParamaters();

                foreach (KeyValuePair<string, List<ItemChecked>> items in tempTickerList)
                {
                    if (items.Key != "CUSTOM TICKER")
                    {
                        List<TickerUserControl> listTicker = new List<TickerUserControl>();
                        foreach (ItemChecked ticker in tempTickerList[items.Key].ToList())
                        {
                            TickerUserControl tempTicker = new TickerUserControl();
                            tempTicker.Value = ticker.Text;
                            tempTicker.CheckBox_ItemChecked += CheckTicker;
                            tempTicker.IsChecked = ticker.IsChecked;
                            tempTicker.TickerWidth = 135;
                            addContextMenuToTicker(tempTicker);
                            listTicker.Add(tempTicker);

                            if (ticker.IsChecked)
                            {
                                if (tfItems.selectedTickerList.Contains(ticker.Text) && tfItems.filteredoutTickerList.Contains(ticker.Text))
                                {
                                    //tempTicker.Background = Brushes.Orange;
                                    tempTicker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_orange.png")));
                                    tempTicker.LabelFontColor = Brushes.Black;   //TODO
                                }
                                else
                                {
                                    tempTicker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                    tempTicker.LabelFontColor = Brushes.White;   //TODO
                                }
                            }
                            else
                            {
                                if (tfItems.unselectedTickerList.Contains(ticker.Text) && tfItems.filteredinTickerList.Contains(ticker.Text))
                                {
                                    //tempTicker.BorderBackground = Brushes.Green;
                                    tempTicker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                                    tempTicker.LabelFontColor = Brushes.Black;   //TODO
                                }
                                else
                                {
                                    tempTicker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                    tempTicker.LabelFontColor = Brushes.White;   //TODO
                                }
                            }
                        }
                        if (tempTickerList[items.Key].Count > 0)
                            tickerList.Add(items.Key, listTicker);
                    }
                }

                createPanelObject(tickerList);

                foreach (KeyValuePair<string, List<ItemChecked>> listTicker in tempTickerList)
                {
                    if (listTicker.Key == "CUSTOM TICKER")
                    {
                        foreach (ItemChecked item in listTicker.Value)
                        {
                            addTickerToPanel(item.Text, item.IsChecked);
                        }
                        break;
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while removeTicker: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace removeTicker: " + stackTrace, "INFO");
            }
        }

        private void doCDSIndexChangedWork(string chgcdsIndexName)
        {
            try
            {
                Trace.WriteLine("doCDSIndexChangedWork is called", "TRACE");

                // Introduce an artificial delay to demonstrate the busy indicator in the UI
                Thread thread = new Thread(() =>
                {
                    try
                    {
                        vm.getBloombergInitialData(chgcdsIndexName);
                    }
                    finally
                    {
                        vm.IsBusy = false;
                    }
                });
                thread.Start();

                while (vm.IsBusy == true)
                {
                    if (!thread.IsAlive)
                    {
                        vm.IsBusy = false;
                    }
                    System.Threading.Thread.Sleep(100); // artificial delay
                }

                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        vm.getTickerFilterItems().CDSIndexName = vm.getTickerFilter().TFCDSIndex.CDSIndexName;
                        vm.getTickerFilter().TickerFilterName = vm.getTickerFilterItems().CDSIndexName;

                        getInitialTickerFilterItems(false);
                        updateTickerFilterItems(vm.getTickerFilterItems(), false);

                        vm.setisTickerFilterChanged(true);
                        vm.setisCDSDataRetrieved(true);
                        vm.setisAddedTickerDataRetrieved(true);

                        savedList.SelectedValue = "";
                    }
                    catch (Exception ex2)
                    {
                        Trace.WriteLine("Error: (5006) - Exception in doCDSIndexChangedWork while changing CDS index " + chgcdsIndexName + "\nException: " + ex2.Message.ToString(), "ERROR");

                        string stackTrace = "";
                        if (ex2.StackTrace != null)
                            stackTrace = ex2.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace (5006): " + stackTrace, "INFO");
                    }
                    finally
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                        cdsIndexList.Background = Brushes.White;
                    }
                });

                Trace.WriteLine("doCDSIndexChangedWork is completed", "TRACE");
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Error: (5007) - Exception while changing CDS Index to " + chgcdsIndexName + "\nException: " + ex.Message.ToString(), "ERROR");

                string stackTrace = "";
                if (ex.StackTrace != null)
                    stackTrace = ex.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace (5007): " + stackTrace, "INFO");
                
                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                        cdsIndexList.Background = Brushes.White;
                    }
                    catch (Exception eDispatcher)
                    {
                        Trace.WriteLine("Exception while mainThreadDispatcher process : " + eDispatcher.Message.ToString(), "INFO");
                        string stackTraceDispatcher = "";
                        if (eDispatcher.StackTrace != null)
                            stackTraceDispatcher = eDispatcher.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace: " + stackTraceDispatcher, "INFO");
                    }
                 });
                //Trace.WriteLine(string.Format("Unable to load PDF file {0}: {1}", uri, ex), "ERROR");
            }
        
        }

        private void cdsIndexList_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            try
            {
                Trace.WriteLine("cdsIndexList_SelectionChanged is called", "TRACE");

                ComboBox cb = (ComboBox)sender;
                if (cb != null && cb.IsDropDownOpen)
                {
                    cdsIndexList.Background = Brushes.Yellow;

                    if (cdsIndexList.SelectedValue != null &&
                        /*cdsIndexList.SelectedValue != "" &&*/
                        vm.getTickerFilterItems().CDSIndexName != null &&
                        vm.getTickerFilterItems().CDSIndexName != "" &&
                        cdsIndexList.SelectedValue.ToString() != vm.getCDSIndexLongName(vm.getTickerFilterItems().CDSIndexName))
                    {
                        resetBorderBrush();
                        //TODO: ask user ? save no save cancel data will be lost

                        if (uncheckedRemoved)
                            uncheckedRemoved = false;

                        vm.getTickerFilter().reset();

                        clearTickerListParamaters();
                        /*
                        chckBox.IsChecked = false;
                        removeChckBox.IsChecked = false;
                        unChckBox.IsChecked = false;
                        */

                        string tempcdsindex = vm.getCDSIndexShortName(cdsIndexList.SelectedValue.ToString());

                        vm.IsBusy = true;

                        Mouse.OverrideCursor = Cursors.Wait;

                        ShowBusyIndicator("Loading CDS Index...");


                        // Introduce an artificial delay to demonstrate the busy indicator in the UI
                        Thread worker = new Thread(() =>
                        {
                            doCDSIndexChangedWork(tempcdsindex);
                        });
                        worker.Start();
                    }
                    else
                        cdsIndexList.Background = Brushes.White;
                }
                Trace.WriteLine("cdsIndexList_SelectionChanged is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while cdsIndexList_SelectionChanged: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace cdsIndexList_SelectionChanged: " + stackTrace, "INFO");
            }
            
        }

        private void doPricingSourceChangedWork()
        {
            try
            {
                Trace.WriteLine("doPricingSourceChangedWork is called", "TRACE");

                // Introduce an artificial delay to demonstrate the busy indicator in the UI
                Thread thread = new Thread(() =>
                {
                    try
                    {
                        vm.updateCDSPricePriceSource();
                    }
                    finally
                    {
                        vm.IsBusy = false;
                    }
                });
                thread.Start();

                while (vm.IsBusy == true)
                {
                    System.Threading.Thread.Sleep(100); // artificial delay
                }

                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        bool updateCheckedItem = false;

                        if (sliderSpread.minimum < sliderSpread.lowerValue ||
                           sliderSpread.maximum > sliderSpread.upperValue ||
                           sliderCurve.minimum < sliderCurve.lowerValue ||
                           sliderCurve.maximum > sliderCurve.upperValue)
                            updateCheckedItem = true;

                        var spread5Y_minmax = vm.getTickerFilter().getCDS5YSpread_MinMax();
                        sliderSpread.minimum = spread5Y_minmax[0] ?? 0.0;
                        sliderSpread.maximum = spread5Y_minmax[1] ?? 0.0;
                        sliderSpread.lowerValue = sliderSpread.minimum;
                        sliderSpread.upperValue = sliderSpread.maximum;

                        //fill CDS curve slider
                        var curve_minmax = vm.getCDSCurveFilter_MinMax();
                        sliderCurve.minimum = curve_minmax[0] ?? 0.0;
                        sliderCurve.maximum = curve_minmax[1] ?? 0.0;
                        sliderCurve.lowerValue = sliderCurve.minimum;
                        sliderCurve.upperValue = sliderCurve.maximum;

                        vm.setisTickerFilterChanged(true);

                        if (updateCheckedItem)
                            onDragCompleted(null, null);
                    }
                    catch (Exception ex3)
                    {
                        Trace.WriteLine("Exception while changing Pricing Source (5008): " + ex3.Message.ToString(), "ERROR");
                        //Trace.WriteLine(string.Format("Unable to load PDF file {0}: {1}", uri, ex), "ERROR");

                        string stackTrace = "";
                        if (ex3.StackTrace != null)
                            stackTrace = ex3.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace (5008): " + stackTrace, "INFO");
                    }
                    finally
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                        cdsPriceSourceList.Background = Brushes.White;
                    }
                });

                Trace.WriteLine("doPricingSourceChangedWork is completed", "TRACE");
            }
            catch (Exception ex)
            {
                Trace.WriteLine("Exception while changing Pricing Source (5009): " + ex.Message.ToString(), "ERROR");
                //Trace.WriteLine(string.Format("Unable to load PDF file {0}: {1}", uri, ex), "ERROR");

                string stackTrace = "";
                if (ex.StackTrace != null)
                    stackTrace = ex.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace (5009): " + stackTrace, "INFO");

                mainThreadDispatcher.BeginInvoke((Action)delegate
                {
                    try
                    {
                        HideBusyIndicator();
                        Mouse.OverrideCursor = null;
                        cdsPriceSourceList.Background = Brushes.White;
                    }
                    catch (Exception eDispatcher)
                    {
                        Trace.WriteLine("Exception while mainThreadDispatcher process : " + eDispatcher.Message.ToString(), "INFO");
                        string stackTraceDispatcher = "";
                        if (eDispatcher.StackTrace != null)
                            stackTraceDispatcher = eDispatcher.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace: " + stackTraceDispatcher, "INFO");
                    }
                });
            }
        }

        private void PricingSource_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            try
            {
                Trace.WriteLine("PricingSource_SelectionChanged is called", "TRACE");

                ComboBox cb = (ComboBox)sender;
                if (cb != null && cb.IsDropDownOpen)
                {
                    cdsPriceSourceList.Background = Brushes.Yellow;

                    if (cdsPriceSourceList.SelectedValue != null &&
                        cdsPriceSourceList.SelectedValue.ToString() != "" &&
                        vm.getTickerFilterItems().PriceSource != "" &&
                        cdsPriceSourceList.SelectedValue.ToString() != vm.getTickerFilterItems().PriceSource)
                    {
                        resetBorderBrush();

                        vm.getTickerFilterItems().PriceSource = cdsPriceSourceList.SelectedValue.ToString();
                        vm.setPriceSource(cdsPriceSourceList.SelectedValue.ToString());
                        vm.getTickerFilter().PriceSource = cdsPriceSourceList.SelectedValue.ToString();

                        Mouse.OverrideCursor = Cursors.Wait;
                        ShowBusyIndicator("Updating CDS Price Source...");

                        vm.IsBusy = true;

                        // Introduce an artificial delay to demonstrate the busy indicator in the UI
                        Thread worker = new Thread(() =>
                        {
                            doPricingSourceChangedWork();
                        });
                        worker.Start();
                    }
                }

                Trace.WriteLine("PricingSource_SelectionChanged is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while PricingSource_SelectionChanged: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace PricingSource_SelectionChanged: " + stackTrace, "INFO");
            }
        }

        private void Curve_SelectionChanged(object sender, RoutedEventArgs e)
        {
            resetBorderBrush();

            bool needUpdate = false;

            if (sliderCurve.minimum < sliderCurve.lowerValue ||
                sliderCurve.maximum > sliderCurve.upperValue)
                needUpdate = true;

            var tfItems = vm.getTickerFilterItems();
            var curve_minmax = vm.getCDSCurveFilter_MinMax();

            tfItems.selCDSCurveFilter = vm.getCurveFilter_name();

            tfItems.CDSCurveFilterMin = sliderCurve.minimum = curve_minmax[0] ?? 0.0;
            tfItems.CDSCurveFilterMax = sliderCurve.maximum = curve_minmax[1] ?? 0.0;
            tfItems.CDSCurveFilterSelMin = sliderCurve.lowerValue = sliderCurve.minimum;
            tfItems.CDSCurveFilterSelMax = sliderCurve.upperValue = sliderCurve.maximum;

            if (needUpdate)
                onDragCompleted(null, null);
        }

        private void ratingClick(object sender, RoutedEventArgs e)
        {
            CheckBox chckBox = sender as CheckBox;
            bool checkedValue = (chckBox.IsChecked ?? false);
            string rating = chckBox.Content.ToString();

            var tf = vm.getTickerFilterItems();

            for (int i = 0; i < tf.Ratings.Count; ++i)
            {
                if (rating == tf.Ratings[i])
                {
                    if (tf.RatingsChecked[i] != checkedValue)
                    {
                        tf.RatingsChecked[i] = checkedValue;

                        onDragCompleted(null, null);
                    }
                    break;
                }
            }

            
        }

        private void industriesClick(object sender, RoutedEventArgs e)
        {
            CheckBox chckBox = sender as CheckBox;
            bool checkedValue = (chckBox.IsChecked ?? false);
            string industryName = chckBox.Content.ToString();

            var tf = vm.getTickerFilterItems();

            for (int i = 0; i < tf.Industries.Count; ++i)
            {
                if (industryName == tf.Industries[i])
                {
                    if (tf.IndustriesChecked[i] != checkedValue)
                    {
                        tf.IndustriesChecked[i] = checkedValue;

                        onDragCompleted(null, null);
                    }
                    break;
                }
            }

            
        }

        public void getInitialTickerFilterItems(bool keepAddedTickers=true)
        {
            try
            {
                Trace.WriteLine("getInitialTickerFilterItems is called", "TRACE");

                var tickerFilter = vm.getTickerFilter();

                //fill industry list
                vm.fillIndustriesList();

                //fill ratings list
                vm.fillRatingsList();

                //fill CDS 5Y spread slider
                var spread5Y_minmax = tickerFilter.getCDS5YSpread_MinMax();
                sliderSpread.minimum = spread5Y_minmax[0] ?? 0.0;
                sliderSpread.maximum = spread5Y_minmax[1] ?? 0.0;
                sliderSpread.lowerValue = sliderSpread.minimum;
                sliderSpread.upperValue = sliderSpread.maximum;
                sliderSpread.suffix = "";
                sliderSpread.tickFrequency = 1;
                sliderSpread.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //fill CDS curve slider
                var curve_minmax = vm.getCDSCurveFilter_MinMax();
                sliderCurve.minimum = curve_minmax[0] ?? 0.0;
                sliderCurve.maximum = curve_minmax[1] ?? 0.0;
                sliderCurve.lowerValue = sliderCurve.minimum;
                sliderCurve.upperValue = sliderCurve.maximum;
                sliderCurve.suffix = "";
                sliderCurve.tickFrequency = 0.01;
                sliderCurve.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //fill Market Cap
                var marketcap_minmax = tickerFilter.getMarketCap_MinMax();
                sliderMarketCap.minimum = marketcap_minmax[0] ?? 0.0;
                sliderMarketCap.maximum = marketcap_minmax[1] ?? 0.0;
                sliderMarketCap.lowerValue = sliderMarketCap.minimum;
                sliderMarketCap.upperValue = sliderMarketCap.maximum;
                sliderMarketCap.suffix = ""; //"B";
                sliderMarketCap.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //fill Total Debt To Total Capital
                var totaldebttocap_minmax = tickerFilter.getTotalDebtTotalCap_MinMax();
                sliderDept.minimum = totaldebttocap_minmax[0] ?? 0.0;
                sliderDept.maximum = totaldebttocap_minmax[1] ?? 0.0;
                sliderDept.lowerValue = sliderDept.minimum;
                sliderDept.upperValue = sliderDept.maximum;
                sliderDept.suffix = "%";
                sliderDept.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //fill Debt to Common Equity
                var debttoequity_minmax = tickerFilter.getDebtCommonEquity_MinMax();
                sliderEquity.minimum = debttoequity_minmax[0] ?? 0.0;
                sliderEquity.maximum = debttoequity_minmax[1] ?? 0.0;
                sliderEquity.lowerValue = sliderEquity.minimum;
                sliderEquity.upperValue = sliderEquity.maximum;
                sliderEquity.suffix = "%";
                sliderEquity.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //fill Interest Coverage Ratio
                var interestcovratio_minmax = tickerFilter.getInterestCoverageRatio_MinMax();
                sliderRatio.minimum = interestcovratio_minmax[0] ?? 0.0;
                sliderRatio.maximum = interestcovratio_minmax[1] ?? 0.0;
                sliderRatio.lowerValue = sliderRatio.minimum;
                sliderRatio.upperValue = sliderRatio.maximum;
                sliderRatio.suffix = "";
                sliderRatio.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                var industryTickerList = vm.getIndustryTickerList();

                tickerList.Clear();

                foreach (KeyValuePair<string, List<ItemChecked>> listTicker in industryTickerList)
                {
                    if (listTicker.Key != "CUSTOM TICKER")
                    {
                        List<TickerUserControl> list = new List<TickerUserControl>();

                        foreach (ItemChecked item in listTicker.Value)
                        {
                            //if (removeChckBox.IsChecked == false)

                            TickerUserControl ticker = new TickerUserControl();
                            ticker.Value = item.Text;
                            ticker.CheckBox_ItemChecked += CheckTicker;
                            ticker.IsChecked = item.IsChecked;
                            ticker.TickerWidth = 135;                       //TODO
                            addContextMenuToTicker(ticker);                //TODO
                            ticker.Background = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                            ticker.LabelFontColor = Brushes.White;   //TODO
                            list.Add(ticker);

                        }

                        if (list.Count > 0)
                            tickerList.Add(listTicker.Key, list);
                    }
                }

                createPanelObject(tickerList);
                if (keepAddedTickers)
                {
                    foreach (KeyValuePair<string, List<ItemChecked>> listTicker in industryTickerList)
                    {
                        if (listTicker.Key == "CUSTOM TICKER")
                        {
                            foreach (ItemChecked item in listTicker.Value)
                            {
                                //if (removeChckBox.IsChecked == false)
                                addTickerToPanel(item.Text, item.IsChecked);
                            }
                            break;
                        }
                    }
                }

                Trace.WriteLine("getInitialTickerFilterItems is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while getInitialTickerFilterItems: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace getInitialTickerFilterItems: " + stackTrace, "INFO");
            }
        }

        public void loadTickerFilterItems(TickerFilterItems tickerFilterItems, bool isFilter)
        {
            try
            {
                Trace.WriteLine("loadTickerFilterItems is called", "TRACE");
                //load industry list
                vm.loadIndustriesList(tickerFilterItems.Industries, tickerFilterItems.IndustriesChecked);

                //load ratings list
                vm.loadRatingsList(tickerFilterItems.Ratings, tickerFilterItems.RatingsChecked);

                //load CDS 5Y spread slider
                sliderSpread.minimum = tickerFilterItems.CDS5YSpreadMin ?? 0.0;
                sliderSpread.maximum = tickerFilterItems.CDS5YSpreadMax ?? 0.0;
                sliderSpread.lowerValue = tickerFilterItems.CDS5YSpreadSelMin ?? 0.0;
                sliderSpread.upperValue = tickerFilterItems.CDS5YSpreadSelMax ?? 0.0;
                sliderSpread.suffix = "";
                sliderSpread.tickFrequency = 1;
                sliderSpread.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //load CDS curve slider
                vm.checkCurveList(tickerFilterItems.selCDSCurveFilter, true);
                sliderCurve.minimum = tickerFilterItems.CDSCurveFilterMin ?? 0.0;
                sliderCurve.maximum = tickerFilterItems.CDSCurveFilterMax ?? 0.0;
                sliderCurve.lowerValue = tickerFilterItems.CDSCurveFilterSelMin ?? 0.0;
                sliderCurve.upperValue = tickerFilterItems.CDSCurveFilterSelMax ?? 0.0;
                sliderCurve.suffix = "";
                sliderCurve.tickFrequency = 0.01;
                sliderCurve.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //load Market Cap
                sliderMarketCap.minimum = tickerFilterItems.marketCapMin ?? 0.0;
                sliderMarketCap.maximum = tickerFilterItems.marketCapMax ?? 0.0;
                sliderMarketCap.lowerValue = tickerFilterItems.marketCapSelMin ?? 0.0;
                sliderMarketCap.upperValue = tickerFilterItems.marketCapSelMax ?? 0.0;
                sliderMarketCap.suffix = ""; //"B";
                sliderMarketCap.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //load Total Debt To Total Capital
                sliderDept.minimum = tickerFilterItems.totalDebtToTotalCapMin ?? 0.0;
                sliderDept.maximum = tickerFilterItems.totalDebtToTotalCapMax ?? 0.0;
                sliderDept.lowerValue = tickerFilterItems.totalDebtToTotalCapSelMin ?? 0.0;
                sliderDept.upperValue = tickerFilterItems.totalDebtToTotalCapSelMax ?? 0.0;
                sliderDept.suffix = "%";
                sliderDept.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //load Debt to Common Equity
                sliderEquity.minimum = tickerFilterItems.debtToCommonEquityMin ?? 0.0;
                sliderEquity.maximum = tickerFilterItems.debtToCommonEquityMax ?? 0.0;
                sliderEquity.lowerValue = tickerFilterItems.debtToCommonEquitySelMin ?? 0.0;
                sliderEquity.upperValue = tickerFilterItems.debtToCommonEquitySelMax ?? 0.0;
                sliderEquity.suffix = "%";
                sliderEquity.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                //fill Interest Coverage Ratio
                sliderRatio.minimum = tickerFilterItems.interestCoverageRatioMin ?? 0.0;
                sliderRatio.maximum = tickerFilterItems.interestCoverageRatioMax ?? 0.0;
                sliderRatio.lowerValue = tickerFilterItems.interestCoverageRatioSelMin ?? 0.0;
                sliderRatio.upperValue = tickerFilterItems.interestCoverageRatioSelMax ?? 0.0;
                sliderRatio.suffix = "";
                sliderRatio.DragCompleted += new DragCompletedEventHandler(onDragCompleted);

                chkApplyFilter.IsChecked = tickerFilterItems.applyFilterDync;

                //TODO: set quickFilterList
                createQuickFilterItems();

                tickerList.Clear();
                var industryTickerList = vm.getIndustryTickerList();

                foreach (KeyValuePair<string, List<ItemChecked>> listTicker in industryTickerList)
                {
                    if (listTicker.Key != "CUSTOM TICKER")
                    {
                        List<TickerUserControl> list = new List<TickerUserControl>();

                        foreach (ItemChecked item in listTicker.Value)
                        {
                            //if (removeChckBox.IsChecked == false)
                            {
                                TickerUserControl ticker = new TickerUserControl();
                                ticker.Value = item.Text;
                                ticker.CheckBox_ItemChecked += CheckTicker;
                                ticker.IsChecked = item.IsChecked;

                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                ticker.LabelFontColor = Brushes.White;   //TODO

                                ticker.TickerWidth = 135;                       //TODO
                                addContextMenuToTicker(ticker);                //TODO
                                list.Add(ticker);
                            }
                        }

                        if (list.Count > 0)
                            tickerList.Add(listTicker.Key, list);
                    }
                }

                createPanelObject(tickerList);

                foreach (KeyValuePair<string, List<ItemChecked>> listTicker in industryTickerList)
                {
                    if (listTicker.Key == "CUSTOM TICKER")
                    {
                        foreach (ItemChecked item in listTicker.Value)
                        {
                            //if (removeChckBox.IsChecked == false)
                            addTickerToPanel(item.Text, item.IsChecked);
                        }
                        break;
                    }
                }

                if (isFilter)
                {
                    onDragCompleted(null, null);

                    //TODO: compare previously checked/unchecked tickers according to new filter item values
                }

                Trace.WriteLine("loadTickerFilterItems is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while loadTickerFilterItems: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace loadTickerFilterItems: " + stackTrace, "INFO");
            }

        }

        //call save tickerFilterItems after this
        public void updateTickerFilterItems(TickerFilterItems tickerFilterItems, bool keepAddedTickers)
        {
            try
            {
                Trace.WriteLine("updateTickerFilterItems is called", "TRACE");
                //fill industries
                tickerFilterItems.Industries.Clear();
                tickerFilterItems.IndustriesChecked.Clear();

                foreach (var industry in vm.retrieveIndustryList())
                {
                    tickerFilterItems.Industries.Add(industry);
                    tickerFilterItems.IndustriesChecked.Add(true);
                }

                //fill ratings
                tickerFilterItems.Ratings.Clear();
                tickerFilterItems.RatingsChecked.Clear();
                foreach (var industry in vm.retrieveRatingsList())
                {
                    tickerFilterItems.Ratings.Add(industry);
                    tickerFilterItems.RatingsChecked.Add(true);
                }

                //pricesource
                if (cdsPriceSourceList.SelectedValue != null)
                    tickerFilterItems.PriceSource = cdsPriceSourceList.SelectedValue.ToString();
                else
                    tickerFilterItems.PriceSource = "Default";

                //fill CDS 5Y spread slider
                tickerFilterItems.CDS5YSpreadMin = sliderSpread.minimum;
                tickerFilterItems.CDS5YSpreadMax = sliderSpread.maximum;
                tickerFilterItems.CDS5YSpreadSelMin = sliderSpread.lowerValue;
                tickerFilterItems.CDS5YSpreadSelMax = sliderSpread.upperValue;

                //fill CDS curve slider
                //TODO: set radiobutton
                tickerFilterItems.selCDSCurveFilter = vm.getCurveFilter_name();
                tickerFilterItems.CDSCurveFilterMin = sliderCurve.minimum;
                tickerFilterItems.CDSCurveFilterMax = sliderCurve.maximum;
                tickerFilterItems.CDSCurveFilterSelMin = sliderCurve.lowerValue;
                tickerFilterItems.CDSCurveFilterSelMax = sliderCurve.upperValue;

                //fill Market Cap
                tickerFilterItems.marketCapMin = sliderMarketCap.minimum;
                tickerFilterItems.marketCapMax = sliderMarketCap.maximum;
                tickerFilterItems.marketCapSelMin = sliderMarketCap.lowerValue;
                tickerFilterItems.marketCapSelMax = sliderMarketCap.upperValue;

                //fill Total Debt To Total Capital
                tickerFilterItems.totalDebtToTotalCapMin = sliderDept.minimum;
                tickerFilterItems.totalDebtToTotalCapMax = sliderDept.maximum;
                tickerFilterItems.totalDebtToTotalCapSelMin = sliderDept.lowerValue;
                tickerFilterItems.totalDebtToTotalCapSelMax = sliderDept.upperValue;

                //fill Debt to Common Equity
                tickerFilterItems.debtToCommonEquityMin = sliderEquity.minimum;
                tickerFilterItems.debtToCommonEquityMax = sliderEquity.maximum;
                tickerFilterItems.debtToCommonEquitySelMin = sliderEquity.lowerValue;
                tickerFilterItems.debtToCommonEquitySelMax = sliderEquity.upperValue;

                //fill Interest Coverage Ratio
                tickerFilterItems.interestCoverageRatioMin = sliderRatio.minimum;
                tickerFilterItems.interestCoverageRatioMax = sliderRatio.maximum;
                tickerFilterItems.interestCoverageRatioSelMin = sliderRatio.lowerValue;
                tickerFilterItems.interestCoverageRatioSelMax = sliderRatio.upperValue;

                tickerFilterItems.applyFilterDync = chkApplyFilter.IsChecked ?? false;

                tickerFilterItems.unselectedTickerList.Clear();
                tickerFilterItems.selectedTickerList.Clear();
                tickerFilterItems.filteredoutTickerList.Clear();
                tickerFilterItems.filteredinTickerList.Clear();

                if (keepAddedTickers)
                {
                    foreach (var keylist in tickerList)
                    {
                        if (keylist.Key == "CUSTOM TICKER")
                        {
                            foreach (var listitem in keylist.Value)
                            {
                                if (listitem.IsChecked)
                                    tickerFilterItems.filteredinTickerList.Add(listitem.Value.ToString());
                                else
                                    tickerFilterItems.unselectedTickerList.Add(listitem.Value.ToString());
                            }
                        }
                        else
                        {
                            foreach (var listitem in keylist.Value)
                            {
                                if (listitem.IsChecked)
                                    tickerFilterItems.filteredinTickerList.Add(listitem.Value.ToString());
                                else
                                    tickerFilterItems.unselectedTickerList.Add(listitem.Value.ToString());
                            }
                        }
                    }
                }
                else
                {
                    foreach (var keylist in tickerList)
                    {
                        foreach (var listitem in keylist.Value)
                        {
                            if (listitem.IsChecked)
                                tickerFilterItems.filteredinTickerList.Add(listitem.Value.ToString());
                            else
                                tickerFilterItems.unselectedTickerList.Add(listitem.Value.ToString());
                        }
                    }

                    tickerFilterItems.quickFilterItems.Clear();
                    tickerFilterItems.addedTickerList.Clear();
                    tickerFilterItems.addedTickerDescriptionList.Clear();
                }

                Trace.WriteLine("updateTickerFilterItems is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while updateTickerFilterItems: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updateTickerFilterItems: " + stackTrace, "INFO");
            }
        }
        
        public void createTickerFilterListOnLoad(bool isDynamicFilter)
        {
            try
            {
                Trace.WriteLine("createTickerFilterListOnLoad is called", "TRACE");
                var tickerFilter = vm.getTickerFilter();
                var tickerFilterItems = vm.getTickerFilterItems();

                List<double?> minmaxSlider;
                double? minVal;
                double? maxVal;
                double? tickerVal;

                vm.upd_loadIndustriesList(tickerFilterItems.Industries, tickerFilterItems.IndustriesChecked);
                vm.upd_loadRatingsList(tickerFilterItems.Ratings, tickerFilterItems.RatingsChecked);

                //already created
                //createQuickFilterItems();
            
                if (isDynamicFilter)
                {
                    tickerFilterItems.filteredinTickerList.Clear();
                    tickerFilterItems.filteredoutTickerList.Clear();
                }

                int caseFalse = 0x00;
                int caseFalse2 = 0x00;

                foreach (KeyValuePair<string, List<TickerUserControl>> item in tickerList)
                {
                    bool industryChecked = vm.getIndustriesChecked(item.Key);

                    foreach (TickerUserControl ticker in tickerList[item.Key])
                    {
                        bool falseTicker = industryChecked;

                        if(falseTicker == false)
                            caseFalse2 |= 0x02;

                        string tickerName = ticker.Value.ToString();

                        if (item.Key == "CUSTOM TICKER")
                        {
                            if (tickerFilterItems.unselectedTickerList.Contains(tickerName))
                            {
                                tickerFilter.checkCDSIndexMember(tickerName, false);
                                ticker.IsChecked = false;
                                //ticker.Background = Brushes.Green;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                                ticker.LabelFontColor = Brushes.Black;   //TODO
                            }
                            else
                            {
                                tickerFilterItems.filteredinTickerList.Add(tickerName);
                                tickerFilter.checkCDSIndexMember(tickerName, true);
                                ticker.IsChecked = true;
                                //ticker.Background = Brushes.Transparent;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                ticker.LabelFontColor = Brushes.White;   //TODO
                            }
                        
                            continue;
                        }

                        if (vm.getRatingsChecked(tickerName) == false)
                        {
                            falseTicker = false;
                            caseFalse2 |= 0x04;
                        }

                        minmaxSlider = tickerFilter.getCDS5YSpread_MinMax();
                        minVal = minmaxSlider[0];
                        maxVal = minmaxSlider[1];
                        tickerVal = vm.getCDSSpread5Y(tickerName);

                        if (tickerFilterItems.CDS5YSpreadMin == tickerFilterItems.CDS5YSpreadSelMin)
                        {
                            sliderSpread.minimum = minVal ?? sliderSpread.minimum;
                            tickerFilterItems.CDS5YSpreadSelMin = tickerFilterItems.CDS5YSpreadMin = minVal;
                        }
                        else
                        {
                            if (minVal < tickerFilterItems.CDS5YSpreadMin)
                            {
                                sliderSpread.minimum = minVal ?? sliderSpread.minimum;
                                tickerFilterItems.CDS5YSpreadMin = minVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal < tickerFilterItems.CDS5YSpreadSelMin)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x01;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x01;
                            }
                        }

                        if (tickerFilterItems.CDS5YSpreadMax == tickerFilterItems.CDS5YSpreadSelMax)
                        {
                            sliderSpread.maximum = maxVal ?? sliderSpread.maximum;
                            tickerFilterItems.CDS5YSpreadSelMax = tickerFilterItems.CDS5YSpreadMax = maxVal;
                        }
                        else
                        {
                            if (maxVal > tickerFilterItems.CDS5YSpreadMax)
                            {
                                sliderSpread.maximum = maxVal ?? sliderSpread.maximum;
                                tickerFilterItems.CDS5YSpreadMax = maxVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal > tickerFilterItems.CDS5YSpreadSelMax)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x01;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x01;
                            }
                        }

                        minmaxSlider = tickerFilter.getCDSCurveFilter_MinMax(tickerFilterItems.selCDSCurveFilter);
                        minVal = minmaxSlider[0];
                        maxVal = minmaxSlider[1];
                        tickerVal = vm.getCDSCurve(tickerName);

                        if (tickerFilterItems.CDSCurveFilterMin == tickerFilterItems.CDSCurveFilterSelMin)
                        {
                            sliderCurve.minimum = minVal ?? sliderCurve.minimum;
                            tickerFilterItems.CDSCurveFilterSelMin = tickerFilterItems.CDSCurveFilterMin = minVal;
                        }
                        else
                        {
                            if (minVal < tickerFilterItems.CDSCurveFilterMin)
                            {
                                sliderCurve.minimum = minVal ?? sliderCurve.minimum;
                                tickerFilterItems.CDSCurveFilterMin = minVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal < tickerFilterItems.CDSCurveFilterSelMin)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x02;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x02;
                            }
                        }

                        if (tickerFilterItems.CDSCurveFilterMax == tickerFilterItems.CDSCurveFilterSelMax)
                        {
                            sliderCurve.maximum = maxVal ?? sliderCurve.maximum;
                            tickerFilterItems.CDSCurveFilterSelMax = tickerFilterItems.CDSCurveFilterMax = maxVal;
                        }
                        else
                        {
                            if (maxVal > tickerFilterItems.CDSCurveFilterMax)
                            {
                                sliderCurve.maximum = maxVal ?? sliderCurve.maximum;
                                tickerFilterItems.CDSCurveFilterMax = maxVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal > tickerFilterItems.CDSCurveFilterSelMax)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x02;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x02;
                            }
                        }

                        minmaxSlider = tickerFilter.getMarketCap_MinMax();
                        minVal = minmaxSlider[0];
                        maxVal = minmaxSlider[1];
                        tickerVal = vm.getMarketCapital(tickerName);

                        if (tickerFilterItems.marketCapMin == tickerFilterItems.marketCapSelMin)
                        {
                            sliderMarketCap.minimum = minVal ?? sliderMarketCap.minimum;
                            tickerFilterItems.marketCapSelMin = tickerFilterItems.marketCapMin = minVal;
                        }
                        else
                        {
                            if (minVal < tickerFilterItems.marketCapMin)
                            {
                                sliderMarketCap.minimum = minVal ?? sliderMarketCap.minimum;
                                tickerFilterItems.marketCapMin = minVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal < tickerFilterItems.marketCapSelMin)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x04;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x04;
                            }
                        }

                        if (tickerFilterItems.marketCapMax == tickerFilterItems.marketCapSelMax)
                        {
                            sliderMarketCap.maximum = maxVal ?? sliderMarketCap.maximum;
                            tickerFilterItems.marketCapSelMax = tickerFilterItems.marketCapMax = maxVal;
                        }
                        else
                        {
                            if (maxVal > tickerFilterItems.marketCapMax)
                            {
                                sliderMarketCap.maximum = maxVal ?? sliderMarketCap.maximum;
                                tickerFilterItems.marketCapMax = maxVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal > tickerFilterItems.marketCapSelMax)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x04;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x04;
                            }
                        }

                        minmaxSlider = tickerFilter.getTotalDebtTotalCap_MinMax();
                        minVal = minmaxSlider[0];
                        maxVal = minmaxSlider[1];
                        tickerVal = vm.getTotalDebtToCapital(tickerName);

                        if (tickerFilterItems.totalDebtToTotalCapMin == tickerFilterItems.totalDebtToTotalCapSelMin)
                        {
                            sliderDept.minimum = minVal ?? sliderDept.minimum;
                            tickerFilterItems.totalDebtToTotalCapSelMin = tickerFilterItems.totalDebtToTotalCapMin = minVal;
                        }
                        else
                        {
                            if (minVal < tickerFilterItems.totalDebtToTotalCapMin)
                            {
                                sliderDept.minimum = minVal ?? sliderDept.minimum;
                                tickerFilterItems.totalDebtToTotalCapMin = minVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal < tickerFilterItems.totalDebtToTotalCapSelMin)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x08;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x08;
                            }
                        }

                        if (tickerFilterItems.totalDebtToTotalCapMax == tickerFilterItems.totalDebtToTotalCapSelMax)
                        {
                            sliderDept.maximum = maxVal ?? sliderDept.maximum;
                            tickerFilterItems.totalDebtToTotalCapSelMax = tickerFilterItems.totalDebtToTotalCapMax = maxVal;
                        }
                        else
                        {
                            if (maxVal > tickerFilterItems.totalDebtToTotalCapMax)
                            {
                                sliderDept.maximum = maxVal ?? sliderDept.maximum;
                                tickerFilterItems.totalDebtToTotalCapMax = maxVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal > tickerFilterItems.totalDebtToTotalCapSelMax)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x08;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x08;
                            }
                        }

                        minmaxSlider = tickerFilter.getDebtCommonEquity_MinMax();
                        minVal = minmaxSlider[0];
                        maxVal = minmaxSlider[1];
                        tickerVal = vm.getDebtToComEquity(tickerName);

                        if (tickerFilterItems.debtToCommonEquityMin == tickerFilterItems.debtToCommonEquitySelMin)
                        {
                            sliderDept.minimum = minVal ?? sliderDept.minimum;
                            tickerFilterItems.debtToCommonEquitySelMin = tickerFilterItems.debtToCommonEquityMin = minVal;
                        }
                        else
                        {
                            if (minVal < tickerFilterItems.debtToCommonEquityMin)
                            {
                                sliderEquity.minimum = minVal ?? sliderEquity.minimum;
                                tickerFilterItems.debtToCommonEquityMin = minVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal < tickerFilterItems.debtToCommonEquitySelMin)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x10;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x10;
                            }
                        }

                        if (tickerFilterItems.debtToCommonEquityMax == tickerFilterItems.debtToCommonEquitySelMax)
                        {
                            sliderEquity.maximum = maxVal ?? sliderEquity.maximum;
                            tickerFilterItems.debtToCommonEquitySelMax = tickerFilterItems.debtToCommonEquityMax = maxVal;
                        }
                        else
                        {
                            if (maxVal > tickerFilterItems.debtToCommonEquityMax)
                            {
                                sliderEquity.maximum = maxVal ?? sliderEquity.maximum;
                                tickerFilterItems.debtToCommonEquityMax = maxVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal > tickerFilterItems.debtToCommonEquitySelMax)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x10;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x10;
                            }
                        }

                        minmaxSlider = tickerFilter.getInterestCoverageRatio_MinMax();
                        minVal = minmaxSlider[0];
                        maxVal = minmaxSlider[1];
                        tickerVal = vm.getInterestCovRatio(tickerName);

                        if (tickerFilterItems.interestCoverageRatioMin == tickerFilterItems.interestCoverageRatioSelMin)
                        {
                            sliderDept.minimum = minVal ?? sliderDept.minimum;
                            tickerFilterItems.interestCoverageRatioSelMin = tickerFilterItems.interestCoverageRatioMin = minVal;
                        }
                        else
                        {
                            if (minVal < tickerFilterItems.interestCoverageRatioMin)
                            {
                                sliderRatio.minimum = minVal ?? sliderRatio.minimum;
                                tickerFilterItems.interestCoverageRatioMin = minVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal < tickerFilterItems.interestCoverageRatioSelMin)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x20;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x20;
                            }
                        }

                        if (tickerFilterItems.interestCoverageRatioMax == tickerFilterItems.interestCoverageRatioSelMax)
                        {
                            sliderRatio.maximum = maxVal ?? sliderRatio.maximum;
                            tickerFilterItems.interestCoverageRatioSelMax = tickerFilterItems.interestCoverageRatioMax = maxVal;
                        }
                        else
                        {
                            if (maxVal > tickerFilterItems.interestCoverageRatioMax)
                            {
                                sliderRatio.maximum = maxVal ?? sliderRatio.maximum;
                                tickerFilterItems.interestCoverageRatioMax = maxVal;
                            }

                            if (tickerVal.HasValue)
                            {
                                if (tickerVal > tickerFilterItems.interestCoverageRatioSelMax)
                                {
                                    falseTicker = false;
                                    caseFalse |= 0x20;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                                caseFalse |= 0x20;
                            }
                        }

                        if (QuickFilterFalseTickerList != null)
                        {
                            if (QuickFilterFalseTickerList.Contains(tickerName))
                            {
                                falseTicker = false;
                                caseFalse2 |= 0x01;
                            }
                        }

                        if (isDynamicFilter)
                        {
                            if (falseTicker)
                            {
                                tickerFilterItems.filteredinTickerList.Add(tickerName);

                                if (tickerFilterItems.unselectedTickerList.Contains(tickerName))
                                {
                                    tickerFilter.checkCDSIndexMember(tickerName, false);
                                    ticker.IsChecked = false;

                                    //ticker.Background = Brushes.Green;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                                    ticker.LabelFontColor = Brushes.Black;   //TODO
                                }
                                else
                                {
                                    tickerFilter.checkCDSIndexMember(tickerName, true);
                                    ticker.IsChecked = true;

                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                    ticker.LabelFontColor = Brushes.White;   //TODO
                                }
                            }
                            else
                            {
                                tickerFilterItems.filteredoutTickerList.Add(tickerName);

                                if (tickerFilterItems.selectedTickerList.Contains(tickerName))
                                {
                                    tickerFilterItems.filteredinTickerList.Add(tickerName);

                                    tickerFilter.checkCDSIndexMember(tickerName, true);
                                    ticker.IsChecked = true;

                                    //ticker.Background = Brushes.Orange;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_orange.png")));
                                    ticker.LabelFontColor = Brushes.Black;   //TODO
                                }
                                else
                                {
                                    tickerFilter.checkCDSIndexMember(tickerName, false);
                                    ticker.IsChecked = false;

                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                    ticker.LabelFontColor = Brushes.White;   //TODO

                                }
                            }
                        }
                        else
                        {
                            if (tickerFilterItems.filteredinTickerList.Contains(tickerName))
                            {
                                tickerFilter.checkCDSIndexMember(tickerName, true);
                                ticker.IsChecked = true;

                                if (tickerFilterItems.unselectedTickerList.Contains(tickerName))
                                {
                                    tickerFilter.checkCDSIndexMember(tickerName, false);
                                    ticker.IsChecked = false;
                                    //ticker.Background = Brushes.Green;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                                    ticker.LabelFontColor = Brushes.Black;   //TODO
                                }
                                else if (!falseTicker && !tickerFilterItems.selectedTickerList.Contains(tickerName))
                                {
                                    //ticker.Background = Brushes.Red;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_red.png")));
                                    ticker.LabelFontColor = Brushes.White;   //TODO
                                    BorderBrushedTickerList.Add(ticker);
                                    borderBrushed = true;
                                }
                                else  //falseTicker = true
                                {
                                    //ticker.Background = Brushes.Transparent;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                    ticker.LabelFontColor = Brushes.White;   //TODO
                                }
                            }
                            else
                            {
                                tickerFilter.checkCDSIndexMember(tickerName, false);
                                ticker.IsChecked = false;

                                if (tickerFilterItems.selectedTickerList.Contains(tickerName))
                                {
                                    tickerFilter.checkCDSIndexMember(tickerName, true);
                                    ticker.IsChecked = true;
                                    //ticker.Background = Brushes.Green;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_orange.png")));
                                    ticker.LabelFontColor = Brushes.Black;   //TODO
                                }
                                else if (falseTicker && !tickerFilterItems.unselectedTickerList.Contains(tickerName))
                                {
                                    //ticker.Background = Brushes.Red;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_red.png")));
                                    ticker.LabelFontColor = Brushes.White;   //TODO
                                    BorderBrushedTickerList.Add(ticker);
                                    borderBrushed = true;
                                }
                                else  //falseTicker = false
                                {
                                    //ticker.Background = Brushes.Transparent;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                    ticker.LabelFontColor = Brushes.White;   //TODO
                                }
                            }
                        }
                    }
                }

                if (!isDynamicFilter && borderBrushed)
                    brushSliderBorder(caseFalse, caseFalse2);

                Trace.WriteLine("createTickerFilterListOnLoad is completed", "TRACE");

            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while createTickerFilterListOnLoad: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace createTickerFilterListOnLoad: " + stackTrace, "INFO");
            }
        }

        public void brushSliderBorder(int caseFalse, int caseFalse2)
        {
            if ((caseFalse2 & 0x01) == 0x01)
            {
                quickFilter.BorderBrush = Brushes.Red;
                borderBrushed = true;
            }

            if ((caseFalse & 0x01) == 0x01)
            {
                sliderSpreadGrp.BorderBrush = Brushes.Red;
                borderBrushed = true;
            }

            if ((caseFalse & 0x02) == 0x02)
            {
                sliderCurveGrp.BorderBrush = Brushes.Red;
                borderBrushed = true;
            }

            if ((caseFalse & 0x04) == 0x04)
            {
                sliderMarketCapGrp.BorderBrush = Brushes.Red;
                borderBrushed = true;
            }

            if ((caseFalse & 0x08) == 0x08)
            {
                sliderDebtGrp.BorderBrush = Brushes.Red;
                borderBrushed = true;
            }

            if ((caseFalse & 0x10) == 0x10)
            {
                sliderEquityGrp.BorderBrush = Brushes.Red;
                borderBrushed = true;
            }

            if ((caseFalse & 0x20) == 0x20)
            {
                sliderRatioGrp.BorderBrush = Brushes.Red;
                borderBrushed = true;
            }
        }

        public void createQuickFilterItems()
        {
            try
            {
                Trace.WriteLine("TickerFilterView createQuickFilterItems is called", "TRACE");

                var tickerFilterItems = vm.getTickerFilterItems();

                quickFilter.QuickFilterCollection.Clear();
                quickFilter.createGridItems("Hidden", "Visible", "Hidden");

                filterList.Clear();
                bool first = true;
                foreach (var quickFilterString in tickerFilterItems.quickFilterItems)
                {
                    var itemList = parseQuickFilterItem(quickFilterString);
                    QuickFilterViewObject quickObject = new QuickFilterViewObject();

                    int i = 0;
                    if (!first)
                    {
                        if (itemList.Count < 5)
                            continue;

                        quickObject.andOrValue = itemList[i++];
                    }
                    else
                    {
                        first = false;
                        if (itemList.Count < 4)
                            continue;
                    }

                    quickObject.mainValue = itemList[i++];
                    quickObject.subValue = itemList[i++];
                    quickObject.operatorValue = itemList[i++];
                    quickObject.minTextValue = itemList[i++];

                    if (itemList.Count > i)
                        quickObject.maxTextValue = itemList[i++];

                    if (ValidateQuickFilterItem.validateFilter(quickObject))
                    {
                        filterList.Add(quickObject);
                    }
                }

                if (filterList.Count > 0)
                {
                    foreach (var filterItem in filterList)
                    {
                        if (filterItem.andOrValue != null && filterItem.andOrValue != "")
                            quickFilter.addRow(null, null);

                        quickFilter.setGridRow(filterItem.andOrValue, filterItem.mainValue, filterItem.subValue, filterItem.operatorValue, filterItem.minTextValue, filterItem.maxTextValue);
                    }

                    ObservableCollection<QuickFilterObject> gridItem = quickFilter.getGridList();
                    foreach (var item in gridItem)
                    {
                        foreach (var filteritem in filterList)
                        {
                            if (item.subFilterValue != null)
                            {
                                if (item.fieldList.ContainsKey(item.subFilterValue))
                                    filteritem.fieldName = item.fieldList[item.subFilterValue];
                                else
                                    filteritem.fieldName = "";
                            }
                        }
                    }

                    QuickFilterFalseTickerList = vm.quickFilterTickers(filterList);
                }

                Trace.WriteLine("TickerFilterView createQuickFilterItems is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while TickerFilterView createQuickFilterItems: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace TickerFilterView createQuickFilterItems: " + stackTrace, "INFO");
            }

        }

        void onDragCompleted(object sender, EventArgs e)
        {
            try
            {
                Trace.WriteLine("onDragCompleted is called", "TRACE");

                resetBorderBrush();

                if (uncheckedRemoved)
                {
                    retrieveTickerList();
                    uncheckedRemoved = false;
                }

                var tf = vm.getTickerFilter();
                var tfItems = vm.getTickerFilterItems();

                vm.getTickerFilterItems().TickerFilterName = vm.getTickerFilter().TickerFilterName = "";
                savedList.SelectedValue = "";

                tfItems.filteredoutTickerList.Clear();
                tfItems.filteredinTickerList.Clear();

                tfItems.CDS5YSpreadMin = sliderSpread.minimum;
                tfItems.CDS5YSpreadMax = sliderSpread.maximum;
                tfItems.CDS5YSpreadSelMin = sliderSpread.lowerValue;
                tfItems.CDS5YSpreadSelMax = sliderSpread.upperValue;

                tfItems.selCDSCurveFilter = vm.getCurveFilter_name();
                tfItems.CDSCurveFilterMin = sliderCurve.minimum;
                tfItems.CDSCurveFilterMax = sliderCurve.maximum;
                tfItems.CDSCurveFilterSelMin = sliderCurve.lowerValue;
                tfItems.CDSCurveFilterSelMax = sliderCurve.upperValue;

                tfItems.marketCapMin = sliderMarketCap.minimum;
                tfItems.marketCapMax = sliderMarketCap.maximum;
                tfItems.marketCapSelMin = sliderMarketCap.lowerValue;
                tfItems.marketCapSelMax = sliderMarketCap.upperValue;

                tfItems.totalDebtToTotalCapMin = sliderDept.minimum;
                tfItems.totalDebtToTotalCapMax = sliderDept.maximum;
                tfItems.totalDebtToTotalCapSelMin = sliderDept.lowerValue;
                tfItems.totalDebtToTotalCapSelMax = sliderDept.upperValue;

                tfItems.debtToCommonEquityMin = sliderEquity.minimum;
                tfItems.debtToCommonEquityMax = sliderEquity.maximum;
                tfItems.debtToCommonEquitySelMin = sliderEquity.lowerValue;
                tfItems.debtToCommonEquitySelMax = sliderEquity.upperValue;

                tfItems.interestCoverageRatioMin = sliderRatio.minimum;
                tfItems.interestCoverageRatioMax = sliderRatio.maximum;
                tfItems.interestCoverageRatioSelMin = sliderRatio.lowerValue;
                tfItems.interestCoverageRatioSelMax = sliderRatio.upperValue;

                vm.setisTickerFilterChanged(true);

                foreach (KeyValuePair<string, List<TickerUserControl>> item in tickerList)
                {
                    bool industryChecked = vm.getIndustriesChecked(item.Key);

                    foreach (TickerUserControl ticker in tickerList[item.Key])
                    {
                        bool falseTicker = true;
                        string tickerName = ticker.Value.ToString();

                        if (item.Key == "CUSTOM TICKER")
                        {
                            if (!tfItems.unselectedTickerList.Contains(tickerName))
                            {
                                tfItems.filteredinTickerList.Add(tickerName);
                                tf.checkCDSIndexMember(tickerName, true);
                                ticker.IsChecked = true;
                                //ticker.Background = Brushes.Transparent;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                ticker.LabelFontColor = Brushes.White;   //TODO
                            }
                            else
                            {
                                tf.checkCDSIndexMember(tickerName, false);
                                ticker.IsChecked = false;
                                //ticker.BorderBrush = Brushes.Green;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                                ticker.LabelFontColor = Brushes.Black;   //TODO
                            }
                            continue;
                        }

                        if (!industryChecked)
                        {
                            if (tfItems.selectedTickerList.Contains(tickerName))
                            {
                                tf.checkCDSIndexMember(tickerName, true);
                                ticker.IsChecked = true;

                                //ticker.Background = Brushes.Orange;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_orange.png")));
                                ticker.LabelFontColor = Brushes.Black;   //TODO
                            
                            }
                            else
                            {
                                tf.checkCDSIndexMember(tickerName, false);
                                ticker.IsChecked = false;

                                //ticker.Background = Brushes.Transparent;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                ticker.LabelFontColor = Brushes.White;   //TODO
                            
                            }

                            tfItems.filteredoutTickerList.Add(tickerName);
                            continue;
                        }

                        if(vm.getRatingsChecked(tickerName) == false)
                            falseTicker = false;

                        if (!(sliderSpread.lowerValue == sliderSpread.minimum &&
                            sliderSpread.upperValue == sliderSpread.maximum))
                        {
                            var spread5Y = vm.getCDSSpread5Y(tickerName);
                            if (spread5Y.HasValue)
                            {
                                if (spread5Y < sliderSpread.lowerValue || spread5Y > sliderSpread.upperValue)
                                {
                                    falseTicker = false;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                            }
                        }

                        if (!(sliderCurve.lowerValue == sliderCurve.minimum &&
                            sliderCurve.upperValue == sliderCurve.maximum))
                        {
                            var curveRate = vm.getCDSCurve(tickerName);
                            if (curveRate.HasValue)
                            {
                                if (curveRate < sliderCurve.lowerValue || curveRate > sliderCurve.upperValue)
                                {
                                    falseTicker = false;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                            }
                        }

                        if (!(sliderMarketCap.lowerValue == sliderMarketCap.minimum &&
                            sliderMarketCap.upperValue == sliderMarketCap.maximum))
                        {
                            var marketCap = vm.getMarketCapital(tickerName);
                            if (marketCap.HasValue)
                            {
                                if (marketCap < sliderMarketCap.lowerValue || marketCap > sliderMarketCap.upperValue)
                                {
                                    falseTicker = false;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                            }
                        }

                        if (!(sliderDept.lowerValue == sliderDept.minimum &&
                            sliderDept.upperValue == sliderDept.maximum))
                        {
                            var debtToCap = vm.getTotalDebtToCapital(tickerName);
                            if (debtToCap.HasValue)
                            {
                                if (debtToCap < sliderDept.lowerValue || debtToCap > sliderDept.upperValue)
                                {
                                    falseTicker = false;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                            }
                        }

                        if (!(sliderEquity.lowerValue == sliderEquity.minimum &&
                            sliderEquity.upperValue == sliderEquity.maximum))
                        {
                            var debtToEquity = vm.getDebtToComEquity(tickerName);
                            if (debtToEquity.HasValue)
                            {
                                if (debtToEquity < sliderEquity.lowerValue || debtToEquity > sliderEquity.upperValue)
                                {
                                    falseTicker = false;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                            }
                        }

                        if (!(sliderRatio.lowerValue == sliderRatio.minimum &&
                            sliderRatio.upperValue == sliderRatio.maximum))
                        {
                            var intCovRatio = vm.getInterestCovRatio(tickerName);
                            if (intCovRatio.HasValue)
                            {
                                if (intCovRatio < sliderRatio.lowerValue || intCovRatio > sliderRatio.upperValue)
                                {
                                    falseTicker = false;
                                }
                            }
                            else
                            {
                                falseTicker = false;
                            }
                        }

                        if (QuickFilterFalseTickerList != null)
                        {
                            if (QuickFilterFalseTickerList.Contains(tickerName))
                                falseTicker = false;
                        }

                        if (falseTicker)
                        {
                            tfItems.filteredinTickerList.Add(tickerName);

                            if (tfItems.unselectedTickerList.Contains(tickerName))
                            {
                                tf.checkCDSIndexMember(tickerName, false);
                                ticker.IsChecked = false;
                                //ticker.Background = Brushes.Green;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                                ticker.LabelFontColor = Brushes.Black;   //TODO
                            }
                            else
                            {
                                tf.checkCDSIndexMember(tickerName, true);
                                ticker.IsChecked = true;

                                //ticker.Background = Brushes.Transparent;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                ticker.LabelFontColor = Brushes.White;   //TODO
                            }
                        }
                        else
                        {
                            tfItems.filteredoutTickerList.Add(tickerName);

                            if (tfItems.selectedTickerList.Contains(tickerName))
                            {
                                tf.checkCDSIndexMember(tickerName, true);
                                ticker.IsChecked = true;
                                //ticker.Background = Brushes.Orange;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_orange.png")));
                                ticker.LabelFontColor = Brushes.Black;   //TODO
                            }
                            else
                            {
                                tf.checkCDSIndexMember(tickerName, false);
                                ticker.IsChecked = false;
                                //ticker.Background = Brushes.Transparent;
                                ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                ticker.LabelFontColor = Brushes.White;   //TODO
                            }

                        }
                    }
                }

                Trace.WriteLine("onDragCompleted is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while onDragCompleted: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace onDragCompleted: " + stackTrace, "INFO");
            }
        }

        private void CheckTicker(ItemChecked item)
        {
            try
            {
                if (item.Text == "")
                    return;

                var tf = vm.getTickerFilter();
                var tfItems = vm.getTickerFilterItems();

                vm.getTickerFilterItems().TickerFilterName = vm.getTickerFilter().TickerFilterName = "";
                savedList.SelectedValue = "";

                if (item.IsChecked)
                {
                    tf.checkCDSIndexMember(item.Text, true);

                    if (!tfItems.selectedTickerList.Contains(item.Text))
                        tfItems.selectedTickerList.Add(item.Text);

                    tfItems.unselectedTickerList.Remove(item.Text);
                }
                else
                {
                    tf.checkCDSIndexMember(item.Text, false);

                    if (!tfItems.unselectedTickerList.Contains(item.Text))
                        tfItems.unselectedTickerList.Add(item.Text);

                    tfItems.selectedTickerList.Remove(item.Text);
                }

                brushTickerBck(tfItems, item.Text, item.IsChecked);
                vm.setisTickerFilterChanged(true);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while CheckTicker: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace CheckTicker: " + stackTrace, "INFO");
            }
        }
        //TODO: brush ticker check
        private void brushTickerBck(TickerFilterItems tfItems, string tickerName, bool isChecked)
        {
            try
            {
                foreach (KeyValuePair<string, List<TickerUserControl>> item in tickerList)
                {
                    foreach (TickerUserControl ticker in tickerList[item.Key])
                    {
                        if (ticker.Value.ToString() == tickerName)
                        {
                            if (isChecked)
                            {
                                if (tfItems.filteredoutTickerList.Contains(tickerName))
                                {
                                    //ticker.BorderBackground = Brushes.Orange;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_orange.png")));
                                    ticker.LabelFontColor = Brushes.Black;   //TODO
                                }
                                else
                                {
                                    //ticker.BorderBackground = Brushes.Transparent;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                    ticker.LabelFontColor = Brushes.White;   //TODO
                                }
                            }
                            else
                            {
                                if (tfItems.filteredinTickerList.Contains(tickerName))
                                {
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                                    ticker.LabelFontColor = Brushes.Black;   //TODO
                                    //ticker.BorderBackground = Brushes.Green;
                                }
                                else
                                {
                                    //ticker.BorderBackground = Brushes.Transparent;
                                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                                    ticker.LabelFontColor = Brushes.White;   //TODO
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while brushTickerBck: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace brushTickerBck: " + stackTrace, "INFO");
            }
        }

        private void searchTickerFromApi(object sender, RoutedEventArgs e)
        {
            try
            {
                Trace.WriteLine("searchTickerFromApi is called", "TRACE");

                resetBorderBrush();

                listView.Items.Clear();
                listView.Visibility = Visibility.Visible;
                List<string> list = vm.searchTicker(customTickerName.Text);

                if (list.Count == 0)
                {
                    listView.Visibility = Visibility.Collapsed;
                    return;
                }

                Style btnstyle = this.FindResource("RoundedButtonTemplate") as Style;

                for (int i = 0; i < list.Count; i++)
                {
                    listView.Visibility = Visibility.Visible;
                    StackPanel panel = new StackPanel();
                    panel.Orientation = Orientation.Horizontal;
                    Button btn = new Button();
                    btn.VerticalAlignment = VerticalAlignment.Center;
                    btn.Content = "Add";
                    btn.Click += btn_Click;
                    btn.Width = 60;
                    btn.Style = btnstyle;

                    var brushBackground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#4d4d4c"));
                    btn.Background = brushBackground;

                    var brushForeground = (SolidColorBrush)(new BrushConverter().ConvertFrom("#ffffff"));
                    btn.Foreground = brushForeground;

                    TextBlock txt = new TextBlock();
                    txt.Text = list[i];
                    txt.VerticalAlignment = VerticalAlignment.Center;
                    txt.Width = 150;
                    btn.Tag = txt.Text;
                    panel.Children.Add(txt);
                    panel.Children.Add(btn);
                    listView.Items.Add(panel);
                }
                Trace.WriteLine("searchTickerFromApi is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while searchTickerFromApi: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace searchTickerFromApi: " + stackTrace, "INFO");
            }

        }

        void btn_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                clearFields();
                Button btn = sender as Button;
                FrameworkElement panel = (FrameworkElement)btn.Parent;
                int index = listView.Items.IndexOf(panel);
                string myValue = ((Button)sender).Tag.ToString();

                List<string> secDesc = new List<string>();
                string[] split = myValue.Split(new Char[] { ':' });

                foreach (string s in split)
                {
                    if (s.Trim() != "")
                        secDesc.Add(s);
                }

                if (secDesc.Count <= 0)
                    return;

                else if (secDesc.Count == 1)
                    secDesc.Add(secDesc[0]);

                if (validationAddTickerFields(secDesc[0]))
                {
                    if (vm.addTicker(new SecurityDescription(secDesc[0], secDesc[1])))
                    {
                        addTickerToPanel(secDesc[0]);
                        listView.Items.RemoveAt(index);

                        vm.setisTickerFilterChanged(true);
                        vm.setisAddedTickerDataRetrieved(false);

                        vm.getTickerFilterItems().TickerFilterName = vm.getTickerFilter().TickerFilterName = "";
                        savedList.SelectedValue = "";
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while btn_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace btn_Click: " + stackTrace, "INFO");
            }
        }

        private void addTickerToPanel(string tickerName, bool isCheckFlag = true)
        {
            try
            {
                clearFields();//clear warn text

                if (validationAddTickerFields(tickerName))
                {
                    if (flagForCustomPanel == -1)
                    {
                        dpCustom = new DockPanel();
                        //Border brdr = new Border();
                        customBorder.HorizontalAlignment = HorizontalAlignment.Stretch;
                        customBorder.BorderBrush = Brushes.White;
                        customBorder.BorderThickness = new Thickness(1);
                        customBorder.Background = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/TickerFilter_title.png")));
                        customBorder.Padding = new Thickness(1);
                        customBorder.CornerRadius = new CornerRadius(4);

                        customHeader.Text = "CUSTOM TICKER";
                        customHeader.Margin = new Thickness(2);
                        customHeader.Foreground = Brushes.White;
                        customHeader.HorizontalAlignment = HorizontalAlignment.Center;
                        customBorder.Child = customHeader;
                        DockPanel.SetDock(customBorder, Dock.Top);
                        DockPanel.SetDock(wpBottomCustom, Dock.Bottom);
                        dpCustom.Children.Add(customBorder);
                        dpCustom.Children.Add(wpBottomCustom);
                        flagForCustomPanel = -1;
                        customBorder.Width = wrpPnl0.ActualWidth - ((SystemParameters.VerticalScrollBarWidth) / 4);
                    }

                    TickerUserControl tckr = new TickerUserControl();
                    tckr.Value = tickerName;
                    tckr.CheckBox_ItemChecked += CheckTicker;
                    tckr.IsChecked = isCheckFlag;
                    if (!isCheckFlag)
                    {
                        //tckr.Background = Brushes.Green;
                        tckr.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                        tckr.LabelFontColor = Brushes.Black;   //TODO
                    }
                    else
                    {
                        tckr.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                        tckr.LabelFontColor = Brushes.White;   //TODO
                    }

                    tckr.TickerWidth = 135;
                    addContextMenuToTicker(tckr);
                    customTickerList.Add(tckr);
                    wpBottomCustom.Children.Add(tckr);

                    if (flagForCustomPanel != -1 && tickerList.ContainsKey(customHeader.Text))
                    {
                        return;
                    }
                    else
                    {
                        int minRow = findMinCount(wrpPnl0RowCount, wrpPnl1RowCount, wrpPnl2RowCount, wrpPnl3RowCount);

                        if (minRow == wrpPnl0RowCount)
                        {
                            wrpPnl0RowCount = wrpPnl0RowCount + 1;
                            wrpPnl0.Children.Add(dpCustom);
                            flagForCustomPanel = 0;
                        }
                        else if (minRow == wrpPnl1RowCount)
                        {
                            wrpPnl1RowCount = wrpPnl1RowCount + 1;
                            wrpPnl1.Children.Add(dpCustom);
                            flagForCustomPanel = 1;
                        }
                        else if (minRow == wrpPnl2RowCount)
                        {
                            wrpPnl2RowCount = wrpPnl2RowCount + 1;
                            wrpPnl2.Children.Add(dpCustom);
                            flagForCustomPanel = 2;
                        }
                        else if (minRow == wrpPnl3RowCount)
                        {
                            wrpPnl3RowCount = wrpPnl3RowCount + 1;
                            wrpPnl3.Children.Add(dpCustom);
                            flagForCustomPanel = 3;
                        }

                    }

                    if (customTickerList.Count > 0)
                        tickerList.Add(customHeader.Text, customTickerList);

                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while addTickerToPanel: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace addTickerToPanel: " + stackTrace, "INFO");
            }
        }

        private bool validationAddTickerFields(string tickerName)
        {
            try
            {
                bool isValid = true;
                List<List<TickerUserControl>> tickerControlsList = tickerList.Values.ToList();
                bool isFind = false;

                if (String.IsNullOrWhiteSpace(tickerName))
                {
                    //warnCustomTickerName.Text = "*Ticker name can not be empty";
                    isValid = false;
                }

                else
                {
                    /*search ticker*/
                    foreach (List<TickerUserControl> item in tickerControlsList)
                    {
                        foreach (TickerUserControl ticker in item)
                        {
                            if (ticker.Value.ToString() == tickerName)
                            {
                                isFind = true;
                                break;
                            }
                        }
                        if (isFind)
                            break;
                    }

                    if (isFind)
                    {
                        //warnCustomTickerName.Text = "*Ticker exist in filter";
                        isValid = false;
                    }

                }

                return isValid;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while validationAddTickerFields: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace validationAddTickerFields: " + stackTrace, "INFO");
                return false;
            }

        }

        private void clickApplyFilter(object sender, RoutedEventArgs e)
        {
            try
            {
                resetBorderBrush();

                filterList.Clear();
                vm.getTickerFilterItems().quickFilterItems.Clear();

                ObservableCollection<QuickFilterObject> gridItem = quickFilter.getGridList();
                foreach (var item in gridItem)
                {
                    QuickFilterViewObject quickObject = new QuickFilterViewObject();
                    quickObject.andOrValue = item.andOrValue;
                    quickObject.mainValue = item.mainFilterValue;
                    quickObject.subValue = item.subFilterValue;
                    quickObject.operatorValue = item.filterOperatorValue;
                    quickObject.maxTextValue = item.maxValue;
                    quickObject.minTextValue = item.minValue;
                    if (item.subFilterValue != null)
                    {
                        if (item.fieldList.ContainsKey(item.subFilterValue))
                            quickObject.fieldName = item.fieldList[item.subFilterValue];
                        else
                            quickObject.fieldName = "";
                    }

                    if (ValidateQuickFilterItem.validateFilter(quickObject))
                    {
                        filterList.Add(quickObject);
                        vm.getTickerFilterItems().quickFilterItems.Add(convertQuickFilterItem(quickObject));
                    }
                }

                if (filterList.Count > 0)
                {
                    QuickFilterFalseTickerList = vm.quickFilterTickers(filterList);

                    onDragCompleted(null, null);
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while clickApplyFilter: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace clickApplyFilter: " + stackTrace, "INFO");
            }
        }

        public List<string> parseQuickFilterItem(string filter)
        {
            try
            {
                List<string> fields = new List<string>();

                string[] split = filter.Split(new Char[] { ':' });

                foreach (string s in split)
                {
                    if (s.Trim() != "")
                        fields.Add(s);
                }

                return fields;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while parseQuickFilterItem: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace parseQuickFilterItem: " + stackTrace, "INFO");
                return new List<string>();
            }
        }

        public string convertQuickFilterItem(QuickFilterViewObject quickFilterItem)
        {
            string quickFilter;

            quickFilter = quickFilterItem.andOrValue + ":" + quickFilterItem.mainValue + ":" + quickFilterItem.subValue + ":" +
                quickFilterItem.operatorValue + ":" + quickFilterItem.minTextValue + ":" + quickFilterItem.maxTextValue;

            return quickFilter;
        }

        private void resetCustomTickerParams()
        {
            flagForCustomPanel = -1;

            if (customBorder.Child != null)
                customBorder.Child = null;

            if (wpBottomCustom.Children != null)
                wpBottomCustom.Children.Clear();

            if (dpCustom != null && dpCustom.Children != null)
                dpCustom.Children.Clear();

            dpCustom = null;

            customHeader.Text = "";
        }

        private void setCustomTickerParams(int flag, string headerText)
        {
            flagForCustomPanel = flag;
            customHeader.Text = headerText;
        }

        private void clearTickerListParamaters()
        {
            customTickerList.Clear();
            resetCustomTickerParams();

            wrpPnl0RowCount = 0;
            wrpPnl1RowCount = 0;
            wrpPnl2RowCount = 0;
            wrpPnl3RowCount = 0;
            if (wrpPnl0.Children != null)   wrpPnl0.Children.Clear();
            if (wrpPnl1.Children != null)   wrpPnl1.Children.Clear();
            if (wrpPnl2.Children != null)   wrpPnl2.Children.Clear();
            if (wrpPnl3.Children != null)   wrpPnl3.Children.Clear();

            tickerList.Clear();
        }

        public void resetBorderBrush()
        {
            if (borderBrushed)
            {
                quickFilter.BorderBrush = Brushes.Transparent;
                sliderSpreadGrp.BorderBrush = (SolidColorBrush)(new BrushConverter().ConvertFrom("#7a7a7a"));
                sliderCurveGrp.BorderBrush = (SolidColorBrush)(new BrushConverter().ConvertFrom("#7a7a7a"));
                sliderMarketCapGrp.BorderBrush = (SolidColorBrush)(new BrushConverter().ConvertFrom("#7a7a7a"));
                sliderDebtGrp.BorderBrush = (SolidColorBrush)(new BrushConverter().ConvertFrom("#7a7a7a"));
                sliderEquityGrp.BorderBrush = (SolidColorBrush)(new BrushConverter().ConvertFrom("#7a7a7a"));
                sliderRatioGrp.BorderBrush = (SolidColorBrush)(new BrushConverter().ConvertFrom("#7a7a7a"));

                foreach (var ticker in BorderBrushedTickerList)
                {
                    //ticker.Background = Brushes.Transparent;
                    ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox.png")));
                    ticker.LabelFontColor = Brushes.White;   //TODO
                }

                BorderBrushedTickerList.Clear();
                
                borderBrushed = false;
            }

        }

        private void clearFields()
        {
            //warnFilterName.Text = "";
            //warnCustomTickerName.Text = "";
        }

        public void retrieveTickerList()
        {
            try
            {
                //TODO: reset panels
                clearTickerListParamaters();

                var tickerFilterItems = vm.getTickerFilterItems();

                var industryTickerList = vm.getIndustryTickerList();

                foreach (KeyValuePair<string, List<ItemChecked>> listTicker in industryTickerList)
                {
                    if (listTicker.Key != "CUSTOM TICKER")
                    {
                        List<TickerUserControl> list = new List<TickerUserControl>();

                        foreach (ItemChecked item in listTicker.Value)
                        {
                            //if (removeChckBox.IsChecked == false)
                            {
                                TickerUserControl ticker = new TickerUserControl();
                                ticker.Value = item.Text;
                                ticker.CheckBox_ItemChecked += CheckTicker;
                                ticker.IsChecked = item.IsChecked;

                                if (ticker.IsChecked)
                                {
                                    if (tickerFilterItems.filteredoutTickerList.Contains(item.Text))
                                    {
                                        //ticker.Background = Brushes.Orange;
                                        ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_orange.png")));
                                        ticker.LabelFontColor = Brushes.Black;   //TODO
                                    }
                                }
                                else
                                {
                                    if (!tickerFilterItems.filteredoutTickerList.Contains(item.Text))
                                    {
                                        //ticker.Background = Brushes.Green;
                                        ticker.BorderBackground = new ImageBrush(new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/tickerbox_green.png")));
                                        ticker.LabelFontColor = Brushes.Black;   //TODO
                                    }
                                }

                                ticker.TickerWidth = 135;                       //TODO
                                addContextMenuToTicker(ticker);                //TODO
                                list.Add(ticker);
                            }
                        }

                        if (list.Count > 0)
                            tickerList.Add(listTicker.Key, list);
                    }
                }

                createPanelObject(tickerList);

                foreach (KeyValuePair<string, List<ItemChecked>> listTicker in industryTickerList)
                {
                    if (listTicker.Key == "CUSTOM TICKER")
                    {
                        foreach (ItemChecked item in listTicker.Value)
                        {
                            //if (removeChckBox.IsChecked == false)
                            addTickerToPanel(item.Text, item.IsChecked);
                        }
                        break;
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while retrieveTickerList: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace retrieveTickerList: " + stackTrace, "INFO");
            }
        }

        private void chkApplyFilter_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                CheckBox chckBox = sender as CheckBox;
                bool checkedValue = (chckBox.IsChecked ?? false);

                vm.getTickerFilterItems().applyFilterDync = checkedValue;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while TFView chkApplyFilter_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace TFView chkApplyFilter_Click: " + stackTrace, "INFO");
            }
        }

        private void ShowBusyIndicator(string message)
        {
            BringToFront(BusyIndicatiorPanel);
            BusyIndicatiorPanel.Visibility = Visibility.Visible;
            PleaseWaitMsg.Text = message;
            //BusyIndicator.BusyContent = new TextBlock() { Text = message };
            //BusyIndicator.IsBusy = true;
            this.IsHitTestVisible = false;

        }

        private void HideBusyIndicator()
        {
            //BusyIndicator.IsBusy = false;
            BusyIndicatiorPanel.Visibility = Visibility.Hidden;
            this.IsHitTestVisible = true;
        }

        public void BringToFront(FrameworkElement element)
        {
            if (element == null) return;

            Panel parent = element.Parent as Panel;
            if (parent == null) return;

            var maxZ = parent.Children.OfType<UIElement>()
              .Where(x => x != element)
              .Select(x => Panel.GetZIndex(x))
              .Max();
            Panel.SetZIndex(element, maxZ + 1);
        }


        public void showGuidanceAtOrder(int order, bool isShow)
        {
            try
            {
                if (BaseWindowViewModel.onHeatMapView == true)
                {
                    return;
                }

                switch (order)
                {
                    case 1:
                        GuidanceService.SetShowGuidance(mainDockPanel, isShow);

                        GuidanceService.SetShowGuidance(regionListGuidance, false);
                        break;

                    case 2:
                        GuidanceService.SetShowGuidance(mainDockPanel, false);

                        GuidanceService.SetShowGuidance(regionListGuidance, isShow);

                        GuidanceService.SetShowGuidance(cdsIndexListGuidance, false);
                        break;

                    case 3:
                        GuidanceService.SetShowGuidance(regionListGuidance, false);

                        GuidanceService.SetShowGuidance(cdsIndexListGuidance, isShow);

                        GuidanceService.SetShowGuidance(ratingsIndustriesGuidance, false);
                        break;

                    case 4:
                        GuidanceService.SetShowGuidance(cdsIndexListGuidance, false);

                        GuidanceService.SetShowGuidance(ratingsIndustriesGuidance, isShow);

                        GuidanceService.SetShowGuidance(cdsPriceSourceListGuidance, false);
                        break;

                    case 5:
                        GuidanceService.SetShowGuidance(ratingsIndustriesGuidance, false);

                        GuidanceService.SetShowGuidance(cdsPriceSourceListGuidance, isShow);

                        GuidanceService.SetShowGuidance(sliderSpreadGrpGuidance, false);
                        break;

                    case 6:
                        GuidanceService.SetShowGuidance(cdsPriceSourceListGuidance, false);

                        GuidanceService.SetShowGuidance(sliderSpreadGrpGuidance, isShow);

                        GuidanceService.SetShowGuidance(sliderCurveGrpGuidance, false);
                        break;

                    case 7:
                        GuidanceService.SetShowGuidance(sliderSpreadGrpGuidance, false);

                        GuidanceService.SetShowGuidance(sliderCurveGrpGuidance, isShow);

                        GuidanceService.SetShowGuidance(otherSlidersGuidance, false);
                        break;

                    case 8:
                        GuidanceService.SetShowGuidance(sliderCurveGrpGuidance, false);

                        GuidanceService.SetShowGuidance(otherSlidersGuidance, isShow);

                        GuidanceService.SetShowGuidance(quickFilterGuidance, false);
                        break;

                    case 9:
                        GuidanceService.SetShowGuidance(otherSlidersGuidance, false);

                        GuidanceService.SetShowGuidance(quickFilterGuidance, isShow);

                        GuidanceService.SetShowGuidance(applyQFGuidance, false);
                        break;

                    case 10:
                        GuidanceService.SetShowGuidance(quickFilterGuidance, false);

                        GuidanceService.SetShowGuidance(applyQFGuidance, isShow);

                        GuidanceService.SetShowGuidance(tickerFilterGuidance, false);
                        break;

                    case 11:
                        GuidanceService.SetShowGuidance(applyQFGuidance, false);

                        GuidanceService.SetShowGuidance(tickerFilterGuidance, isShow);

                        GuidanceService.SetShowGuidance(mainGroupBox, false);
                        break;

                    case 12:
                        GuidanceService.SetShowGuidance(tickerFilterGuidance, false);

                        GuidanceService.SetShowGuidance(mainGroupBox, isShow);

                        break;

                    case 13:
                        GuidanceService.SetShowGuidance(mainGroupBox, false);

                        if (isPlayingGuidance)
                        {
                            isPlayingGuidance = false;

                            var playGuidanceTemplate = PlayGuidance.Template;
                            var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                            if (playPauseImage != null)
                            {
                                playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                                if (playPauseImage.Source.CanFreeze)
                                    playPauseImage.Source.Freeze();
                            }
                        }

                        GuidanceDisplay(false);
                        showGuidanceOrder = 1;
                        break;
                }
            }
            catch (Exception e)
            {
                if (isShow)
                    Trace.WriteLine("Exception while displaying showGuidanceAtOrder order:" + order + " : " + e.Message.ToString(), "INFO");
                else
                    Trace.WriteLine("Exception while closing showGuidanceAtOrder order:" + order + " : " + e.Message.ToString(), "INFO");
            }

        }

        private void CloseGuidance_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                showGuidanceAtOrder(showGuidanceOrder, false);
                showGuidanceOrder = 0;

                GuidanceDisplay(false);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while CloseGuidance_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace CloseGuidance_Click: " + stackTrace, "INFO");
            }
        }

        private void NextGuidance_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                showGuidanceOrder++;
                showGuidanceAtOrder(showGuidanceOrder, true);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while NextGuidance_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace NextGuidance_Click: " + stackTrace, "INFO");
            }
        }

        private void PlayPauseGuidance_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (isPlayingGuidance == false)
                {
                    PlayGuidance.Content = "Pause";

                    if (showGuidanceOrder <= 0 || showGuidanceOrder >= 13)
                        showGuidanceOrder = 0;

                    isPlayingGuidance = true;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/pause.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }

                    Thread worker = new Thread(() =>
                    {
                        try
                        {
                            if (showGuidanceOrder != 0)
                                Thread.Sleep(5000);

                            while (showGuidanceOrder <= 13)
                            {
                                if (isPlayingGuidance == false)
                                    break;

                                if (BaseWindowViewModel.onHeatMapView == true)
                                {
                                    isPlayingGuidance = false;
                                    showGuidanceOrder = 0;
                                    //GuidanceDisplay(false);
                                    break;
                                }

                                try
                                {
                                    mainThreadDispatcher.BeginInvoke((Action)delegate
                                    {
                                        try
                                        {
                                            showGuidanceOrder++;
                                            showGuidanceAtOrder(showGuidanceOrder, true);
                                        }
                                        catch (Exception eDispatcher)
                                        {
                                            Trace.WriteLine("Exception while mainThreadDispatcher process : " + eDispatcher.Message.ToString(), "INFO");
                                            string stackTraceDispatcher = "";
                                            if (eDispatcher.StackTrace != null)
                                                stackTraceDispatcher = eDispatcher.StackTrace.ToString();

                                            Trace.WriteLine("Exception Stacktrace: " + stackTraceDispatcher, "INFO");
                                        }
                                    });
                                }
                                catch (Exception e1)
                                {
                                    if (BaseWindowViewModel.onHeatMapView == true)
                                    {
                                        isPlayingGuidance = false;
                                        showGuidanceOrder = 0;
                                        //GuidanceDisplay(false);
                                        break;
                                    }
                                }

                                if (isPlayingGuidance == false)
                                    break;

                                Thread.Sleep(5000);

                                if (BaseWindowViewModel.onHeatMapView == true)
                                {
                                    isPlayingGuidance = false;
                                    showGuidanceOrder = 0;
                                    //GuidanceDisplay(false);
                                    break;
                                }
                            }
                        }
                        catch (Exception e1)
                        {
                            Trace.WriteLine("Exception while running Thread in TickerFilterView PlayPauseGuidance_Click: " + e1.Message, "ERROR");
                            string stackTrace = "";
                            if (e1.StackTrace != null)
                                stackTrace = e1.StackTrace.ToString();

                            Trace.WriteLine("Exception while running Thread in TickerFilterView PlayPauseGuidance_Click: " + stackTrace, "INFO");
                        }
                    });
                    worker.Start();
                }
                else
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }
            }
            catch (Exception ex)
            {
                Trace.Write("Exception during tickerfilter play guidance!!!" + ex.Message);
            }
        }

        private void PrevGuidance_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                if (showGuidanceOrder == 1)
                    return;

                showGuidanceOrder--;
                showGuidanceAtOrder(showGuidanceOrder, true);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while PrevGuidance_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace PrevGuidance_Click: " + stackTrace, "INFO");
            }
        }

        public void resetGuidance()
        {
            try
            {
                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                CloseGuidance_Click(null, null);
                showGuidanceOrder = 0;

                GuidanceDisplay(false);
            }
            catch (Exception ex)
            {
                Trace.Write("Exception during tickerfilter reset guidance!!!" + ex.Message);
            }

        }

        public void GuidanceDisplay(bool isDisplay)
        {
            try
            {
                if (isDisplay)
                {   //Display Guidance
                    mainStackPanel.Visibility = System.Windows.Visibility.Collapsed;
                    mainStackPanelGuidance.Visibility = System.Windows.Visibility.Visible;

                    //fill CDS 5Y spread slider
                    sliderSpreadGuidance.minimum = sliderSpread.minimum;
                    sliderSpreadGuidance.maximum = sliderSpread.maximum;
                    sliderSpreadGuidance.lowerValue = sliderSpread.lowerValue;
                    sliderSpreadGuidance.upperValue = sliderSpread.upperValue;
                    sliderSpreadGuidance.suffix = "";

                    //fill CDS curve slider
                    sliderCurveGuidance.minimum = sliderCurve.minimum;
                    sliderCurveGuidance.maximum = sliderCurve.maximum;
                    sliderCurveGuidance.lowerValue = sliderCurve.lowerValue;
                    sliderCurveGuidance.upperValue = sliderCurve.upperValue;
                    sliderCurveGuidance.suffix = "";

                    //fill Market Cap
                    sliderMarketCapGuidance.minimum = sliderMarketCap.minimum;
                    sliderMarketCapGuidance.maximum = sliderMarketCap.maximum;
                    sliderMarketCapGuidance.lowerValue = sliderMarketCap.lowerValue;
                    sliderMarketCapGuidance.upperValue = sliderMarketCap.upperValue;
                    sliderMarketCapGuidance.suffix = ""; //"B";


                    //fill Total Debt To Total Capital
                    sliderDeptGuidance.minimum = sliderDept.minimum;
                    sliderDeptGuidance.maximum = sliderDept.maximum;
                    sliderDeptGuidance.lowerValue = sliderDept.lowerValue;
                    sliderDeptGuidance.upperValue = sliderDept.upperValue;
                    sliderDeptGuidance.suffix = "%";

                    //fill Debt to Common Equity
                    sliderEquityGuidance.minimum = sliderEquity.minimum;
                    sliderEquityGuidance.maximum = sliderEquity.maximum;
                    sliderEquityGuidance.lowerValue = sliderEquity.lowerValue;
                    sliderEquityGuidance.upperValue = sliderEquity.upperValue;
                    sliderEquityGuidance.suffix = "%";

                    //fill Interest Coverage Ratio
                    sliderRatioGuidance.minimum = sliderRatio.minimum;
                    sliderRatioGuidance.maximum = sliderRatio.maximum;
                    sliderRatioGuidance.lowerValue = sliderRatio.lowerValue;
                    sliderRatioGuidance.upperValue = sliderRatio.upperValue;
                    sliderRatioGuidance.suffix = "";

                    if (cdsIndexListGuidance.ItemsSource == null)
                        cdsIndexListGuidance.ItemsSource = CDSHeatMap.Util.ListUtil.getValueFromKey((TickerFilterViewModel.regionValue.ToString()), TickerFilterViewModel.newList);

                    if (!cdsIndexListGuidance.Items.Contains(cdsIndexList.SelectedValue.ToString()))
                        cdsIndexListGuidance.Items.Add(cdsIndexList.SelectedValue.ToString());

                    cdsIndexListGuidance.SelectedValue = cdsIndexList.SelectedValue;
                    cdsPriceSourceListGuidance.SelectedValue = cdsPriceSourceList.SelectedValue;

                    TFViewBottom.Visibility = System.Windows.Visibility.Collapsed;
                    TFViewBottomGuidance.Visibility = System.Windows.Visibility.Visible;

                    if (quickFilterGuidance.QuickFilterCollection == null || quickFilterGuidance.QuickFilterCollection.Count == 0)
                    {
                        MainFilterItems items = new MainFilterItems(true);
                        quickFilterGuidance.setItemList(items.mainList, items.fieldList, 0);
                        quickFilterGuidance.setGroupBoxName("Quick Filter");
                        quickFilterGuidance.createGridItems("Hidden", "Visible", "Hidden");
                    }

                    CloseGuidance.Visibility = System.Windows.Visibility.Visible;
                    NextGuidance.Visibility = System.Windows.Visibility.Visible;
                    PrevGuidance.Visibility = System.Windows.Visibility.Visible;
                    PlayGuidance.Visibility = System.Windows.Visibility.Visible;

                }
                else
                {   //Hide Guidance

                    mainStackPanelGuidance.Visibility = System.Windows.Visibility.Collapsed;
                    mainStackPanel.Visibility = System.Windows.Visibility.Visible;

                    TFViewBottomGuidance.Visibility = System.Windows.Visibility.Collapsed;
                    TFViewBottom.Visibility = System.Windows.Visibility.Visible;
                    quickFilterGuidance.QuickFilterCollection.Clear();

                    CloseGuidance.Visibility = System.Windows.Visibility.Hidden;
                    NextGuidance.Visibility = System.Windows.Visibility.Hidden;
                    PrevGuidance.Visibility = System.Windows.Visibility.Hidden;
                    PlayGuidance.Visibility = System.Windows.Visibility.Hidden;
                }
            }
            catch (Exception ex)
            {
                Trace.Write("Exception during tickerfilter guidance display!!!" + ex.Message);
            }
        }

        /*
        private void OnOpenDocumentCompleted(object sender, EventArgs e)
        {
            Dispatcher.BeginInvoke((Action)delegate
            {
                HideBusyIndicator();
                Mouse.OverrideCursor = null;
            });
        }
        */
        private void MenuGuide_Click(object sender, RoutedEventArgs e)
        {
            string uri = "http://www.globit.com.tr/static/CDS_HeatMapUserGuide.pdf";

            try
            {
                if (_documentShell == null)
                {
                    _documentShell = new WebDocument();
                    //_documentShell.OpenDocumentCompleted += OnOpenDocumentCompleted;
                }

                /*
                Mouse.OverrideCursor = Cursors.Wait;
                ShowBusyIndicator("Loading User Guide...");
                */
                // Introduce an artificial delay to demonstrate the busy indicator in the UI
                Thread thread = new Thread(() =>
                {
                    try
                    {
                        _documentShell.OpenDocumentAsync(new Uri(uri));
                        System.Threading.Thread.Sleep(500); // artificial delay
                    }
                    catch (Exception e1)
                    {
                        Trace.WriteLine("Exception while running Thread in TickerFilterView MenuGuide_Click: " + e1.Message, "ERROR");
                        string stackTrace = "";
                        if (e1.StackTrace != null)
                            stackTrace = e1.StackTrace.ToString();

                        Trace.WriteLine("Exception while running Thread in TickerFilterView MenuGuide_Click: " + stackTrace, "INFO");
                    }
                });
                thread.Start();

                String guideMessage = "User Guide is being downloaded in the background, and will open automatically in your pdf reader. \n\nYou can continue using CDS HeatMap, or have a quick look at our Tutorial in the meantime. \n\nThank you!";

                var popup = new NotificationView(guideMessage, ErrorMsgLevel.None);
                PopupWindow.Instance.Title = "Downloading...";
                PopupWindow.Instance.ShowWindow(popup);
                PopupWindow.Instance.Width = 400;
                PopupWindow.Instance.Height = 250;

            }
            catch (Exception ex)
            {
                Trace.WriteLine(string.Format("Error: (5002) - Unable to load PDF file {0}: {1}", uri, ex), "ERROR");

                string stackTrace = "";
                if (ex.StackTrace != null)
                    stackTrace = ex.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace (5002): " + stackTrace, "INFO");

                /*
                Dispatcher.BeginInvoke((Action)delegate
                {
                    HideBusyIndicator();
                    Mouse.OverrideCursor = null;
                });
                 */
            }
        }

        private void MenuTutorial_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                GuidanceDisplay(true);

                if (isPlayingGuidance)
                {
                    isPlayingGuidance = false;

                    var playGuidanceTemplate = PlayGuidance.Template;
                    var playPauseImage = (System.Windows.Controls.Image)playGuidanceTemplate.FindName("PlayPauseImage", PlayGuidance);

                    if (playPauseImage != null)
                    {
                        playPauseImage.Source = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/play.png"));
                        if (playPauseImage.Source.CanFreeze)
                            playPauseImage.Source.Freeze();
                    }
                }

                //CloseGuidance_Click(null, null);

                if (showGuidanceOrder > 1)
                    showGuidanceAtOrder(showGuidanceOrder, false);

                showGuidanceOrder = 1;
                showGuidanceAtOrder(showGuidanceOrder, true);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while MenuTutorial_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace MenuTutorial_Click: " + stackTrace, "INFO");
            }
        }

        private void MenuAbout_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                var popup = new AboutView();
                PopupWindow.Instance.Title = "About";
                PopupWindow.Instance.ShowWindow(popup);
                PopupWindow.Instance.Width = 800;
                PopupWindow.Instance.Height = 600;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while MenuAbout_Click: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace MenuAbout_Click: " + stackTrace, "INFO");
            }
        }

        public static void Dispose()
        {
            Trace.WriteLine("TickerFilterView Dispose is called", "TRACE");

            if (_documentShell != null)
                _documentShell.Dispose();

            Trace.WriteLine("TickerFilterView Dispose is completed", "TRACE");
        }
        

    }
}
