﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Samples;
using System.Windows.Input;
using System.Windows.Media;
using CDSHeatMap.Util;
using CDSHeatMap.Model;
using CDSHeatMap.View;
using CDSHeatMap.BloombergAPIManager;
using CDSHeatMap.NormalDist;
using CDSHeatMap.Interface;
using CDSHeatMap.BloombergDataManager;
using System.Threading;
using System.Windows.Threading;
using System.Windows.Media.Imaging;
using System.Diagnostics;
using Bloomberglp.AppPortalApi.Desktop;

namespace CDSHeatMap.ViewModel
{
    public static class LockHolder
    {
        public static object Lock = new object();
    }

    class HeatMapViewModel : BaseWindowViewModel
    {
        private const int BLINK_WAIT = 500;
        private int MIN_RECT_SIZE_PCT = 0;
        private const int DEFAULT_RECTSIZEPCT = 750;
        private const double MIN_RECT_SIZE_TERM = 0.1;

        public volatile bool waitMainThread = false;

        public volatile bool IsBusy;

        public volatile bool justChangedGroup = false;

        public override string WindowName
        {
            get { return "HeatMap"; }
        }

        public static bool isInitializedVM = false;

        public PersistLastParams AppHeatMapLastParams;

        Dispatcher mainThreadDispatcher;

        private Thread worker;

        public static bool isInitialized = false;
        public volatile bool SubscriptionUpdate;
        private List<int> subscriptionTickerIDList = new List<int>();

        private DataFormatter formatter = new DataFormatter();

        private static int IDvalue { get; set; }

        public List<DataChild> childList { get; set; }
        public List<DataChildGroup> childGroupList { get; set; }

        public ObservableCollection<DataGroup> DataCollectionTree { get; set; }
        /*
        { 
            get { return DataCollection; }
            set
            {
                DataCollection = value;
                OnPropertyChanged("DataCollectionTree");
            }
        }

        private ObservableCollection<DataGroup> DataCollection;
        */
        public ObservableCollection<CDSIndexBase> CDSGroupCollection { get; set; }

        public Dictionary<int, object> HeatMapHash { get; set; }
        public Dictionary<string, int> HeatMapMemberHash { get; set; }
        public Dictionary<string, int> HeatMapEquityTickerHash { get; set; }

        public static Dictionary<string, double?> RectColorChgPCT { get; set; }
        public static Dictionary<string, double?> CircleColorChgPCT { get; set; }

        public static Dictionary<string, double?> RectColorChgNET { get; set; }
        public static Dictionary<string, double?> CircleColorChgNET { get; set; }

        public string PricingSource { get; set; }

        public static double CircleDataMinimum { get; set; }
        public static double CircleDataMaximum { get; set; }

        public static double RectangleDataMinimum { get; set; }
        public static double RectangleDataMaximum { get; set; }

        public double? MinRectangleSize { get; set; }
        public double? TotalRectangleSize { get; set; }

        private CDSIndexBase heatMapGroup { get; set; }
        public CDSIndexBase HeatMapGroup {
            get { return heatMapGroup; }
            set
            {
                heatMapGroup = value;
                OnPropertyChanged("HeatMapGroup");
            }
        }

        private string firstBy { get; set; }
        public string FirstBy {
            get { return firstBy; }
            set {
                firstBy = value;
                OnPropertyChanged("FirstBy");
            }         
        }

        private string thenBy { get; set; }
        public string ThenBy
        {
            get { return thenBy; }
            set
            {
                thenBy = value;
                OnPropertyChanged("ThenBy");
            }
        }

        private string rectSize { get; set; }
        public string RectSize {
            get { return rectSize; }
            set
            {
                rectSize = value;
                OnPropertyChanged("RectSize");
            }
        }

        public static string RectColor { get; set; }
        public static string CircleColor { get; set; }

        private string donutColor { get; set; }
        public string DonutColor {
            get { return donutColor; }
            set {
                donutColor = value;
                OnPropertyChanged("DonutColor");
            } 
        }

        public CDSIndexBase PrevHeatMapGroup { get; set; }
        public string PrevFirstBy { get; set; }
        public string PrevThenBy { get; set; }
        public string PrevRectSize { get; set; }
        public string PrevRectColor { get; set; }
        public string PrevCircleColor { get; set; }
        public string PrevDonutColor { get; set; }


        public static ShowChangeRateClass RateClass { get; set; }
        public ShowChangeRateClass PrevRateClass { get; set; }
        public DateTime PrevDate1 { get; set; }
        public DateTime PrevDate2 { get; set; }


        List<QuickFilterViewObject> quickfilterItems { get; set; }
        
        public List<string> FirstByList { get; set; }
        public List<string> ThenByList { get; set; }
        public List<string> RectangleSizeList { get; set; }
        public List<string> RectangleColorList { get; set; }
        public List<string> CircleColorList { get; set; }
        public List<string> DonutColorList { get; set; }

        private readonly ICommand _clearHighLightCircle;
        public ICommand ClearHighLightCircle { get { return _clearHighLightCircle; } }

        private ObservableName selectedTickerName { get; set; }
        public ObservableName SelectedTickerName {
            get { return selectedTickerName; }
            set {
                selectedTickerName = value;
                OnPropertyChanged("SelectedTickerName");
            } 
        }
        public ObservableCollection<ObservableName> tickerNameList { get; set; }

        private readonly ICommand _highLightRect;
        public ICommand HighLightRect { get { return _highLightRect; } }

        ObservableCollection<TickerDetails> _TickerDetailsCollection = new ObservableCollection<TickerDetails>();
        public ObservableCollection<TickerDetails> TickerDetailsCollection { get { return _TickerDetailsCollection; } }

        ObservableCollection<TickerDetailsName> _TickerDetailsNameCollection = new ObservableCollection<TickerDetailsName>();
        public ObservableCollection<TickerDetailsName> TickerDetailsNameCollection { get { return _TickerDetailsNameCollection; } }



        #region NormalDistColorVariables
        public List<double> CircleListPositive = new List<double>();
        public List<double> CircleListNegative = new List<double>();
        public List<double> RectListPositive = new List<double>();
        public List<double> RectListNegative = new List<double>();
        double minNormalDistForRectNeg = 0d;
        double maxNormalDistForRectNeg = 0d;
        double minNormalDistForCircleNeg = 0d;
        double maxNormalDistForCircleNeg = 0d;
        double minNormalDistForRectPos = 0d;
        double maxNormalDistForRectPos = 0d;
        double minNormalDistForCirclePos = 0d;
        double maxNormalDistForCirclePos = 0d;
        double maxMainForRectPos = 0d;
        double minMainForRectPos = 0d;
        double maxMainForCirclePos = 0d;
        double minMainForCirclePos = 0d;
        double maxMainForRectNeg = 0d;
        double minMainForRectNeg = 0d;
        double maxMainForCircleNeg = 0d;
        double minMainForCircleNeg = 0d;
        #endregion


        public List<double> DonutChartListPositive = new List<double>();
        public List<double> DonutChartListNegative = new List<double>();
        public double maxDonutChartListPositive = 0d;
        public double minDonutChartListPositive = 0d;
        double maxDonutChartListNegative = 0d;
        public double minDonutChartListNegative = 0d;

        public static DateTime BeginDate{ get; set; }
        public static DateTime EndDate { get; set; }

        public DateTime lastUpdateTime { get; set; }
        public DateTime lastDrawTime { get; set; }

        public LastUpdateDate LastUpdate { get; set; }

        private ItemVisibility gridVisibility;
        public ItemVisibility GridVisibility
        {
            get
            {
                return gridVisibility;
            }
            set
            {
                gridVisibility = value;
                OnPropertyChanged("GridVisibility");
            }
        }

        private ItemVisibility gridHideVisibility;
        public ItemVisibility GridHideVisibility
        {
            get
            {
                return gridHideVisibility;
            }
            set
            {
                gridHideVisibility = value;
                OnPropertyChanged("GridHideVisibility");
            }
        }

        private readonly ICommand showHideCommand;
        public ICommand ShowHidecommand
        {
            get { return showHideCommand; }
        }

        public void OnShowHideCommand(object obj)
        {
            if (buttonState == ButtonState.Shown)
            {
                buttonState = ButtonState.Hidden;
                GridVisibility._Visibility = Visibility.Collapsed;
                GridHideVisibility._Visibility = Visibility.Visible;
            }
            else
            {
                buttonState = ButtonState.Shown;
                GridVisibility._Visibility = Visibility.Visible;
                GridHideVisibility._Visibility = Visibility.Collapsed;
            }

        }

        public ButtonState buttonState;
        public enum ButtonState
        {
            Shown,
            Hidden
        }

        public HeatMapViewModel()
        {
            Trace.WriteLine("HeatMapViewModel is created.", "TRACE");

            _clearHighLightCircle = new RelayCommand(ClickClearQuickFilter, CanCreate);
            _highLightRect = new RelayCommand(ClickHighlightRect, CanCreate);

            showHideCommand = new RelayCommand(OnShowHideCommand, CanCreate);

            LastUpdate = new LastUpdateDate(DateTime.Now.ToLongTimeString());

            buttonState = ButtonState.Shown;
            GridHideVisibility = new ItemVisibility(Visibility.Collapsed);
            GridVisibility = new ItemVisibility(Visibility.Visible);

            Trace.WriteLine("HeatMapViewModel is completed.", "TRACE");
        }

        public void initializeViewModel()
        {
            if (CDSGroupCollection == null)
                isInitializedVM = false;

            if (!isInitializedVM)
            {
                Trace.WriteLine("HeatMapViewModel is initialized.", "TRACE");

                IsBusy = false;
                IDvalue = 0;
                
                DataCollectionTree = new ObservableCollection<DataGroup>();
                CDSGroupCollection = new ObservableCollection<CDSIndexBase>();

                HeatMapGroup = new CDSIndexBase();
                PrevHeatMapGroup = new CDSIndexBase();

                childList = new List<DataChild>();
                childGroupList = new List<DataChildGroup>();
                tickerNameList = new ObservableCollection<ObservableName>();

                fillAllList();

                initializeCDSHeatMapDetailsContainer();

                if (!isDataManagerInitialized())
                    return;

                createCDSGroupCollection();

                HeatMapHash = new Dictionary<int, object>();
                HeatMapMemberHash = new Dictionary<string, int>();
                HeatMapEquityTickerHash = new Dictionary<string, int>();

                RectColorChgPCT = new Dictionary<string, double?>();
                CircleColorChgPCT = new Dictionary<string, double?>();

                RectColorChgNET = new Dictionary<string, double?>();
                CircleColorChgNET = new Dictionary<string, double?>();

                CircleDataMinimum = 0d;
                CircleDataMaximum = 0d;
                RectangleDataMinimum = 0d;
                RectangleDataMaximum = 0d;

                HeatMapSelectedGroup = PrevHeatMapGroup = HeatMapGroup;
                PrevFirstBy = FirstBy;
                PrevThenBy = ThenBy;
                PrevRectSize = RectSize;
                PrevRectColor = RectColor;
                PrevCircleColor = CircleColor;
                PrevDonutColor = DonutColor;
                PrevRateClass = RateClass;
                PrevDate1 = BeginDate;
                PrevDate2 = EndDate;

                DataManager.SubscriptionResultUpdate += SubscriptionUpdHeatMap;
                SubscriptionUpdate = false;

                mainThreadDispatcher = Dispatcher.CurrentDispatcher;

                PricingSource = DataManager.PricingSource = "Default";

                if (tickerFilterItems.PriceSource != null)
                    PricingSource = DataManager.PricingSource = tickerFilterItems.PriceSource;
                else
                    tickerFilterItems.PriceSource = PricingSource;

                isInitializedVM = true;

                worker = new Thread(worker_DoWork);
                worker.Start();

                AppHeatMapLastParams = cacheManager.getAppLastParams();

                if (AppHeatMapLastParams != null)
                {
                    if (AppHeatMapLastParams.Group != "")
                    {
                        int index = CDSGroupCollection.ToList().FindIndex(list => list.CDSIndexName == AppHeatMapLastParams.Group);

                        if (index >= 0 && CDSGroupCollection[index] != null)
                        {
                            HeatMapSelectedGroup = PrevHeatMapGroup = HeatMapGroup = CDSGroupCollection[index];
                        }
                    }

                    if (AppHeatMapLastParams.FirstBy != "")
                    {
                        int index = FirstByList.FindIndex(list => list == AppHeatMapLastParams.FirstBy);

                        if (index >= 0)
                        {
                            PrevFirstBy = FirstBy = FirstByList[index];
                        }
                    }

                    if (AppHeatMapLastParams.ThenBy != "")
                    {
                        int index = ThenByList.FindIndex(list => list == AppHeatMapLastParams.ThenBy);

                        if (index >= 0)
                        {
                            PrevThenBy = ThenBy = ThenByList[index];
                        }
                    }

                    if (AppHeatMapLastParams.RectangleSize != "")
                    {
                        int index = RectangleSizeList.FindIndex(list => list == AppHeatMapLastParams.RectangleSize);

                        if (index >= 0)
                        {
                            PrevRectSize = RectSize = RectangleSizeList[index];
                        }
                    }

                    if (AppHeatMapLastParams.RectangleColor != "")
                    {
                        int index = RectangleColorList.FindIndex(list => list == AppHeatMapLastParams.RectangleColor);

                        if (index >= 0)
                        {
                            PrevRectColor = RectColor = RectangleColorList[index];
                        }
                    }

                    if (AppHeatMapLastParams.CircleColor != "")
                    {
                        int index = CircleColorList.FindIndex(list => list == AppHeatMapLastParams.CircleColor);

                        if (index >= 0)
                        {
                            PrevCircleColor = CircleColor = CircleColorList[index];
                        }
                    }

                    if (AppHeatMapLastParams.CircleBorder != "")
                    {
                        int index = DonutColorList.FindIndex(list => list == AppHeatMapLastParams.CircleBorder);

                        if (index >= 0)
                        {
                            PrevDonutColor = DonutColor = DonutColorList[index];
                        }
                    }

                    if (AppHeatMapLastParams.PricingSource != null && AppHeatMapLastParams.PricingSource != "")
                        PricingSource = DataManager.PricingSource = AppHeatMapLastParams.PricingSource;

                }
                else
                    AppHeatMapLastParams = new PersistLastParams();

                Trace.WriteLine("HeatMapViewModel initializing is completed.", "TRACE");
            }
            else
            {
                CDSGroupCollection.Clear();
                createCDSGroupCollection();
            }
        }

        public void initialize()
        {
            //initializeViewModel();

            //IsBusy = true;
            try
            {
                Trace.WriteLine("HeatMapViewModel initialize is called.", "TRACE");

                List<string> EqFieldList = createHeatMapFieldList(tickerFilter.TFCDSIndex.CDSIndexName);

                if (!isInitialized || !isCDSDataRetrieved) //TODO
                {
                    initializeCDSHeatMap();

                    unsubscribeAll();
                }
                else if (!isAddedTickerDataRetrieved)
                {
                    unsubscribeAll();
                    //updateHeatMapGroup();

                    retrieveValuesForAddedTickers(EqFieldList);

                    //get52WeekChgPCT(tickerFilter.AddedTickerList);
                }
                else //if (isTickerFilterChanged /*&& !inheatMap*/)
                {
                    if (EqFieldList != null && EqFieldList.Count > 0)
                    {
                        cacheManager.getTickerFieldsAndUpdateCache(tickerFilter, tickerFilter.getAllEquityTicker(), EqFieldList);
                    }
                    //updateHeatMapGroup();

                    if (tickerFilter.TFCDSIndex.CDSIndexName != HeatMapGroup.CDSIndexName)
                    {
                        if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                        {
                            getPriceFromBloomberg();
                        }
                    }

                    unsubscribeAll();
                }

                Trace.WriteLine("HeatMapViewModel initialize is completed.", "TRACE");
            }
            catch (Exception e)
            {
                if (mainThreadDispatcher != null)
                {
                    mainThreadDispatcher.BeginInvoke((Action)delegate
                    {
                        string errMessage = "A problem is occurred in CDS Heatmap application while initializing data!!!";
                        try
                        {
                            Trace.WriteLine(string.Format("A problem is occurred in CDS Heatmap application - HeatMap init data!!!: {0}", e.Message.ToString()), "ERROR");

                            string stackTrace = "";
                            if (e.Message != null && e.StackTrace != null)
                                stackTrace = e.StackTrace.ToString();

                            Trace.WriteLine("Exception Stacktrace: " + stackTrace, "INFO");

                            var popup = new DisplayExceptionView(errMessage + "\n" + e.Message.ToString(), stackTrace);
                            PopupWindow.Instance.Title = "API Error";
                            PopupWindow.Instance.ShowWindow(popup);
                            PopupWindow.Instance.Width = 500;//Aysegul Albayrak,popup size
                            PopupWindow.Instance.Height = 600;
                        }
                        catch (Exception eDisplay)
                        {
                            Trace.WriteLine("Exception while displaying Bloomberg API Error (heatmap init data): " + errMessage + "\n" + eDisplay.Message, "ERROR");

                            string stackTraceDisplay = "";
                            if (eDisplay.StackTrace != null)
                                stackTraceDisplay = eDisplay.StackTrace.ToString();

                            Trace.WriteLine("Exception Stacktrace (1041): " + stackTraceDisplay, "INFO");
                        }
                    });
                }
            }

            //IsBusy = false;
        }

        public void initializeAfter(object obj)
        {
            try
            {
                Trace.WriteLine("HeatMapViewModel initializeAfter is called.", "TRACE");

                if (!isInitialized || !isCDSDataRetrieved) //TODO
                {
                    isTickerFilterChanged = true;
                    isCDSDataRetrieved = true;
                    isAddedTickerDataRetrieved = true;

                    updateHeatMapGroup();

                    DrawHeatMap();
                    isInitialized = true;
                }
                else if (!isAddedTickerDataRetrieved)
                {
                    updateHeatMapGroup();
                    DrawHeatMap();

                    isTickerFilterChanged = false;
                    isAddedTickerDataRetrieved = true;
                }
                else //if (isTickerFilterChanged /*&& !inheatMap*/)
                {
                    updateHeatMapGroup();
                    DrawHeatMap();

                    isTickerFilterChanged = false;
                }

                Trace.WriteLine("HeatMapViewModel initializeAfter is completed.", "TRACE");
            }
            catch (Exception e)
            {
                if (mainThreadDispatcher != null)
                {
                    mainThreadDispatcher.BeginInvoke((Action)delegate
                    {
                        string errMessage = "A problem is occurred in CDS Heatmap application while initializing view!!!";
                        try
                        {
                            Trace.WriteLine(string.Format("A problem is occurred in CDS Heatmap application - HeatMap init view!!!: {0}", e.Message.ToString()), "ERROR");

                            string stackTrace = "";
                            if (e.Message != null && e.StackTrace != null)
                                stackTrace = e.StackTrace.ToString();

                            Trace.WriteLine("Exception Stacktrace: " + stackTrace, "INFO");

                            var popup = new DisplayExceptionView(errMessage + "\n" + e.Message.ToString(), stackTrace);
                            PopupWindow.Instance.Title = "API Error";
                            PopupWindow.Instance.ShowWindow(popup);
                            PopupWindow.Instance.Width = 500;//Aysegul Albayrak,popup size
                            PopupWindow.Instance.Height = 600;
                        }
                        catch (Exception eDisplay)
                        {
                            Trace.WriteLine("Exception while displaying Bloomberg API Error (heatmap init view): " + errMessage + "\n" + eDisplay.Message, "ERROR");

                            string stackTraceDisplay = "";
                            if (eDisplay.StackTrace != null)
                                stackTraceDisplay = eDisplay.StackTrace.ToString();

                            Trace.WriteLine("Exception Stacktrace (1041): " + stackTraceDisplay, "INFO");
                        }
                    });
                }
            }
            finally
            {
                IsBusy = false;
               
                justChangedGroup = true;
            }
        }


        public void updateHeatMapGroup()
        {
            try
            {
                Trace.WriteLine("HeatMapViewModel updateHeatMapGroup is called.", "TRACE");

                foreach (var group in CDSGroupCollection)
                {
                    if (tickerFilter.TickerFilterName.Equals(group.CDSIndexName) && group != null)
                    {
                        HeatMapSelectedGroup = PrevHeatMapGroup = HeatMapGroup = group;
                        return;
                    }
                }

                CDSGroupCollection.Add(new CDSIndexBase(tickerFilter.TickerFilterName, CDSIndexType.TICKERFILTER));

                if (CDSGroupCollection.Last() != null)
                    HeatMapSelectedGroup = PrevHeatMapGroup = HeatMapGroup = CDSGroupCollection.Last();

                if (HeatMapGroup == null)
                    Trace.Write("HeatMapGroup is null!!!", "INFO");

                Trace.WriteLine("HeatMapViewModel updateHeatMapGroup is completed.", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while updateHeatMapGroup: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updateHeatMapGroup: " + stackTrace, "INFO");
            }
        }

        public void initializeCDSHeatMap()
        {
            try
            {
                Trace.WriteLine("HeatMapViewModel initializeCDSHeatMap is called.", "TRACE");

                tickerFilter.reset();

                tickerFilter.TFCDSIndex.CDSIndexMemberList.Clear();

                getBloombergInitialData();
                //get52WeekChgPCT(tickerFilter.getAllCDSMembers());

                if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    getPriceFromBloomberg();
                }

                Trace.WriteLine("HeatMapViewModel initializeCDSHeatMap is completed.", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while initializeCDSHeatMap: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace initializeCDSHeatMap: " + stackTrace, "INFO");
            }
                
        }

        #region QuickFilterCommand
        public bool CanCreate(object obj)
        {
            return true;
            /*
            if (DataCollection.Count > 0)
                return true;
            return false;
             */
        }

        public void ClickClearQuickFilter(object obj)
        {
            clearHighLightCircle();
        }


        #endregion
        #region updateHeatMapCommand
        public void UpdateHeatMap()
        {
            try
            {
                Trace.WriteLine("UpdateHeatMap is called", "TRACE");
                setAppLastParams();

                Thread thread = new Thread(() =>
                {
                    try
                    {
                        cacheManager.saveAppLastParams(AppHeatMapLastParams);
                    }
                    catch (Exception e)
                    {
                        Trace.WriteLine("Exception while saveAppLastParams in UpdateHeatMap: " + e.Message, "ERROR");
                        string stackTrace = "";
                        if (e.StackTrace != null)
                            stackTrace = e.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace saveAppLastParams in UpdateHeatMap: " + stackTrace, "INFO");
                    }
                });
                thread.Start();

                if (FirstBy == ConstantItemList.NONE)
                {
                    ThenBy = ConstantItemList.NONE;
                }

                if (!isInitialized)
                {
                    initializeCDSHeatMap();

                }
                else if (HeatMapGroup.CDSIndexName != PrevHeatMapGroup.CDSIndexName)
                {
                    unsubscribeAll();
                    initializeCDSHeatMap();
                }

                Trace.WriteLine("UpdateHeatMap is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while UpdateHeatMap: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace UpdateHeatMap: " + stackTrace, "INFO");
            }

            //IsBusy = false;
        }

        public void UpdateHeatMapAfter()
        {
            try
            {
                Trace.WriteLine("UpdateHeatMapAfter is called", "TRACE");

                clearHighLightCircle();
                if (!isInitialized)
                {
                    isTickerFilterChanged = true;
                    isCDSDataRetrieved = true;
                    isAddedTickerDataRetrieved = true;

                    DrawHeatMap();
                    
                    isInitialized = true;
                }
                else if (HeatMapGroup.CDSIndexName != PrevHeatMapGroup.CDSIndexName)
                {

                    isTickerFilterChanged = true;
                    isCDSDataRetrieved = true;
                    isAddedTickerDataRetrieved = true;

                    DrawHeatMap();

                    justChangedGroup = true;
                }
                else
                {
                    updateHeatMapItemValues();
                    isCDSDataRetrieved = true;
                    isAddedTickerDataRetrieved = true;
                }

                HeatMapSelectedGroup = PrevHeatMapGroup = HeatMapGroup;
                PrevFirstBy = FirstBy;
                PrevThenBy = ThenBy;
                PrevRectSize = RectSize;
                PrevRectColor = RectColor;
                PrevCircleColor = CircleColor;
                PrevDonutColor = DonutColor;
                PrevRateClass = RateClass;
                PrevDate1 = BeginDate;
                PrevDate2 = EndDate;

                //LastUpdate.LastUpdateTime = DateTime.Now.ToLongTimeString();
                //lastUpdateTime = DateTime.Now;

                Trace.WriteLine("UpdateHeatMapAfter is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while UpdateHeatMapAfter: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace UpdateHeatMapAfter: " + stackTrace, "INFO");
            }

        }
        #endregion




        #region searchTickerCommand
        public void ClickHighlightRect(object obj)
        {
            clearHighLightCircle();

            if (SelectedTickerName == null)
                return;

            if (SelectedTickerName.DisplayName == null)
                return;

            string ticker = SelectedTickerName.DisplayName;
            if (String.IsNullOrWhiteSpace(ticker))
                return;

            int id;

            if (HeatMapMemberHash.ContainsKey(ticker))
                id = HeatMapMemberHash[ticker];

            else if (HeatMapEquityTickerHash.ContainsKey(ticker + " Equity"))
                id = HeatMapEquityTickerHash[ticker + " Equity"];

            else
                return;

            DataChild item = (DataChild)HeatMapHash[id];

            //item.DisplayImage = "/CDSHeatMap;component/Image/TickerCircle_gold.png";
            item.DisplayImage = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/TickerCircle_gold.png"));
            if (item.DisplayImage.CanFreeze)
                item.DisplayImage.Freeze();

            highlightBorderChildTicker(id);

        }
        public void clearBorderBrush()
        {
            foreach (DataGroup datagroup in DataCollectionTree)
            {
                foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                {
                    foreach (DataChild item in childgroup.DataChildCollection)
                    {
                        item.ChildBorderBrush = item.RectangleFillingColor;

                        if (item.ChildBorderBrush.CanFreeze)
                            item.ChildBorderBrush.Freeze();
                    }
                    childgroup.ChildGroupBorderBrush = null;
                }
                datagroup.GroupBorderBrush = null;
            }
        }
        #endregion


        public void highlightBorderChildTicker(int id)
        {
            clearBorderBrush();

            foreach (DataGroup datagroup in DataCollectionTree)
            {
                foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                {
                    foreach (DataChild item in childgroup.DataChildCollection)
                    {
                        if (id == item.ID)
                        {
                            item.ChildBorderBrush = Brushes.Black;
                        }
                    }
                }
            }

        }


        public void highlightBorderChildGroupTicker(int id)
        {
            clearBorderBrush();

            foreach (DataGroup datagroup in DataCollectionTree)
            {
                foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                {
                    if (id == childgroup.ID)
                    {
                        childgroup.ChildGroupBorderBrush = Brushes.Black;
                    }

                }
            }

        }

        public void highlightBorderGroupTicker(int id)
        {
            clearBorderBrush();

            foreach (DataGroup datagroup in DataCollectionTree)
            {
                if (id == datagroup.ID)
                {
                    datagroup.GroupBorderBrush = Brushes.Black;
                }
            }

        }



        public void ClickLeftChildRect(object obj)
        {
            try
            {
                int id = Convert.ToInt32(obj);
                TickerDetailsCollection.Clear();
                TickerDetailsNameCollection.Clear();
                highlightBorderChildTicker(id);
                var resultSet = getSelectionDataDisplay(id);

                if (resultSet.Keys.Count < 1)
                    return;

                TickerDetailsName nameItem = new TickerDetailsName();
                nameItem.detailsName = resultSet.Keys.First().ToString();
                TickerDetailsNameCollection.Add(nameItem);


                foreach (var item in resultSet.Values.First())
                {
                    TickerDetailsCollection.Add(item);
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while ClickLeftChildRect: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace ClickLeftChildRect: " + stackTrace, "INFO");
            }

        }


        public void ClickLeftChildGroupRect(object obj)
        {
            try
            {
                int id = Convert.ToInt32(obj);
                TickerDetailsCollection.Clear();
                TickerDetailsNameCollection.Clear();
                highlightBorderChildGroupTicker(id);
                var resultSet = getSelectionDataDisplay(id);

                if (resultSet.Keys.Count < 1)
                    return;

                TickerDetailsName nameItem = new TickerDetailsName();
                nameItem.detailsName = resultSet.Keys.First().ToString();
                TickerDetailsNameCollection.Add(nameItem);

                foreach (var item in resultSet.Values.First())
                {
                    TickerDetailsCollection.Add(item);
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while ClickLeftChildGroupRect: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace ClickLeftChildGroupRect: " + stackTrace, "INFO");
            }

        }


        public void ClickLeftGroupRect(object obj)
        {
            try
            {
                int id = Convert.ToInt32(obj);
                TickerDetailsCollection.Clear();
                TickerDetailsNameCollection.Clear();
                highlightBorderGroupTicker(id);
                var resultSet = getSelectionDataDisplay(id);

                if (resultSet.Keys.Count < 1)
                    return;

                TickerDetailsName nameItem = new TickerDetailsName();
                nameItem.detailsName = resultSet.Keys.First().ToString();
                TickerDetailsNameCollection.Add(nameItem);

                foreach (var item in resultSet.Values.First())
                {
                    TickerDetailsCollection.Add(item);
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while ClickLeftGroupRect: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace ClickLeftGroupRect: " + stackTrace, "INFO");
            }
        }

        public bool CompareFilteredItems(object itemValue, string compare, string filterValue, string maxFilterValue)
        {
            try
            {
                if (string.IsNullOrEmpty(filterValue))
                    return false;

                switch (compare)
                {
                    case "Between":
                        if (string.IsNullOrEmpty(maxFilterValue))
                            return false;

                        if (itemValue.GetType() == typeof(double))
                        {
                            double valDouble1 = 0.0;
                            double valDouble2 = 0.0;

                            if (double.TryParse(filterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble1))
                            {
                                if (double.TryParse(maxFilterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble2))
                                {
                                    if (((double)itemValue >= valDouble1 && ((double)itemValue <= valDouble2)))
                                        return true;
                                    else
                                        return false;
                                }
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        else if (itemValue.GetType() == typeof(string))
                        {
                            return false;
                        }
                        else if (itemValue.GetType() == typeof(Bloomberglp.Blpapi.Datetime))
                        {
                            if ((((Bloomberglp.Blpapi.Datetime)itemValue).ToSystemDateTime().Date >= DateTime.Parse(filterValue).Date)
                                && (((Bloomberglp.Blpapi.Datetime)itemValue).ToSystemDateTime().Date <= DateTime.Parse(maxFilterValue).Date))
                                return true;
                            else
                                return false;

                        }
                        else if (itemValue.GetType() == typeof(Int32) || itemValue.GetType() == typeof(int))
                        {
                            int valueInt1 = 0;
                            int valueInt2 = 0;

                            if (int.TryParse(filterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt1))
                            {
                                if (int.TryParse(maxFilterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt2))
                                {
                                    if (((int)itemValue >= valueInt1) && ((int)itemValue <= valueInt2))
                                        return true;
                                    else
                                        return false;
                                }
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        break;

                    case "Equals":
                        if (itemValue.GetType() == typeof(double))
                        {
                            double valDouble1 = 0.0;

                            if (double.TryParse(filterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble1))
                            {
                                if ((double)itemValue == valDouble1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        else if (itemValue.GetType() == typeof(string))
                        {
                            if (itemValue.ToString() == filterValue)
                                return true;
                            else
                                return false;
                        }
                        else if (itemValue.GetType() == typeof(Bloomberglp.Blpapi.Datetime))
                        {
                            if (((Bloomberglp.Blpapi.Datetime)itemValue).ToSystemDateTime().Date == DateTime.Parse(filterValue).Date)
                                return true;
                            else
                                return false;

                        }
                        else if (itemValue.GetType() == typeof(Int32) || itemValue.GetType() == typeof(int))
                        {
                            int valueInt1 = 0;

                            if (int.TryParse(filterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt1))
                            {
                                if ((int)itemValue == valueInt1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        break;

                    case "Does Not Equal":
                        if (itemValue.GetType() == typeof(double))
                        {
                            double valDouble1 = 0.0;

                            if (double.TryParse(filterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble1))
                            {
                                if ((double)itemValue != valDouble1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        else if (itemValue.GetType() == typeof(string))
                        {
                            if (itemValue.ToString() != filterValue)
                                return true;
                            else
                                return false;
                        }
                        else if (itemValue.GetType() == typeof(Bloomberglp.Blpapi.Datetime))
                        {
                            if (((Bloomberglp.Blpapi.Datetime)itemValue).ToSystemDateTime().Date != DateTime.Parse(filterValue).Date)
                                return true;
                            else
                                return false;

                        }
                        else if (itemValue.GetType() == typeof(Int32) || itemValue.GetType() == typeof(int))
                        {
                            int valueInt1 = 0;

                            if (int.TryParse(filterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt1))
                            {
                                if ((int)itemValue != valueInt1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        break;

                    case "Greather Than":
                        if (itemValue.GetType() == typeof(double))
                        {
                            double valDouble1 = 0.0;

                            if (double.TryParse(filterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble1))
                            {
                                if ((double)itemValue > valDouble1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        else if (itemValue.GetType() == typeof(string))
                        {
                            return false;
                        }
                        else if (itemValue.GetType() == typeof(Bloomberglp.Blpapi.Datetime))
                        {
                            if (((Bloomberglp.Blpapi.Datetime)itemValue).ToSystemDateTime().Date > DateTime.Parse(filterValue).Date)
                                return true;
                            else
                                return false;

                        }
                        else if (itemValue.GetType() == typeof(Int32) || itemValue.GetType() == typeof(int))
                        {
                            int valueInt1 = 0;

                            if (int.TryParse(filterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt1))
                            {
                                if ((int)itemValue > valueInt1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        break;

                    case "Greather Than Or Equal To":
                        if (itemValue.GetType() == typeof(double))
                        {
                            double valDouble1 = 0.0;

                            if (double.TryParse(filterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble1))
                            {
                                if ((double)itemValue >= valDouble1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        else if (itemValue.GetType() == typeof(string))
                        {
                            return false;
                        }
                        else if (itemValue.GetType() == typeof(Bloomberglp.Blpapi.Datetime))
                        {
                            if (((Bloomberglp.Blpapi.Datetime)itemValue).ToSystemDateTime().Date >= DateTime.Parse(filterValue).Date)
                                return true;
                            else
                                return false;

                        }
                        else if (itemValue.GetType() == typeof(Int32) || itemValue.GetType() == typeof(int))
                        {
                            int valueInt1 = 0;

                            if (int.TryParse(filterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt1))
                            {
                                if ((int)itemValue >= valueInt1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        break;

                    case "Less Than":
                        if (itemValue.GetType() == typeof(double))
                        {
                            double valDouble1 = 0.0;

                            if (double.TryParse(filterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble1))
                            {
                                if ((double)itemValue < valDouble1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        else if (itemValue.GetType() == typeof(string))
                        {
                            return false;
                        }
                        else if (itemValue.GetType() == typeof(Bloomberglp.Blpapi.Datetime))
                        {
                            if (((Bloomberglp.Blpapi.Datetime)itemValue).ToSystemDateTime().Date < DateTime.Parse(filterValue).Date)
                                return true;
                            else
                                return false;

                        }
                        else if (itemValue.GetType() == typeof(Int32) || itemValue.GetType() == typeof(int))
                        {
                            int valueInt1 = 0;

                            if (int.TryParse(filterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt1))
                            {
                                if ((int)itemValue < valueInt1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;

                        }
                        break;

                    case "Less Than Or Equal To":
                        if (itemValue.GetType() == typeof(double))
                        {
                            double valDouble1 = 0.0;

                            if (double.TryParse(filterValue, NumberStyles.AllowDecimalPoint | NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valDouble1))
                            {
                                if ((double)itemValue <= valDouble1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        else if (itemValue.GetType() == typeof(string))
                        {
                            return false;
                        }
                        else if (itemValue.GetType() == typeof(Bloomberglp.Blpapi.Datetime))
                        {
                            if (((Bloomberglp.Blpapi.Datetime)itemValue).ToSystemDateTime().Date <= DateTime.Parse(filterValue).Date)
                                return true;
                            else
                                return false;

                        }
                        else if (itemValue.GetType() == typeof(Int32) || itemValue.GetType() == typeof(int))
                        {
                            int valueInt1 = 0;

                            if (int.TryParse(filterValue, NumberStyles.AllowLeadingSign, CultureInfo.InvariantCulture, out valueInt1))
                            {
                                if ((int)itemValue <= valueInt1)
                                    return true;
                                else
                                    return false;
                            }
                            else
                                return false;
                        }
                        break;

                    case "Begins With":
                        if (itemValue.GetType() == typeof(string))
                        {
                            return itemValue.ToString().StartsWith(filterValue, StringComparison.CurrentCultureIgnoreCase);
                        }
                        break;

                    case "Ends With":
                        if (itemValue.GetType() == typeof(string))
                        {
                            return itemValue.ToString().EndsWith(filterValue, StringComparison.CurrentCultureIgnoreCase);
                        }
                        break;

                    case "Contains":
                        if (itemValue.GetType() == typeof(string))
                        {
                            if (itemValue.ToString().IndexOf(filterValue, StringComparison.CurrentCultureIgnoreCase) >= 0)
                                return true;
                            else return false;
                        }
                        break;

                    case "Does Not Contain":
                        if (itemValue.GetType() == typeof(string))
                        {
                            if (itemValue.ToString().IndexOf(filterValue, StringComparison.CurrentCultureIgnoreCase) < 0)
                                return true;
                            else return false;
                        }
                        break;

                    default:
                        return false;
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while CompareFilteredItems: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace CompareFilteredItems: " + stackTrace, "INFO");
            }

            return false;
        }

        public void clearHighLightCircle()
        {
            foreach (DataGroup datagroup in DataCollectionTree)
            {
                foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                {
                    foreach (DataChild item in childgroup.DataChildCollection)
                    {
                        //item.DisplayImage = "/CDSHeatMap;component/Image/TickerCircle_small.png";
                        item.DisplayImage = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/TickerCircle_small.png"));
                        if (item.DisplayImage.CanFreeze)
                            item.DisplayImage.Freeze();
                    }
                }
            }

        }

        public double? getPriceFromTickerFilter(string ticker, ShowChangeRateClass type)
        {
            try
            {
                foreach (var member in tickerFilter.TFCDSIndex.CDSIndexMemberList.Concat(tickerFilter.AddedTickerList))
                {
                    if (member.TickerEquity == ticker)
                    {
                        if (type == ShowChangeRateClass.YTD)
                            return member.ChgPCTYTD;
                        else if (type == ShowChangeRateClass.CLOSE)
                            return member.ChgPCT1D;
                        /*
                    else if(type == ShowChangeRateClass.WEEK52)
                        return member.ChgPCT52W;
                         */
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while getPriceFromTickerFilter: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace getPriceFromTickerFilter: " + stackTrace, "INFO");
            }

            return null;
        }


        public void updateHighLightCircle()
        {
            try
            {
                if (quickfilterItems.Count <= 0)
                    return;

                List<string> fields = new List<string>();
                foreach (var filter in quickfilterItems)
                {
                    if (filter.fieldName != null && filter.fieldName != "")
                    {
                        if (!filter.fieldName.Contains("CALCULATED"))
                            fields.Add(filter.fieldName);
                        else
                        {
                            if (filter.subValue == "Change Percent Between User Set Dates")
                                continue;

                            string[] split = filter.fieldName.Split(new Char[] { '=', '/' });

                            foreach (string s in split)
                            {

                                if (s.Trim() != "" && s != "CALCULATED")
                                    fields.Add(s);
                            }
                        }
                    }
                }

                if (quickfilterItems.Count > 1)
                    quickfilterItems[0].andOrValue = quickfilterItems[1].andOrValue;
                else
                    quickfilterItems[0].andOrValue = "AND";

                var resultSet = cacheManager.dataManager.GetFieldValues(tickerFilter.getAllEquityTicker(), fields);

                foreach (DataGroup datagroup in DataCollectionTree)
                {
                    foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                    {
                        foreach (DataChild item in childgroup.DataChildCollection)
                        {
                            bool isFilteredTicker = true;
                            string ticker = item.getTickerEquity();
                            if (ticker == "")
                                continue;

                            bool isFiltered = true;

                            for (int i = 0; i < quickfilterItems.Count; ++i)
                            {
                                if (quickfilterItems[i].fieldName == null || quickfilterItems[i].fieldName == "")
                                {
                                    continue;
                                }

                                if (quickfilterItems[i].subValue == "Change Percent Between User Set Dates")
                                {
                                    double? val = null;
                                    //TODO: item chg YTD 1D value

                                    if (RateClass == ShowChangeRateClass.YTD)
                                        val = getPriceFromTickerFilter(item.ChildEqTicker, ShowChangeRateClass.YTD);
                                    else if (RateClass == ShowChangeRateClass.CLOSE)
                                        val = getPriceFromTickerFilter(item.ChildEqTicker, ShowChangeRateClass.CLOSE);
                                    /*
                                else if (RateClass == ShowChangeRateClass.WEEK52)
                                {
                                    val = getPriceFromTickerFilter(item.ChildEqTicker, ShowChangeRateClass.WEEK52);
                                }
                                     */
                                    else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                                    {
                                        string tickerEq = item.getTickerEquity();
                                        if (tickerEq != "" && RectColorChgPCT.ContainsKey(tickerEq))
                                            val = RectColorChgPCT[tickerEq];
                                        else if (tickerEq != "" && CircleColorChgPCT.ContainsKey(tickerEq))
                                            val = CircleColorChgPCT[tickerEq];
                                        else
                                            val = null;
                                    }

                                    if (val != null)
                                    {
                                        if (CompareFilteredItems(val, quickfilterItems[i].operatorValue, quickfilterItems[i].minTextValue, quickfilterItems[i].maxTextValue))
                                        {
                                            isFiltered = true;
                                        }
                                        else
                                        {
                                            isFiltered = false;
                                        }
                                    }
                                    else
                                        isFiltered = false;
                                }
                                else if (quickfilterItems[i].fieldName.Contains("CALCULATED"))
                                {
                                    string[] split = quickfilterItems[i].fieldName.Split(new Char[] { '=', '/' });
                                    List<string> calcFields = new List<string>();

                                    foreach (string s in split)
                                    {
                                        if (s.Trim() != "" && s != "CALCULATED")
                                            calcFields.Add(s);
                                    }

                                    double? value1 = null;
                                    double? value2 = null;

                                    if (calcFields.Count != 2)
                                        continue;

                                    if (resultSet != null && resultSet.ContainsKey(ticker))
                                    {
                                        for (int j = 0; j < resultSet.Values.Count; ++j)
                                        {
                                            if (resultSet[ticker][j].Value != null)
                                            {
                                                if (resultSet[ticker][j].Name == calcFields[0])
                                                {
                                                    value1 = (double)resultSet[ticker][j].Value;
                                                }

                                                if (resultSet[ticker][j].Name == calcFields[1])
                                                {
                                                    value2 = (double)resultSet[ticker][j].Value;
                                                }
                                            }
                                            else
                                                isFiltered = false;
                                        }

                                        if (value1 != null && value2 != null && value2 != 0.0)
                                        {
                                            var val = value1 / value2;

                                            if (CompareFilteredItems(val, quickfilterItems[i].operatorValue, quickfilterItems[i].minTextValue, quickfilterItems[i].maxTextValue))
                                            {
                                                isFiltered = true;
                                            }
                                            else
                                            {
                                                isFiltered = false;
                                            }
                                        }
                                        else
                                            isFiltered = false;
                                    }
                                    else
                                        isFiltered = false;
                                }
                                else
                                {
                                    if (resultSet != null && resultSet.ContainsKey(ticker))
                                    {
                                        for (int j = 0; j < fields.Count; ++j)
                                        {
                                            if (resultSet[ticker][j].Name == quickfilterItems[i].fieldName)
                                            {
                                                if (resultSet[ticker][j].Value != null)
                                                {
                                                    var value = resultSet[ticker][j].Value;

                                                    if (CompareFilteredItems(value, quickfilterItems[i].operatorValue, quickfilterItems[i].minTextValue, quickfilterItems[i].maxTextValue))
                                                    {
                                                        isFiltered = true;
                                                    }
                                                    else
                                                    {
                                                        isFiltered = false;
                                                    }
                                                }
                                                else
                                                    isFiltered = false;
                                            }
                                        }
                                    }
                                    else
                                        isFiltered = false;
                                }

                                if (i == 0)
                                {
                                    isFilteredTicker = isFiltered;
                                }
                                else
                                {
                                    if (quickfilterItems[i].andOrValue == "OR")
                                        isFilteredTicker |= isFiltered;
                                    else if (quickfilterItems[i].andOrValue == "AND")
                                        isFilteredTicker &= isFiltered;
                                }

                                if ((quickfilterItems[i].andOrValue == "OR" && isFiltered == true) ||
                                    (quickfilterItems[i].andOrValue == "AND" && isFiltered == false))
                                    break;

                            }

                            if (isFilteredTicker)
                            {
                                //item.FilterMarkColor = Brushes.Red;
                                //item.DisplayImage = "/CDSHeatMap;component/Image/TickerCircle_gold.png";
                                item.DisplayImage = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/TickerCircle_gold.png"));
                                if (item.DisplayImage.CanFreeze)
                                    item.DisplayImage.Freeze();
                            }
                            else
                            {
                                //item.FilterMarkColor = Brushes.Transparent;
                                //item.DisplayImage = "/CDSHeatMap;component/Image/TickerCircle_small.png";
                                item.DisplayImage = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/TickerCircle_small.png"));
                                if (item.DisplayImage.CanFreeze)
                                    item.DisplayImage.Freeze();
                            }
                        }
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while updateHighLightCircle: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updateHighLightCircle: " + stackTrace, "INFO");
            }
        }

        public void updateHeatMap()
        {
            lock (LockHolder.Lock)
            {
                //your safe code
                try
                {
                    setParameters();

                    fillListFromCollectionAndSetParams();

                    foreach (DataGroup datagroup in DataCollectionTree)
                    {
                        foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                        {
                            foreach (DataChild item in childgroup.DataChildCollection)
                            {
                                if (HeatMapView.isHideTickerChecked)
                                    item.TickerName = "";
                                else
                                    item.TickerName = item.ChildEqTicker;

                                if (HeatMapView.isNormalDistChecked)
                                {
                                    if (CircleColor == ConstantItemList.NONE)
                                        item.CircleFillingColor = Brushes.Transparent;
                                    else
                                        item.CircleFillingColor = generateColorFromNormForCircle(item.CircleColor);

                                    item.RectangleFillingColor = generateColorFromNormForRect(item.RectangleColor);
                                    item.ChildBorderBrush = item.RectangleFillingColor;
                                }
                                else
                                {
                                    if (CircleColor == ConstantItemList.NONE)
                                        item.CircleFillingColor = Brushes.Transparent;
                                    else
                                        item.CircleFillingColor = generateColorForCircle(item.CircleColor);

                                    item.RectangleFillingColor = generateColorForRectangle(item.RectangleColor);
                                    item.ChildBorderBrush = item.RectangleFillingColor;
                                }
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    Trace.WriteLine("Exception while updating CDS Heat Map View: Exception (7001): " + e.Message, "ERROR");

                    string stackTrace = "";
                    if (e.StackTrace != null)
                        stackTrace = e.StackTrace.ToString();

                    Trace.WriteLine("Exception Stacktrace (7001): " + stackTrace, "INFO");

                    var popup = new NotificationView(e.ToString(), ErrorMsgLevel.None);
                    PopupWindow.Instance.Title = "CDS Heat Map View Notification";
                    PopupWindow.Instance.ShowWindow(popup);
                    PopupWindow.Instance.Width = 250;//Aysegul Albayrak,popup size
                    PopupWindow.Instance.Height = 230;

                }

                lastUpdateTime = DateTime.Now;
                LastUpdate.LastUpdateTime = DateTime.Now.ToLongTimeString();
            }
        }



        //begin test
        public void updateHeatMapFromNormDist()
        {
            try
            {
                setParameters();

                fillListFromCollectionAndSetParams();

                lastUpdateTime = DateTime.Now;
                LastUpdate.LastUpdateTime = DateTime.Now.ToLongTimeString();

                foreach (DataGroup datagroup in DataCollectionTree)
                {
                    foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                    {
                        foreach (DataChild item in childgroup.DataChildCollection)
                        {
                            try
                            {
                                if (CircleColor == ConstantItemList.NONE)
                                    item.CircleFillingColor = Brushes.Transparent;
                                else
                                    item.CircleFillingColor = generateColorFromNormForCircle(item.CircleColor);
                                item.RectangleFillingColor = generateColorFromNormForRect(item.RectangleColor);
                                item.ChildBorderBrush = item.RectangleFillingColor;
                            }
                            catch (Exception e)
                            {
                                Trace.WriteLine("Exception in updateHeatMapFromNormDist while updating CDS Heat Map View: Exception (7002): " + e.Message, "ERROR");

                                string stackTrace = "";
                                if (e.StackTrace != null)
                                    stackTrace = e.StackTrace.ToString();

                                Trace.WriteLine("Exception Stacktrace (7002): " + stackTrace, "INFO");
                            }
                        }
                    }
                }
            }
            catch (Exception e)
            {
                Trace.WriteLine("Exception while updateHeatMapFromNormDist: " + e.Message, "ERROR");
                string stackTrace = "";
                if (e.StackTrace != null)
                    stackTrace = e.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updateHeatMapFromNormDist: " + stackTrace, "INFO");
            }
        }

        public void updateHeatMapShowTickerName(bool isShowTicker)
        {
            try
            {
                foreach (DataGroup datagroup in DataCollectionTree)
                {
                    foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                    {
                        foreach (DataChild item in childgroup.DataChildCollection)
                        {
                            if (isShowTicker)
                                item.TickerName = item.ChildEqTicker;
                            else
                                item.TickerName = "";
                        }
                    }
                }
            }
            catch (Exception e)
            {
                Trace.WriteLine("Exception while updateHeatMapShowTickerName: " + e.Message, "ERROR");
                string stackTrace = "";
                if (e.StackTrace != null)
                    stackTrace = e.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updateHeatMapShowTickerName: " + stackTrace, "INFO");
            }
        }



        public void updateHeatMapFromNormLinear()
        {
            try
            {
                setParameters();

                fillListFromCollectionAndSetParams();

                lastUpdateTime = DateTime.Now;
                LastUpdate.LastUpdateTime = DateTime.Now.ToLongTimeString();

                foreach (DataGroup datagroup in DataCollectionTree)
                {
                    foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                    {
                        foreach (DataChild item in childgroup.DataChildCollection)
                        {
                            try
                            {
                                if (CircleColor == ConstantItemList.NONE)
                                    item.CircleFillingColor = Brushes.Transparent;
                                else
                                    item.CircleFillingColor = generateColorForCircle(item.CircleColor);
                                item.RectangleFillingColor = generateColorForRectangle(item.RectangleColor);
                                item.ChildBorderBrush = item.RectangleFillingColor;
                            }
                            catch (Exception e)
                            {
                                Trace.WriteLine("Exception in updateHeatMapFromNormLinear while updating CDS Heat Map View (7003): " + e.Message, "ERROR");

                                string stackTrace = "";
                                if (e.StackTrace != null)
                                    stackTrace = e.StackTrace.ToString();

                                Trace.WriteLine("Exception Stacktrace (7003): " + stackTrace, "INFO");
                            }
                        }
                    }
                }
            }
            catch (Exception e)
            {
                Trace.WriteLine("Exception while updateHeatMapFromNormLinear: " + e.Message, "ERROR");
                string stackTrace = "";
                if (e.StackTrace != null)
                    stackTrace = e.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updateHeatMapFromNormLinear: " + stackTrace, "INFO");
            }
        }
        //end test


        public void addContextMenuToChild(DataChild child)
        {
            try
            {
                //context menu
                ContextMenuItem contextItem = new ContextMenuItem();
                contextItem.Displayname = "Equity DES";
                contextItem.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem.Id = child.ID;
                contextItem.ChildName = child.ChildName;
                contextItem.EquityTicker = child.ChildEqTicker;
                contextItem.CDSTicker = child.ChildCDSTicker;
                child.ContextMenuList = new ObservableCollection<ContextMenuItem>();
                child.ContextMenuList.Add(contextItem);

                if (child.ChildCDSTicker != null && child.ChildCDSTicker != "")
                {
                    ContextMenuItem contextItem2 = new ContextMenuItem();
                    contextItem2.Displayname = "Corp DES";
                    contextItem2.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                    contextItem2.Id = child.ID;
                    contextItem2.ChildName = child.ChildName;
                    contextItem2.EquityTicker = child.ChildEqTicker;
                    contextItem2.CDSTicker = child.ChildCDSTicker;
                    child.ContextMenuList.Add(contextItem2);
                }

                ContextMenuItem contextItem3 = new ContextMenuItem();
                contextItem3.Displayname = "ECCG";
                contextItem3.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem3.Id = child.ID;
                contextItem3.ChildName = child.ChildName;
                contextItem3.EquityTicker = child.ChildEqTicker;
                contextItem3.CDSTicker = child.ChildCDSTicker;
                child.ContextMenuList.Add(contextItem3);

                if (child.ChildCDSTicker != null && child.ChildCDSTicker != "")
                {
                    ContextMenuItem contextItem4 = new ContextMenuItem();
                    contextItem4.Displayname = "HS";
                    contextItem4.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                    contextItem4.Id = child.ID;
                    contextItem4.ChildName = child.ChildName;
                    contextItem4.EquityTicker = child.ChildEqTicker;
                    contextItem4.CDSTicker = child.ChildCDSTicker;
                    child.ContextMenuList.Add(contextItem4);
                }

                if (child.ChildCDSTicker != null && child.ChildCDSTicker != "")
                {
                    ContextMenuItem contextItem5 = new ContextMenuItem();
                    contextItem5.Displayname = "CDSW";
                    contextItem5.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                    contextItem5.Id = child.ID;
                    contextItem5.ChildName = child.ChildName;
                    contextItem5.EquityTicker = child.ChildEqTicker;
                    contextItem5.CDSTicker = child.ChildCDSTicker;
                    child.ContextMenuList.Add(contextItem5);
                }

                if (child.ChildCDSTicker != null && child.ChildCDSTicker != "")
                {
                    ContextMenuItem contextItem6 = new ContextMenuItem();
                    contextItem6.Displayname = "Corp GP";
                    contextItem6.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                    contextItem6.Id = child.ID;
                    contextItem6.ChildName = child.ChildName;
                    contextItem6.EquityTicker = child.ChildEqTicker;
                    contextItem6.CDSTicker = child.ChildCDSTicker;
                    child.ContextMenuList.Add(contextItem6);
                }

                ContextMenuItem contextItem7 = new ContextMenuItem();
                contextItem7.Displayname = "Equity Corp";
                contextItem7.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem7.Id = child.ID;
                contextItem7.ChildName = child.ChildName;
                contextItem7.EquityTicker = child.ChildEqTicker;
                contextItem7.CDSTicker = child.ChildCDSTicker;
                child.ContextMenuList.Add(contextItem7);

                ContextMenuItem contextItem8 = new ContextMenuItem();
                contextItem8.Displayname = "Equity GP";
                contextItem8.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem8.Id = child.ID;
                contextItem8.ChildName = child.ChildName;
                contextItem8.EquityTicker = child.ChildEqTicker;
                contextItem8.CDSTicker = child.ChildCDSTicker;
                child.ContextMenuList.Add(contextItem8);

                ContextMenuItem contextItem9 = new ContextMenuItem();
                contextItem9.Displayname = "CN";
                contextItem9.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem9.Id = child.ID;
                contextItem9.ChildName = child.ChildName;
                contextItem9.EquityTicker = child.ChildEqTicker;
                contextItem9.CDSTicker = child.ChildCDSTicker;
                child.ContextMenuList.Add(contextItem9);

                ContextMenuItem contextItem10 = new ContextMenuItem();
                contextItem10.Displayname = "RV";
                contextItem10.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem10.Id = child.ID;
                contextItem10.ChildName = child.ChildName;
                contextItem10.EquityTicker = child.ChildEqTicker;
                contextItem10.CDSTicker = child.ChildCDSTicker;
                child.ContextMenuList.Add(contextItem10);

                ContextMenuItem contextItem11 = new ContextMenuItem();
                contextItem11.Displayname = "CRPR";
                contextItem11.MyContextMenuCommand = new RelayCommand(ClickContextMenu, CanCreateContextMenu);
                contextItem11.Id = child.ID;
                contextItem11.ChildName = child.ChildName;
                contextItem11.EquityTicker = child.ChildEqTicker;
                contextItem11.CDSTicker = child.ChildCDSTicker;
                child.ContextMenuList.Add(contextItem11);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while addContextMenuToChild: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace addContextMenuToChild: " + stackTrace, "INFO");
            }
        }

        #region RetrieveCommandForContextMenuItem
        public bool CanCreateContextMenu(object obj)
        {
            if (DataCollectionTree.Count > 0)
                return true;
            return false;
        }
        public void ClickContextMenu(object obj)
        {
            MenuItemDataObject items = (MenuItemDataObject)obj;
            //MessageBox.Show(items.action + " " + items.childName);
            if (items.action == "Equity DES" && items.equityTicker != "")
                HeatMapView.runFunction("DES", items.equityTicker + " Equity");
            else if (items.action == "Corp DES" && items.cdsTicker != "")
                HeatMapView.runFunction("DES", items.cdsTicker + " Corp");
            else if (items.action == "ECCG" && items.equityTicker != "")
                HeatMapView.runFunction("ECCG", items.equityTicker + " Equity");
            else if (items.action == "HS" && items.equityTicker != "" && items.cdsTicker != "")
                HeatMapView.runFunction("HS", items.cdsTicker + " Corp " + items.equityTicker + " Equity");
            else if (items.action == "CDSW" && items.cdsTicker != "")
                HeatMapView.runFunction("CDSW", items.cdsTicker + " Corp");
            else if (items.action == "Corp GP" && items.cdsTicker != "")
                HeatMapView.runFunction("GP", items.cdsTicker + " Corp");
            else if (items.action == "Equity Corp" && items.equityTicker != "")
                HeatMapView.runFunction("Corp", items.equityTicker);
            else if (items.action == "Equity GP" && items.equityTicker != "")
                HeatMapView.runFunction("GP", items.equityTicker + " Equity");
            else if (items.action == "CN" && items.equityTicker != "")
                HeatMapView.runFunction("CN", items.equityTicker + " Equity");
            else if (items.action == "RV" && items.equityTicker != "")
                HeatMapView.runFunction("RV", items.equityTicker + " Equity");
            else if (items.action == "CRPR" && items.equityTicker != "")
                HeatMapView.runFunction("CRPR", items.equityTicker + " Equity");

        }
        #endregion

        public SolidColorBrush generateColorForCircle(double? value)
        {
            bool isNegativeGreen = getNegativeGreenColor(CircleColor);
            Color color = new Color();
            double interval = 0;
            double increase = 0;
            int section = 0;

            int numOfColor = 25;

            //byte colorCode = 0;
            if (value.HasValue)
            {

                if (value == 0d)
                {
                    color = Color.FromRgb(255, 255, 255);
                }
                else
                {
                    if (value > 0)
                        interval = Math.Abs(CircleDataMaximum);
                    else
                        interval = Math.Abs(CircleDataMinimum);

                    if (interval != 0)
                    {
                        //increase = (interval / 255);
                        increase = (interval / numOfColor);
                        section = Math.Abs((int)(value / increase));
                        //colorCode = (byte)(255 - section);

                        if (section < 0)
                            section = 0;
                        else if (section >= numOfColor)
                            section = numOfColor - 1;

                        if (isNegativeGreen)
                        {
                            if (value > 0)
                                color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                            else
                                color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                        }
                        else
                        {
                            if (value < 0)
                                color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                            else
                                color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                        }
                    }
                    else
                        color = Color.FromRgb(255, 255, 255);
                }
            }
            else//if null
            {
                color = Color.FromRgb(0, 0, 0);       //black
            }

            return new SolidColorBrush(color);
        }

        public SolidColorBrush generateColorForRectangle(double? value)
        {
            bool isNegativeGreen = getNegativeGreenColor(RectColor);
            Color color = new Color();
            double interval = 0;
            double increase = 0;
            int section = 0;
            //byte colorCode = 0;

            int numOfColor = 25;

            if (value.HasValue)
            {

                if (value == 0d)
                {
                    color = Color.FromRgb(255, 255, 255);
                }
                else
                {
                    if (value > 0)
                        interval = Math.Abs(RectangleDataMaximum);
                    else
                        interval = Math.Abs(RectangleDataMinimum);

                    if (interval != 0)
                    {
                        //increase = (interval / 255);
                        increase = (interval / numOfColor);
                        section = Math.Abs((int)(value / increase));
                        //colorCode = (byte)(255 - section);

                        if (section < 0)
                            section = 0;
                        else if (section >= numOfColor)
                            section = numOfColor - 1;

                        if (isNegativeGreen)
                        {
                            if (value > 0)
                                color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                            else
                                color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                        }
                        else
                        {
                            if (value < 0)
                                color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                            else
                                color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                        }
                    }
                    else
                        color = Color.FromRgb(255, 255, 255);
                }
            }
            else//if null
            {
                color = Color.FromRgb(0, 0, 0);     //black
            }
            return new SolidColorBrush(color);
        }

        #region GenerateColorByNormalDist
        public void fillListFromCollectionAndSetParams()
        {
            RectListNegative.Clear();
            RectListPositive.Clear();
            CircleListNegative.Clear();
            CircleListPositive.Clear();

            NormalDistribution nd = new NormalDistribution();

            foreach (DataGroup datagroup in DataCollectionTree)
            {
                foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                {
                    foreach (DataChild item in childgroup.DataChildCollection)
                    {
                        if (item.RectangleColor < 0)
                            RectListNegative.Add(item.RectangleColor ?? 0);
                        if (item.RectangleColor > 0)
                            RectListPositive.Add(item.RectangleColor ?? 0);

                        if (item.CircleColor < 0)
                            CircleListNegative.Add(item.CircleColor ?? 0);
                        if (item.CircleColor > 0)
                            CircleListPositive.Add(item.CircleColor ?? 0);

                        // begin yeni eklendi 15.08.2014
                        if (item.DonutChartColor < 0)
                            DonutChartListNegative.Add(item.DonutChartColor);
                        if (item.DonutChartColor > 0)
                            DonutChartListPositive.Add(item.DonutChartColor);
                        // end yeni eklendi 15.08.2014
                    }
                }
            }

            // begin yeni eklendi 15.08.2014
            DonutChartListNegative = DonutChartListNegative.OrderBy(numbers => numbers).ToList();
            DonutChartListPositive = DonutChartListPositive.OrderBy(numbers => numbers).ToList();

            minDonutChartListPositive = DonutChartListPositive.Count > 0 ? DonutChartListPositive.First() : 0;
            maxDonutChartListPositive = DonutChartListPositive.Count > 0 ? DonutChartListPositive.Last() : 0;
            minDonutChartListNegative = DonutChartListNegative.Count > 0 ? DonutChartListNegative.First() : 0;
            maxDonutChartListNegative = DonutChartListNegative.Count > 0 ? DonutChartListNegative.Last() : 0;
            // end yeni eklendi 15.08.2014

            RectListNegative = RectListNegative.OrderBy(numbers => numbers).ToList();
            RectListPositive = RectListPositive.OrderBy(numbers => numbers).ToList();
            CircleListNegative = CircleListNegative.OrderBy(numbers => numbers).ToList();
            CircleListPositive = CircleListPositive.OrderBy(numbers => numbers).ToList();

            minMainForRectPos = RectListPositive.Count > 0 ? RectListPositive.First() : 0;
            maxMainForRectPos = RectListPositive.Count > 0 ? RectListPositive.Last() : 0;
            minMainForRectNeg = RectListNegative.Count > 0 ? RectListNegative.First() : 0;
            maxMainForRectNeg = RectListNegative.Count > 0 ? RectListNegative.Last() : 0;

            minMainForCirclePos = CircleListPositive.Count > 0 ? CircleListPositive.First() : 0;
            maxMainForCirclePos = CircleListPositive.Count > 0 ? CircleListPositive.Last() : 0;
            minMainForCircleNeg = CircleListNegative.Count > 0 ? CircleListNegative.First() : 0;
            maxMainForCircleNeg = CircleListNegative.Count > 0 ? CircleListNegative.Last() : 0;

            minNormalDistForRectNeg = nd.getMinNormDistValue(RectListNegative);
            maxNormalDistForRectNeg = nd.getMaxNormDistValue(RectListNegative);
            if (maxNormalDistForRectNeg > 0)
                maxNormalDistForRectNeg = maxMainForRectNeg; //TODO negatif max
            minNormalDistForCircleNeg = nd.getMinNormDistValue(CircleListNegative);
            maxNormalDistForCircleNeg = nd.getMaxNormDistValue(CircleListNegative);
            if (maxNormalDistForCircleNeg > 0)
                maxNormalDistForCircleNeg = maxMainForCircleNeg;


            minNormalDistForRectPos = nd.getMinNormDistValue(RectListPositive);
            if (minNormalDistForRectPos < 0)
                minNormalDistForRectPos = minMainForRectPos; //TODO pozitif min
            maxNormalDistForRectPos = nd.getMaxNormDistValue(RectListPositive);
            minNormalDistForCirclePos = nd.getMinNormDistValue(CircleListPositive);
            if (minNormalDistForCirclePos < 0)
                minNormalDistForCirclePos = minMainForCirclePos;
            maxNormalDistForCirclePos = nd.getMaxNormDistValue(CircleListPositive);
        }

        public SolidColorBrush generateColorFromNormForRect(double? value)
        {
            int numOfColor = 25;

            bool isNegativeGreen = getNegativeGreenColor(RectColor);
            //double maxColorweight = (215 - ((215 * 16) / 100));
            //double minColorweight = (((215 * 16) / 100));
            double maxColorweight = (numOfColor - ((numOfColor * 16) / 100));
            double minColorweight = (((numOfColor * 16) / 100));

            Color color = new Color();
            double interval = 0;
            int section = 0;
            double intervalColor = 0;
            double? difference = 0;
            byte colorCode = 0;

            if (value.HasValue)
            {
                if (value == 0d)
                {
                    color = Color.FromRgb(255, 255, 255);
                }
                else if (value > 0)
                {
                    if (minNormalDistForRectPos == maxNormalDistForRectPos)
                    {
                        section = numOfColor - 1;
                    }
                    else if (value < minNormalDistForRectPos)
                    {
                        interval = (minNormalDistForRectPos - minMainForRectPos);

                        if (interval == 0)
                        {
                            section = 0;
                        }
                        else
                        {
                            //intervalColor = (215 - maxColorweight) / interval;
                            intervalColor = (numOfColor - maxColorweight) / interval;
                            difference = value - minMainForRectPos;
                            section = (int)(difference * intervalColor);

                            //colorCode = (byte)(215 - section);
                        }
                    }
                    else if (value >= minNormalDistForRectPos && value <= maxNormalDistForRectPos)
                    {
                        interval = (maxNormalDistForRectPos - minNormalDistForRectPos);
                        intervalColor = (maxColorweight - minColorweight) / interval;
                        difference = value - minNormalDistForRectPos;
                        section = (int)(difference * intervalColor);
                        //colorCode = (byte)(maxColorweight - section);

                        section += (int)minColorweight;
                    }
                    else if (value > maxNormalDistForRectPos)
                    {
                        interval = (maxMainForRectPos - maxNormalDistForRectPos);

                        if (interval == 0)
                        {
                            section = numOfColor - 1;
                        }
                        else
                        {
                            intervalColor = (minColorweight - 0) / interval;
                            difference = value - maxNormalDistForRectPos;
                            section = (int)(difference * intervalColor);
                            //colorCode = (byte)(minColorweight - section);

                            section += (int)maxColorweight;
                        }
                    }

                    if (section < 0)
                        section = 0;
                    else if (section >= numOfColor)
                        section = numOfColor - 1;

                    if (isNegativeGreen)
                        color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                    else
                        color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                }

                else if (value < 0)
                {
                    if (minNormalDistForRectNeg == maxNormalDistForRectNeg)
                    {
                        section = numOfColor - 1;
                    }
                    else if (value < minNormalDistForRectNeg)
                    {
                        interval = Math.Abs(Math.Abs(minNormalDistForRectNeg) - Math.Abs(minMainForRectNeg));

                        if (interval == 0)
                        {
                            section = numOfColor - 1;
                        }
                        else
                        {
                            //intervalColor = (215 - maxColorweight) / interval;
                            intervalColor = (numOfColor - maxColorweight) / interval;
                            difference = Math.Abs(Math.Abs(value ?? 0) - Math.Abs(minNormalDistForRectNeg));
                            section = (int)(difference * intervalColor);
                            colorCode = (byte)(minColorweight - section);

                            section += (int)maxColorweight;
                        }

                    }
                    else if (value >= minNormalDistForRectNeg && value <= maxNormalDistForRectNeg)
                    {
                        interval = Math.Abs((Math.Abs(maxNormalDistForRectNeg) - Math.Abs(minNormalDistForRectNeg)));
                        intervalColor = (maxColorweight - minColorweight) / interval;
                        difference = Math.Abs(Math.Abs(value ?? 0) - Math.Abs(maxNormalDistForRectNeg));
                        section = (int)(difference * intervalColor);
                        colorCode = (byte)(maxColorweight - section);

                        section += (int)minColorweight;
                    }
                    else if (value > maxNormalDistForRectNeg)
                    {
                        interval = Math.Abs((Math.Abs(maxMainForRectNeg) - Math.Abs(maxNormalDistForRectNeg)));

                        if (interval == 0)
                        {
                            section = 0;
                        }
                        else
                        {
                            intervalColor = (minColorweight - 0) / interval;
                            difference = Math.Abs(Math.Abs(value ?? 0) - Math.Abs(maxMainForRectNeg));
                            section = (int)(difference * intervalColor);
                            //colorCode = (byte)(215 - section);
                        }
                    }

                    if (section < 0)
                        section = 0;
                    else if (section >= numOfColor)
                        section = numOfColor - 1;

                    if (isNegativeGreen)
                        color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                    else
                        color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                }
            }

            else//if null
            {
                color = Color.FromRgb(0, 0, 0);     //black
            }

            return new SolidColorBrush(color);

        }

        public SolidColorBrush generateColorFromNormForCircle(double? value)
        {
            int numOfColor = 25;
            bool isNegativeGreen = getNegativeGreenColor(CircleColor);
            //double maxColorweight = (215 - ((215 * 16) / 100));
            //double minColorweight = (((215 * 16) / 100));
            double maxColorweight = (numOfColor - ((numOfColor * 16) / 100));
            double minColorweight = (((numOfColor * 16) / 100));

            Color color = new Color();
            double interval = 0;
            //double? section = 0;
            int section = 0;
            double intervalColor = 0;
            double? difference = 0;
            //byte colorCode = 0;

            if (value.HasValue)
            {
                if (value == 0d)
                {
                    color = Color.FromRgb(255, 255, 255);
                }
                else if (value > 0)
                {
                    if (minNormalDistForCirclePos == maxNormalDistForCirclePos)
                    {
                        section = numOfColor - 1;
                    }
                    else if (value < minNormalDistForCirclePos)
                    {
                        interval = (minNormalDistForCirclePos - minMainForCirclePos);

                        if (interval == 0)
                        {
                            section = 0;
                        }
                        else
                        {
                            //intervalColor = (215 - maxColorweight) / interval;
                            intervalColor = (numOfColor - maxColorweight) / interval;
                            difference = value - minMainForCirclePos;
                            section = (int)(difference * intervalColor);
                            //colorCode = (byte)(215 - section);
                        }
                    }
                    else if (value >= minNormalDistForCirclePos && value <= maxNormalDistForCirclePos)
                    {
                        interval = (maxNormalDistForCirclePos - minNormalDistForCirclePos);
                        intervalColor = (maxColorweight - minColorweight) / interval;
                        difference = value - minNormalDistForCirclePos;
                        section = (int)(difference * intervalColor);

                        section += (int)minColorweight;
                        //colorCode = (byte)(maxColorweight - section);
                    }
                    else if (value > maxNormalDistForCirclePos)
                    {
                        interval = (maxMainForCirclePos - maxNormalDistForCirclePos);

                        if (interval == 0)
                        {
                            section = numOfColor - 1;
                        }
                        else
                        {
                            intervalColor = (minColorweight - 0) / interval;
                            difference = value - maxNormalDistForCirclePos;
                            section = (int)(difference * intervalColor);

                            section += (int)maxColorweight;
                            //colorCode = (byte)(minColorweight - section);
                        }
                    }

                    if (section < 0)
                        section = 0;
                    else if (section >= numOfColor)
                        section = numOfColor - 1;


                    if (isNegativeGreen)
                        color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                    else
                        color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                }


                else if (value < 0)
                {
                    if (minNormalDistForCircleNeg == maxNormalDistForCircleNeg)
                    {
                        section = numOfColor - 1;
                    }
                    else if (value < minNormalDistForCircleNeg)
                    {
                        interval = Math.Abs(Math.Abs(minNormalDistForCircleNeg) - Math.Abs(minMainForCircleNeg));

                        if (interval == 0)
                        {
                            section = numOfColor - 1;
                        }
                        else
                        {
                            //intervalColor = (215 - maxColorweight) / interval;
                            intervalColor = (numOfColor - maxColorweight) / interval;
                            difference = Math.Abs(Math.Abs(value ?? 0) - Math.Abs(minNormalDistForCircleNeg));
                            section = (int)(difference * intervalColor);

                            section += (int)maxColorweight;
                            //colorCode = (byte)(minColorweight - section);
                        }

                    }
                    else if (value >= minNormalDistForCircleNeg && value <= maxNormalDistForCircleNeg)
                    {
                        interval = Math.Abs((Math.Abs(maxNormalDistForCircleNeg) - Math.Abs(minNormalDistForCircleNeg)));
                        intervalColor = (maxColorweight - minColorweight) / interval;
                        difference = Math.Abs(Math.Abs(value ?? 0) - Math.Abs(maxNormalDistForCircleNeg));
                        section = (int)(difference * intervalColor);

                        section += (int)minColorweight;
                        //colorCode = (byte)(maxColorweight - section);
                    }
                    else if (value > maxNormalDistForCircleNeg)
                    {
                        interval = Math.Abs((Math.Abs(maxMainForCircleNeg) - Math.Abs(maxNormalDistForCircleNeg)));

                        if (interval == 0)
                        {
                            section = 0;
                        }
                        else
                        {
                            intervalColor = (minColorweight - 0) / interval;
                            difference = Math.Abs(Math.Abs(value ?? 0) - Math.Abs(maxMainForCircleNeg));
                            section = (int)(difference * intervalColor);
                            //colorCode = (byte)(215 - section);
                        }
                    }

                    if (section < 0)
                        section = 0;
                    else if (section >= numOfColor)
                        section = numOfColor - 1;

                    if (isNegativeGreen)
                        color = Color.FromRgb((byte)ConstantItemList.RedColorValues[section, 0], (byte)ConstantItemList.RedColorValues[section, 1], (byte)ConstantItemList.RedColorValues[section, 2]);
                    else
                        color = Color.FromRgb((byte)ConstantItemList.GreenColorValues[section, 0], (byte)ConstantItemList.GreenColorValues[section, 1], (byte)ConstantItemList.GreenColorValues[section, 2]);
                }

            }

            else//if null
            {
                color = Color.FromRgb(0, 0, 0); //black
            }

            return new SolidColorBrush(color);

        }
        #endregion

        public void setParameters()
        {
            try
            {
                double? circleMin = 0d;
                double? circleMax = 0d;

                double? rectangleMin = 0d;
                double? rectangleMax = 0d;

                bool isCircleInitialized = false;
                bool isRectInitialized = false;

                foreach (DataGroup datagroup in DataCollectionTree)
                {
                    foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                    {
                        foreach (DataChild item in childgroup.DataChildCollection)
                        {
                            if (!isCircleInitialized)
                            {
                                if (item.CircleColor.HasValue)
                                {
                                    circleMin = item.CircleColor;
                                    circleMax = item.CircleColor;
                                    isCircleInitialized = true;
                                }
                            }
                            else
                            {
                                if (item.CircleColor.HasValue)
                                {
                                    if (circleMin > item.CircleColor)
                                        circleMin = item.CircleColor;
                                    if (circleMax < item.CircleColor)
                                        circleMax = item.CircleColor;
                                }
                            }

                            if (!isRectInitialized)
                            {
                                if (item.RectangleColor.HasValue)
                                {
                                    rectangleMin = item.RectangleColor;
                                    rectangleMax = item.RectangleColor;
                                    isRectInitialized = true;
                                }
                            }
                            else
                            {
                                if (item.RectangleColor.HasValue)
                                {
                                    if (rectangleMin > item.RectangleColor)
                                        rectangleMin = item.RectangleColor;
                                    if (rectangleMax < item.RectangleColor)
                                        rectangleMax = item.RectangleColor;
                                }
                            }
                        }
                    }
                }

                CircleDataMinimum = (circleMin ?? 0d);
                CircleDataMaximum = (circleMax ?? 0d);
                RectangleDataMinimum = (rectangleMin ?? 0d);
                RectangleDataMaximum = (rectangleMax ?? 0d);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while setParameters: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace setParameters: " + stackTrace, "INFO");
            }
        }

        public void DrawHeatMap()
        {
            unsubscribeAll();

            mainThreadDispatcher.BeginInvoke((Action)delegate
            {
                try
                {
                    Trace.WriteLine("DrawHeatMap is called", "TRACE");

                    resetHeatMapCollection();

                    createChildList();
                    updateChildListRectangleSize();
                    createChildGroupList();
                    createDataGroupCollection();

                    setParameters();

                    fillListFromCollectionAndSetParams();
                    finalizeHeatMapCollection();

                    fillTickerNameList();

                    lastDrawTime = DateTime.Now;
                    lastUpdateTime = DateTime.Now;
                    LastUpdate.LastUpdateTime = DateTime.Now.ToLongTimeString();

                    createCDSHeatMapDetails();

                    subscribeAll();

                    Trace.WriteLine("DrawHeatMap is completed", "TRACE");
                }
                catch (Exception eDispatcher)
                {
                    Trace.WriteLine("Exception while mainThreadDispatcher process DrawHeatMap: " + eDispatcher.Message.ToString(), "INFO");
                    string stackTraceDispatcher = "";
                    if (eDispatcher.StackTrace != null)
                        stackTraceDispatcher = eDispatcher.StackTrace.ToString();

                    Trace.WriteLine("Exception Stacktrace: " + stackTraceDispatcher, "INFO");
                }
            });
        }

        public void createCDSHeatMapDetails()
        {
            try
            {
                TickerDetailsCollection.Clear();
                TickerDetailsNameCollection.Clear();
                var resultSet = getCDSHeatMapDataDisplay();

                if (resultSet.Keys.Count < 1)
                    return;

                TickerDetailsName nameItem = new TickerDetailsName();
                nameItem.detailsName = resultSet.Keys.First().ToString();
                TickerDetailsNameCollection.Add(nameItem);

                foreach (var item in resultSet.Values.First())
                {
                    TickerDetailsCollection.Add(item);
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while createCDSHeatMapDetails: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace createCDSHeatMapDetails: " + stackTrace, "INFO");
            }
        }

        public Dictionary<string, ObservableCollection<TickerDetails>> getCDSHeatMapDataDisplay()
        {
            Dictionary<string, ObservableCollection<TickerDetails>> resultSet = new Dictionary<string, ObservableCollection<TickerDetails>>();
            ObservableCollection<TickerDetails> detailList = new ObservableCollection<TickerDetails>();
            string keyName;

            keyName = HeatMapGroup.CDSIndexLongName;

            foreach (var data in SelDataDisplayMin)
            {
                TickerDetails detail = new TickerDetails();
                detail.dataField = data.Key;
                detail.min = (data.Value ?? 0.0);
                if (data.Key != "" && SelDataDisplayMax.ContainsKey(data.Key))
                    detail.max = (SelDataDisplayMax[data.Key] ?? 0.0);
                if (data.Key != "" && SelDataDisplayAvg.ContainsKey(data.Key))
                    detail.avg = (SelDataDisplayAvg[data.Key] ?? 0.0);

                detailList.Add(detail);
            }

            resultSet.Add(keyName, detailList);

            return resultSet;
        }

        public void resetHeatMapCollection()
        {
            try
            {
                TotalRectangleSize = 0.0;
                MinRectangleSize = null;

                HeatMapHash.Clear();
                HeatMapMemberHash.Clear();
                HeatMapEquityTickerHash.Clear();
                tickerNameList.Clear();

                foreach (var child in childList)
                {
                    child.Dispose();
                }

                foreach (var childGroup in childGroupList)
                {
                    childGroup.Dispose();
                }

                foreach (var dataGroup in DataCollectionTree)
                {
                    dataGroup.Dispose();
                }
            }
            catch (Exception e)
            {
                Trace.Write("resetHeatMapCollection failed to clear collections (7004): " + e.Message, "WARNING");

                string stackTrace = "";
                if (e.StackTrace != null)
                    stackTrace = e.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace (7004): " + stackTrace, "INFO");
            }

            childList.Clear();
            childGroupList.Clear();
            DataCollectionTree.Clear();
        }

        public void setMinRectSizePCT(int size)
        {
            MIN_RECT_SIZE_PCT = size;
            //return;

            if (childList.Count < 100)
                MIN_RECT_SIZE_PCT = 250;
            else if (childList.Count <= 150)
                MIN_RECT_SIZE_PCT = 400;
            else if (childList.Count <= 300)
                MIN_RECT_SIZE_PCT = (childList.Count * 2);
            else
                MIN_RECT_SIZE_PCT = (int)(childList.Count * 1.5);

        }

        public void updateChildListRectangleSize()
        {
            try
            {
                setMinRectSizePCT(DEFAULT_RECTSIZEPCT);

                DataFormatter formatter = new DataFormatter();

                if (childList.Count <= 0)
                    return;

                double rectSizeMin = (MinRectangleSize ?? 1.0);
                double totalRectSize = (TotalRectangleSize ?? 1.0);

                if (totalRectSize == 0)
                    totalRectSize = 1;

                if (RectSize == ConstantItemList.EQUAL_SIZE || TotalRectangleSize == 0.0)
                {
                    foreach (DataChild child in childList)
                    {
                        child.RectangleSize = 1;
                    }
                    return;
                }

                double newTotalRectSize = 0.0;

                //initialize null rectangle's size with min rectangle size
                foreach (DataChild child in childList)
                {
                    if (!child.ActualRectangleSize.HasValue || child.ActualRectangleSize == 0.0)
                    {
                        child.RectangleSize = rectSizeMin;
                    }
                    else if (child.ActualRectangleSize < 0.0)
                    {
                        //dev #551, ticker has negative value to determine rectangle size
                        child.RectangleSize = rectSizeMin;
                    }
                    else
                    {
                        child.RectangleSize = (child.ActualRectangleSize ?? rectSizeMin);
                    }

                    newTotalRectSize += child.RectangleSize;
                }

                //optimize all rectangle sizes, so first calculated total rectangle size will not change
                double oldTotal2newTotal = totalRectSize / newTotalRectSize;

                if (oldTotal2newTotal != 1.0)
                {
                    foreach (DataChild child in childList)
                    {
                        child.RectangleSize *= oldTotal2newTotal;
                    }
                }

                if (MIN_RECT_SIZE_PCT <= childList.Count)
                    MIN_RECT_SIZE_PCT = DEFAULT_RECTSIZEPCT;

                double optimizedRectSize = totalRectSize / MIN_RECT_SIZE_PCT;

                childList = childList.OrderBy(dc => dc.RectangleSize).ToList();

                if (childList[0].RectangleSize >= optimizedRectSize)
                {
                    childList = childList.OrderByDescending(dc => dc.RectangleSize).ToList();
                    return;
                }

                bool isOptimized = false;

                if (HeatMapView.isRectSizeAlg1Checked)
                {
                    //Real rectangle size algorithm
                    while (!isOptimized)
                    {
                        newTotalRectSize = 0.0;

                        foreach (DataChild child in childList)
                        {
                            if (child.RectangleSize < optimizedRectSize)
                            {
                                child.RectangleSize = optimizedRectSize;
                            }

                            newTotalRectSize += child.RectangleSize;
                        }

                        oldTotal2newTotal = totalRectSize / newTotalRectSize;

                        if (oldTotal2newTotal != 1.0)
                        {
                            foreach (DataChild child in childList)
                            {
                                child.RectangleSize *= oldTotal2newTotal;
                            }
                        }

                        //if (childList[0].RectangleSize >= optimizedRectSize)
                        {
                            isOptimized = true;
                        }
                    }
                }
                else
                {
                    //Normalized rectangle size algorithm
                    double diffTermVSmin = 0.0;
                    Dictionary<double, double> termDiffVec = new Dictionary<double, double>();

                    double maxBound = 1.0;
                    double minBound = 0.0;
                    double term;  //starting point

                    while (!isOptimized)
                    {
                        term = (maxBound + minBound) / 2;

                        newTotalRectSize = 0.0;
                        foreach (DataChild child in childList)
                        {
                            newTotalRectSize += Math.Pow(child.RectangleSize, term);
                        }

                        oldTotal2newTotal = totalRectSize / newTotalRectSize;

                        double minOptimized = Math.Pow(childList[0].RectangleSize, term) * oldTotal2newTotal;

                        diffTermVSmin = minOptimized - optimizedRectSize;
                        termDiffVec.Add(term, diffTermVSmin);

                        if (diffTermVSmin == 0)
                        {
                            isOptimized = true;

                            foreach (DataChild child in childList)
                            {
                                child.RectangleSize = Math.Pow(child.RectangleSize, term);
                                newTotalRectSize += child.RectangleSize;
                            }

                            oldTotal2newTotal = totalRectSize / newTotalRectSize;
                            foreach (DataChild child in childList)
                            {
                                child.RectangleSize *= oldTotal2newTotal;
                            }
                        }
                        else if ((maxBound - minBound) < MIN_RECT_SIZE_TERM)
                        {
                            double maxTerm = 0.0;

                            foreach (var keyValues in termDiffVec)
                            {
                                if (keyValues.Value > 0 && maxTerm < keyValues.Key)
                                {
                                    maxTerm = keyValues.Key;
                                }
                            }

                            if (maxTerm != 0.0)
                            {
                                foreach (DataChild child in childList)
                                {
                                    child.RectangleSize = Math.Pow(child.RectangleSize, maxTerm);
                                    newTotalRectSize += child.RectangleSize;
                                }

                                oldTotal2newTotal = totalRectSize / newTotalRectSize;
                                foreach (DataChild child in childList)
                                {
                                    child.RectangleSize *= oldTotal2newTotal;
                                }
                            }
                            else
                            {
                                foreach (DataChild child in childList)
                                {
                                    child.RectangleSize = Math.Pow(child.RectangleSize, term);
                                    newTotalRectSize += child.RectangleSize;
                                }

                                oldTotal2newTotal = totalRectSize / newTotalRectSize;
                                foreach (DataChild child in childList)
                                {
                                    child.RectangleSize *= oldTotal2newTotal;
                                }
                            }

                            isOptimized = true;
                        }
                        else if (diffTermVSmin > 0)
                        {
                            minBound = term;
                        }
                        else
                        {
                            maxBound = term;
                        }
                    }

                    childList = childList.OrderByDescending(dc => dc.RectangleSize).ToList();
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while updateChildListRectangleSize: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updateChildListRectangleSize: " + stackTrace, "INFO");
            }
        }

        public void finalizeHeatMapCollection()
        {
            try
            {
                foreach (DataGroup datagroup in DataCollectionTree)
                {
                    foreach (DataChildGroup childgroup in datagroup.DataChildGroupCollection)
                    {
                        foreach (DataChild item in childgroup.DataChildCollection)
                        {
                            /*item.CircleFillingColor = generateColorForCircle(item.CircleColor);
                            item.RectangleFillingColor = generateColorForRectangle(item.RectangleColor);*/

                            if (HeatMapView.isHideTickerChecked)
                                item.TickerName = "";
                            else
                                item.TickerName = item.ChildEqTicker;

                            if (HeatMapView.isNormalDistChecked)
                            {
                                if (CircleColor == ConstantItemList.NONE)
                                    item.CircleFillingColor = Brushes.Transparent;
                                else
                                    item.CircleFillingColor = generateColorFromNormForCircle(item.CircleColor);
                                item.RectangleFillingColor = generateColorFromNormForRect(item.RectangleColor);
                                item.ChildBorderBrush = item.RectangleFillingColor;
                            }
                            else
                            {
                                if (CircleColor == ConstantItemList.NONE)
                                    item.CircleFillingColor = Brushes.Transparent;
                                else
                                    item.CircleFillingColor = generateColorForCircle(item.CircleColor);
                                item.RectangleFillingColor = generateColorForRectangle(item.RectangleColor);
                                item.ChildBorderBrush = item.RectangleFillingColor;
                            }

                            item.LeftClickRect = new RelayCommand(ClickLeftChildRect, CanCreate);
                        }
                        childgroup.LeftClickRect = new RelayCommand(ClickLeftChildGroupRect, CanCreate);
                    }
                    datagroup.LeftClickRect = new RelayCommand(ClickLeftGroupRect, CanCreate);
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while finalizeHeatMapCollection: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace finalizeHeatMapCollection: " + stackTrace, "INFO");
            }

        }

        public void createChildList()
        {
            try
            {
                int id;

                bool isRectSizeInitialized = false;

                foreach (CDSIndexMember member in tickerFilter.TFCDSIndex.CDSIndexMemberList)
                {
                    if (member.IsCheckedTicker)
                    {
                        id = generateID();
                        childList.Add(new DataChild(id, member.CDSRefName, member.TickerEquity, member.TickerSpread, getRectSize(member), getRectColor(member), getCircleColor(member), getDonutColor(member), getRectLastPrice(member), getCircleLastPrice(member), getFirstBy(member), getThenBy(member), member.TickerSpreadList, "Ticker", RectSize, RectColor, CircleColor));
                        childList.Last().setToolTipData(member.LastPrice, member.CDSPrice, member.PricingSource, member.Currency);

                        childList.Last().setEqCDSChgTooltip(member.ChgPCT1D, member.ChgNET1D, member.getSpreadChgPCT1D(4), member.CDS5YChgNET1D);
                        //childList.Last().DisplayImage = "/CDSHeatMap;component/Image/TickerCircle_small.png";
                        childList.Last().DisplayImage = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/TickerCircle_small.png"));
                        if (childList.Last().DisplayImage.CanFreeze)
                            childList.Last().DisplayImage.Freeze();

                        addSelectionDataToChild(member, childList.Last());

                        HeatMapHash.Add(id, (DataChild)childList.Last());

                        if (member.CDSRefName != "" && !HeatMapMemberHash.ContainsKey(member.CDSRefName))
                            HeatMapMemberHash.Add(member.CDSRefName, id);

                        if (member.getTickerEquity() != "" && !HeatMapEquityTickerHash.ContainsKey(member.getTickerEquity()))
                            HeatMapEquityTickerHash.Add(member.getTickerEquity(), id);

                        if (childList.Last().ActualRectangleSize.HasValue && childList.Last().ActualRectangleSize > 0.0)
                            TotalRectangleSize += childList.Last().ActualRectangleSize;

                        if (!isRectSizeInitialized)
                        {
                            if (childList.Last().ActualRectangleSize.HasValue && childList.Last().ActualRectangleSize > 0.0)
                            {
                                MinRectangleSize = childList.Last().ActualRectangleSize;
                                isRectSizeInitialized = true;
                            }
                        }
                        else
                        {
                            if (childList.Last().ActualRectangleSize.HasValue && childList.Last().ActualRectangleSize > 0.0)
                            {
                                if (MinRectangleSize > childList.Last().ActualRectangleSize)
                                    MinRectangleSize = childList.Last().ActualRectangleSize;
                            }
                        }
                    }
                }

                foreach (CDSIndexMember member in tickerFilter.AddedTickerList)
                {
                    if (member.IsCheckedTicker)
                    {
                        id = generateID();
                        childList.Add(new DataChild(id, member.CDSRefName, member.TickerEquity, member.TickerSpread, getRectSize(member), getRectColor(member), getCircleColor(member), getDonutColor(member), getRectLastPrice(member), getCircleLastPrice(member), getFirstBy(member), getThenBy(member), member.TickerSpreadList, "Ticker", RectSize, RectColor, CircleColor));
                        childList.Last().setToolTipData(member.LastPrice, member.CDSPrice, member.PricingSource, member.Currency);

                        childList.Last().setEqCDSChgTooltip(member.ChgPCT1D, member.ChgNET1D, member.getSpreadChgPCT1D(4), member.CDS5YChgNET1D);
                        //childList.Last().DisplayImage = "/CDSHeatMap;component/Image/TickerCircle_small.png";
                        childList.Last().DisplayImage = new BitmapImage(new Uri(@"pack://application:,,,/CDSHeatMap;component/Image/TickerCircle_small.png"));
                        if (childList.Last().DisplayImage.CanFreeze)
                            childList.Last().DisplayImage.Freeze();

                        addSelectionDataToChild(member, childList.Last());

                        HeatMapHash.Add(id, (DataChild)childList.Last());

                        if (member.CDSRefName != "" && !HeatMapMemberHash.ContainsKey(member.CDSRefName))
                            HeatMapMemberHash.Add(member.CDSRefName, id);

                        if (member.getTickerEquity() != "" && !HeatMapEquityTickerHash.ContainsKey(member.getTickerEquity()))
                            HeatMapEquityTickerHash.Add(member.getTickerEquity(), id);

                        if (childList.Last().ActualRectangleSize.HasValue && childList.Last().ActualRectangleSize > 0.0)
                            TotalRectangleSize += childList.Last().ActualRectangleSize;

                        if (!isRectSizeInitialized)
                        {
                            if (childList.Last().ActualRectangleSize.HasValue && childList.Last().ActualRectangleSize > 0.0)
                            {
                                MinRectangleSize = childList.Last().ActualRectangleSize;
                                isRectSizeInitialized = true;
                            }
                        }
                        else
                        {
                            if (childList.Last().ActualRectangleSize.HasValue && childList.Last().ActualRectangleSize > 0.0)
                            {
                                if (MinRectangleSize > childList.Last().ActualRectangleSize)
                                    MinRectangleSize = childList.Last().ActualRectangleSize;
                            }
                        }
                    }
                }

                if (childList.Count <= 0)
                {
                    return;
                }

                int nextID = 0;
                string groupName = ConstantItemList.NOTAVAILABLE;

                if (FirstBy == ConstantItemList.SHORT_INTEREST_EF || FirstBy == ConstantItemList.CDS_SPREAD_5Y || FirstBy == ConstantItemList.YTD_5Y_CDS_SPREAD_CHG ||
                FirstBy == ConstantItemList.PE_RATIO || FirstBy == ConstantItemList.PRICE_SALES_RATIO || FirstBy == ConstantItemList.MARKET_CAPITAL ||
                FirstBy == ConstantItemList.YTD_EQUITY_CHG || FirstBy == ConstantItemList.EQUITY_BETA || FirstBy == ConstantItemList.EBITDA ||
                FirstBy == ConstantItemList.TOTAL_DEBT_COMMON_EQ || FirstBy == ConstantItemList.INTEREST_COVERAGE_RATIO || FirstBy == ConstantItemList.HIST_CALL_IMPL_VOL)
                {
                    string fxCcy = "";
                    if (FirstBy == ConstantItemList.CDS_SPREAD_5Y || FirstBy == ConstantItemList.MARKET_CAPITAL || FirstBy == ConstantItemList.EBITDA)
                        fxCcy = "$";

                    int numOfItem = childList.Count / ConstantItemList.MAXHEATMAPGROUP;

                    childList = childList.OrderByDescending(dc => (dc.MainGroupName != "") ? double.Parse(dc.MainGroupName) : float.MaxValue).ToList();

                    int countGroup = 0;

                    int i = 0;
                    while (true)
                    {
                        if (childList[i].MainGroupName == "")
                        {

                            childList[i].MainGroupName = "( " + countGroup.ToString() + " ) " + ConstantItemList.NOTAVAILABLE;
                            i++;
                            if (i == childList.Count) break;

                        }
                        else
                        {
                            numOfItem = (childList.Count - i + 1) / (ConstantItemList.MAXHEATMAPGROUP - 1);
                            break;
                        }
                    }

                    countGroup++;

                    for (nextID = i; i < childList.Count; ++i)
                    {
                        if (nextID == i)
                        {
                            nextID = i + numOfItem;
                            if (nextID >= childList.Count) nextID = childList.Count - 1;

                            for (int j = nextID + 1; j < childList.Count; ++j)
                            {
                                if (double.Parse(childList[nextID].MainGroupName) == double.Parse(childList[j].MainGroupName))
                                    nextID++;
                                else
                                    break;
                            }

                            double group1, group2;

                            bool groupParse1 = double.TryParse(childList[nextID].MainGroupName, out group1);
                            bool groupParse2 = double.TryParse(childList[i].MainGroupName, out group2);

                            if (groupParse1 && groupParse2)
                                groupName = String.Format("( " + countGroup.ToString() + " ) " + fxCcy + formatter.Convert(group1, null, null, null) + "-" + fxCcy +
                                                            formatter.Convert(group2, null, null, null));
                            else if (groupParse1)
                                groupName = String.Format("( " + countGroup.ToString() + " ) " + fxCcy + formatter.Convert(group1, null, null, null) + "-" + fxCcy +
                                                            formatter.Convert(childList[i].MainGroupName, null, null, null));
                            else if (groupParse2)
                                groupName = String.Format("( " + countGroup.ToString() + " ) " + fxCcy + formatter.Convert(childList[nextID].MainGroupName, null, null, null) + "-" + fxCcy +
                                                            formatter.Convert(group2, null, null, null));
                            else
                                groupName = String.Format("( " + countGroup.ToString() + " ) " + fxCcy + formatter.Convert(childList[nextID].MainGroupName, null, null, null) + "-" + fxCcy +
                                                            formatter.Convert(childList[i].MainGroupName, null, null, null));
                            countGroup++;
                        }
                        childList[i].MainGroupName = groupName;
                    }
                }

                if (ThenBy == ConstantItemList.SHORT_INTEREST_EF || ThenBy == ConstantItemList.CDS_SPREAD_5Y || ThenBy == ConstantItemList.YTD_5Y_CDS_SPREAD_CHG ||
                ThenBy == ConstantItemList.PE_RATIO || ThenBy == ConstantItemList.MARKET_CAPITAL || ThenBy == ConstantItemList.YTD_EQUITY_CHG ||
                ThenBy == ConstantItemList.PRICE_SALES_RATIO || ThenBy == ConstantItemList.EQUITY_BETA || ThenBy == ConstantItemList.EBITDA ||
                ThenBy == ConstantItemList.TOTAL_DEBT_COMMON_EQ || ThenBy == ConstantItemList.INTEREST_COVERAGE_RATIO || ThenBy == ConstantItemList.HIST_CALL_IMPL_VOL)
                {
                    string fxCcy = "";
                    if (ThenBy == ConstantItemList.CDS_SPREAD_5Y || ThenBy == ConstantItemList.MARKET_CAPITAL || ThenBy == ConstantItemList.EBITDA)
                        fxCcy = "$";

                    int numOfItem = childList.Count / ConstantItemList.MAXHEATMAPSUBGROUP;

                    childList = childList.OrderBy(dc => (dc.SubGroupName != "") ? double.Parse(dc.SubGroupName) : float.MinValue).ToList();

                    int i = 0;
                    while (true)
                    {
                        if (childList[i].SubGroupName == "")
                        {
                            childList[i].SubGroupName = ConstantItemList.NOTAVAILABLE;
                            i++;
                            if (i == childList.Count) break;
                        }
                        else
                        {
                            numOfItem = (childList.Count - i + 1) / (ConstantItemList.MAXHEATMAPSUBGROUP - 1);
                            break;
                        }
                    }


                    for (nextID = i; i < childList.Count; ++i)
                    {
                        if (nextID == i)
                        {
                            nextID = i + numOfItem;
                            if (nextID >= childList.Count) nextID = childList.Count - 1;

                            for (int j = nextID + 1; j < childList.Count; ++j)
                            {
                                if (double.Parse(childList[nextID].SubGroupName) == double.Parse(childList[j].SubGroupName))
                                    nextID++;
                                else
                                    break;
                            }

                            double group1, group2;

                            bool groupParse1 = double.TryParse(childList[i].SubGroupName, out group1);
                            bool groupParse2 = double.TryParse(childList[nextID].SubGroupName, out group2);

                            if (groupParse1 && groupParse2)
                                groupName = fxCcy + String.Format(formatter.Convert(group1, null, null, null) + "-" + fxCcy +
                                                            formatter.Convert(group2, null, null, null));
                            else if (groupParse1)
                                groupName = fxCcy + String.Format(formatter.Convert(group1, null, null, null) + "-" + fxCcy +
                                                            formatter.Convert(childList[nextID].SubGroupName, null, null, null));
                            else if (groupParse2)
                                groupName = String.Format(formatter.Convert(childList[i].SubGroupName, null, null, null) + "-" +
                                                            formatter.Convert(group2, null, null, null));
                            else
                                groupName = fxCcy + String.Format(formatter.Convert(group1, null, null, null) + "-" + fxCcy +
                                                            formatter.Convert(childList[nextID].SubGroupName, null, null, null));
                        }
                        childList[i].SubGroupName = groupName;
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while createChildList: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace createChildList: " + stackTrace, "INFO");
            }
        }

        public void addSelectionDataToChild(CDSIndexMember member, DataChild child)
        {
            try
            {
                child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[0], member.ChgPCTYTD);
                child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[1], member.getMidSpread(4));
                child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[2], member.getMidSpread(6));
                if (!member.getMidSpread(2).HasValue || !member.getMidSpread(4).HasValue || member.getMidSpread(4) == 0.0)
                    child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[3], null);
                else
                    child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[3], member.getMidSpread(2) / member.getMidSpread(4));

                if (!member.getMidSpread(4).HasValue || !member.getMidSpread(6).HasValue || member.getMidSpread(6) == 0.0)
                    child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[4], null);
                else
                    child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[4], member.getMidSpread(4) / member.getMidSpread(6));

                child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[5], member.PeRatio);
                child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[6], member.EqDividendeYield);
                child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[7], member.DebtOS == null ? null : member.DebtOS * 1000);
                child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[8], member.DebtToCommonEquity);

                if (!member.EnterpriseValue.HasValue || !member.EBITDA.HasValue || member.EBITDA == 0.0)
                    child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[9], null);
                else
                    child.SelectionDataDisplay.Add(ConstantItemList.SelDataDisplayList[9], member.EnterpriseValue / member.EBITDA);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while addSelectionDataToChild: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace addSelectionDataToChild: " + stackTrace, "INFO");
            }
        }

        public Dictionary<string, ObservableCollection<TickerDetails>> getSelectionDataDisplay(int id)
        {
            Dictionary<string, ObservableCollection<TickerDetails>> resultSet = new Dictionary<string, ObservableCollection<TickerDetails>>();
            ObservableCollection<TickerDetails> detailList = new ObservableCollection<TickerDetails>();
            string keyName;

            if (!HeatMapHash.ContainsKey(id))
                return resultSet;

            var item = HeatMapHash[id];

            if (item.GetType() == typeof(DataChild))
            {
                DataChild child = (DataChild)item;
                keyName = child.MainGroupName + " / " + child.SubGroupName + " / " + child.ChildEqTicker;

                foreach (var data in child.SelectionDataDisplay)
                {
                    TickerDetails detail = new TickerDetails();
                    detail.dataField = data.Key;
                    detail.avg = (data.Value ?? 0.0);
                    detailList.Add(detail);
                }

                resultSet.Add(keyName, detailList);
            }
            else if (item.GetType() == typeof(DataChildGroup))
            {
                DataChildGroup childGroup = (DataChildGroup)item;
                keyName = childGroup.ParentName + " / " + " / " + childGroup.ChildGroupName;

                foreach (var data in childGroup.SelDataDisplayMin)
                {
                    TickerDetails detail = new TickerDetails();
                    detail.dataField = data.Key;
                    detail.min = (data.Value ?? 0.0);
                    if (data.Key != "" && childGroup.SelDataDisplayMax.ContainsKey(data.Key))
                        detail.max = (childGroup.SelDataDisplayMax[data.Key] ?? 0.0);
                    if (data.Key != "" && childGroup.SelDataDisplayAvg.ContainsKey(data.Key))
                        detail.avg = (childGroup.SelDataDisplayAvg[data.Key] ?? 0.0);

                    detailList.Add(detail);
                }
                resultSet.Add(keyName, detailList);
            }
            else if (item.GetType() == typeof(DataGroup))
            {
                DataGroup group = (DataGroup)item;
                keyName = group.GroupName;

                foreach (var data in group.SelDataDisplayMin)
                {
                    TickerDetails detail = new TickerDetails();
                    detail.dataField = data.Key;
                    detail.min = (data.Value ?? 0.0);
                    if (data.Key != "" && group.SelDataDisplayMax.ContainsKey(data.Key))
                        detail.max = (group.SelDataDisplayMax[data.Key] ?? 0.0);
                    if (data.Key != "" && group.SelDataDisplayAvg.ContainsKey(data.Key))
                        detail.avg = (group.SelDataDisplayAvg[data.Key] ?? 0.0);

                    detailList.Add(detail);
                }
                resultSet.Add(keyName, detailList);
            }

            return resultSet;

        }

        public void createChildGroupList()
        {
            try
            {
                bool found = false;
                foreach (DataChild child in childList)
                {
                    addContextMenuToChild(child);//context menu eklendi

                    foreach (DataChildGroup childgroup in childGroupList)
                    {
                        if (childgroup.ParentName == child.MainGroupName &&
                            childgroup.ChildGroupName == child.SubGroupName)
                        {
                            childgroup.AddChild(child);
                            found = true;
                            break;
                        }
                    }
                    if (found == false)
                    {
                        int id = generateID();
                        childGroupList.Add(new DataChildGroup(id, child.SubGroupName, child.MainGroupName));
                        childGroupList.Last().AddChild(child);
                        HeatMapHash.Add(id, (DataChildGroup)childGroupList.Last());
                    }
                    found = false;
                }

                childGroupList = childGroupList.OrderByDescending(dc => dc.TotalChildRectangleSize).ToList();
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while createChildGroupList: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace createChildGroupList: " + stackTrace, "INFO");
            }
        }

        public void createDataGroupCollection()
        {
            try
            {
                resetCDSHeatMapDetailsContainer();
              
                if (DataCollectionTree != null && DataCollectionTree.Count > 0) DataCollectionTree.Clear();
            
                bool found = false;
                foreach (DataChildGroup childgroup in childGroupList)
                {
                    foreach (DataGroup datagroup in DataCollectionTree)
                    {
                        if (childgroup.ParentName == datagroup.GroupName)
                        {
                            try
                            {
                                found = true;
                                datagroup.AddChildGroup(childgroup);

                                break;
                            }
                            catch (Exception EX)
                            {
                                Trace.WriteLine("datagroup.AddChildGroup.Add failed ", "TRACE");

                                if (EX.StackTrace != null)
                                    Trace.WriteLine("datagroup.AddChildGroup.Add failed " + EX.Message + "\n" + EX.StackTrace, "TRACE");
                            }
                        }
                    }
                    if (found == false)
                    {
                        int id = generateID();

                        try
                        {
                            DataCollectionTree.Add(new DataGroup(id, childgroup.ParentName, childgroup));
                            //In DataGroup constructor this function is called
                            //DataCollectionTree.Last().AddChildGroup(childgroup);
                        }
                        catch (Exception EX)
                        {
                            Trace.WriteLine("DataCollectionTree.Add failed ", "TRACE");

                            if (EX.StackTrace != null)
                                Trace.WriteLine("DataCollectionTree.Add failed " + EX.Message + "\n" + EX.StackTrace, "TRACE");
                        }

                        HeatMapHash.Add(id, (DataGroup)DataCollectionTree.Last());                    
                    }
                    found = false;
                }

                foreach (var collectionGroup in DataCollectionTree)
                {
                    addCDSHeatMapDetailsItem(collectionGroup);
                }

                DataCollectionTree.Add(new DataGroup(0, ""));

            }
            catch (Exception e)
            {
                Trace.WriteLine("Failed to create DataCollectionTree (0): " + e.Message, "INFO");

                string stackTrace = "";
                if (e.StackTrace != null)
                    stackTrace = e.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace (0): " + stackTrace, "INFO");

                if (mainThreadDispatcher != null)
                {
                    mainThreadDispatcher.BeginInvoke((Action)delegate
                    {
                        string errMessage = "A problem is occurred in CDS Heatmap application while drawing HeatMap!!!";
                        try
                        {
                            Trace.WriteLine(string.Format("A problem is occurred in CDS Heatmap application - HeatMap create & draw!!!: {0}", e.Message.ToString()), "ERROR");

                            string stackTraceDisplay = "";
                            if (e.Message != null && e.StackTrace != null)
                                stackTraceDisplay = e.StackTrace.ToString();

                            Trace.WriteLine("Exception Stacktrace: " + stackTraceDisplay, "INFO");

                            var popup = new DisplayExceptionView(errMessage + "\n" + e.Message.ToString(), stackTraceDisplay);
                            PopupWindow.Instance.Title = "API Error";
                            PopupWindow.Instance.ShowWindow(popup);
                            PopupWindow.Instance.Width = 500;//Aysegul Albayrak,popup size
                            PopupWindow.Instance.Height = 600;
                        }
                        catch (Exception eDisplay)
                        {
                            Trace.WriteLine("Exception while displaying Bloomberg API Error (heatmap init view): " + errMessage + "\n" + eDisplay.Message, "ERROR");

                            string stackTraceDisplay = "";
                            if (eDisplay.StackTrace != null)
                                stackTraceDisplay = eDisplay.StackTrace.ToString();

                            Trace.WriteLine("Exception Stacktrace (1041): " + stackTraceDisplay, "INFO");
                        }
                    });
                }
            }
        }

        Dictionary<string, double?> SelDataDisplayMin;
        Dictionary<string, double?> SelDataDisplayAvg;
        Dictionary<string, double?> SelDataDisplayMax;
        Dictionary<string, double> SelDataChildCount;

        private void initializeCDSHeatMapDetailsContainer()
        {
            if (SelDataDisplayMin == null)
                SelDataDisplayMin = new Dictionary<string, double?>();
            else
                SelDataDisplayMin.Clear();

            if (SelDataDisplayAvg == null)
                SelDataDisplayAvg = new Dictionary<string, double?>();
            else
                SelDataDisplayAvg.Clear();

            if (SelDataDisplayMax == null)
                SelDataDisplayMax = new Dictionary<string, double?>();
            else
                SelDataDisplayMax.Clear();

            if (SelDataChildCount == null)
                SelDataChildCount = new Dictionary<string, double>();
            else
                SelDataChildCount.Clear();
        }

        private void resetCDSHeatMapDetailsContainer()
        {
            SelDataDisplayMin.Clear();
            SelDataDisplayAvg.Clear();
            SelDataDisplayMax.Clear();
            SelDataChildCount.Clear();
        }

        private void addCDSHeatMapDetailsItem(DataGroup child)
        {
            try
            {
                foreach (KeyValuePair<string, double?> key in child.SelDataDisplayMin)
                {
                    if (key.Key != "" && SelDataDisplayMin.ContainsKey((key.Key)))
                    {
                        if (SelDataDisplayMin[key.Key].HasValue && key.Value.HasValue)
                        {
                            if (SelDataDisplayMin[key.Key] > key.Value)
                            {
                                SelDataDisplayMin[key.Key] = key.Value;
                            }
                        }
                        else if (key.Value.HasValue)
                        {
                            SelDataDisplayMin[key.Key] = key.Value;
                        }
                    }
                    else
                    {
                        SelDataDisplayMin.Add(key.Key, key.Value);
                    }
                }

                foreach (KeyValuePair<string, double?> key in child.SelDataDisplayMax)
                {
                    if (key.Key != "" && SelDataDisplayMax.ContainsKey((key.Key)))
                    {
                        if (SelDataDisplayMax[key.Key].HasValue && key.Value.HasValue)
                        {
                            if (SelDataDisplayMax[key.Key] < key.Value)
                            {
                                SelDataDisplayMax[key.Key] = key.Value;
                            }
                        }
                        else if (key.Value.HasValue)
                        {
                            SelDataDisplayMax[key.Key] = key.Value;
                        }
                    }
                    else
                    {
                        SelDataDisplayMax.Add(key.Key, key.Value);
                    }
                }

                foreach (KeyValuePair<string, double?> key in child.SelDataDisplayAvg)
                {
                    if (key.Key != "" && SelDataDisplayAvg.ContainsKey((key.Key)))
                    {
                        if (key.Value.HasValue)
                        {
                            SelDataChildCount[key.Key] = SelDataChildCount[key.Key] + 1;
                            SelDataDisplayAvg[key.Key] = ((SelDataDisplayAvg[key.Key] * (SelDataChildCount[key.Key] - 1)) + key.Value) / SelDataChildCount[key.Key];
                        }
                    }
                    else
                    {
                        if (key.Value.HasValue)
                        {
                            SelDataChildCount.Add(key.Key, 1);
                            SelDataDisplayAvg.Add(key.Key, key.Value);
                        }
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while addCDSHeatMapDetailsItem: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace addCDSHeatMapDetailsItem: " + stackTrace, "INFO");
            }
        }

        public string getFirstBy(CDSIndexMember member)
        {
            if (FirstBy == ConstantItemList.INDUSTRY)
                return member.IndustryName;
            else if (FirstBy == ConstantItemList.MOODYSRATING)
            {
                foreach (var rating in ConstantItemList.MoodysRatingScale.Keys)
                {
                    if (!String.IsNullOrEmpty(member.MoodysRating) && !String.IsNullOrEmpty(rating.ToString()) && member.MoodysRating.Contains(rating.ToString()))
                        return ConstantItemList.MoodysRatingScale[rating.ToString()];
                }

                return ConstantItemList.MOODYSNAV;
            }
            else if (FirstBy == ConstantItemList.EXPECTED_EARNINGS_RD)
            {
                return GetFirstByExpectedReportDT(member.ExpectedReportDT);
            }
            else if (FirstBy == ConstantItemList.SHORT_INTEREST_EF)
            {
                return member.ShortInterest.ToString();
            }
            else if (FirstBy == ConstantItemList.CDS_SPREAD_5Y)
            {
                return (member.CDSPrice * member.FXRateCDS).ToString();
            }
            else if (FirstBy == ConstantItemList.YTD_5Y_CDS_SPREAD_CHG)
            {
                double? retFirstBy = member.getSpreadChgPCTYTD(4);
                if (retFirstBy == null)
                    return "";
                else
                    return retFirstBy.ToString();
            }
            else if (FirstBy == ConstantItemList.PE_RATIO)
            {
                return member.PeRatio.ToString();
            }
            else if (FirstBy == ConstantItemList.PRICE_SALES_RATIO)
            {
                return member.PriceToSalesRatio.ToString();
            }
            else if (FirstBy == ConstantItemList.MARKET_CAPITAL)
            {
                return (member.MarketCapital * member.FXRateEquity).ToString();
            }
            else if (FirstBy == ConstantItemList.YTD_EQUITY_CHG)
            {
                return member.ChgPCTYTD.ToString();
            }
            else if (FirstBy == ConstantItemList.EQUITY_BETA)
            {
                return member.EQBeta.ToString();
            }
            else if (FirstBy == ConstantItemList.EBITDA)
            {
                return (member.EBITDA * member.FXRateEquity).ToString();
            }
            else if (FirstBy == ConstantItemList.TOTAL_DEBT_COMMON_EQ)
            {
                return member.DebtToCommonEquity.ToString();
            }
            else if (FirstBy == ConstantItemList.INTEREST_COVERAGE_RATIO)
            {
                return member.InterestCoverageRatio.ToString();
            }
            else if (FirstBy == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return member.HistCallImplVol.ToString();
            }
            else if (FirstBy == ConstantItemList.NONE)
            {
                //return ConstantItemList.NONEHeader;
                return HeatMapGroup.CDSIndexLongName;
            }
            else
            {
                return HeatMapGroup.CDSIndexLongName;
                //return ConstantItemList.FirstNOTAVAILABLE;
            }
        }

        public string getThenBy(CDSIndexMember member)
        {
            if (ThenBy == ConstantItemList.MOODYSRATING)
            {
                foreach (var rating in ConstantItemList.MoodysRatingScale.Keys)
                {
                    if (!String.IsNullOrEmpty(member.MoodysRating) && !String.IsNullOrEmpty(rating.ToString()) && member.MoodysRating.Contains(rating.ToString()))
                        return ConstantItemList.MoodysRatingScale[rating.ToString()];
                }

                return ConstantItemList.MOODYSNAV;
            }
            else if (ThenBy == ConstantItemList.EXPECTED_EARNINGS_RD)
            {
                return GetThenByExpectedReportDT(member.ExpectedReportDT);
            }
            else if (ThenBy == ConstantItemList.SHORT_INTEREST_EF)
            {
                return member.ShortInterest.ToString();
            }
            else if (ThenBy == ConstantItemList.CDS_SPREAD_5Y)
            {
                return (member.CDSPrice * member.FXRateCDS).ToString();
            }
            else if (ThenBy == ConstantItemList.YTD_5Y_CDS_SPREAD_CHG)
            {
                double? retThenBy = member.getSpreadChgPCTYTD(4);

                if (retThenBy == null)
                    return "";
                else
                    return retThenBy.ToString();
            }
            else if (ThenBy == ConstantItemList.PE_RATIO)
            {
                return member.PeRatio.ToString();
            }
            else if (ThenBy == ConstantItemList.MARKET_CAPITAL)
            {
                return (member.MarketCapital * member.FXRateEquity).ToString();
            }
            else if (ThenBy == ConstantItemList.YTD_EQUITY_CHG)
            {
                return member.ChgPCTYTD.ToString();
            }
            else if (ThenBy == ConstantItemList.PRICE_SALES_RATIO)
            {
                return member.PriceToSalesRatio.ToString();
            }
            else if (ThenBy == ConstantItemList.EQUITY_BETA)
            {
                return member.EQBeta.ToString();
            }
            else if (ThenBy == ConstantItemList.EBITDA)
            {
                return (member.EBITDA * member.FXRateEquity).ToString();
            }
            else if (ThenBy == ConstantItemList.TOTAL_DEBT_COMMON_EQ)
            {
                return member.DebtToCommonEquity.ToString();
            }
            else if (ThenBy == ConstantItemList.INTEREST_COVERAGE_RATIO)
            {
                return member.InterestCoverageRatio.ToString();
            }
            else if (ThenBy == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return member.HistCallImplVol.ToString();
            }
            else if (ThenBy == ConstantItemList.NONE)
            {
                return ConstantItemList.NONEHeader;
            }
            else
                return ConstantItemList.NOTAVAILABLE;
        }

        public double? getRectSize(CDSIndexMember member)
        {
            if (RectSize == ConstantItemList.MARKET_CAPITAL)
                return member.MarketCapital * member.FXRateEquity;
            else if (RectSize == ConstantItemList.CDS_SPREAD_5Y)
                return member.CDSPrice * member.FXRateCDS;
            else if (RectSize == ConstantItemList.HIST_CALL_IMPL_VOL)
                return member.HistCallImplVol;
            else if (RectSize == ConstantItemList.TOTAL_DEBT)
                return member.TotalDebt * member.FXRateEquity;
            else if (RectSize == ConstantItemList.TOTAL_ASSETS)
                return member.TotalAssets * member.FXRateEquity;
            else if (RectSize == ConstantItemList.ENTERPRISE_VALUE)
                return member.EnterpriseValue * member.FXRateEquity;
            else if (RectSize == ConstantItemList.EQUAL_SIZE)
                return 1.0;
            else
                return null;
        }

        public double? getEquityChg(CDSIndexMember member, ShowChangeRateClass rateClass)
        {
            if (rateClass == ShowChangeRateClass.YTD)
                return member.ChgPCTYTD;
            else if (rateClass == ShowChangeRateClass.CLOSE)
                return member.ChgPCT1D;
            /*
        else if (rateClass == ShowChangeRateClass.WEEK52)
        {
            return member.ChgPCT52W;
        }
             */
            else
            {
                string ticker = member.getTickerEquity();
                if (ticker != "" && RectColorChgPCT.ContainsKey(ticker))
                    return RectColorChgPCT[ticker];
                else if (ticker != "" && CircleColorChgPCT.ContainsKey(ticker))
                    return CircleColorChgPCT[ticker];
                else
                    return null;
            }
        }

        public double? getEquityChgNet(CDSIndexMember member, ShowChangeRateClass rateClass)
        {
            if (rateClass == ShowChangeRateClass.YTD)
                return member.ChgNETYTD;
            else if (rateClass == ShowChangeRateClass.CLOSE)
                return member.ChgNET1D;
            /*
        else if (rateClass == ShowChangeRateClass.WEEK52)
        {
            return member.ChgNET52W;
        }
             */
            else
            {
                //TODO: calculate net change
                string ticker = member.getTickerEquity();
                if (ticker != "" && RectColorChgNET.ContainsKey(ticker))
                    return RectColorChgNET[ticker];
                else if (ticker != "" && CircleColorChgNET.ContainsKey(ticker))
                    return CircleColorChgNET[ticker];
                else
                    return null;
            }
        }

        public double? get5YCDSChg(CDSIndexMember member, ShowChangeRateClass rateClass)
        {
            if (rateClass == ShowChangeRateClass.YTD)
                return member.getSpreadChgPCTYTD(4);
            else if (rateClass == ShowChangeRateClass.CLOSE)
                return member.getSpreadChgPCT1D(4);
            else
            {
                string ticker = member.getTickerSpread(4, PricingSource);
                if (ticker != "" && CircleColorChgPCT.ContainsKey(ticker))
                    return CircleColorChgPCT[ticker];
                else if (ticker != "" && RectColorChgPCT.ContainsKey(ticker))
                    return RectColorChgPCT[ticker];
                else
                    return null;
            }
        }

        public double? get5YCDSChgNet(CDSIndexMember member, ShowChangeRateClass rateClass)
        {
            if (rateClass == ShowChangeRateClass.YTD)
                return member.CDS5YChgNETYTD;
            else if (rateClass == ShowChangeRateClass.CLOSE)
                return member.CDS5YChgNET1D;
            else
            {
                //TODO: calculate net change
                string ticker = member.getTickerSpread(4, PricingSource);
                if (ticker != "" && CircleColorChgNET.ContainsKey(ticker))
                    return CircleColorChgNET[ticker];
                else if (ticker != "" && RectColorChgNET.ContainsKey(ticker))
                    return RectColorChgNET[ticker];
                else
                    return null;
            }
        }

        public void updMemberLastPrice(CDSIndexMember member, string ticker, double? fieldValue)
        {
            try
            {
                if (RectColor == ConstantItemList.SHARE_PRICE_CHG || CircleColor == ConstantItemList.SHARE_PRICE_CHG ||
                    RectColor == ConstantItemList.CDS_PRICE_5Y_CHG || CircleColor == ConstantItemList.CDS_PRICE_5Y_CHG ||
                    RectColor == ConstantItemList.CDS_PRICE_1Y_CHG || CircleColor == ConstantItemList.CDS_PRICE_1Y_CHG ||
                    RectColor == ConstantItemList.CDS_PRICE_2Y_CHG || CircleColor == ConstantItemList.CDS_PRICE_2Y_CHG ||
                    RectColor == ConstantItemList.CDS_PRICE_10Y_CHG || CircleColor == ConstantItemList.CDS_PRICE_10Y_CHG)
                {
                    if (RateClass == ShowChangeRateClass.YTD)
                    {
                        if (ticker == member.getTickerEquity())
                            member.ChgPCTYTD = fieldValue;
                        else if (ticker == member.getTickerSpread(4, PricingSource))
                            member.setSpreadChgPCTYTD(4, fieldValue);
                        else if (ticker == member.getTickerSpread(0, PricingSource))
                            member.setSpreadChgPCTYTD(0, fieldValue);
                        else if (ticker == member.getTickerSpread(1, PricingSource))
                            member.setSpreadChgPCTYTD(1, fieldValue);
                        else if (ticker == member.getTickerSpread(6, PricingSource))
                            member.setSpreadChgPCTYTD(6, fieldValue);
                    }
                    else if (RateClass == ShowChangeRateClass.WEEK52
                        || (RateClass == ShowChangeRateClass.CUSTOM && EndDate.ToString("yyyyMMdd") == DateTime.Now.ToString("yyyyMMdd")))
                    {
                        if (ticker != "" && RectColorChgPCT.ContainsKey(ticker))
                            RectColorChgPCT[ticker] = fieldValue;
                        else if (ticker != "" && CircleColorChgPCT.ContainsKey(ticker))
                            CircleColorChgPCT[ticker] = fieldValue;
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while updMemberLastPrice: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updMemberLastPrice: " + stackTrace, "INFO");
            }
        }


        public double? getRectColor(CDSIndexMember member)
        {
            //public static List<string> RectColorList = new List<string> { SHARE_PRICE_CHG, CDS_PRICE_5Y_CHG, CDS_PRICE_1Y_CHG, CDS_PRICE_2Y_CHG, CDS_PRICE_10Y_CHG, VOLUME_CHG_5D_20D, SALES_1Y_GROWTH };
            //RateClass
            if (RectColor == ConstantItemList.SHARE_PRICE_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.ChgPCTYTD;
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.ChgPCT1D;
                /*
            else if (RateClass == ShowChangeRateClass.WEEK52)
                return member.ChgPCT52W;
                 */
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, RectColor);
                    if (ticker != "" && RectColorChgPCT.ContainsKey(ticker))
                        return RectColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (RectColor == ConstantItemList.CDS_PRICE_5Y_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.getSpreadChgPCTYTD(4);
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.getSpreadChgPCT1D(4);
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, RectColor);
                    if (ticker != "" && RectColorChgPCT.ContainsKey(ticker))
                        return RectColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (RectColor == ConstantItemList.CDS_PRICE_1Y_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.getSpreadChgPCTYTD(0);
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.getSpreadChgPCT1D(0);
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, RectColor);
                    if (ticker != "" && RectColorChgPCT.ContainsKey(ticker))
                        return RectColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (RectColor == ConstantItemList.CDS_PRICE_2Y_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.getSpreadChgPCTYTD(1);
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.getSpreadChgPCT1D(1);
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, RectColor);
                    if (ticker != "" && RectColorChgPCT.ContainsKey(ticker))
                        return RectColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (RectColor == ConstantItemList.CDS_PRICE_10Y_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.getSpreadChgPCTYTD(6);
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.getSpreadChgPCT1D(6);
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, RectColor);
                    if (ticker != "" && RectColorChgPCT.ContainsKey(ticker))
                        return RectColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (RectColor == ConstantItemList.VOLUME_CHG_5D_20D)
            {
                return member.VolumeChg5d20d;
            }
            else if (RectColor == ConstantItemList.SALES_1Y_GROWTH)
            {
                return member.SalesGrowth;
            }
            else if (RectColor == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return member.HistCallImplVol;
            }
            return null;
        }

        public double? getCircleColor(CDSIndexMember member)
        {
            //public static List<string> CircleColorList = new List<string> { CDS_PRICE_5Y_CHG, CDS_PRICE_1Y_CHG, CDS_PRICE_2Y_CHG, CDS_PRICE_10Y_CHG, SHARE_PRICE_CHG, VOLUME_CHG_5D_20D, SALES_1Y_GROWTH, NONE };
            if (CircleColor == ConstantItemList.CDS_PRICE_5Y_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.getSpreadChgPCTYTD(4);
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.getSpreadChgPCT1D(4);
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, CircleColor);
                    if (ticker != "" && CircleColorChgPCT.ContainsKey(ticker))
                        return CircleColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (CircleColor == ConstantItemList.CDS_PRICE_1Y_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.getSpreadChgPCTYTD(0);
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.getSpreadChgPCT1D(0);
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, CircleColor);
                    if (ticker != "" && CircleColorChgPCT.ContainsKey(ticker))
                        return CircleColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (CircleColor == ConstantItemList.CDS_PRICE_2Y_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.getSpreadChgPCTYTD(1);
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.getSpreadChgPCT1D(1);
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, CircleColor);
                    if (ticker != "" && CircleColorChgPCT.ContainsKey(ticker))
                        return CircleColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (CircleColor == ConstantItemList.CDS_PRICE_10Y_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.getSpreadChgPCTYTD(6);
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.getSpreadChgPCT1D(6);
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, CircleColor);
                    if (ticker != "" && CircleColorChgPCT.ContainsKey(ticker))
                        return CircleColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (CircleColor == ConstantItemList.SHARE_PRICE_CHG)
            {
                if (RateClass == ShowChangeRateClass.YTD)
                    return member.ChgPCTYTD;
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    return member.ChgPCT1D;
                /*
            else if (RateClass == ShowChangeRateClass.WEEK52)
                return member.ChgPCT52W;
                 */
                else if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    string ticker = getColorTicker(member, CircleColor);
                    if (ticker != "" && CircleColorChgPCT.ContainsKey(ticker))
                        return CircleColorChgPCT[ticker];
                    else
                        return null;
                }
            }
            else if (CircleColor == ConstantItemList.VOLUME_CHG_5D_20D)
            {
                return member.VolumeChg5d20d;
            }
            else if (CircleColor == ConstantItemList.SALES_1Y_GROWTH)
            {
                return member.SalesGrowth;
            }
            else if (CircleColor == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return member.HistCallImplVol;
            }

            return null;
        }

        public double getDonutColor(CDSIndexMember member)
        {
            if (DonutColor == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return member.HistCallImplVol ?? 0.0;
            }
            else if (DonutColor == ConstantItemList.VOL_MEAN)
            {
                return member.VolMean ?? 0.0;
            }
            else if (DonutColor == ConstantItemList.NONE)
                return 1.0;

            return 0.0;
        }

        public double? getRectLastPrice(CDSIndexMember member)
        {
            if (RectColor == ConstantItemList.SHARE_PRICE_CHG)
            {
                return member.LastPrice;
            }
            else if (RectColor == ConstantItemList.CDS_PRICE_5Y_CHG)
            {
                return member.getMidSpread(4);
            }
            else if (RectColor == ConstantItemList.CDS_PRICE_1Y_CHG)
            {
                return member.getMidSpread(0);
            }
            else if (RectColor == ConstantItemList.CDS_PRICE_2Y_CHG)
            {
                return member.getMidSpread(1);
            }
            else if (RectColor == ConstantItemList.CDS_PRICE_10Y_CHG)
            {
                return member.getMidSpread(6);
            }
            else if (RectColor == ConstantItemList.VOLUME_CHG_5D_20D)
            {
                return member.LastPrice;
            }
            else if (RectColor == ConstantItemList.SALES_1Y_GROWTH)
            {
                return member.LastPrice;
            }
            else if (RectColor == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return member.LastPrice;
            }
            return null;
        }

        public double? getCircleLastPrice(CDSIndexMember member)
        {
            if (CircleColor == ConstantItemList.CDS_PRICE_5Y_CHG)
            {
                return member.getMidSpread(4);
            }
            else if (CircleColor == ConstantItemList.CDS_PRICE_1Y_CHG)
            {
                return member.getMidSpread(0);
            }
            else if (CircleColor == ConstantItemList.CDS_PRICE_2Y_CHG)
            {
                return member.getMidSpread(1);
            }
            else if (CircleColor == ConstantItemList.CDS_PRICE_10Y_CHG)
            {
                return member.getMidSpread(6);
            }
            else if (CircleColor == ConstantItemList.SHARE_PRICE_CHG)
            {
                return member.LastPrice;
            }
            else if (CircleColor == ConstantItemList.VOLUME_CHG_5D_20D)
            {
                return member.LastPrice;
            }
            else if (CircleColor == ConstantItemList.SALES_1Y_GROWTH)
            {
                return member.LastPrice;
            }
            else if (CircleColor == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return member.LastPrice;
            }

            return null;
        }


        public void retrieveValuesForAddedTickers(List<string> EqFieldList)
        {
            try
            {
                cacheManager.getInitialAddedTickerList(tickerFilter.AddedTickerList, EqFieldList);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while retrieveValuesForAddedTickers: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace retrieveValuesForAddedTickers: " + stackTrace, "INFO");
            }
        }


        public void runHighlighter()
        {
            List<string> HighlighterFields = new List<string>();

        }

        public void showChange()
        {

        }

        public void createCDSGroupCollection()
        {
            try
            {
                var list = cacheManager.getTickerFilterList();

                if (list != null)
                {
                    for (int i = 0; i < list.Count; ++i)
                    {
                        CDSGroupCollection.Add(new CDSIndexBase(list[i], CDSIndexType.TICKERFILTER));
                    }
                }

                int firstcdx = CDSGroupCollection.Count();
                retrieveCDSIndexList();

                if (CDSGroupCollection.Count > firstcdx && CDSGroupCollection[firstcdx] != null)
                    HeatMapGroup = CDSGroupCollection[firstcdx];
                else if (CDSGroupCollection.Count > 0 && CDSGroupCollection.First() != null)
                    HeatMapGroup = CDSGroupCollection.First();

                if (HeatMapGroup == null)
                {
                    Trace.Write("HeatMapGroup is null !!!!", "INFO");
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while createCDSGroupCollection: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace createCDSGroupCollection: " + stackTrace, "INFO");
            }
        }

        public void retrieveCDSIndexList()
        {
            try
            {
                var cdsIndexList = cacheManager.getCDSIndexList();

                if (cdsIndexList == null)
                {
                    Trace.WriteLine("Failed to retrieve CDS Index List!", "ERROR");
                    return;
                }

                for (int i = 0; i < cdsIndexList.Count; ++i)
                {
                    this.CDSGroupCollection.Add(cdsIndexList[i]);
                }
                //check for new index, if exist add it to collection
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while retrieveCDSIndexList: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace retrieveCDSIndexList: " + stackTrace, "INFO");
            }
        }

        public void getBloombergInitialData()
        {
            try
            {
                List<string> EqFieldList = createHeatMapFieldList();

                if (HeatMapGroup.IndexType == CDSIndexType.EQUITY)
                {
                    tickerFilter.TFCDSIndex.setCDSIndexName(HeatMapGroup);
                    tickerFilter.TickerFilterName = HeatMapGroup.CDSIndexName;

                    cacheManager.getInitialCDSIndex(tickerFilter.TFCDSIndex, EqFieldList);
                }
                else if (HeatMapGroup.IndexType == CDSIndexType.SPREAD)
                {
                    tickerFilter.TFCDSIndex.setCDSIndexName(HeatMapGroup);
                    tickerFilter.TickerFilterName = HeatMapGroup.CDSIndexName;

                    cacheManager.getInitialCDSIndex(tickerFilter.TFCDSIndex, EqFieldList);

                }
                else if (HeatMapGroup.IndexType == CDSIndexType.TICKERFILTER)
                {
                    var tfItem = cacheManager.getTickerFilterItems(HeatMapGroup.CDSIndexName);
                    if (tfItem == null)
                        return;
                    else
                    {
                        tickerFilterItems = tfItem;
                    }

                    tickerFilter.reset();
                    tickerFilter.TickerFilterName = tfItem.TickerFilterName;

                    if (tickerFilterItems.PriceSource == null || tickerFilterItems.PriceSource == "")
                        tickerFilterItems.PriceSource = "Default";

                    tickerFilter.setPricingSource(tickerFilterItems.PriceSource);
                    PricingSource = DataManager.PricingSource = tickerFilterItems.PriceSource;

                    if (tickerFilterItems.CDSIndexName != "")
                    {   //TODO: check if CDSIndexName is null empty
                        //TODO: apply filter dynamically
                        //compare filteredintickerlist, custom CDS index

                        var tickerCdsIndexBase = cacheManager.getCDSIndexBase(tickerFilterItems.CDSIndexName);

                        if (tickerCdsIndexBase == null)
                        {
                            //TODO: cds index not found

                            tickerCdsIndexBase = new CDSIndexBase(tickerFilterItems.CDSIndexName, CDSIndexType.UNKNOWN);
                        }

                        cacheManager.initTickerFilter(tickerFilter, tickerCdsIndexBase, tickerFilterItems);

                        if (tickerFilter.addcoherentCustomTickers(tickerFilterItems))
                        {
                            cacheManager.saveTickerFilterItems(tickerFilterItems);
                        }

                        cacheManager.getInitialTickerFilterData(tickerFilter, EqFieldList);

                        tickerFilter.checkAllTickers(tickerFilterItems);

                        if (tickerFilterItems.applyFilterDync)
                        {
                            applyTickerFilter();
                        }
                    }
                    else
                    {
                        tickerFilter.setPricingSource(tickerFilterItems.PriceSource);
                        tickerFilter.addTickersToList(tickerFilterItems.addedTickerList, tickerFilterItems.addedTickerDescriptionList);
                        cacheManager.getInitialAddedTickerList(tickerFilter.AddedTickerList, EqFieldList);
                        tickerFilter.checkAllTickers(tickerFilterItems);
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while getBloombergInitialData: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace getBloombergInitialData: " + stackTrace, "INFO");
            }
        }

        public void applyTickerFilter()
        {
            try
            {
                //same as updloadTickerFilter in TickerFilterViewModel

                comparemergelists(tickerFilterItems.Industries, tickerFilterItems.IndustriesChecked, cacheManager.CDSIndexIndustryList);
                comparemergelists(tickerFilterItems.Ratings, tickerFilterItems.RatingsChecked, cacheManager.CDSIndexRatingsList);

                //tickerFilterItems.filteredinTickerList.Clear();
                //tickerFilterItems.filteredoutTickerList.Clear();

                List<string> QuickFilteredoutList = createQuickFilteredTickerList();

                foreach (CDSIndexMember member in tickerFilter.getAllCDSMembers())
                {
                    bool falseTicker = true;
                    string tickerName = member.TickerEquity;

                    if (tickerName != "" && tickerFilterItems.addedTickerList.Contains(tickerName))
                    {
                        if (tickerName != "" && tickerFilterItems.unselectedTickerList.Contains(tickerName))
                        {
                            member.IsCheckedTicker = false;
                        }
                        else
                        {
                            //tickerFilterItems.filteredinTickerList.Add(tickerName);
                            member.IsCheckedTicker = true;
                        }
                        continue;
                    }

                    int index = tickerFilterItems.Industries.FindIndex(industry => industry == member.IndustryName);
                    if (index >= 0)
                    {
                        if (tickerFilterItems.IndustriesChecked[index] == false)
                        {
                            //tickerFilterItems.filteredoutTickerList.Add(tickerName);

                            if (tickerName != "" && tickerFilterItems.selectedTickerList.Contains(tickerName))
                            {
                                //tickerFilterItems.filteredinTickerList.Add(tickerName);
                                member.IsCheckedTicker = true;
                            }
                            else
                            {
                                member.IsCheckedTicker = false;
                            }

                            continue;
                        }
                    }

                    index = tickerFilterItems.Ratings.FindIndex(rating => rating == member.MoodysRating);
                    if (index >= 0)
                    {
                        if (tickerFilterItems.RatingsChecked[index] == false)
                        {
                            //tickerFilterItems.filteredoutTickerList.Add(tickerName);

                            if (tickerName != "" && tickerFilterItems.selectedTickerList.Contains(tickerName))
                            {
                                //tickerFilterItems.filteredinTickerList.Add(tickerName);
                                member.IsCheckedTicker = true;
                            }
                            else
                            {
                                member.IsCheckedTicker = false;
                            }

                            continue;
                        }
                    }

                    if (tickerName != "" && QuickFilteredoutList.Contains(tickerName))
                    {
                        //tickerFilterItems.filteredoutTickerList.Add(tickerName);

                        if (tickerName != "" && tickerFilterItems.selectedTickerList.Contains(tickerName))
                        {
                            //tickerFilterItems.filteredinTickerList.Add(tickerName);
                            member.IsCheckedTicker = true;
                        }
                        else
                        {
                            member.IsCheckedTicker = false;
                        }

                        continue;
                    }

                    //slider
                    List<double?> minmaxSlider;
                    double? minVal;
                    double? maxVal;

                    minmaxSlider = tickerFilter.getCDS5YSpread_MinMax();
                    minVal = minmaxSlider[0];
                    maxVal = minmaxSlider[1];

                    if (tickerFilterItems.CDS5YSpreadMin == tickerFilterItems.CDS5YSpreadSelMin)
                    {
                        tickerFilterItems.CDS5YSpreadSelMin = tickerFilterItems.CDS5YSpreadMin = minVal;
                    }
                    else
                    {
                        if (minVal < tickerFilterItems.CDS5YSpreadMin)
                        {
                            tickerFilterItems.CDS5YSpreadMin = minVal;
                        }

                        if (member.CDSPrice.HasValue)
                        {
                            if ((member.CDSPrice * member.FXRateCDS) < tickerFilterItems.CDS5YSpreadSelMin)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    if (tickerFilterItems.CDS5YSpreadMax == tickerFilterItems.CDS5YSpreadSelMax)
                    {
                        tickerFilterItems.CDS5YSpreadSelMax = tickerFilterItems.CDS5YSpreadMax = maxVal;
                    }
                    else
                    {
                        if (maxVal > tickerFilterItems.CDS5YSpreadMax)
                        {
                            tickerFilterItems.CDS5YSpreadMax = maxVal;
                        }

                        if (member.CDSPrice.HasValue)
                        {
                            if ((member.CDSPrice * member.FXRateCDS) > tickerFilterItems.CDS5YSpreadSelMax)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }


                    minmaxSlider = tickerFilter.getCDSCurveFilter_MinMax(tickerFilterItems.selCDSCurveFilter);
                    minVal = minmaxSlider[0];
                    maxVal = minmaxSlider[1];

                    double? curveRate = member.getCDSCurve(tickerFilterItems.selCDSCurveFilter);
                    if (tickerFilterItems.CDSCurveFilterMin == tickerFilterItems.CDSCurveFilterSelMin)
                    {
                        tickerFilterItems.CDSCurveFilterSelMin = tickerFilterItems.CDSCurveFilterMin = minVal;
                    }
                    else
                    {
                        if (minVal < tickerFilterItems.CDSCurveFilterMin)
                        {
                            tickerFilterItems.CDSCurveFilterMin = minVal;
                        }

                        if (curveRate.HasValue)
                        {
                            if (curveRate < tickerFilterItems.CDSCurveFilterSelMin)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    if (tickerFilterItems.CDSCurveFilterMax == tickerFilterItems.CDSCurveFilterSelMax)
                    {
                        tickerFilterItems.CDSCurveFilterSelMax = tickerFilterItems.CDSCurveFilterMax = maxVal;
                    }
                    else
                    {
                        if (maxVal > tickerFilterItems.CDSCurveFilterMax)
                        {
                            tickerFilterItems.CDSCurveFilterMax = maxVal;
                        }

                        if (curveRate.HasValue)
                        {
                            if (curveRate > tickerFilterItems.CDSCurveFilterSelMax)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    minmaxSlider = tickerFilter.getMarketCap_MinMax();
                    minVal = minmaxSlider[0];
                    maxVal = minmaxSlider[1];

                    if (tickerFilterItems.marketCapMin == tickerFilterItems.marketCapSelMin)
                    {
                        tickerFilterItems.marketCapSelMin = tickerFilterItems.marketCapMin = minVal;
                    }
                    else
                    {
                        if (minVal < tickerFilterItems.marketCapMin)
                        {
                            tickerFilterItems.marketCapMin = minVal;
                        }

                        if (member.MarketCapital.HasValue)
                        {
                            if ((member.MarketCapital * member.FXRateEquity) < tickerFilterItems.marketCapSelMin)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    if (tickerFilterItems.marketCapMax == tickerFilterItems.marketCapSelMax)
                    {
                        tickerFilterItems.marketCapSelMax = tickerFilterItems.marketCapMax = maxVal;
                    }
                    else
                    {
                        if (maxVal > tickerFilterItems.marketCapMax)
                        {
                            tickerFilterItems.marketCapMax = maxVal;
                        }

                        if (member.MarketCapital.HasValue)
                        {
                            if ((member.MarketCapital * member.FXRateEquity) > tickerFilterItems.marketCapSelMax)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }


                    minmaxSlider = tickerFilter.getTotalDebtTotalCap_MinMax();
                    minVal = minmaxSlider[0];
                    maxVal = minmaxSlider[1];

                    if (tickerFilterItems.totalDebtToTotalCapMin == tickerFilterItems.totalDebtToTotalCapSelMin)
                    {
                        tickerFilterItems.totalDebtToTotalCapSelMin = tickerFilterItems.totalDebtToTotalCapMin = minVal;
                    }
                    else
                    {
                        if (minVal < tickerFilterItems.totalDebtToTotalCapMin)
                        {
                            tickerFilterItems.totalDebtToTotalCapMin = minVal;
                        }

                        if (member.TotalDebtToCapital.HasValue)
                        {
                            if (member.TotalDebtToCapital < tickerFilterItems.totalDebtToTotalCapSelMin)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    if (tickerFilterItems.totalDebtToTotalCapMax == tickerFilterItems.totalDebtToTotalCapSelMax)
                    {
                        tickerFilterItems.totalDebtToTotalCapSelMax = tickerFilterItems.totalDebtToTotalCapMax = maxVal;
                    }
                    else
                    {
                        if (maxVal > tickerFilterItems.totalDebtToTotalCapMax)
                        {
                            tickerFilterItems.totalDebtToTotalCapMax = maxVal;
                        }

                        if (member.TotalDebtToCapital.HasValue)
                        {
                            if (member.TotalDebtToCapital > tickerFilterItems.totalDebtToTotalCapSelMax)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    minmaxSlider = tickerFilter.getDebtCommonEquity_MinMax();
                    minVal = minmaxSlider[0];
                    maxVal = minmaxSlider[1];

                    if (tickerFilterItems.debtToCommonEquityMin == tickerFilterItems.debtToCommonEquitySelMin)
                    {
                        tickerFilterItems.debtToCommonEquitySelMin = tickerFilterItems.debtToCommonEquityMin = minVal;
                    }
                    else
                    {
                        if (minVal < tickerFilterItems.debtToCommonEquityMin)
                        {
                            tickerFilterItems.debtToCommonEquityMin = minVal;
                        }

                        if (member.DebtToCommonEquity.HasValue)
                        {
                            if (member.DebtToCommonEquity < tickerFilterItems.debtToCommonEquitySelMin)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    if (tickerFilterItems.debtToCommonEquityMax == tickerFilterItems.debtToCommonEquitySelMax)
                    {
                        tickerFilterItems.debtToCommonEquitySelMax = tickerFilterItems.debtToCommonEquityMax = maxVal;
                    }
                    else
                    {
                        if (maxVal > tickerFilterItems.debtToCommonEquityMax)
                        {
                            tickerFilterItems.debtToCommonEquityMax = maxVal;
                        }

                        if (member.DebtToCommonEquity.HasValue)
                        {
                            if (member.DebtToCommonEquity > tickerFilterItems.debtToCommonEquitySelMax)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    minmaxSlider = tickerFilter.getInterestCoverageRatio_MinMax();
                    minVal = minmaxSlider[0];
                    maxVal = minmaxSlider[1];

                    if (tickerFilterItems.interestCoverageRatioMin == tickerFilterItems.interestCoverageRatioSelMin)
                    {
                        tickerFilterItems.interestCoverageRatioSelMin = tickerFilterItems.interestCoverageRatioMin = minVal;
                    }
                    else
                    {
                        if (minVal < tickerFilterItems.interestCoverageRatioMin)
                        {
                            tickerFilterItems.interestCoverageRatioMin = minVal;
                        }

                        if (member.InterestCoverageRatio.HasValue)
                        {
                            if (member.InterestCoverageRatio < tickerFilterItems.interestCoverageRatioSelMin)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    if (tickerFilterItems.interestCoverageRatioMax == tickerFilterItems.interestCoverageRatioSelMax)
                    {
                        tickerFilterItems.interestCoverageRatioSelMax = tickerFilterItems.interestCoverageRatioMax = maxVal;
                    }
                    else
                    {
                        if (maxVal > tickerFilterItems.interestCoverageRatioMax)
                        {
                            tickerFilterItems.interestCoverageRatioMax = maxVal;
                        }

                        if (member.InterestCoverageRatio.HasValue)
                        {
                            if (member.InterestCoverageRatio > tickerFilterItems.interestCoverageRatioSelMax)
                            {
                                falseTicker = false;
                            }
                        }
                        else
                            falseTicker = false;
                    }

                    if (falseTicker)
                    {
                        if (tickerName != "" && tickerFilterItems.unselectedTickerList.Contains(tickerName))
                        {
                            member.IsCheckedTicker = false;
                        }
                        else
                        {
                            //tickerFilterItems.filteredinTickerList.Add(tickerName);
                            member.IsCheckedTicker = true;
                        }
                    }
                    else
                    {
                        //tickerFilterItems.filteredoutTickerList.Add(tickerName);

                        if (tickerName != "" && tickerFilterItems.selectedTickerList.Contains(tickerName))
                        {
                            //tickerFilterItems.filteredinTickerList.Add(tickerName);
                            member.IsCheckedTicker = true;
                        }
                        else
                            member.IsCheckedTicker = false;
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while applyTickerFilter: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace applyTickerFilter: " + stackTrace, "INFO");
            }
        }

        public void comparemergelists(List<string> list1, List<bool> list1checked, List<string> list2)
        {
            foreach (var item in list2)
            {
                if (item != "" && !list1.Contains(item))
                {
                    list1.Add(item);
                    list1checked.Add(false);
                }
            }
        }

        public List<string> createQuickFilteredTickerList()
        {
            List<string> QuickFilterFalseTickerList = new List<string>();
            List<QuickFilterViewObject> filterList = new List<QuickFilterViewObject>();

            bool first = true;
            foreach (var quickFilterString in tickerFilterItems.quickFilterItems)
            {
                var itemList = parseQuickFilterItem(quickFilterString);
                QuickFilterViewObject quickObject = new QuickFilterViewObject();

                int i = 0;
                if (!first)
                {
                    if (itemList.Count < 5)
                        continue;

                    quickObject.andOrValue = itemList[i++];
                }
                else
                {
                    first = false;
                    if (itemList.Count < 4)
                        continue;
                }

                quickObject.mainValue = itemList[i++];
                quickObject.subValue = itemList[i++];
                quickObject.operatorValue = itemList[i++];
                quickObject.minTextValue = itemList[i++];

                if (itemList.Count > i)
                    quickObject.maxTextValue = itemList[i++];

                if (ValidateQuickFilterItem.validateFilter(quickObject))
                {
                    filterList.Add(quickObject);
                }
            }

            if (filterList.Count > 0)
            {
                return quickFilterTickers(filterList);
            }

            return QuickFilterFalseTickerList;
        }

        public List<string> quickFilterTickers(List<QuickFilterViewObject> quickfilterItems)
        {
            List<string> FilteredTickerFalse = new List<string>();

            List<string> fields = new List<string>();
            foreach (var filter in quickfilterItems)
            {
                if (filter.fieldName != null && filter.fieldName != "")
                {
                    if (!filter.fieldName.Contains("CALCULATED"))
                        fields.Add(filter.fieldName);
                    else
                    {
                        string[] split = filter.fieldName.Split(new Char[] { '=', '/' });

                        foreach (string s in split)
                        {

                            if (s.Trim() != "" && s != "CALCULATED")
                                fields.Add(s);
                        }
                    }
                }
            }

            if (quickfilterItems.Count > 1)
                quickfilterItems[0].andOrValue = quickfilterItems[1].andOrValue;
            else
                quickfilterItems[0].andOrValue = "AND";

            if (fields.Count < 1)
                return FilteredTickerFalse;

            var resultSet = cacheManager.dataManager.GetFieldValues(tickerFilter.TFCDSIndex.getAllEquityTicker(), fields);

            foreach (var member in tickerFilter.TFCDSIndex.CDSIndexMemberList)
            {
                string ticker = member.getTickerEquity();
                if (ticker == "")
                    continue;

                if (resultSet.ContainsKey(ticker))
                {
                    bool isFilteredTicker = true;

                    for (int i = 0; i < quickfilterItems.Count; ++i)
                    {
                        bool isFilteredItem = true;
                        if (quickfilterItems[i].fieldName == null || quickfilterItems[i].fieldName == "")
                        {
                            continue;
                        }

                        if (quickfilterItems[i].fieldName.Contains("CALCULATED"))
                        {
                            string[] split = quickfilterItems[i].fieldName.Split(new Char[] { '=', '/' });
                            List<string> calcFields = new List<string>();

                            foreach (string s in split)
                            {
                                if (s.Trim() != "" && s != "CALCULATED")
                                    calcFields.Add(s);
                            }

                            double? value1 = null;
                            double? value2 = null;

                            if (calcFields.Count != 2)
                                continue;

                            for (int j = 0; j < resultSet.Values.Count; ++j)
                            {
                                if (resultSet[ticker][j].Value != null)
                                {
                                    if (resultSet[ticker][j].Name == calcFields[0])
                                    {
                                        value1 = (double)resultSet[ticker][j].Value;
                                    }

                                    if (resultSet[ticker][j].Name == calcFields[1])
                                    {
                                        value2 = (double)resultSet[ticker][j].Value;
                                    }
                                }
                                else
                                    isFilteredItem = false;
                            }

                            if (value1 != null && value2 != null && value2 != 0.0)
                            {
                                var val = value1 / value2;

                                if (CompareFilteredItems(val, quickfilterItems[i].operatorValue, quickfilterItems[i].minTextValue, quickfilterItems[i].maxTextValue))
                                {
                                    isFilteredItem = true;
                                }
                                else
                                {
                                    isFilteredItem = false;
                                }
                            }
                            else
                                isFilteredItem = false;
                        }
                        else
                        {

                            for (int j = 0; j < fields.Count; ++j)
                            {
                                if (resultSet[ticker][j].Name == quickfilterItems[i].fieldName)
                                {
                                    if (resultSet[ticker][j].Value != null)
                                    {
                                        var value = resultSet[ticker][j].Value;

                                        if (CompareFilteredItems(value, quickfilterItems[i].operatorValue, quickfilterItems[i].minTextValue, quickfilterItems[i].maxTextValue))
                                        {
                                            isFilteredItem = true;
                                        }
                                        else
                                        {
                                            isFilteredItem = false;
                                        }
                                    }
                                    else
                                        isFilteredItem = false;
                                }
                            }
                        }

                        if (i == 0)
                        {
                            isFilteredTicker = isFilteredItem;
                        }
                        else
                        {
                            if (quickfilterItems[i].andOrValue == "OR")
                                isFilteredTicker |= isFilteredItem;
                            else if (quickfilterItems[i].andOrValue == "AND")
                                isFilteredTicker &= isFilteredItem;

                        }
                    }

                    if (!isFilteredTicker)
                    {
                        FilteredTickerFalse.Add(member.TickerEquity);
                    }

                }
            }

            return FilteredTickerFalse;
        }

        public List<string> parseQuickFilterItem(string filter)
        {
            List<string> fields = new List<string>();

            string[] split = filter.Split(new Char[] { ':' });

            foreach (string s in split)
            {
                if (s.Trim() != "")
                    fields.Add(s);
            }

            return fields;
        }

        public void updateHeatMapItemValues()
        {
            try
            {
                bool isDrawHeatMap = false;
                bool isUpdateHeatMap = false;

                List<string> EqFieldList = createHeatMapFieldList();

                if (HeatMapGroup.CDSIndexName != PrevHeatMapGroup.CDSIndexName)
                {
                    initializeCDSHeatMap();

                    DrawHeatMap();

                    justChangedGroup = true;
                }
                else
                {
                    if (FirstBy != PrevFirstBy || ThenBy != PrevThenBy || RectSize != PrevRectSize || DonutColor != PrevDonutColor)
                    {
                        isDrawHeatMap = true;
                    }

                    if (RectColor != PrevRectColor || CircleColor != PrevCircleColor)
                    {
                        if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                        {
                            getPriceFromBloomberg();
                        }

                        isUpdateHeatMap = true;
                    }

                    if (RateClass != PrevRateClass || (RateClass == ShowChangeRateClass.CUSTOM && (BeginDate != PrevDate1 || EndDate != PrevDate2)))
                    {
                        if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                        {
                            getPriceFromBloomberg();
                        }
                        isUpdateHeatMap = true;
                    }

                    if (EqFieldList.Count > 0)
                        getHeatMapFieldValues(EqFieldList);

                    if (isDrawHeatMap == true)
                    {
                        DrawHeatMap();
                    }
                    else if (isUpdateHeatMap == true)
                    {
                        unsubscribeAll();
                        foreach (CDSIndexMember member in tickerFilter.getAllCDSMembers())
                        {
                            int id;
                            DataChild child;

                            if (!HeatMapEquityTickerHash.TryGetValue(member.getTickerEquity(), out id))
                                continue;

                            if (!HeatMapHash.ContainsKey(id))
                                continue;

                            child = (DataChild)HeatMapHash[id];

                            if (RectSize != PrevRectSize)
                            {
                                child.ActualRectangleSize = getRectSize(member);
                            }

                            if (RectColor != PrevRectColor)
                            {
                                child.RectangleColor = getRectColor(member);
                                child.RectLastPrice = getRectLastPrice(member);

                                child.RectColorName = RectColor;
                            }

                            if (CircleColor != PrevCircleColor)
                            {
                                child.CircleColor = getCircleColor(member);
                                child.CircleLastPrice = getCircleLastPrice(member);

                                child.CircleColorName = CircleColor;
                            }

                            if (DonutColor != PrevDonutColor)
                            {
                                child.DonutChartColor = getDonutColor(member);
                            }

                            if (RateClass != PrevRateClass || (RateClass == ShowChangeRateClass.CUSTOM && (BeginDate != PrevDate1 || EndDate != PrevDate2)))
                            {
                                child.RectangleColor = getRectColor(member);
                                child.CircleColor = getCircleColor(member);
                            }

                        }
                        updateHeatMap();
                        subscribeAll();
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while updateHeatMapItemValues: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updateHeatMapItemValues: " + stackTrace, "INFO");
            }
        }

        void getHeatMapFieldValues(List<string> EqFieldList)
        {
            try
            {
                cacheManager.getTickerFields(tickerFilter.getAllCDSMembers(), tickerFilter.getAllEquityTicker(), EqFieldList);
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while getHeatMapFieldValues: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace getHeatMapFieldValues: " + stackTrace, "INFO");
            }
        }

        public List<string> createHeatMapFieldList(string heatMapGroupCDSIndex = null)
        {
            if (heatMapGroupCDSIndex == null || heatMapGroupCDSIndex == "")
                heatMapGroupCDSIndex = HeatMapGroup.CDSIndexName;

            List<string> fields = new List<string>();

            if (FirstBy != PrevFirstBy || !isInitialized
                || heatMapGroupCDSIndex != PrevHeatMapGroup.CDSIndexName)
            {
                if (FirstBy == ConstantItemList.EXPECTED_EARNINGS_RD)
                    fields.Add(DataFieldNames.EXPECTED_REPORT_DT);
                else if (FirstBy == ConstantItemList.SHORT_INTEREST_EF)
                    fields.Add(DataFieldNames.SI_PERCENT_EQUITY_FLOAT);
                else if (FirstBy == ConstantItemList.PRICE_SALES_RATIO)
                    fields.Add(DataFieldNames.PX_TO_SALES_RATIO);
                else if (FirstBy == ConstantItemList.EQUITY_BETA)
                    fields.Add(DataFieldNames.EQY_BETA);
            }

            if (ThenBy != PrevThenBy || !isInitialized
                || heatMapGroupCDSIndex != PrevHeatMapGroup.CDSIndexName)
            {
                if (ThenBy == ConstantItemList.EXPECTED_EARNINGS_RD)
                    fields.Add(DataFieldNames.EXPECTED_REPORT_DT);
                else if (ThenBy == ConstantItemList.SHORT_INTEREST_EF)
                    fields.Add(DataFieldNames.SI_PERCENT_EQUITY_FLOAT);
                else if (ThenBy == ConstantItemList.PRICE_SALES_RATIO)
                    fields.Add(DataFieldNames.PX_TO_SALES_RATIO);
                else if (ThenBy == ConstantItemList.EQUITY_BETA)
                    fields.Add(DataFieldNames.EQY_BETA);
            }

            /*
            if (RectSize != PrevRectSize)
            {
                
            }
             */

            if (RectColor != PrevRectColor || !isInitialized
                || heatMapGroupCDSIndex != PrevHeatMapGroup.CDSIndexName)
            {
                if (RectColor == ConstantItemList.VOLUME_CHG_5D_20D)
                    fields.Add(DataFieldNames.VOLUME_PCT_5_20);
                else if (RectColor == ConstantItemList.SALES_1Y_GROWTH)
                    fields.Add(DataFieldNames.SALES_GROWTH);
            }

            if (CircleColor != PrevCircleColor || !isInitialized
                || heatMapGroupCDSIndex != PrevHeatMapGroup.CDSIndexName)
            {
                if (CircleColor == ConstantItemList.VOLUME_CHG_5D_20D)
                    fields.Add(DataFieldNames.VOLUME_PCT_5_20);
                else if (CircleColor == ConstantItemList.SALES_1Y_GROWTH)
                    fields.Add(DataFieldNames.SALES_GROWTH);
            }

            return fields;
        }

        public List<string> createColorTickerList(string colorOption)
        {

            if (colorOption == ConstantItemList.SHARE_PRICE_CHG ||
                colorOption == ConstantItemList.VOLUME_CHG_5D_20D ||
                colorOption == ConstantItemList.SALES_1Y_GROWTH ||
                colorOption == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return tickerFilter.getAllEquityTicker();
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_5Y_CHG)
            {
                return tickerFilter.getSpreadTickerPricingSource(4, PricingSource);
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_1Y_CHG)
            {
                return tickerFilter.getSpreadTickerPricingSource(0, PricingSource);
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_2Y_CHG)
            {
                return tickerFilter.getSpreadTickerPricingSource(1, PricingSource);
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_10Y_CHG)
            {
                return tickerFilter.getSpreadTickerPricingSource(1, PricingSource);
            }

            return new List<string>();
        }

        public Dictionary<string, double?> getColorTickerLastPriceList(string colorOption)
        {

            if (colorOption == ConstantItemList.SHARE_PRICE_CHG ||
                colorOption == ConstantItemList.VOLUME_CHG_5D_20D ||
                colorOption == ConstantItemList.SALES_1Y_GROWTH ||
                colorOption == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return tickerFilter.getAllEquityTickerLastPrice();
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_5Y_CHG)
            {
                return tickerFilter.getSpreadTickerLastPrice(4, PricingSource);
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_1Y_CHG)
            {
                return tickerFilter.getSpreadTickerLastPrice(0, PricingSource);
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_2Y_CHG)
            {
                return tickerFilter.getSpreadTickerLastPrice(1, PricingSource);
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_10Y_CHG)
            {
                return tickerFilter.getSpreadTickerLastPrice(1, PricingSource);
            }

            return new Dictionary<string, double?>();
        }

        public string getColorTicker(CDSIndexMember member, string colorOption)
        {
            if (colorOption == ConstantItemList.SHARE_PRICE_CHG ||
                colorOption == ConstantItemList.VOLUME_CHG_5D_20D ||
                colorOption == ConstantItemList.SALES_1Y_GROWTH ||
                colorOption == ConstantItemList.HIST_CALL_IMPL_VOL)
            {
                return member.getTickerEquity();
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_5Y_CHG)
            {
                return member.getTickerSpread(4, PricingSource);
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_1Y_CHG)
            {
                return member.getTickerSpread(0, PricingSource);
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_2Y_CHG)
            {
                return member.getTickerSpread(1, PricingSource);
            }
            else if (colorOption == ConstantItemList.CDS_PRICE_10Y_CHG)
            {
                return member.getTickerSpread(1, PricingSource);
            }
            else
                return "";

        }

        public static void fillDateFields(ShowChangeRateClass rateclass)
        {
            RateClass = rateclass;
            setShowChangeDate();
        }

        public static void setShowChangeDate()
        {
            if (RateClass == ShowChangeRateClass.YTD)
            {
                EndDate = GetLastBusinessDay(DateTime.Now);
                BeginDate = GetLastBusinessDayofYear(EndDate.AddYears(-1).Year, 12);
            }
            else if (RateClass == ShowChangeRateClass.CLOSE)
            {
                EndDate = GetLastBusinessDay(DateTime.Now);
                BeginDate = GetLastBusinessDay(EndDate.AddDays(-1));

            }
            else if (RateClass == ShowChangeRateClass.WEEK52)
            {
                EndDate = GetLastBusinessDay(DateTime.Now);
                BeginDate = GetLastBusinessDay(EndDate.AddYears(-1));
            }
            else if (RateClass == ShowChangeRateClass.DAY1)
            {
                EndDate = GetLastBusinessDay(DateTime.Now.AddDays(-1));
                BeginDate = GetLastBusinessDay(EndDate.AddDays(-1));
            }
            else //OTHER
            {
                EndDate = GetLastBusinessDay(EndDate);
                BeginDate = GetLastBusinessDay(BeginDate);
                if (BeginDate.Date == EndDate.Date)
                    BeginDate = GetLastBusinessDay(BeginDate.AddDays(-1));
            }

        }

        public void getPriceFromBloomberg()
        {
            try
            {
                Dictionary<string, Rate> result1;
                Dictionary<string, Rate> result2 = null;

                List<string> rectTickerList = createColorTickerList(RectColor);
                List<string> circleTickerList = createColorTickerList(CircleColor);

                if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.DAY1 || RateClass == ShowChangeRateClass.CUSTOM)
                {
                    if ((RectColor != ConstantItemList.SHARE_PRICE_CHG || RectColor != ConstantItemList.VOLUME_CHG_5D_20D ||
                       RectColor != ConstantItemList.SALES_1Y_GROWTH || RectColor != ConstantItemList.HIST_CALL_IMPL_VOL) ||
                       !(CircleColor == ConstantItemList.SHARE_PRICE_CHG || CircleColor == ConstantItemList.VOLUME_CHG_5D_20D ||
                       CircleColor == ConstantItemList.SALES_1Y_GROWTH || CircleColor == ConstantItemList.HIST_CALL_IMPL_VOL))
                    {
                        rectTickerList = rectTickerList.Union(tickerFilter.getAllEquityTicker()).ToList();
                    }

                    if (CircleColor != ConstantItemList.CDS_PRICE_5Y_CHG || RectColor != ConstantItemList.CDS_PRICE_5Y_CHG)
                    {
                        circleTickerList = circleTickerList.Union(tickerFilter.getSpreadTickerPricingSource(4, PricingSource)).ToList();
                    }
                }

                if (rectTickerList == null && circleTickerList == null)
                    return;

                var rectCircleTickerList = rectTickerList.Union(circleTickerList).ToList();

                if (rectCircleTickerList.Count() == 0)
                    return;

                setShowChangeDate();

                if (RateClass == ShowChangeRateClass.WEEK52 || RateClass == ShowChangeRateClass.CUSTOM || RateClass == ShowChangeRateClass.DAY1)
                {
                    if (rectTickerList != null && rectTickerList.Count > 0)
                    {
                        RectColorChgPCT.Clear();
                        RectColorChgNET.Clear();
                    }
                    if (circleTickerList != null && circleTickerList.Count > 0)
                    {
                        CircleColorChgPCT.Clear();
                        CircleColorChgNET.Clear();
                    }
                    result1 = cacheManager.getTickerHistPrice(rectCircleTickerList, BeginDate);

                    if (EndDate.Date == GetLastBusinessDay(DateTime.Today).Date)
                    {
                        foreach (CDSIndexMember member in tickerFilter.getAllCDSMembers())
                        {
                            var list1 = getColorTickerLastPriceList(RectColor);
                            var list2 = getColorTickerLastPriceList(CircleColor);

                            result2 = new Dictionary<string, Rate>();
                            foreach (var keyval in list1)
                            {
                                if (keyval.Key != "" && !result2.ContainsKey(keyval.Key))
                                    result2.Add(keyval.Key, new Rate(EndDate, keyval.Value));
                            }

                            foreach (var keyval in list2)
                            {
                                if (keyval.Key != "" && !result2.ContainsKey(keyval.Key))
                                    result2.Add(keyval.Key, new Rate(EndDate, keyval.Value));
                            }
                        }
                    }
                    else
                    {
                        result2 = cacheManager.getTickerHistPrice(rectCircleTickerList, EndDate);
                    }

                    for (int i = 0; i < rectTickerList.Count; ++i)
                    {
                        if (rectTickerList[i] == "")
                            continue;

                        double? chg = null;
                        if (result1.ContainsKey(rectTickerList[i]) && result2.ContainsKey(rectTickerList[i]))
                            chg = calculate_PCT_CHG(result1[rectTickerList[i]].RateValue, result2[rectTickerList[i]].RateValue);

                        if (!RectColorChgPCT.ContainsKey(rectTickerList[i]))
                            RectColorChgPCT.Add(rectTickerList[i], chg);

                        if (result1.ContainsKey(rectTickerList[i]) && result2.ContainsKey(rectTickerList[i]))
                            chg = calculate_NET_CHG(result1[rectTickerList[i]].RateValue, result2[rectTickerList[i]].RateValue);
                        else
                            chg = null;

                        if (!RectColorChgNET.ContainsKey(rectTickerList[i]))
                            RectColorChgNET.Add(rectTickerList[i], chg);
                    }

                    for (int i = 0; i < circleTickerList.Count; ++i)
                    {
                        if (circleTickerList[i] == "")
                            continue;

                        double? chg = null;

                        if (result1.ContainsKey(circleTickerList[i]) && result2.ContainsKey(circleTickerList[i]))
                            chg = calculate_PCT_CHG(result1[circleTickerList[i]].RateValue, result2[circleTickerList[i]].RateValue);

                        if (!CircleColorChgPCT.ContainsKey(circleTickerList[i]))
                            CircleColorChgPCT.Add(circleTickerList[i], chg);

                        if (result1.ContainsKey(circleTickerList[i]) && result2.ContainsKey(circleTickerList[i]))
                            chg = calculate_NET_CHG(result1[circleTickerList[i]].RateValue, result2[circleTickerList[i]].RateValue);
                        else
                            chg = null;

                        if (!CircleColorChgNET.ContainsKey(circleTickerList[i]))
                            CircleColorChgNET.Add(circleTickerList[i], chg);
                    }

                }
                else if (RateClass != ShowChangeRateClass.CLOSE && RateClass != ShowChangeRateClass.YTD)    //RateClass = ShowChangeRateClass.OTHER
                {

                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while getPriceFromBloomberg: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace getPriceFromBloomberg: " + stackTrace, "INFO");
            }
        }

        public void get52WeekChgPCT(List<CDSIndexMember> memberList)
        {
            try
            {
                List<string> eqTickerList = new List<string>();

                foreach (var member in memberList)
                {
                    var ticker = member.getTickerEquity();

                    if (ticker != "")
                        eqTickerList.Add(ticker);
                }

                Dictionary<string, Rate> result1;

                DateTime date2 = GetLastBusinessDay(DateTime.Now.Date);
                DateTime date1 = GetLastBusinessDay(date2.AddYears(-1).Date);

                result1 = cacheManager.getTickerHistPrice(eqTickerList, date1);

                if (result1 == null)
                    return;

                foreach (CDSIndexMember member in memberList)
                {
                    string ticker = member.getTickerEquity();
                    if (ticker == "")
                        continue;

                    double? chg = calculate_PCT_CHG(result1[ticker].RateValue, member.LastPrice);
                    member.ChgPCT52W = chg;
                    chg = calculate_NET_CHG(result1[ticker].RateValue, member.LastPrice);
                    member.ChgNET52W = chg;
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while get52WeekChgPCT: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace get52WeekChgPCT: " + stackTrace, "INFO");
            }
        }

        public double? calculate_PCT_CHG(double? rate1, double? rate2)
        {
            if (rate1 == null || rate2 == null) return null;
            return (rate2 - rate1) / rate1;
        }

        public double? calculate_NET_CHG(double? rate1, double? rate2)
        {
            if (rate1 == null || rate2 == null) return null;
            return (rate2 - rate1);
        }

        private int generateID()
        {
            return IDvalue++;
        }

        public static bool IsBusinessDay(DateTime date)
        {
            return
                date.DayOfWeek != DayOfWeek.Saturday &&
                date.DayOfWeek != DayOfWeek.Sunday;
        }

        public static DateTime GetLastBusinessDayofYear(int Year, int Month)
        {
            DateTime LastOfMonth = default(DateTime);
            DateTime LastBusinessDay = default(DateTime);
            LastOfMonth = new DateTime(Year, Month, DateTime.DaysInMonth(Year, Month));
            if (LastOfMonth.DayOfWeek == DayOfWeek.Sunday)
            {
                LastBusinessDay = LastOfMonth.AddDays(-2);
            }
            else if (LastOfMonth.DayOfWeek == DayOfWeek.Saturday)
            {
                LastBusinessDay = LastOfMonth.AddDays(-1);
            }
            else
            {
                LastBusinessDay = LastOfMonth;
            }
            return LastBusinessDay;
        }

        public static DateTime GetLastBusinessDay(DateTime date)
        {
            DateTime result;
            if (date.DayOfWeek == DayOfWeek.Sunday)
                result = date.AddDays(-2);
            else if (date.DayOfWeek == DayOfWeek.Saturday)
                result = date.AddDays(-1);
            else
                result = date;

            return result;
        }

        public static int DaysToThisWeek(DateTime date)
        {
            return (DayOfWeek.Sunday - date.DayOfWeek);
        }

        public static int DaysToMonth(DateTime date)
        {
            return (int)(GetLastBusinessDayofYear(date.Year, date.Month) - date).TotalDays;
        }



        public string GetFirstByExpectedReportDT(DateTime? date)
        {
            if (!date.HasValue)
                return ConstantItemList.NOTAVAILABLE;

            DateTime reportDate = (date ?? System.DateTime.Now);

            int dateDiff = (int)(reportDate.Date - System.DateTime.Now.Date).TotalDays;

            if (dateDiff == 0)
                return ConstantItemList.TODAY;
            else if (dateDiff == 1)
                return ConstantItemList.TOMORROW;
            else if (dateDiff > 1 && dateDiff <= DaysToThisWeek(reportDate))
                return ConstantItemList.THISWEEK;
            else if (dateDiff > DaysToThisWeek(reportDate) && dateDiff <= (7 + DaysToThisWeek(reportDate)))
                return ConstantItemList.NEXTWEEK;
            else if (dateDiff > (7 + DaysToThisWeek(reportDate)) && dateDiff <= DaysToMonth(reportDate))
                return ConstantItemList.THISMONTH;
            else if (dateDiff > DaysToMonth(reportDate) && dateDiff <= DaysToMonth(reportDate.AddMonths(1)))
                return ConstantItemList.NEXTMONTH;
            else if (dateDiff > DaysToMonth(reportDate.AddMonths(1)) && dateDiff <= 60)
                return ConstantItemList.WITHIN60D;
            else if (dateDiff < 60 && dateDiff <= 90)
                return ConstantItemList.WITHIN90D;
            else
            {
                DateTime group = DateTime.Now.AddDays(91);
                var dtf = CultureInfo.CurrentCulture.DateTimeFormat;
                string abbreviatedMonthName = dtf.GetAbbreviatedMonthName(group.Month);
                return ("Later Than " + abbreviatedMonthName + " " + group.Day);
            }
        }

        public string GetThenByExpectedReportDT(DateTime? date)
        {
            if (!date.HasValue)
                return ConstantItemList.NOTAVAILABLE;

            DateTime reportDate = (date ?? System.DateTime.Now);

            int dateDiff = (int)(reportDate - System.DateTime.Now).TotalDays;

            if (dateDiff == 0)
                return ConstantItemList.TODAY;
            else if (dateDiff == 1)
                return ConstantItemList.TOMORROW;
            else if (dateDiff > 1 && dateDiff <= DaysToThisWeek(reportDate))
                return ConstantItemList.THISWEEK;
            else if (dateDiff > DaysToThisWeek(reportDate) && dateDiff <= (7 + DaysToThisWeek(reportDate)))
                return ConstantItemList.NEXTWEEK;
            else
            {
                DateTime group = DateTime.Now.AddDays(8 + DaysToThisWeek(DateTime.Now));
                var dtf = CultureInfo.CurrentCulture.DateTimeFormat;
                string abbreviatedMonthName = dtf.GetAbbreviatedMonthName(group.Month);
                return ("Later Than " + abbreviatedMonthName + " " + group.Day);
            }
        }

        public void fillAllList()
        {
            try
            {
                quickfilterItems = HeatMapView.filterList;
                fillFirstByList();
                fillThenByList();
                fillRectangleSizeList();
                fillRectangleColorList();
                fillCircleColorList();
                fillDonutColorList();
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while fillAllList: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace fillAllList: " + stackTrace, "INFO");
            }
        }
        public void fillFirstByList()
        {

            FirstByItems items = new FirstByItems();
            FirstByList = items.itemValues;
            FirstBy = FirstByList.First();

        }
        public void fillThenByList()
        {

            ThenByItems items = new ThenByItems();
            ThenByList = items.itemValues;

            ThenBy = ThenByList.First();

        }
        public void fillRectangleSizeList()
        {

            RectangleSizeItems items = new RectangleSizeItems();
            RectangleSizeList = items.itemValues;
            RectSize = RectangleSizeList.First();

        }
        public void fillRectangleColorList()
        {

            RectangleColorItems items = new RectangleColorItems();
            RectangleColorList = items.itemValues;
            RectColor = RectangleColorList.First();

        }
        public void fillCircleColorList()
        {

            CircleColorItems items = new CircleColorItems();
            CircleColorList = items.itemValues;
            CircleColor = CircleColorList.First();

        }
        public void fillDonutColorList()
        {

            DonutColorItems items = new DonutColorItems();
            DonutColorList = items.itemValues;

            DonutColor = DonutColorList.First();
        }


        public void fillTickerNameList()
        {
            try
            {
                tickerNameList.Clear();

                List<string> tickerNameSortedList = new List<string>();

                foreach (DataChild child in childList)
                {
                    if (!String.IsNullOrWhiteSpace(child.ChildName))
                        tickerNameSortedList.Add(child.ChildName);
                    if (!String.IsNullOrWhiteSpace(child.ChildEqTicker))
                        tickerNameSortedList.Add(child.ChildEqTicker);
                }

                tickerNameSortedList = tickerNameSortedList.OrderBy(nameTicker => nameTicker).ToList();

                foreach (string tickername in tickerNameSortedList)
                {
                    tickerNameList.Add(new ObservableName(tickername));
                }

                tickerNameSortedList.Clear();
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while fillTickerNameList: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace fillTickerNameList: " + stackTrace, "INFO");
            }
        }

        // return true = green +, red -
        // return false = red +, green -
        public bool getNegativeGreenColor(string item)
        {
            if (ConstantItemList.GreenColorList.ContainsKey(item))
                return ConstantItemList.GreenColorList[item];
            else
                return false;
        }

        public void subscribeAll()
        {
            try
            {
                List<string> SubscriptionFields = new List<string>() { DataFieldNames.LAST_PRICE, 
                                                                       DataFieldNames.RT_PX_CHG_PCT_1D, DataFieldNames.RT_PX_CHG_NET_1D };

                List<string> fields = new List<string>();

                if (RateClass == ShowChangeRateClass.CLOSE)
                    fields.Add(DataFieldNames.RT_PX_CHG_PCT_1D);
                else if (RateClass == ShowChangeRateClass.YTD || RateClass == ShowChangeRateClass.WEEK52)
                    fields.Add(DataFieldNames.LAST_PRICE);
                else if (RateClass == ShowChangeRateClass.CUSTOM)
                {
                    if (EndDate.ToString("yyyyMMdd") == DateTime.Now.ToString("yyyyMMdd"))
                        fields.Add(DataFieldNames.LAST_PRICE);
                }

                foreach (DataChild child in childList)
                {
                    child.Ticker = "";

                    child.Ticker = child.getTickerEquity();

                    if (child.Ticker != "")
                        cacheManager.dataManager.SubscribeForUpdates(child, SubscriptionFields);


                    child.Ticker = child.getSpreadTicker(4, PricingSource);
                    if (child.Ticker != "")
                    {
                        cacheManager.dataManager.SubscribeForUpdates(child, SubscriptionFields);
                        child.Ticker = "";
                    }

                    if (RectColor == ConstantItemList.CDS_PRICE_1Y_CHG || CircleColor == ConstantItemList.CDS_PRICE_1Y_CHG)
                    {
                        child.Ticker = child.getSpreadTicker(0, PricingSource);
                    }
                    else if (RectColor == ConstantItemList.CDS_PRICE_2Y_CHG || CircleColor == ConstantItemList.CDS_PRICE_2Y_CHG)
                    {
                        child.Ticker = child.getSpreadTicker(1, PricingSource);
                    }
                    else if (RectColor == ConstantItemList.CDS_PRICE_10Y_CHG || CircleColor == ConstantItemList.CDS_PRICE_10Y_CHG)
                    {
                        child.Ticker = child.getSpreadTicker(6, PricingSource);
                    }

                    if (child.Ticker != "" && fields.Count >= 0)
                        cacheManager.dataManager.SubscribeForUpdates(child, fields);
                }

                SubscriptionUpdate = false;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while subscribeAll: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace subscribeAll: " + stackTrace, "INFO");
            }
        }

        public void unsubscribeAll()
        {
            try
            {
                SubscriptionUpdate = true;
                subscriptionTickerIDList.Clear();
                cacheManager.dataManager.Unsubscribe();
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while unsubscribeAll: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace unsubscribeAll: " + stackTrace, "INFO");
            }
        }

        private void SubscriptionUpdHeatMap(int tickerID, string subscriptionTicker, string fieldName, double fieldValue)
        {
            try
            {
                if (!HeatMapHash.ContainsKey(tickerID))
                    return;

                Thread thread = new Thread(() =>
                {
                    try
                    {
                        DataChild child = (DataChild)HeatMapHash[tickerID];

                        CDSIndexMember member = getCDSMemberDetails(child.ChildEqTicker);

                        /*TODO: update member fields*/

                        bool valueUpdated = false;

                        if (fieldName == DataFieldNames.RT_PX_CHG_PCT_1D)
                        {
                            if (child.getTickerEquity() != "" && subscriptionTicker.Contains(child.getTickerEquity()))
                            {
                                child.EqChgPCT = fieldValue;

                                if (member != null)
                                    member.ChgPCT1D = fieldValue;
                            }
                            else if (child.getSpreadTicker(4, PricingSource) != "" && subscriptionTicker.Contains(child.getSpreadTicker(4, PricingSource)))
                            {
                                child.CDS5YChgPCT = fieldValue;

                                if (member != null)
                                    member.setSpreadChgPCT1D(4, fieldValue);
                            }

                            if (RateClass == ShowChangeRateClass.CLOSE)
                            {
                                valueUpdated = UpdateDataChildElements(child, subscriptionTicker, fieldName, fieldValue);

                                if (child.getSpreadTicker(0, PricingSource) != "" && subscriptionTicker.Contains(child.getSpreadTicker(0, PricingSource)))
                                {
                                    if (member != null)
                                        member.setSpreadChgPCT1D(0, fieldValue);
                                }
                                else if (child.getSpreadTicker(1, PricingSource) != "" && subscriptionTicker.Contains(child.getSpreadTicker(1, PricingSource)))
                                {
                                    if (member != null)
                                        member.setSpreadChgPCT1D(1, fieldValue);
                                }
                                else if (child.getSpreadTicker(6, PricingSource) != "" && subscriptionTicker.Contains(child.getSpreadTicker(6, PricingSource)))
                                {
                                    if (member != null)
                                        member.setSpreadChgPCT1D(6, fieldValue);
                                }
                            }

                        }
                        else if (fieldName == DataFieldNames.RT_PX_CHG_NET_1D)
                        {
                            if (child.getTickerEquity() != "" && subscriptionTicker.Contains(child.getTickerEquity()))
                            {
                                child.EqChgNET = fieldValue;

                                if (member != null)
                                    member.ChgNET1D = fieldValue;
                            }
                            else if (child.getSpreadTicker(4, PricingSource) != "" && subscriptionTicker.Contains(child.getSpreadTicker(4, PricingSource)))
                            {
                                child.CDS5YChgNET = fieldValue;

                                if (member != null)
                                    member.CDS5YChgNET1D = fieldValue;
                            }
                        }
                        else if (fieldName == DataFieldNames.LAST_PRICE && fieldValue != 0.0)
                        {
                            if (RateClass == ShowChangeRateClass.YTD || RateClass == ShowChangeRateClass.WEEK52
                            || (RateClass == ShowChangeRateClass.CUSTOM && EndDate.ToString("yyyyMMdd") == DateTime.Now.ToString("yyyyMMdd")))
                            {
                                valueUpdated = UpdateDataChildElements(child, subscriptionTicker, fieldName, fieldValue);

                                updateRectCircleColorChg(subscriptionTicker, member, fieldValue);

                            }

                            if (child.getTickerEquity() != "" && subscriptionTicker.Contains(child.getTickerEquity()))
                            {
                                child.EquityPrice = fieldValue;
                            }
                            else if (child.getSpreadTicker(4, PricingSource) != "" && subscriptionTicker.Contains(child.getSpreadTicker(4, PricingSource)))
                            {
                                child.CDS5YSpread = fieldValue;
                            }
                        }

                        if (valueUpdated)
                        {
                            while (SubscriptionUpdate == true)
                            {
                                Thread.Sleep(100);
                            }

                            subscriptionTickerIDList.Add(tickerID);
                        }
                    }
                    catch (Exception e)
                    {
                        Trace.WriteLine(string.Format("Exception while processing subscription data SubscriptionUpdHeatMap: {0}", e.Message.ToString()), "ERROR");

                        string stackTrace = "";
                        if (e.StackTrace != null)
                            stackTrace = e.StackTrace.ToString();

                        Trace.WriteLine("Exception Stacktrace SubscriptionUpdHeatMap: " + stackTrace, "INFO");
                    }

                });
                thread.Start();
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while SubscriptionUpdHeatMap: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace SubscriptionUpdHeatMap: " + stackTrace, "INFO");
            }
        }

        private void upd_RectCircleColorChg(string ticker, double? lastPrice, double? oldLastPrice)
        {
            try
            {
                double? tempCalc;

                if (ticker != "" && RectColorChgPCT.ContainsKey(ticker))
                {
                    tempCalc = calcFromLastPrice_PCT_CHG(lastPrice, RectColorChgPCT[ticker], oldLastPrice);

                    if (tempCalc != null)
                        RectColorChgPCT[ticker] = tempCalc;
                }

                if (ticker != "" && CircleColorChgPCT.ContainsKey(ticker))
                {
                    tempCalc = calcFromLastPrice_PCT_CHG(lastPrice, CircleColorChgPCT[ticker], oldLastPrice);

                    if (tempCalc != null)
                        CircleColorChgPCT[ticker] = tempCalc;
                }

                if (ticker != "" && RectColorChgNET.ContainsKey(ticker))
                {
                    tempCalc = calcFromLastPrice_NET_CHG(lastPrice, RectColorChgNET[ticker], oldLastPrice);

                    if (tempCalc != null)
                        RectColorChgNET[ticker] = tempCalc;
                }

                if (ticker != "" && CircleColorChgNET.ContainsKey(ticker))
                {
                    tempCalc = calcFromLastPrice_NET_CHG(lastPrice, CircleColorChgNET[ticker], oldLastPrice);

                    if (tempCalc != null)
                        CircleColorChgNET[ticker] = tempCalc;
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while upd_RectCircleColorChg: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace upd_RectCircleColorChg: " + stackTrace, "INFO");
            }
        }

        private void updateRectCircleColorChg(string subscriptionTicker, CDSIndexMember member, double? lastPrice)
        {
            try
            {
                if (subscriptionTicker == "" || member == null || lastPrice != null || lastPrice != 0.0)
                    return;

                double? tempCalc;

                if (member.getTickerEquity() != "" && subscriptionTicker.Contains(member.getTickerEquity()))
                {
                    if (RateClass == ShowChangeRateClass.YTD)
                    {
                        tempCalc = calcFromLastPrice_PCT_CHG(lastPrice, member.ChgPCTYTD, member.LastPrice);

                        if (tempCalc != null)
                            member.ChgPCTYTD = tempCalc;

                        tempCalc = calcFromLastPrice_NET_CHG(lastPrice, member.ChgNETYTD, member.LastPrice);

                        if (tempCalc != null)
                            member.ChgNETYTD = tempCalc;
                    }
                    else
                        upd_RectCircleColorChg(member.getTickerEquity(), lastPrice, member.LastPrice);

                    member.LastPrice = lastPrice;
                }

                if (member.getTickerSpread(4, PricingSource) != "" && subscriptionTicker.Contains(member.getTickerSpread(4, PricingSource)))
                {
                    if (RateClass == ShowChangeRateClass.YTD)
                    {
                        tempCalc = calcFromLastPrice_PCT_CHG(lastPrice, member.getSpreadChgPCTYTD(4), member.getMidSpread(4));

                        if (tempCalc != null)
                            member.setSpreadChgPCTYTD(4, tempCalc);

                        tempCalc = calcFromLastPrice_NET_CHG(lastPrice, member.CDS5YChgNETYTD, member.getMidSpread(4));

                        if (tempCalc != null)
                            member.CDS5YChgNETYTD = tempCalc;
                    }
                    else
                        upd_RectCircleColorChg(member.getTickerSpread(4, PricingSource), lastPrice, member.getMidSpread(4));

                    member.setMidSpread(4, lastPrice);
                }

                if (member.getTickerSpread(0, PricingSource) != "" && subscriptionTicker.Contains(member.getTickerSpread(0, PricingSource)))
                {
                    if (RateClass == ShowChangeRateClass.YTD)
                    {
                        tempCalc = calcFromLastPrice_PCT_CHG(lastPrice, member.getSpreadChgPCTYTD(0), member.getMidSpread(0));

                        if (tempCalc != null)
                            member.setSpreadChgPCTYTD(0, tempCalc);
                    }
                    else
                        upd_RectCircleColorChg(member.getTickerSpread(0, PricingSource), lastPrice, member.getMidSpread(0));

                    member.setMidSpread(0, lastPrice);
                }

                if (member.getTickerSpread(1, PricingSource) != "" && subscriptionTicker.Contains(member.getTickerSpread(1, PricingSource)))
                {
                    if (RateClass == ShowChangeRateClass.YTD)
                    {
                        tempCalc = calcFromLastPrice_PCT_CHG(lastPrice, member.getSpreadChgPCTYTD(1), member.getMidSpread(1));

                        if (tempCalc != null)
                            member.setSpreadChgPCTYTD(1, tempCalc);
                    }
                    else
                        upd_RectCircleColorChg(member.getTickerSpread(1, PricingSource), lastPrice, member.getMidSpread(1));

                    member.setMidSpread(1, lastPrice);
                }

                if (member.getTickerSpread(6, PricingSource) != "" && subscriptionTicker.Contains(member.getTickerSpread(6, PricingSource)))
                {
                    if (RateClass == ShowChangeRateClass.YTD)
                    {
                        tempCalc = calcFromLastPrice_PCT_CHG(lastPrice, member.getSpreadChgPCTYTD(6), member.getMidSpread(6));

                        if (tempCalc != null)
                            member.setSpreadChgPCTYTD(6, tempCalc);
                    }
                    else
                        upd_RectCircleColorChg(member.getTickerSpread(6, PricingSource), lastPrice, member.getMidSpread(6));

                    member.setMidSpread(6, lastPrice);
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while updateRectCircleColorChg: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace updateRectCircleColorChg: " + stackTrace, "INFO");
            }
        }

        private bool updateRectangleFromSubscription(string ticker, DataChild child, string fieldName, double fieldValue)
        {
            bool valueUpdated = false;

            if (fieldName == DataFieldNames.RT_PX_CHG_PCT_1D)
            {
                if (child.RectangleColor != fieldValue)
                {
                    valueUpdated = true;
                    child.RectangleColor = fieldValue;
                }
            }
            else if (fieldName == DataFieldNames.LAST_PRICE)
            {
                if (child.RectLastPrice != fieldValue)
                {
                    valueUpdated = true;
                    child.RectangleColor = calcFromLastPrice_PCT_CHG(fieldValue, child.RectangleColor, child.RectLastPrice);
                    child.RectLastPrice = fieldValue;

                    if (child.RectangleColor == null && child.RectLastPrice.HasValue && child.RectLastPrice != 0.0)
                    {
                        child.RectangleColor = updateRectCircleAfterSubscription(ticker, child.RectLastPrice);
                    }
                }
            }

            return valueUpdated;
        }

        private bool updateCircleFromSubscription(string ticker, DataChild child, string fieldName, double fieldValue)
        {
            bool valueUpdated = false;

            if (fieldName == DataFieldNames.RT_PX_CHG_PCT_1D)
            {
                if (child.CircleColor != fieldValue)
                {
                    valueUpdated = true;
                    child.CircleColor = fieldValue;
                }
            }
            else if (fieldName == DataFieldNames.LAST_PRICE)
            {
                if (child.CircleLastPrice != fieldValue)
                {
                    valueUpdated = true;
                    child.CircleColor = calcFromLastPrice_PCT_CHG(fieldValue, child.CircleColor, child.CircleLastPrice);
                    child.CircleLastPrice = fieldValue;

                    if (child.CircleColor == null && child.CircleLastPrice.HasValue && child.CircleLastPrice != 0.0)
                    {
                        child.CircleColor = updateRectCircleAfterSubscription(ticker, child.CircleLastPrice);
                    }
                }
            }

            return valueUpdated;
        }

        private bool UpdateDataChildElements(DataChild ticker, string subscriptionTicker, string fieldName, double fieldValue)
        {
            bool valueUpdated = false;

            if (ticker.getTickerEquity() != "" && subscriptionTicker.Contains(ticker.getTickerEquity()))
            {
                if (ticker.RectColorName == ConstantItemList.SHARE_PRICE_CHG)
                {
                    valueUpdated = updateRectangleFromSubscription(ticker.getTickerEquity(), ticker, fieldName, fieldValue);
                }

                if (ticker.CircleColorName == ConstantItemList.SHARE_PRICE_CHG)
                {
                    valueUpdated = updateCircleFromSubscription(ticker.getTickerEquity(), ticker, fieldName, fieldValue);
                }
            }

            if (ticker.getSpreadTicker(4, PricingSource) != "" && subscriptionTicker.Contains(ticker.getSpreadTicker(4, PricingSource)))
            {
                if (ticker.RectColorName == ConstantItemList.CDS_PRICE_5Y_CHG)
                {
                    valueUpdated = updateRectangleFromSubscription(ticker.getSpreadTicker(4, PricingSource), ticker, fieldName, fieldValue);
                }

                if (ticker.CircleColorName == ConstantItemList.CDS_PRICE_5Y_CHG)
                {
                    valueUpdated = updateCircleFromSubscription(ticker.getSpreadTicker(4, PricingSource), ticker, fieldName, fieldValue);
                }
            }

            if (ticker.getSpreadTicker(0, PricingSource) != "" && subscriptionTicker.Contains(ticker.getSpreadTicker(0, PricingSource)))
            {
                if (ticker.RectColorName == ConstantItemList.CDS_PRICE_1Y_CHG)
                {
                    valueUpdated = updateRectangleFromSubscription(ticker.getSpreadTicker(0, PricingSource), ticker, fieldName, fieldValue);
                }

                if (ticker.CircleColorName == ConstantItemList.CDS_PRICE_1Y_CHG)
                {
                    valueUpdated = updateCircleFromSubscription(ticker.getSpreadTicker(0, PricingSource), ticker, fieldName, fieldValue);
                }
            }

            if (ticker.getSpreadTicker(1, PricingSource) != "" && subscriptionTicker.Contains(ticker.getSpreadTicker(1, PricingSource)))
            {
                if (ticker.RectColorName == ConstantItemList.CDS_PRICE_2Y_CHG)
                {
                    valueUpdated = updateRectangleFromSubscription(ticker.getSpreadTicker(1, PricingSource), ticker, fieldName, fieldValue);
                }

                if (ticker.CircleColorName == ConstantItemList.CDS_PRICE_2Y_CHG)
                {
                    valueUpdated = updateCircleFromSubscription(ticker.getSpreadTicker(1, PricingSource), ticker, fieldName, fieldValue);
                }
            }

            if (ticker.getSpreadTicker(6, PricingSource) != "" && subscriptionTicker.Contains(ticker.getSpreadTicker(6, PricingSource)))
            {
                if (ticker.RectColorName == ConstantItemList.CDS_PRICE_10Y_CHG)
                {
                    valueUpdated = updateRectangleFromSubscription(ticker.getSpreadTicker(6, PricingSource), ticker, fieldName, fieldValue);
                }

                if (ticker.CircleColorName == ConstantItemList.CDS_PRICE_10Y_CHG)
                {
                    valueUpdated = updateCircleFromSubscription(ticker.getSpreadTicker(6, PricingSource), ticker, fieldName, fieldValue);
                }
            }

            return valueUpdated;
        }

        private double? calcFromLastPrice_PCT_CHG(double? lastPrice, double? oldChg, double? oldLastPrice)
        {
            if (lastPrice == null || oldChg == null || oldLastPrice == null) return null;

            if (oldLastPrice == 0.0)
                return null;

            return ((lastPrice * (oldChg + 1)) / oldLastPrice - 1.0);
        }

        private double? calcFromLastPrice_NET_CHG(double? lastPrice, double? oldChg, double? oldLastPrice)
        {
            if (lastPrice == null || oldChg == null || oldLastPrice == null) return null;

            return (lastPrice - oldLastPrice + oldChg);
        }

        private double? updateRectCircleAfterSubscription(string ticker, double? lastPrice)
        {
            if (ticker == "")
                return null;

            List<string> TickerList = new List<string>();

            TickerList.Add(ticker);

            if (TickerList.Count > 0)
            {
                var histResultSet = cacheManager.getTickerHistPrice(TickerList, BeginDate);

                if (histResultSet != null && histResultSet.Count > 0)
                {
                    if (ticker != "" && histResultSet.ContainsKey(ticker))
                    {
                        var val = histResultSet[ticker];
                        if (val != null && val.RateValue.HasValue && val.RateValue != 0.0)
                        {
                            return calculate_PCT_CHG(val.RateValue, lastPrice);
                        }
                    }
                }
            }

            return null;
        }

        private static int subscribeOption = 1;
        private static int subscribeWait = 500;
        private static int subscribeAgain = 0;

        public void setSubscribeOption(int option, int wait, int again)
        {
            subscribeOption = option;
            subscribeWait = wait;
            subscribeAgain = again;
        }

        private void worker_DoWork()
        {
            DateTime theTime;
            DateTime nextSubscribeHeartBeat;
            DateTime nextPeriodicUpdate;
            DateTime nextPeriodicDraw;
            DateTime lastSubscribeShow;

            lastSubscribeShow = lastUpdateTime = theTime = DateTime.Now;

            while (true)
            {
                try
                {
                    if (isInitialized)
                    {
                        int subscOption = subscribeOption;
                        int subcWait = subscribeWait;
                        int again = subscribeAgain;

                        nextSubscribeHeartBeat = nextPeriodicDraw = nextPeriodicUpdate = DateTime.Now;

                        if ((lastUpdateTime.AddSeconds(3) < nextPeriodicUpdate) && justChangedGroup)
                        {
                            waitMainThread = true;

                            mainThreadDispatcher.BeginInvoke(((Action)delegate
                            {
                                try
                                {
                                    updateHeatMap();
                                }
                                catch (Exception ex)
                                {
                                    Trace.WriteLine("Exception while updating CDS Heat Map View after drawing heatmap (7005): " + ex.Message, "ERROR");

                                    string stackTrace = "";
                                    if (ex.StackTrace != null)
                                        stackTrace = ex.StackTrace.ToString();

                                    Trace.WriteLine("Exception Stacktrace (7005): " + stackTrace, "INFO");
                                }
                                finally
                                {
                                    waitMainThread = false;
                                    justChangedGroup = false;
                                }
                            }), null);

                            while (waitMainThread)
                                Thread.Sleep(500);

                            continue;
                        }
                        else
                            Thread.Sleep(1000);

                        if ((lastUpdateTime.AddMinutes(1) < nextPeriodicUpdate))
                        {
                            waitMainThread = true;

                            mainThreadDispatcher.BeginInvoke(((Action)delegate
                            {
                                try
                                {
                                    updateHeatMap();
                                }
                                catch (Exception ex)
                                {
                                    Trace.WriteLine("Exception while updating CDS Heat Map View (7006): " + ex.Message, "ERROR");

                                    string stackTrace = "";
                                    if (ex.StackTrace != null)
                                        stackTrace = ex.StackTrace.ToString();

                                    Trace.WriteLine("Exception Stacktrace (7006): " + stackTrace, "INFO");
                                }
                                finally
                                {
                                    waitMainThread = false;
                                }
                            }), null);

                            while (waitMainThread)
                                Thread.Sleep(500);

                            continue;
                        }

                        if ((lastSubscribeShow.AddSeconds(3) < nextSubscribeHeartBeat) && subscriptionTickerIDList.Count > 0)
                        {
                            SubscriptionUpdate = true;

                            List<int> tickerIDList = new List<int>();

                            foreach (int id in subscriptionTickerIDList)
                            {
                                if (!tickerIDList.Contains(id))
                                    tickerIDList.Add(id);
                            }

                            subscriptionTickerIDList.Clear();
                            SubscriptionUpdate = false;

                            if (tickerIDList.Count == 0)
                                continue;

                            Dictionary<int, SolidColorBrush> rectColors = new Dictionary<int, SolidColorBrush>();
                            Dictionary<int, SolidColorBrush> circleColors = new Dictionary<int, SolidColorBrush>();

                            Dictionary<int, SolidColorBrush> newRectColors = new Dictionary<int, SolidColorBrush>();
                            Dictionary<int, SolidColorBrush> newCircleColors = new Dictionary<int, SolidColorBrush>();

                            //calculate new colors for each child item

                            waitMainThread = true;
                            mainThreadDispatcher.BeginInvoke(((Action)delegate
                            {
                                try
                                {
                                    foreach (int tickerID in tickerIDList)
                                    {
                                        if (!HeatMapHash.ContainsKey(tickerID))
                                            continue;

                                        var ticker = HeatMapHash[tickerID];

                                        if (ticker.GetType() != typeof(DataChild))
                                            continue;

                                        DataChild childItem = (DataChild)ticker;

                                        string childItemName = "";

                                        if (childItem != null && childItem.ChildName != null)
                                            childItemName = childItem.ChildName;

                                        //Trace.WriteLine("subscription childItem is " + childItemName, "TRACE");

                                        SolidColorBrush circleNewColor;
                                        SolidColorBrush rectNewColor;

                                        if (HeatMapView.isNormalDistChecked)
                                        {
                                            if (CircleColor == ConstantItemList.NONE)
                                                circleNewColor = Brushes.Transparent;
                                            else
                                                circleNewColor = generateColorFromNormForCircle(childItem.CircleColor);
                                            rectNewColor = generateColorFromNormForRect(childItem.RectangleColor);
                                        }
                                        else
                                        {
                                            if (CircleColor == ConstantItemList.NONE)
                                                circleNewColor = Brushes.Transparent;
                                            else
                                                circleNewColor = generateColorForCircle(childItem.CircleColor);
                                            rectNewColor = generateColorForRectangle(childItem.RectangleColor);
                                        }
                                        /*
                                        if (circleNewColor.CanFreeze)
                                            circleNewColor.Freeze();

                                        if (rectNewColor.CanFreeze)
                                            rectNewColor.Freeze();
                                        */
                                        if (childItem.CircleFillingColor == null || childItem.RectangleFillingColor == null)
                                        {
                                            newRectColors.Add(childItem.ID, rectNewColor);
                                            newCircleColors.Add(childItem.ID, circleNewColor);
                                        }
                                        else if (circleNewColor.Color != childItem.CircleFillingColor.Color || rectNewColor.Color != childItem.RectangleFillingColor.Color)
                                        {
                                            newRectColors.Add(childItem.ID, rectNewColor);
                                            newCircleColors.Add(childItem.ID, circleNewColor);
                                        }
                                    }
                                }
                                catch (Exception ex1)
                                {
                                    Trace.WriteLine("Exception in SubscriptionUpdHeatMap while updating CDS Heat Map View (7007): " + ex1.Message, "ERROR");

                                    string stackTrace = "";
                                    if (ex1.StackTrace != null)
                                        stackTrace = ex1.StackTrace.ToString();

                                    Trace.WriteLine("Exception Stacktrace (7007): " + stackTrace, "INFO");
                                }
                                finally
                                {
                                    waitMainThread = false;
                                }
                            }), null);

                            while (waitMainThread)
                                Thread.Sleep(100);

                            tickerIDList.Clear();

                            //add only updated tickers
                            foreach (var chg_id in newRectColors.Keys)
                                tickerIDList.Add(chg_id);

                            if (tickerIDList.Count <= 0)
                            {
                                lastSubscribeShow = DateTime.Now;
                                continue;
                            }

                            waitMainThread = true;

                            //Black
                            mainThreadDispatcher.BeginInvoke(((Action)delegate
                            {
                                try
                                {
                                    foreach (int tickerID in tickerIDList)
                                    {
                                        if (!HeatMapHash.ContainsKey(tickerID))
                                            continue;

                                        var ticker = HeatMapHash[tickerID];

                                        DataChild childItem = (DataChild)ticker;

                                        if (childItem.RectangleFillingColor == null)
                                        {
                                            Trace.WriteLine("RectangleFillingColor is null (7008): ", "ERROR");
                                        }
                                        else
                                            rectColors.Add(childItem.ID, new SolidColorBrush(childItem.RectangleFillingColor.Color));
                                        //rectColors[childItem.ID] = childItem.RectangleFillingColor;

                                        if (childItem.CircleFillingColor == null)
                                        {
                                            Trace.WriteLine("CircleFillingColor is null (7008): ", "ERROR");
                                        }
                                        else
                                            circleColors.Add(childItem.ID, new SolidColorBrush(childItem.CircleFillingColor.Color));
                                        //circleColors[childItem.ID] = childItem.CircleFillingColor;

                                        childItem.RectangleFillingColor = Brushes.Black;
                                        childItem.CircleFillingColor = Brushes.Black;
                                        childItem.ChildBorderBrush = childItem.RectangleFillingColor;
                                    }
                                }
                                catch (Exception ex1)
                                {
                                    Trace.WriteLine("Exception in SubscriptionUpdHeatMap while updating CDS Heat Map View (7008): " + ex1.Message, "ERROR");

                                    string stackTrace = "";
                                    if (ex1.StackTrace != null)
                                        stackTrace = ex1.StackTrace.ToString();

                                    Trace.WriteLine("Exception Stacktrace (7008): " + stackTrace, "INFO");
                                }
                                finally
                                {
                                    waitMainThread = false;
                                }
                            }), null);

                            Thread.Sleep(BLINK_WAIT);

                            while (waitMainThread)
                                Thread.Sleep(100);

                            waitMainThread = true;

                            //Old color
                            mainThreadDispatcher.BeginInvoke(((Action)delegate
                            {
                                try
                                {
                                    foreach (int tickerID in tickerIDList)
                                    {
                                        if (!HeatMapHash.ContainsKey(tickerID))
                                            continue;

                                        var ticker = HeatMapHash[tickerID];

                                        if (ticker == null)
                                        {
                                            Trace.WriteLine("ticker is null", "INFO");
                                        }

                                        DataChild childItem = (DataChild)ticker;

                                        if (childItem == null)
                                        {
                                            Trace.WriteLine("childItem is null", "INFO");
                                        }

                                        if (rectColors.ContainsKey(childItem.ID))
                                        {
                                            if (rectColors[childItem.ID] == null)
                                            {
                                                Trace.WriteLine("rectColors[childItem.ID] is null", "INFO");
                                            }
                                            else
                                            {
                                                childItem.RectangleFillingColor = rectColors[childItem.ID];
                                                childItem.ChildBorderBrush = childItem.RectangleFillingColor;
                                            }
                                        }

                                        if (circleColors.ContainsKey(childItem.ID))
                                        {
                                            if (circleColors[childItem.ID] == null)
                                            {
                                                Trace.WriteLine("circleColors[childItem.ID] is null", "INFO");
                                            }
                                            else
                                                childItem.CircleFillingColor = circleColors[childItem.ID];
                                        }
                                    }
                                }
                                catch (Exception ex2)
                                {
                                    Trace.WriteLine("Exception in SubscriptionUpdHeatMap while updating CDS Heat Map View (7009): " + ex2.Message, "ERROR");

                                    string stackTrace = "";
                                    if (ex2.StackTrace != null)
                                        stackTrace = ex2.StackTrace.ToString();

                                    Trace.WriteLine("Exception Stacktrace (7009): " + stackTrace, "INFO");
                                }
                                finally
                                {
                                    waitMainThread = false;
                                }
                            }), null);

                            Thread.Sleep(BLINK_WAIT);

                            while (waitMainThread)
                                Thread.Sleep(100);

                            waitMainThread = true;

                            //New colors
                            mainThreadDispatcher.BeginInvoke(((Action)delegate
                            {
                                try
                                {
                                    foreach (int tickerID in tickerIDList)
                                    {
                                        if (!HeatMapHash.ContainsKey(tickerID))
                                            continue;

                                        var ticker = HeatMapHash[tickerID];

                                        DataChild childItem = (DataChild)ticker;

                                        if (newRectColors.ContainsKey(childItem.ID))
                                        {
                                            childItem.RectangleFillingColor = newRectColors[childItem.ID];
                                            childItem.ChildBorderBrush = childItem.RectangleFillingColor;
                                        }

                                        if (newCircleColors.ContainsKey(childItem.ID))
                                        {
                                            childItem.CircleFillingColor = newCircleColors[childItem.ID];
                                        }
                                    }
                                }
                                catch (Exception ex3)
                                {
                                    Trace.WriteLine("Exception in SubscriptionUpdHeatMap while changing CDS Heat Map Ticker item (7010): " + ex3.Message, "ERROR");

                                    string stackTrace = "";
                                    if (ex3.StackTrace != null)
                                        stackTrace = ex3.StackTrace.ToString();

                                    Trace.WriteLine("Exception Stacktrace (7010): " + stackTrace, "INFO");
                                }
                                finally
                                {
                                    setParameters();
                                    lastUpdateTime = DateTime.Now;
                                    LastUpdate.LastUpdateTime = DateTime.Now.ToLongTimeString();

                                    waitMainThread = false;
                                }
                            }), null);

                            while (waitMainThread)
                                Thread.Sleep(100);

                            tickerIDList.Clear();
                            rectColors.Clear();
                            circleColors.Clear();
                            newRectColors.Clear();
                            newCircleColors.Clear();

                            lastSubscribeShow = DateTime.Now;
                        }
                    }
                    else
                        Thread.Sleep(1000);
                }
                catch (Exception e)
                {
                    Trace.WriteLine(string.Format("Exception while worker_DoWork: {0}", e.Message.ToString()), "ERROR");

                    string stackTrace = "";
                    if (e.StackTrace != null)
                        stackTrace = e.StackTrace.ToString();

                    Trace.WriteLine("Exception Stacktrace SubscriptionUpdHeatMap: " + stackTrace, "INFO");
                }
            }
        }

        internal DataChild getTickerFromHash(int id)
        {
            try
            {
                DataChild child;
                if (!HeatMapHash.ContainsKey(id))
                    return null;

                child = (DataChild)HeatMapHash[id];

                return child;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while getTickerFromHash: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace getTickerFromHash: " + stackTrace, "INFO");
            }
            return null;
        }

        internal CDSIndexMember getCDSMemberDetails(string eqTicker)
        {
            return tickerFilter.getMemberByEqTicker(eqTicker);
        }

        public void setAppLastParams()
        {
            try
            {
                AppHeatMapLastParams.Group = HeatMapGroup.CDSIndexName;
                AppHeatMapLastParams.FirstBy = FirstBy;
                AppHeatMapLastParams.ThenBy = ThenBy;
                AppHeatMapLastParams.RectangleSize = RectSize;
                AppHeatMapLastParams.RectangleColor = RectColor;
                AppHeatMapLastParams.CircleColor = CircleColor;
                AppHeatMapLastParams.CircleBorder = DonutColor;

                if (RateClass == ShowChangeRateClass.YTD)
                    AppHeatMapLastParams.DisplayChange = "YTD";
                else if (RateClass == ShowChangeRateClass.CLOSE)
                    AppHeatMapLastParams.DisplayChange = "CLOSE";
                else if (RateClass == ShowChangeRateClass.WEEK52)
                    AppHeatMapLastParams.DisplayChange = "52W";
                else if (RateClass == ShowChangeRateClass.CUSTOM)
                {
                    AppHeatMapLastParams.DisplayChange = "CUSTOM";
                }
                else if (RateClass == ShowChangeRateClass.DAY1)
                    AppHeatMapLastParams.DisplayChange = "1D";

                AppHeatMapLastParams.BeginDate = BeginDate;
                AppHeatMapLastParams.EndDate = EndDate;

                AppHeatMapLastParams.isNormalDistChecked = HeatMapView.isNormalDistChecked;
                AppHeatMapLastParams.isHideTickerChecked = HeatMapView.isHideTickerChecked;
                AppHeatMapLastParams.isRectSizeAlg1Checked = HeatMapView.isRectSizeAlg1Checked;
                AppHeatMapLastParams.PricingSource = DataManager.PricingSource;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while setAppLastParams: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace setAppLastParams: " + stackTrace, "INFO");
            }
        }


        public void setFirstByGuidance(bool isEnabled)
        {
            try
            {
                if (DataCollectionTree == null || DataCollectionTree.Count <= 0)
                    return;

                int i = DataCollectionTree.Count / 2;

                if (i == DataCollectionTree.Count - 1)
                    i = 0;

                BooleanNotify boolNotify = new BooleanNotify(isEnabled);
                DataCollectionTree[i].FirstByGuidanceEnabled = boolNotify;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while setFirstByGuidance: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace setFirstByGuidance: " + stackTrace, "INFO");
            }
        }

        public void setThenByGuidance(bool isEnabled)
        {
            try
            {
                if (childGroupList == null || childGroupList.Count <= 0)
                    return;

                int i = childGroupList.Count / 2;

                if (i == childGroupList.Count - 1)
                    i = 0;

                BooleanNotify boolNotify = new BooleanNotify(isEnabled);
                childGroupList[i].ThenByGuidanceEnabled = boolNotify;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while setThenByGuidance: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace setThenByGuidance: " + stackTrace, "INFO");
            }
        }

        public void setRectColorGuidance(bool isEnabled)
        {
            try
            {
                if (childList == null || childList.Count <= 0)
                    return;

                int i = 0;

                BooleanNotify boolNotify = new BooleanNotify(isEnabled);
                childList[i].RectColorGuidanceEnabled = boolNotify;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while setRectColorGuidance: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace setRectColorGuidance: " + stackTrace, "INFO");
            }
        }

        public void setCircleColorGuidance(bool isEnabled)
        {
            try
            {
                if (childList == null || childList.Count <= 0)
                    return;

                int i = childList.Count / 2;

                if (i == childList.Count - 1)
                    i = 0;

                BooleanNotify boolNotify = new BooleanNotify(isEnabled);
                childList[i].CircleColorGuidanceEnabled = boolNotify;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while setCircleColorGuidance: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace setCircleColorGuidance: " + stackTrace, "INFO");
            }
        }

        public void setVolatilityGuidance(bool isEnabled)
        {
            try
            {
                if (childList == null || childList.Count <= 0)
                    return;

                foreach (var child in childList)
                {
                    if (child.DonutChartColor != 0.0)
                    {
                        BooleanNotify boolNotify = new BooleanNotify(isEnabled);
                        child.VolatilityGuidanceEnabled = boolNotify;
                        break;
                    }
                }
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while setVolatilityGuidance: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace setVolatilityGuidance: " + stackTrace, "INFO");
            }
        }

        public void setTooltipGuidance(bool isEnabled)
        {
            try
            {
                if (childList == null || childList.Count <= 0)
                    return;

                int i = childList.Count / 2;

                if (i == childList.Count - 1)
                    i = 0;

                BooleanNotify boolNotify = new BooleanNotify(isEnabled);
                childList[i].TooltipGuidanceEnabled = boolNotify;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while setTooltipGuidance: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace setTooltipGuidance: " + stackTrace, "INFO");
            }
        }

        public void setRightClickGuidance(bool isEnabled)
        {
            try
            {
                if (childList == null || childList.Count <= 0)
                    return;

                int i = childList.Count / 2;

                if (i == childList.Count - 1)
                    i = 0;

                BooleanNotify boolNotify = new BooleanNotify(isEnabled);
                childList[i].RightClickGuidanceEnabled = boolNotify;
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while setRightClickGuidance: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace setRightClickGuidance: " + stackTrace, "INFO");
            }
        }

        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                // dispose managed resources
                if (worker != null)
                    worker.Abort();
            }
            // free native resources
        }

        public void Dispose()
        {
            Trace.WriteLine("HeatmapViewModel Dispose is called", "TRACE");

            Dispose(true);
            GC.SuppressFinalize(this);

            Trace.WriteLine("HeatmapViewModel Dispose is completed", "TRACE");
        }

        public bool isDataManagerInitialized()
        {
            return cacheManager.dataManager.initialized;
        }

    }
}
