﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using CDSHeatMap.Util;

namespace CDSHeatMap.ViewModel
{
    public class MainWindowViewModel : ViewModelBase
    {
        private readonly ObservableCollection<BaseWindowViewModel> _settings;
        internal static HeatMapViewModel heatmapViewModel;
        internal static TickerFilterViewModel tickerfilterViewModel;

        public static bool Is64BitOS = false;

        public ObservableCollection<BaseWindowViewModel> BaseWindowSettings
        {
            get { return this._settings; }
        }

        public MainWindowViewModel()
        {
            try
            {
                Trace.WriteLine("MainWindowViewModel is called", "TRACE");

                heatmapViewModel = new HeatMapViewModel();

                tickerfilterViewModel = new TickerFilterViewModel();

                this._settings = new ObservableCollection<BaseWindowViewModel>();

                this._settings.Add(tickerfilterViewModel);
                this._settings.Add(heatmapViewModel);

                Trace.WriteLine("MainWindowViewModel is completed", "TRACE");
            }
            catch (Exception e1)
            {
                Trace.WriteLine("Exception while MainWindowViewModel: " + e1.Message, "ERROR");
                string stackTrace = "";
                if (e1.StackTrace != null)
                    stackTrace = e1.StackTrace.ToString();

                Trace.WriteLine("Exception Stacktrace MainWindowViewModel: " + stackTrace, "INFO");
            }

        }

    }
}
