# Code for SPN Network Real-Time Monitoring and Optimization in Distribution Grid Communication
(Corresponding files: Manuscript.doc, Figure.doc, Table.doc)

## 1. Code Descriptive Legend
**This code implements data preprocessing, attention-enhanced LSTM communication load prediction, wind-solar fluctuation grade classification, cross-climate SPN communication fingerprint matching, SPN topology self-optimization, and experimental validation for the study.**

## 2. Code File Structure
| File Name | Core Function | Corresponding Manuscript Sections/Figures/Tables |
|-----------|---------------|--------------------------------------------------|
| `data_preprocessing.py` | State Grid wind-solar dataset loading, missing value handling, anomaly detection, feature extraction, normalization, and dataset splitting | Manuscript.doc 2.1.1/4.1.3; Table 5/8 |
| `attention_lstm_prediction.py` | Construction and training of attention-enhanced LSTM model, 1-hour load prediction, and performance evaluation (MAE/RMSE/PA) | Manuscript.doc 2.2; Figure 1/10; Table 9 |
| `fluctuation_grade_classification.py` | K-Means elbow method implementation, wind-solar fluctuation grade division (Level 0-4), and grade validation | Manuscript.doc 2.3; Figure 2; Table 3 |
| `cross_climate_fingerprint.py` | Cross-climate fingerprint library construction (North China/Central China/Northwest China), Euclidean distance matching, and new site adaptation | Manuscript.doc 2.4; Figure 13; Table 4/13 |
| `topology_self_optimization.py` | Routing weight calculation (Formula 10), dynamic topology adjustment, link utilization monitoring, and performance comparison | Manuscript.doc 2.5; Figure 4/12; Table 11 |
| `experimental_validation.py` | Ablation experiments (attention layer/grade classification), stability analysis (season/noise), and multi-indicator radar chart plotting | Manuscript.doc 4.3; Figure 9/14; Table 10/12/14/15 |
| `README.md` | Environmental dependencies, running steps, and parameter descriptions | - |

## 3. Environmental Dependencies
```bash
# Install dependent libraries
pip install pandas==1.5.3 numpy==1.23.5 tensorflow==2.8.0 scikit-learn==1.2.2 matplotlib==3.7.1 scipy==1.10.1