// src/commands/aiCommands.js
const assistantService = require('../services/assistantService');

const aiCommands = {
    '!ai': async (sock, from, message) => {
        const phoneNumber = from.split('@')[0];
        const response = await assistantService.processMessage(phoneNumber, message);

        // Si la respuesta es una URL de imagen
        if (response.startsWith('http')) {
            await sock.sendMessage(from, {
                image: { url: response },
                caption: "Imagen generada por DALL-E 3"
            });
        } else {
            // Respuesta de texto normal
            await sock.sendMessage(from, { text: response });
        }
    }
};

module.exports = aiCommands;