// src/cron/academicNotifications.js - Nuevo archivo

const cron = require('node-cron');
const academicTutorService = require('../services/academicTutorService');

function startAcademicNotificationsCron(sock) {
    // Ejecutar todos los días a las 8:00 AM
    cron.schedule('*/2 * * * *', async () => {
        console.log('🎓 Iniciando notificaciones académicas...');

        try {
            const studentsAtRisk = await academicTutorService.getStudentsAtRisk();
            console.log(`📚 Encontrados ${studentsAtRisk.length} estudiantes que necesitan apoyo`);

            for (const student of studentsAtRisk) {
                try {
                    await academicTutorService.initiateTutorSession(sock, student);
                    // Esperar 2 segundos entre mensajes
                    await new Promise(resolve => setTimeout(resolve, 2000));
                } catch (error) {
                    console.error(`Error procesando estudiante ${student.student_name}:`, error);
                    continue;
                }
            }

            console.log('✅ Proceso de notificaciones académicas completado');
        } catch (error) {
            console.error('❌ Error en el proceso de notificaciones:', error);
        }
    }, {
        timezone: "America/Guayaquil"
    });
}

module.exports = { startAcademicNotificationsCron };