const { aiCommands } = require('../commands');

function messageHandler(sock) {
    sock.ev.on('messages.upsert', async ({ messages }) => {
        const m = messages[0];
        if (!m.message || m.key.fromMe) return;

        const from = m.key.remoteJid;
        const messageType = Object.keys(m.message)[0];
        const messageText = messageType === 'conversation' ?
            m.message.conversation :
            messageType === 'extendedTextMessage' ?
                m.message.extendedTextMessage.text : '';

        if (messageText.startsWith('!ai')) {
            const prompt = messageText.slice(4).trim();
            await aiCommands['!ai'](sock, from, prompt);
        }
        // ... resto de tu código de manejo de mensajes
    });
}

module.exports = { messageHandler };