const prisma = require('../../lib/prisma');

class UserService {
    async getOrCreateUser(phoneNumber) {
        try {
            // Primero buscar el usuario
            let user = await prisma.user.findUnique({
                where: {
                    phone_number: phoneNumber
                }
            });

            // Si no existe, crearlo
            if (!user) {
                user = await prisma.user.create({
                    data: {
                        phone_number: phoneNumber,
                        first_interaction_date: new Date(),
                        last_interaction_date: new Date(),
                        total_interactions: 1,
                        preferred_language: 'es',
                        is_active: true
                    }
                });
                console.log(`✅ Nuevo usuario creado: ${phoneNumber}`);
            }

            return user;

        } catch (error) {
            console.error('❌ Error en getOrCreateUser:', error);
            // Lanzar el error para manejarlo en el nivel superior
            throw error;
        }
    }

    async updateUserInteraction(phoneNumber) {
        try {
            return await prisma.user.update({
                where: {
                    phone_number: phoneNumber
                },
                data: {
                    last_interaction_date: new Date(),
                    total_interactions: {
                        increment: 1
                    }
                }
            });
        } catch (error) {
            console.error('❌ Error en updateUserInteraction:', error);
            throw error;
        }
    }
}

module.exports = new UserService();